/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathPhantomModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel,
WmiFontAttributeSource {
    public static final String LINEBREAK_CONTEXT = "phantom";
    public static final String CONSTRAINTS = "constraints";
    public static final String BOTH = "both";
    public static final String WIDTH_ONLY = "width-only";
    public static final String HEIGHT_ONLY = "height-only";
    public static final String[] CONSTRAINT_OPTIONS = new String[]{"both", "width-only", "height-only"};
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiMathPhantomModel(WmiMathDocumentModel doc) {
        super(doc);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPhantomModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathPhantomModel(WmiMathDocumentModel doc, WmiModel child) throws WmiInvalidModelInitializationException {
        super(doc, new WmiModel[]{child});
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiMathPhantomModel(WmiMathDocumentModel doc, WmiModel model, WmiMathPhantomAttributeSet attrs) {
        super(doc);
        this.children = new WmiModel[]{model};
        this.length = 1;
        this.attributes = attrs;
    }

    public static WmiMathPhantomModel createHeightPhantom(WmiModel model) {
        WmiMathPhantomAttributeSet phattr = new WmiMathPhantomAttributeSet();
        phattr.addAttribute(CONSTRAINTS, HEIGHT_ONLY);
        WmiMathPhantomModel phantom = new WmiMathPhantomModel(model.getDocument(), model, phattr);
        return phantom;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_PHANTOM;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathPhantomAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathPhantomAttributeSet();
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    public static class WmiMathPhantomAttributeSet
    extends WmiFontAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"constraints"};
        public static final WmiAttributeKey[] PHANTOM_KEYS = new WmiAttributeKey[]{new ConstraintsKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, PHANTOM_KEYS);
        public static final int BOTH_INDEX = 0;
        public static final int WIDTH_ONLY_INDEX = 1;
        public static final int HEIGHT_ONLY_INDEX = 2;
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private int constraint = 0;

        public WmiMathPhantomAttributeSet() {
        }

        public WmiMathPhantomAttributeSet(WmiMathPhantomAttributeSet source) {
            super(source);
            this.constraint = source.constraint;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathPhantomAttributeSet) {
                WmiMathPhantomAttributeSet source = (WmiMathPhantomAttributeSet)set;
                this.constraint = source.constraint;
            }
        }

        public boolean useWidth() {
            return this.constraint != 2;
        }

        public boolean useHeight() {
            return this.constraint != 1;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathPhantomAttributeSet(this);
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathPhantomAttributeSet) {
                equals = ((WmiMathPhantomAttributeSet)obj).constraint == this.constraint;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            return code ^= this.constraint;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class ConstraintsKey
        extends WmiEnumeratedAttributeKey {
            protected ConstraintsKey() {
                super(WmiMathPhantomModel.CONSTRAINTS, CONSTRAINT_OPTIONS, 0);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiMathPhantomAttributeSet)set).constraint;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiMathPhantomAttributeSet)set).constraint = value;
            }
        }
    }
}

