/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiMathStringModel
extends WmiAbstractMathTokenModel
implements WmiMathModel,
WmiFontAttributeSource {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static final String LEFT_QUOTE = "lquote";
    public static final String RIGHT_QUOTE = "rquote";
    public static final String DEFAULT_QUOTE = "\"";
    private WmiMathSemantics semantics = null;
    private String contentWithQuotes = null;

    public WmiMathStringModel(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        super(doc, contents, context);
        WmiMathStringAttributeSet defSet = new WmiMathStringAttributeSet();
        try {
            WmiMathAttributeSet set = context.createAttributes(6);
            defSet.addAttributes(set);
            this.setAttributes(defSet);
            this.syncQuotedContent();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_STRING;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathStringAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiMathStringAttributeSet set = new WmiMathStringAttributeSet();
        return set;
    }

    @Override
    protected boolean enableMapleSyntaxMapping() {
        return false;
    }

    @Override
    protected boolean checkForQuotes() {
        return false;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        super.update(undoName);
    }

    @Override
    protected WmiAbstractMathTokenModel.WmiTokenModelEdit createMathTextEdit() {
        return new WmiStringModelEdit(this);
    }

    @Override
    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        super.updateValuesFromPending();
        this.contentWithQuotes = ((WmiMathStringModel)this.pending).contentWithQuotes;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    private void syncQuotedContent() throws WmiNoReadAccessException {
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs instanceof WmiMathStringAttributeSet) {
            WmiMathStringAttributeSet mathAttrs = (WmiMathStringAttributeSet)attrs;
            StringBuffer buffy = new StringBuffer();
            buffy.append(mathAttrs.getLeftQuote());
            buffy.append(super.getText());
            buffy.append(mathAttrs.getRightQuote());
            this.contentWithQuotes = buffy.toString();
        }
    }

    @Override
    public String getText() throws WmiNoReadAccessException {
        String s = this.contentWithQuotes;
        if (this.pending instanceof WmiMathStringModel) {
            s = ((WmiMathStringModel)this.pending).contentWithQuotes;
        }
        return s;
    }

    @Override
    public void deleteText(int offset, int length) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int lengthAdjust = 0;
        try {
            int strlen = this.getLength();
            WmiAttributeSet attrs = this.getAttributes();
            WmiMathStringAttributeSet mathAttrs = null;
            if (attrs instanceof WmiMathStringAttributeSet) {
                mathAttrs = (WmiMathStringAttributeSet)attrs;
            }
            String leftQuote = mathAttrs.getLeftQuote();
            String rightQuote = mathAttrs.getRightQuote();
            if (offset == 0 && leftQuote.length() > 0) {
                mathAttrs.addAttribute(LEFT_QUOTE, "");
                this.setAttributes(mathAttrs);
                ++lengthAdjust;
            }
            if (offset + length == strlen && rightQuote.length() > 0) {
                mathAttrs.addAttribute(RIGHT_QUOTE, "");
                this.setAttributes(mathAttrs);
                ++lengthAdjust;
            }
            this.replaceText(null, offset, length - lengthAdjust);
        }
        catch (WmiNoReadAccessException e) {
            this.replaceText(null, offset, length - lengthAdjust);
        }
    }

    @Override
    public void replaceText(String text, int offset, int span) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        WmiAttributeSet attrs;
        int modelLength = 0;
        String leftQuote = "";
        String rightQuote = "";
        boolean leftQuotePresent = false;
        boolean rightQuotePresent = false;
        try {
            WmiAttributeSet attrs2 = this.getAttributes();
            if (attrs2 instanceof WmiMathStringAttributeSet) {
                leftQuote = ((WmiMathStringAttributeSet)attrs2).getLeftQuote();
                rightQuote = ((WmiMathStringAttributeSet)attrs2).getRightQuote();
                leftQuotePresent = leftQuote != null && leftQuote.length() > 0;
                rightQuotePresent = rightQuote != null && rightQuote.length() > 0;
            }
            modelLength = this.getLength();
        }
        catch (WmiNoReadAccessException nra) {
            WmiErrorLog.log(nra);
        }
        int finoffset = offset;
        finoffset -= offset != 0 && leftQuotePresent ? 1 : 0;
        int n = finoffset = (finoffset -= offset == modelLength && rightQuotePresent ? 1 : 0) < 0 ? 0 : finoffset;
        if (offset == 0 && leftQuote.equals("") && text != null && text.equals(DEFAULT_QUOTE)) {
            try {
                attrs = this.getAttributes();
                attrs.addAttribute(LEFT_QUOTE, null);
                this.setAttributes(attrs);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else if (offset == modelLength && rightQuote.equals("") && text != null && text.equals(DEFAULT_QUOTE)) {
            try {
                attrs = this.getAttributes();
                attrs.addAttribute(RIGHT_QUOTE, null);
                this.setAttributes(attrs);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        } else {
            super.replaceText(text, finoffset, span);
        }
        if (this.pending instanceof WmiMathStringModel) {
            try {
                ((WmiMathStringModel)this.pending).syncQuotedContent();
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    @Override
    public String getSubstring(int offset, int length) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String reply = null;
        String data = this.getText();
        if (data != null) {
            if (offset < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, offset);
            }
            if (offset + length > data.length()) {
                throw new WmiModelIndexOutOfBoundsException(this, offset + length);
            }
            reply = data.substring(offset, offset + length);
        }
        return reply;
    }

    @Override
    public int getLength() throws WmiNoReadAccessException {
        return this.getText().length();
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        String content = super.getText();
        return new WmiMathStringModel(this.getDocument(), content.substring(offset), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    public WmiModelPosition convertToIdentifier(int posIndex) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        String text = this.getText();
        WmiIdentifierModel newModel = new WmiIdentifierModel(this.getDocument(), text, text, context, false);
        WmiCompositeModel parent = this.getParent();
        if (parent != null) {
            int indexOfThisModel = parent.indexOf(this);
            try {
                parent.replaceChild(newModel, indexOfThisModel);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        return new WmiModelPosition(newModel, posIndex);
    }

    public WmiModelPosition convertToMathText(int posIndex) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        String text = this.getText();
        WmiMathTextModel newModel = new WmiMathTextModel(this.getDocument(), text, context);
        WmiCompositeModel parent = this.getParent();
        if (parent != null) {
            int indexOfThisModel = parent.indexOf(this);
            try {
                parent.replaceChild(newModel, indexOfThisModel);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        return new WmiModelPosition(newModel, posIndex);
    }

    @Override
    public WmiTextModel splitModel(int offset, ArrayList retokenizeList) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel model;
        WmiTextModel text = null;
        WmiModelPosition pos = this.convertToMathText(offset);
        if (pos != null && (model = pos.getModel()) instanceof WmiTextModel) {
            text = ((WmiTextModel)model).splitModel(offset);
        }
        return text;
    }

    public static class WmiMathStringAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"lquote", "rquote"};
        private String leftQuote = null;
        private String rightQuote = null;
        public static final WmiAttributeKey[] STRING_KEYS = new WmiAttributeKey[]{new LeftQuoteKey(), new RightQuoteKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_STRING = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, STRING_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();

        public WmiMathStringAttributeSet() {
        }

        public WmiMathStringAttributeSet(WmiMathStringAttributeSet attributes) {
            super(attributes);
            this.rightQuote = attributes.rightQuote;
            this.leftQuote = attributes.leftQuote;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathStringAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathStringAttributeSet) {
                WmiMathStringAttributeSet source = (WmiMathStringAttributeSet)set;
                this.rightQuote = source.rightQuote;
                this.leftQuote = source.leftQuote;
            }
        }

        public String getLeftQuote() {
            return this.leftQuote != null ? this.leftQuote : WmiMathStringModel.DEFAULT_QUOTE;
        }

        public String getRightQuote() {
            return this.rightQuote != null ? this.rightQuote : WmiMathStringModel.DEFAULT_QUOTE;
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathStringAttributeSet) {
                WmiMathStringAttributeSet ref = (WmiMathStringAttributeSet)obj;
                equals = true;
                if (this.leftQuote != null) {
                    equals = this.leftQuote.equals(ref.leftQuote);
                } else {
                    boolean bl = equals = ref.leftQuote == null;
                }
                equals = this.rightQuote != null ? (equals &= this.rightQuote.equals(ref.rightQuote)) : (equals &= ref.rightQuote == null);
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = this.leftQuote != null ? (code ^= this.leftQuote.hashCode()) : (code ^= WmiMathStringModel.DEFAULT_QUOTE.hashCode());
            code = this.rightQuote != null ? (code ^= this.rightQuote.hashCode()) : (code ^= WmiMathStringModel.DEFAULT_QUOTE.hashCode());
            return code;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_STRING;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class LeftQuoteKey
        extends WmiStringAttributeKey {
            public LeftQuoteKey() {
                super(WmiMathStringModel.LEFT_QUOTE, null);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return set instanceof WmiMathStringAttributeSet ? ((WmiMathStringAttributeSet)set).leftQuote : null;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                if (set instanceof WmiMathStringAttributeSet) {
                    ((WmiMathStringAttributeSet)set).leftQuote = value;
                }
            }
        }

        public static class RightQuoteKey
        extends WmiStringAttributeKey {
            public RightQuoteKey() {
                super(WmiMathStringModel.RIGHT_QUOTE, null);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return set instanceof WmiMathStringAttributeSet ? ((WmiMathStringAttributeSet)set).rightQuote : null;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                if (set instanceof WmiMathStringAttributeSet) {
                    ((WmiMathStringAttributeSet)set).rightQuote = value;
                }
            }
        }
    }

    public static class WmiStringBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) {
            String content = dag.getData();
            if (context.useProcRules()) {
                String suffix;
                String prefix;
                int index = content.indexOf(10);
                while (index >= 0) {
                    prefix = content.substring(0, index);
                    suffix = index < content.length() - 1 ? content.substring(index + 1) : "";
                    content = String.valueOf(prefix) + "\\n" + suffix;
                    index = content.indexOf(10);
                }
                index = content.indexOf(34);
                while (index >= 0) {
                    prefix = content.substring(0, index);
                    suffix = index < content.length() - 1 ? content.substring(index + 1) : "";
                    content = String.valueOf(prefix) + "\\\"" + suffix;
                    index = content.indexOf(34, index + 2);
                }
            }
            WmiMathStringModel model = new WmiMathStringModel(docModel, content, context);
            model.setSemantics(this);
            return model;
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            if (model != null && model instanceof WmiMathStringModel) {
                return DagUtil.createStringDag(((WmiMathStringModel)model).getContents());
            }
            return null;
        }
    }

    public static class WmiStringModelEdit
    extends WmiAbstractMathTokenModel.WmiTokenModelEdit {
        private String oldContentWithQuotes = null;
        private String newContentWithQuotes = null;

        protected WmiStringModelEdit(WmiAbstractMathTokenModel model) {
            super(model);
        }

        @Override
        protected void setPreupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, WmiAbstractMathTokenModel.StringList contents) {
            super.setPreupdateProperties(parent, attributes, contents);
            if (this.model instanceof WmiMathStringModel) {
                this.oldContentWithQuotes = ((WmiMathStringModel)this.model).contentWithQuotes;
            }
        }

        @Override
        protected void setPostupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, WmiAbstractMathTokenModel.StringList contents) {
            super.setPostupdateProperties(parent, attributes, contents);
            if (this.model instanceof WmiMathStringModel) {
                this.newContentWithQuotes = ((WmiMathStringModel)this.model).contentWithQuotes;
            }
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            if (this.model instanceof WmiMathStringModel) {
                ((WmiMathStringModel)this.model).contentWithQuotes = this.oldContentWithQuotes;
            }
            super.undo();
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            if (this.model instanceof WmiMathStringModel) {
                ((WmiMathStringModel)this.model).contentWithQuotes = this.newContentWithQuotes;
            }
            super.redo();
        }
    }
}

