/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiFloatAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.util.WmiSearchVisitor;
import java.util.Enumeration;
import java.util.HashMap;

public class WmiMathStyleModel
extends WmiInlineMathModel
implements WmiFontAttributeSource {
    public WmiMathStyleModel(WmiMathDocumentModel doc, WmiModel[] children, WmiMathStyleAttributeSet attrSet) throws WmiInvalidModelInitializationException {
        super(doc, children);
        try {
            this.setAttributesNoRecurse(attrSet);
        }
        catch (WmiNoWriteAccessException nwa) {
            WmiErrorLog.log(nwa);
        }
    }

    public WmiMathStyleModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
    }

    public WmiMathStyleModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_STYLE;
    }

    public void addTemporaryChild(WmiModel model) {
        WmiModel[] add = new WmiModel[]{model};
        this.ensureCapacity(1, this);
        if (model != null) {
            System.arraycopy(add, 0, this.children, 0, 1);
        }
        this.length = 1;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathAttributeSet) {
            this.updateChildrenWithAttributes(set, false);
            super.setAttributes(set);
            ((WmiMathStyleAttributeSet)this.attributes).attributeMap = (HashMap)((WmiMathStyleAttributeSet)set).attributeMap.clone();
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    public void setAttributesNoRecurse(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiMathAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    private void updateChildrenWithAttributes(WmiAttributeSet set, boolean fromBuild) {
        WmiGenericAttributeSet changes = WmiAttributeComparator.subtract(set, this.attributes);
        if (changes != null) {
            try {
                WmiModelUtil.visitModels(this, new WmiApplyStyleVisitor(this, changes, fromBuild));
            }
            catch (WmiNoReadAccessException nra) {
                WmiErrorLog.log(nra);
            }
        }
    }

    public void addAttribute(Object key, Object value, boolean fromBuild) throws WmiNoWriteAccessException {
        WmiGenericAttributeSet change = new WmiGenericAttributeSet();
        change.addAttribute(key, value);
        this.updateChildrenWithAttributes(change, fromBuild);
        super.addAttribute(key, value);
    }

    @Override
    public void addAttribute(Object key, Object value) throws WmiNoWriteAccessException {
        this.addAttribute(key, value, false);
    }

    @Override
    public void addAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        this.updateChildrenWithAttributes(set, false);
        super.addAttributes(set);
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathStyleAttributeSet();
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    public static class WmiApplyStyleVisitor
    implements WmiSearchVisitor {
        private WmiMathStyleModel parentModel;
        private WmiAttributeSet changes;
        private boolean fromBuild;

        public WmiApplyStyleVisitor(WmiMathStyleModel parentModel, WmiAttributeSet changes, boolean fromBuild) {
            this.parentModel = parentModel;
            this.changes = changes;
            this.fromBuild = fromBuild;
        }

        @Override
        public int visitMatch(Object match) {
            int exit;
            block15: {
                HashMap map = null;
                if (this.changes instanceof WmiMathStyleAttributeSet) {
                    map = ((WmiMathStyleAttributeSet)this.changes).attributeMap;
                } else {
                    map = new HashMap();
                    Enumeration attributeNames = this.changes.getAttributeNames();
                    while (attributeNames.hasMoreElements()) {
                        Object name = attributeNames.nextElement();
                        Object attribute = this.changes.getAttribute(name);
                        map.put(name, attribute);
                    }
                }
                exit = 2;
                try {
                    if (this.fromBuild && match != this.parentModel && match instanceof WmiMathStyleModel) {
                        exit = 1;
                        break block15;
                    }
                    if (!(match instanceof WmiMathModel)) break block15;
                    if (match != this.parentModel) {
                        try {
                            WmiAttributeSet tatts = ((WmiModel)match).getAttributes();
                            if (tatts != null) {
                                Object semantics = tatts.getAttribute("Typesetting:-msemantics");
                                boolean proceed = true;
                                boolean bl = proceed = !(semantics instanceof String) || ((String)semantics).indexOf("atomic") <= -1;
                                if (proceed) {
                                    tatts.addAttributes(this.changes);
                                    if (match instanceof WmiAbstractMathTokenModel) {
                                        ((WmiAbstractMathTokenModel)match).setAttributes(tatts, true, map);
                                    } else if (match instanceof WmiAbstractArrayCompositeMathModel) {
                                        ((WmiAbstractArrayCompositeMathModel)match).setAttributes(tatts, map);
                                    } else {
                                        ((WmiMathModel)match).setAttributes(tatts);
                                    }
                                }
                            }
                        }
                        catch (WmiNoReadAccessException nra) {
                            WmiErrorLog.log(nra);
                        }
                    }
                    exit = 0;
                }
                catch (WmiNoWriteAccessException nwa) {
                    WmiErrorLog.log(nwa);
                }
            }
            return exit;
        }
    }

    public static class WmiMathStyleAttributeSet
    extends WmiMathAttributeSet {
        public HashMap attributeMap = new HashMap();
        public static final String BACKGROUND = "background";
        public static final String VERYVERYTHINMATHSPACE = "veryverythinmathspace";
        public static final String VERYTHINMATHSPACE = "verythinmathspace";
        public static final String THINMATHSPACE = "thinmathspace";
        public static final String MEDIUMMATHSPACE = "mediummathspace";
        public static final String THICKMATHSPACE = "thickmathspace";
        public static final String VERYTHICKMATHSPACE = "verythickmathspace";
        public static final String VERYVERYTHICKMATHSPACE = "veryverythickmathspace";
        public static final String SCRIPTLEVEL = "scriptlevel";
        public static final String SCRIPTSIZEMULTIPLIER = "scriptsizemultiplier";
        public static final String SCRIPTMINSIZE = "scriptminsize";
        public static final int DEFAULT_BACKGROUND = 0xFFFFFF;
        public static final String DEFAULT_VERYVERYTHINMATHSPACE = "0.0555556em";
        public static final String DEFAULT_VERYTHINMATHSPACE = "0.111111em";
        public static final String DEFAULT_THINMATHSPACE = "0.166667em";
        public static final String DEFAULT_MEDIUMMATHSPACE = "0.222222em";
        public static final String DEFAULT_THICKMATHSPACE = "0.277778em";
        public static final String DEFAULT_VERYTHICKMATHSPACE = "0.333333em";
        public static final String DEFAULT_VERYVERYTHICKMATHSPACE = "0.388889em";
        public static final String DEFAULT_SCRIPTLEVEL = "0";
        public static final float DEFAULT_SCRIPTSIZEMULTIPLIER = 0.71f;
        public static final WmiDimensionUnit DEFAULT_SCRIPTMINSIZE = WmiDimensionUnit.createDimension("8pt", null);
        public static final String[] ATTRIBUTES = new String[]{"background", "veryverythinmathspace", "verythinmathspace", "thinmathspace", "mediummathspace", "thickmathspace", "verythickmathspace", "veryverythickmathspace", "scriptlevel", "scriptsizemultiplier", "scriptminsize"};
        public static final WmiAttributeKey[] STYLE_KEYS = new WmiAttributeKey[]{new BackgroundKey(), new VeryVeryThinMathSpaceKey(), new VeryThinMathSpaceKey(), new ThinMathSpaceKey(), new MediumMathSpaceKey(), new ThickMathSpaceKey(), new VeryThickMathSpaceKey(), new VeryVeryThickMathSpaceKey(), new ScriptLevelKey(), new ScriptSizeMultiplierKey(), new ScriptMinSizeKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, STYLE_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private int background = 0xFFFFFF;
        private String veryverythinmathspace = "0.0555556em";
        private String verythinmathspace = "0.111111em";
        private String thinmathspace = "0.166667em";
        private String mediummathspace = "0.222222em";
        private String thickmathspace = "0.277778em";
        private String verythickmathspace = "0.333333em";
        private String veryverythickmathspace = "0.388889em";
        private String scriptlevel = "0";
        private float scriptsizemultiplier = 0.71f;
        private WmiDimensionUnit scriptminsize = DEFAULT_SCRIPTMINSIZE;

        public WmiMathStyleAttributeSet() {
        }

        public WmiMathStyleAttributeSet(WmiMathStyleAttributeSet source) {
            super(source);
            this.background = source.background;
            this.veryverythinmathspace = source.veryverythinmathspace;
            this.verythinmathspace = source.verythinmathspace;
            this.thinmathspace = source.thinmathspace;
            this.mediummathspace = source.mediummathspace;
            this.thickmathspace = source.thickmathspace;
            this.verythickmathspace = source.verythickmathspace;
            this.veryverythickmathspace = source.veryverythickmathspace;
            this.scriptlevel = source.scriptlevel;
            this.scriptsizemultiplier = source.scriptsizemultiplier;
            this.scriptminsize = source.scriptminsize;
            this.attributeMap = source.attributeMap;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathStyleAttributeSet) {
                WmiMathStyleAttributeSet source = (WmiMathStyleAttributeSet)set;
                this.background = source.background;
                this.veryverythinmathspace = source.veryverythinmathspace;
                this.verythinmathspace = source.verythinmathspace;
                this.thinmathspace = source.thinmathspace;
                this.mediummathspace = source.mediummathspace;
                this.thickmathspace = source.thickmathspace;
                this.verythickmathspace = source.verythickmathspace;
                this.veryverythickmathspace = source.veryverythickmathspace;
                this.scriptlevel = source.scriptlevel;
                this.scriptsizemultiplier = source.scriptsizemultiplier;
                this.scriptminsize = source.scriptminsize;
                this.attributeMap = source.attributeMap;
            }
        }

        @Override
        public void setBackground(int color) {
            this.background = color;
            this.setExtendedStyle(32);
        }

        @Override
        public int getBackground() {
            return this.background;
        }

        public void setVeryVeryThinMathSpace(String vvthinmathspace) {
            this.veryverythinmathspace = vvthinmathspace;
        }

        public String getVeryVeryThinMathSpace() {
            return this.veryverythinmathspace;
        }

        public void setVeryThinMathSpace(String vthinmathspace) {
            this.verythinmathspace = vthinmathspace;
        }

        public String getVeryThinMathSpace() {
            return this.verythinmathspace;
        }

        public void setThinMathSpace(String thinmathspace) {
            this.thinmathspace = thinmathspace;
        }

        public String getThinMathSpace() {
            return this.thinmathspace;
        }

        public void setMediumMathSpace(String mediummathspace) {
            this.mediummathspace = mediummathspace;
        }

        public String getMediumMathSpace() {
            return this.mediummathspace;
        }

        public void setThickMathSpace(String thickmathspace) {
            this.thickmathspace = thickmathspace;
        }

        public String getThickMathSpace() {
            return this.thickmathspace;
        }

        public void setVeryThickMathSpace(String vthickmathspace) {
            this.verythickmathspace = vthickmathspace;
        }

        public String getVeryThickMathSpace() {
            return this.verythickmathspace;
        }

        public void setVeryVeryThickMathSpace(String vvthickmathspace) {
            this.veryverythickmathspace = vvthickmathspace;
        }

        public String getVeryVeryThickMathSpace() {
            return this.veryverythickmathspace;
        }

        public void setScriptLevel(String scriptlevel) {
            this.scriptlevel = scriptlevel;
        }

        public String getScriptLevel() {
            return this.scriptlevel;
        }

        public void setScriptSizeMultiplier(float multiplier) {
            this.scriptsizemultiplier = multiplier;
        }

        public float getScriptSizeMultiplier() {
            return this.scriptsizemultiplier;
        }

        public void setScriptMinSize(String scriptminsize) {
            this.scriptminsize = WmiDimensionUnit.createDimension(scriptminsize, null);
        }

        public WmiDimensionUnit getScriptMinSize() {
            return this.scriptminsize;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathStyleAttributeSet(this);
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathStyleAttributeSet) {
                WmiMathStyleAttributeSet ref = (WmiMathStyleAttributeSet)obj;
                equals = ref.background == this.background;
                equals &= this.veryverythinmathspace == ref.veryverythinmathspace;
                equals &= this.verythinmathspace == ref.verythinmathspace;
                equals &= this.thinmathspace == ref.thinmathspace;
                equals &= this.mediummathspace == ref.mediummathspace;
                equals &= this.thickmathspace == ref.thickmathspace;
                equals &= this.verythickmathspace == ref.verythickmathspace;
                equals &= this.veryverythickmathspace == ref.veryverythickmathspace;
                equals &= this.scriptlevel == ref.scriptlevel;
                equals &= this.scriptsizemultiplier == ref.scriptsizemultiplier;
                equals &= this.scriptminsize == ref.scriptminsize;
                equals &= this.attributeMap.equals(ref.attributeMap);
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.background;
            code ^= this.veryverythinmathspace.hashCode();
            code ^= this.verythinmathspace.hashCode();
            code ^= this.thinmathspace.hashCode();
            code ^= this.mediummathspace.hashCode();
            code ^= this.thickmathspace.hashCode();
            code ^= this.verythickmathspace.hashCode();
            code ^= this.veryverythickmathspace.hashCode();
            code ^= this.scriptlevel.hashCode();
            code ^= new Float(this.scriptsizemultiplier).hashCode();
            return code ^= this.scriptminsize.hashCode();
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        @Override
        public void addAttribute(Object key, Object value) {
            this.attributeMap.put(key, value);
            super.addAttribute(key, value);
        }

        public static class BackgroundKey
        extends WmiColorAttributeKey {
            public BackgroundKey() {
                super(WmiMathStyleAttributeSet.BACKGROUND, 0xFFFFFF);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).getBackground();
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiMathStyleAttributeSet)set).setBackground(value);
            }
        }

        public static class MediumMathSpaceKey
        extends WmiStringAttributeKey {
            public MediumMathSpaceKey() {
                super(WmiMathStyleAttributeSet.MEDIUMMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_MEDIUMMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).mediummathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).mediummathspace = value;
            }
        }

        public static class ScriptLevelKey
        extends WmiStringAttributeKey {
            public ScriptLevelKey() {
                super(WmiMathStyleAttributeSet.SCRIPTLEVEL, "");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).scriptlevel;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).scriptlevel = value;
            }
        }

        public static class ScriptMinSizeKey
        extends WmiStringAttributeKey {
            public ScriptMinSizeKey() {
                super(WmiMathStyleAttributeSet.SCRIPTMINSIZE, DEFAULT_SCRIPTMINSIZE.toString());
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).scriptminsize.toString();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).scriptminsize = WmiDimensionUnit.createDimension(value, null);
            }
        }

        public static class ScriptSizeMultiplierKey
        extends WmiFloatAttributeKey {
            public ScriptSizeMultiplierKey() {
                super(WmiMathStyleAttributeSet.SCRIPTSIZEMULTIPLIER, 0.71f);
            }

            @Override
            public float getFloatValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).scriptsizemultiplier;
            }

            @Override
            public void setFloatValue(WmiAttributeSet set, float value) {
                ((WmiMathStyleAttributeSet)set).scriptsizemultiplier = value;
            }
        }

        public static class ThickMathSpaceKey
        extends WmiStringAttributeKey {
            public ThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.THICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_THICKMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).thickmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).thickmathspace = value;
            }
        }

        public static class ThinMathSpaceKey
        extends WmiStringAttributeKey {
            public ThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.THINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_THINMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).thinmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).thinmathspace = value;
            }
        }

        public static class VeryThickMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYTHICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYTHICKMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).verythickmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).verythickmathspace = value;
            }
        }

        public static class VeryThinMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYTHINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYTHINMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).verythinmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).verythinmathspace = value;
            }
        }

        public static class VeryVeryThickMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryVeryThickMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYVERYTHICKMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYVERYTHICKMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).veryverythickmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).veryverythickmathspace = value;
            }
        }

        public static class VeryVeryThinMathSpaceKey
        extends WmiStringAttributeKey {
            public VeryVeryThinMathSpaceKey() {
                super(WmiMathStyleAttributeSet.VERYVERYTHINMATHSPACE, WmiMathStyleAttributeSet.DEFAULT_VERYVERYTHINMATHSPACE);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathStyleAttributeSet)set).veryverythinmathspace;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathStyleAttributeSet)set).veryverythinmathspace = value;
            }
        }
    }
}

