/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.dag.HfloatDagFactory;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractElisionBuilder;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericFormatter;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import java.awt.Color;
import java.text.DecimalFormatSymbols;

public class WmiNumericModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    public static final WmiInlineRationalSemantics INLINE_RATIONAL_SEMANTICS = new WmiInlineRationalSemantics();
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiNumericModel(WmiMathDocumentModel doc, String display, String semantics, WmiMathContext context) {
        super(doc, display, context.createAttributes(2), context);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiNumericModel(WmiMathDocumentModel doc, String display, WmiFontAttributeSet set) {
        super(doc, display, (WmiAttributeSet)set);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public void appendText(String text) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        super.appendText(" " + text);
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_NUMERIC;
    }

    @Override
    protected boolean checkForQuotes() {
        return false;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean isSubselectable() {
        return true;
    }

    @Override
    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        return new WmiNumericModel(this.getDocument(), this.getText().substring(offset), this.getText().substring(offset), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    public static class WmiComplexBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            String iunit = context.getImaginaryUnit();
            WmiNumericModel model = new WmiNumericModel(docModel, iunit, iunit, context);
            model.setSemantics(this);
            return model;
        }

        @Override
        public Dag toDag(WmiMathModel model) {
            Dag[] children = new Dag[]{DagConstants.ONE};
            return Dag.createDag(6, children, null, false);
        }
    }

    public static class WmiFloatBuilder
    implements WmiRenderContextAwareBuilder,
    WmiMathModelBuilder,
    WmiMathSemantics {
        private static final int ROUNDING_MINUS_LENGTH_COND = "&uminus0;".length() - 1;
        private static final char ROUNDING_MINUS_STOP_CHAR = "&uminus0;".charAt(ROUNDING_MINUS_LENGTH_COND);
        private static final int MANTISSA_DAG_INDEX = 0;
        private static final int EXPONENT_DAG_INDEX = 1;
        private static final String LINEBREAK_CONTEXT_NAME = "float";
        private static final int INFINITY_INDEX = 1;
        private static final String INFINITY_ID = "infinity";
        private static final int DEFAULT_DISPLAY_PRECISION = -1;
        private static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;
        private static int displayPrecision = -1;
        private static final String EXPLICIT_EXPONENTIATION_OPERATOR = "^";
        private static final String UNDEFINED_NAME = "undefined";
        private static final String ZERO_STRING = "0";
        private static final String POINT_STRING = ".";
        private static final String TEN = "10";

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            if (dag.getLength() == 2) {
                model = this.createFloatModel(dag.getChild(0), dag.getChild(1), dag, docModel, context);
                model.setSemantics(new WmiAssignedSemantics(dag));
            }
            return model;
        }

        protected WmiMathModel buildNaNModel(Dag mantissaDag, Dag exponentDag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            if (DagUtil.isNameNamed(exponentDag, UNDEFINED_NAME) || DagUtil.isNameNamed(mantissaDag, UNDEFINED_NAME)) {
                if (mantissaDag.getData().equals("1") && mantissaDag.getType() == 2) {
                    model = WmiMathFactory.createMath(docModel, DagConstants.UNDEFINED, context);
                } else {
                    if (mantissaDag.getType() == 16) {
                        mantissaDag = SumDagFactory.sumDagToIntegerDag(mantissaDag);
                    }
                    Dag[] expseqUndefined = new Dag[]{DagConstants.NAME_UNDEFINED};
                    Dag[] argsUndefined = new Dag[2];
                    argsUndefined[0] = DagConstants.NAME_FLOAT;
                    Dag[] children = new Dag[2];
                    children[1] = Dag.createDag(29, expseqUndefined, null, false);
                    children[0] = Dag.createDag(mantissaDag.getType(), null, mantissaDag.getData(), false);
                    argsUndefined[1] = Dag.createDag(29, children, null, false);
                    Dag UNDEFINED = Dag.createDag(18, argsUndefined, null, false);
                    model = WmiMathFactory.createMath(docModel, UNDEFINED, context);
                }
            }
            return model;
        }

        protected long calculateScientificNotationExponent(int mantissaLength, long exponent) {
            long expCount = 0L;
            long mantExpDif = (long)mantissaLength + exponent;
            expCount = exponent < 0L && Math.abs(mantExpDif) >= 5L ? mantExpDif : (exponent < 0L ? 0L : (mantExpDif == 0L ? mantExpDif : mantExpDif));
            expCount = Math.abs(expCount) < 6L ? 0L : expCount;
            return expCount;
        }

        protected WmiMathModel createScientificNotationModel(WmiMathDocumentModel docModel, String strMantissa, StringBuffer floatData, WmiMathContext context, long expCount) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiInlineMathModel model = new WmiInlineMathModel(docModel);
            model.addAttributes(context.getStyle());
            WmiAbstractArrayCompositeModel composite = model;
            int rightLength = strMantissa.length();
            rightLength = displayPrecision >= 0 ? displayPrecision : rightLength;
            floatData = WmiFloatBuilder.buildFloatString(floatData, strMantissa, 0, 0, 1, rightLength);
            if (floatData.toString().indexOf(POINT_STRING) == -1) {
                floatData.append(POINT_STRING);
            }
            String f = floatData.toString();
            WmiNumericModel mantissaModel = new WmiNumericModel(docModel, f, f, context);
            mantissaModel.setSemantics(this);
            String sciNotexp = Long.toString(expCount - 1L);
            WmiNumericModel baseModel = new WmiNumericModel(docModel, TEN, TEN, context);
            WmiNumericModel exponentModel = new WmiNumericModel(docModel, sciNotexp, sciNotexp, context);
            composite.appendChild(mantissaModel);
            if (context.useProcRules()) {
                composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, "&sdot;", context));
                composite.appendChild(baseModel);
                composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, EXPLICIT_EXPONENTIATION_OPERATOR, context));
                composite.appendChild(exponentModel);
            } else {
                composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, "&InvisibleTimes;", context));
                WmiSuperscriptModel sm = new WmiSuperscriptModel(docModel, baseModel, exponentModel, context);
                composite.appendChild(sm);
            }
            return model;
        }

        public WmiMathModel createFloatModel(Dag mantissaDag, Dag exponentDag, Dag fullDag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            StringBuffer floatData = new StringBuffer();
            model = this.buildFloatInfinityModel(mantissaDag, exponentDag, docModel, context);
            if (model == null) {
                model = this.buildNaNModel(mantissaDag, exponentDag, docModel, context);
            }
            if (model == null) {
                if (DagUtil.isSum(mantissaDag)) {
                    mantissaDag = SumDagFactory.sumDagToIntegerDag(mantissaDag);
                }
                if (DagUtil.isSum(exponentDag)) {
                    exponentDag = SumDagFactory.sumDagToIntegerDag(exponentDag);
                }
                boolean negative = DagUtil.isNegInt(mantissaDag);
                String strMantissa = mantissaDag.getData();
                long exponent = WmiFloatBuilder.calculateExponent(exponentDag);
                int mantissaLength = strMantissa.length();
                long expCount = this.calculateScientificNotationExponent(mantissaLength, exponent);
                if (negative) {
                    floatData.append("&uminus0;");
                }
                if (expCount != 0L) {
                    model = this.createScientificNotationModel(docModel, strMantissa, floatData, context, expCount);
                } else {
                    String f;
                    assert (Math.abs(exponent) < Integer.MAX_VALUE);
                    int iexp = (int)exponent;
                    int leftHS = mantissaLength + iexp;
                    int rightHS = mantissaLength;
                    int lpad = 0;
                    int rpad = 0;
                    if (iexp < 0 && Math.abs(iexp) > mantissaLength) {
                        lpad = 1;
                        rpad = Math.abs(iexp) - mantissaLength;
                    }
                    int n = rightHS = displayPrecision >= 0 ? displayPrecision + leftHS : rightHS;
                    if (mantissaLength < leftHS) {
                        int i = 0;
                        while (i < leftHS - mantissaLength) {
                            strMantissa = String.valueOf(strMantissa) + ZERO_STRING;
                            ++i;
                        }
                    }
                    if ((floatData = WmiFloatBuilder.buildFloatString(floatData, strMantissa, lpad, rpad, leftHS, rightHS)).toString().indexOf(POINT_STRING) == -1) {
                        if (displayPrecision <= 0) {
                            floatData.append(POINT_STRING);
                        } else {
                            StringBuffer postZeros = new StringBuffer();
                            postZeros.append(POINT_STRING);
                            int i = 1;
                            while (i <= displayPrecision) {
                                postZeros.append(ZERO_STRING);
                                ++i;
                            }
                            floatData.append(postZeros);
                        }
                    }
                    String display = f = floatData.toString();
                    model = new WmiNumericModel(docModel, display, f, context);
                }
            }
            return model;
        }

        public static long calculateExponent(Dag exp) {
            long exponent = 0L;
            try {
                exponent = Long.parseLong(exp.getData());
                exponent = exp.getType() == 1 ? exponent * -1L : exponent;
            }
            catch (Exception e) {
                WmiErrorLog.log(e);
                exponent = 0L;
            }
            return exponent;
        }

        public static StringBuffer buildFloatString(StringBuffer floats, String mantissa, int lprepad, int rprepad, int leftHandSide, int rightHandSide) {
            char[] mantChars = mantissa.toCharArray();
            int mantLength = mantChars.length;
            int pos = 0;
            int i = 0;
            while (i < lprepad) {
                floats.append(ZERO_STRING);
                ++i;
            }
            while (pos < leftHandSide) {
                floats.append(mantChars[pos]);
                ++pos;
            }
            if (mantLength != leftHandSide) {
                floats.append(POINT_STRING);
                i = 0;
                while (i < rprepad) {
                    floats.append(ZERO_STRING);
                    ++i;
                }
                while (pos < rightHandSide) {
                    if (pos >= mantLength) {
                        floats.append(ZERO_STRING);
                    } else if (pos == rightHandSide - 1 && mantChars.length > rightHandSide) {
                        char digit = mantChars[pos + 1];
                        if (digit > '4' && digit <= '9') {
                            digit = mantChars[pos];
                            if (digit == '9') {
                                floats.append('0');
                                int index = floats.length() - 2;
                                while (index > -1) {
                                    digit = floats.charAt(index);
                                    if (digit == '.') {
                                        if (index > 0) {
                                            --index;
                                            continue;
                                        }
                                        floats.insert(0, "1");
                                        break;
                                    }
                                    if (digit == ROUNDING_MINUS_STOP_CHAR && index == ROUNDING_MINUS_LENGTH_COND) {
                                        floats.insert(index + 1, "1");
                                        break;
                                    }
                                    if (digit != '9') {
                                        digit = (char)(digit + '\u0001');
                                        String val = Character.toString(digit);
                                        floats.replace(index, index + 1, val);
                                        break;
                                    }
                                    floats.setCharAt(index, '0');
                                    if (index == 0) {
                                        floats.insert(0, "1");
                                    }
                                    --index;
                                }
                            } else {
                                digit = (char)(digit + '\u0001');
                                floats.append(digit);
                            }
                        } else {
                            floats.append(mantChars[pos]);
                        }
                    } else {
                        floats.append(mantChars[pos]);
                    }
                    ++pos;
                }
            }
            if (floats.length() > 0) {
                if (floats.charAt(0) == '.') {
                    floats.insert(0, '0');
                }
                if (floats.indexOf("-.") == 0) {
                    floats.insert(1, '0');
                }
            }
            return floats;
        }

        public WmiMathModel buildFloatInfinityModel(Dag mantissaDag, Dag exponentDag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            if (this.isFloatInfinity(exponentDag)) {
                boolean negative = false;
                if (mantissaDag.getType() == 16) {
                    negative = DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(mantissaDag));
                }
                if (exponentDag.getType() == 16) {
                    negative = DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(exponentDag));
                }
                if (!negative) {
                    negative = mantissaDag.getType() == 1 || exponentDag.getType() == 1;
                }
                Dag infinity = negative ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
                model = WmiMathFactory.createMath(docModel, infinity, context);
            }
            return model;
        }

        private boolean isFloatInfinity(Dag exponentDag) {
            return exponentDag.getType() == 8 && exponentDag.getData().equals(INFINITY_ID) || exponentDag.getType() == 16 && exponentDag.getChild(1).getData().equals(INFINITY_ID);
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag dag = null;
            if (model instanceof WmiTextModel) {
                String text = ((WmiTextModel)((Object)model)).getText();
                int start = 0;
                while (start < text.length()) {
                    if (text.charAt(start) != '0') break;
                    ++start;
                }
                int decimalPosition = text.indexOf(46);
                Dag[] children = new Dag[2];
                int dagSign = 2;
                if (text.startsWith("&uminus0;") || text.startsWith("&minus;") || text.startsWith(" \u2212 ") || text.startsWith("\u2212")) {
                    text = text.substring(1);
                    dagSign = 1;
                    --decimalPosition;
                }
                if (decimalPosition == start) {
                    children[0] = Dag.createDag(dagSign, null, text.substring(start + 1), false);
                    children[1] = Dag.createDag(1, null, Integer.toString(text.length() - start - 1), false);
                } else if (decimalPosition > 0) {
                    int shift = text.length() - decimalPosition - 1;
                    if (decimalPosition < text.length() - 1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(text.substring(start, decimalPosition));
                        sb.append(text.substring(decimalPosition + 1));
                        children[0] = Dag.createDag(dagSign, null, sb.toString(), false);
                        children[1] = shift > 0 ? Dag.createDag(1, null, Integer.toString(shift), false) : Dag.createDag(2, null, Integer.toString(-shift), false);
                    } else {
                        children[0] = Dag.createDag(dagSign, null, text.substring(start, text.length() - 1), false);
                        children[1] = DagConstants.ZERO;
                    }
                } else {
                    children[0] = Dag.createDag(dagSign, null, text, false);
                    children[1] = DagConstants.ZERO;
                }
                dag = Dag.createDag(4, children, null, false);
            }
            return dag;
        }

        @Override
        public void updateContext(DagRenderContext context) {
            displayPrecision = context.getInterfaceProperty("displayprecision", -1);
        }
    }

    public static class WmiHFloatBuilder
    extends WmiFloatBuilder {
        private static final int MAX_HFLOAT_DIGITS = 15;

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            double value = HfloatDagFactory.getDoubleValue(dag);
            String strValue = Double.toString(value);
            if (strValue.equals("Infinity")) {
                model = this.createHFloatModel(docModel, context, "infinity", false);
            } else if (strValue.equals("-Infinity")) {
                model = this.createHFloatModel(docModel, context, "infinity", true);
            } else if (strValue.equals("NaN")) {
                model = this.createHFloatModel(docModel, context, "undefined", false);
            } else {
                int decimalPos;
                String mantissa = strValue;
                int expPos = strValue.indexOf(69);
                int shift = 0;
                if (expPos >= 0) {
                    shift = Integer.parseInt(strValue.substring(expPos + 1));
                    mantissa = strValue.substring(0, expPos);
                }
                if ((decimalPos = mantissa.indexOf(46)) >= 0) {
                    shift -= mantissa.length() - decimalPos - 1;
                    mantissa = decimalPos != 0 ? String.valueOf(mantissa.substring(0, decimalPos)) + mantissa.substring(decimalPos + 1) : mantissa.substring(decimalPos + 1);
                }
                int mantissaType = 2;
                int expType = 2;
                if (mantissa.length() > 0 && mantissa.startsWith("-")) {
                    mantissaType = 1;
                    mantissa = mantissa.substring(1);
                }
                if (shift < 0) {
                    shift = -shift;
                    expType = 1;
                }
                Dag mantissaDag = Dag.createDag(mantissaType, null, mantissa, false);
                Dag expDag = Dag.createDag(expType, null, Integer.toString(shift), false);
                model = this.createFloatModel(mantissaDag, expDag, dag, docModel, context);
                model.setSemantics(this);
            }
            return model;
        }

        private WmiMathModel createHFloatModel(WmiMathDocumentModel docModel, WmiMathContext context, String name, boolean negate) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathModel model = null;
            Dag[] args = new Dag[]{Dag.createDag(8, null, name, false)};
            if (negate) {
                Dag[] sumArgs = new Dag[]{args[0], DagConstants.MINUS_ONE};
                args[0] = Dag.createDag(16, sumArgs, null, false);
            }
            Dag funcDag = FunctionDagFactory.createFunctionDag("HFloat", args);
            model = WmiMathFactory.createMath(docModel, funcDag, context);
            return model;
        }
    }

    public static class WmiInlineRationalSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            WmiMathModel numerator = (WmiMathModel)composite.getChild(0);
            WmiMathModel denominator = (WmiMathModel)composite.getChild(2);
            Dag[] children = new Dag[]{numerator.toDag(), denominator.toDag()};
            WmiSemanticDagUtil.fillNullDags(children);
            return Dag.createDag(3, children, null, false);
        }
    }

    public static abstract class WmiIntBuilder
    extends WmiAbstractElisionBuilder
    implements WmiMathSemantics {
        public static final String ELISION_MARKER_TEXT = "digits";
        public static final String SINGLE_ELISION_MARKER_TEXT = "digit";
        private static final String LINEBREAK_CONTEXT_NAME = "integer";

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoWriteAccessException {
            String numberStr = dag.getData();
            int length = numberStr.length();
            String semantics = numberStr;
            if (this.isElisionRequired(length)) {
                StringBuffer finalStr = new StringBuffer();
                int elisionSize = length - this.leftSample - this.rightSample;
                finalStr.append(numberStr.substring(0, this.leftSample));
                finalStr.append("[...");
                finalStr.append(elisionSize);
                finalStr.append(" ");
                if (elisionSize > 1) {
                    finalStr.append(this.getElisionMarkerText());
                } else {
                    finalStr.append(this.getSingleElisionMarkerText());
                }
                finalStr.append("...]");
                finalStr.append(numberStr.substring(length - this.rightSample, length));
                semantics = finalStr.toString();
            }
            String display = semantics;
            WmiAbstractModel model = new WmiNumericModel(docModel, display, semantics, context);
            model.setSemantics(new WmiAssignedSemantics(dag));
            String prefix = this.getPrefix(context);
            if (prefix != null && prefix.length() > 0) {
                WmiModel[] kids = new WmiMathModel[]{new WmiMathOperatorModel(docModel, prefix, prefix, context), model};
                try {
                    model = new WmiInlineMathModel(docModel, kids);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            return model;
        }

        @Override
        protected String getElisionThresholdProperty() {
            return "elisiondigitsthreshold";
        }

        @Override
        protected String getElisionAfterProperty() {
            return "elisiondigitsafter";
        }

        @Override
        protected String getElisionBeforeProperty() {
            return "elisiondigitsbefore";
        }

        @Override
        protected int getDefaultElideThreshold() {
            return 10000;
        }

        @Override
        public String getSingleElisionMarkerText() {
            return SINGLE_ELISION_MARKER_TEXT;
        }

        @Override
        public String getElisionMarkerText() {
            return ELISION_MARKER_TEXT;
        }

        public abstract String getPrefix(WmiMathContext var1);

        @Override
        public abstract Dag toDag(WmiMathModel var1) throws WmiNoReadAccessException;
    }

    public static class WmiIntNegBuilder
    extends WmiIntBuilder {
        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiModel child;
            WmiCompositeModel inline;
            String value = null;
            int dagType = 2;
            if (model instanceof WmiTextModel) {
                WmiTextModel text = (WmiTextModel)((Object)model);
                value = text.getText();
                if (value.length() > 0 && (value.startsWith("&uminus0;") || value.startsWith("&minus;") || value.startsWith(" \u2212 ") || value.startsWith("\u2212"))) {
                    value = value.substring(1);
                    dagType = 1;
                }
            } else if (model instanceof WmiInlineMathModel && (inline = (WmiCompositeModel)((Object)model)).getChildCount() == 2 && (child = inline.getChild(1)) instanceof WmiTextModel) {
                value = ((WmiTextModel)child).getText();
            }
            return value != null ? Dag.createDag(dagType, null, value, false) : null;
        }

        @Override
        public String getPrefix(WmiMathContext context) {
            return context.useProcRules() ? "\u2212" : "&uminus0;";
        }
    }

    public static class WmiIntPosBuilder
    extends WmiIntBuilder {
        @Override
        public String getPrefix(WmiMathContext context) {
            return "";
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiTextModel text = (WmiTextModel)((Object)model);
            String value = text.getText();
            return Dag.createDag(2, null, value, false);
        }
    }

    public static class WmiMaskBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        private static final String EXPLICIT_EXPONENTIATION_OPERATOR = "^";

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiInlineMathModel model;
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            WmiNumericFormatter formatter = new WmiNumericFormatter(Character.toString(dfs.getDecimalSeparator()), Character.toString(dfs.getGroupingSeparator()));
            String mask = context.getFormatMask();
            WmiNumericFormatter.WmiFormattedNumeric formatted = formatter.format(dag, mask);
            String ten = new String("10");
            WmiInlineMathModel composite = model = new WmiInlineMathModel(docModel);
            String f = formatted.getMantissa();
            boolean noMantissa = false;
            boolean noDigits = true;
            if (f != null) {
                int i = 0;
                while (i < f.length()) {
                    if (Character.isDigit(f.charAt(i))) {
                        noDigits = false;
                        break;
                    }
                    ++i;
                }
            }
            if (f == null || noDigits) {
                noMantissa = true;
            }
            if (formatted.getSign() == -1 && (f.length() == 0 || f.charAt(0) != '-')) {
                f = "-" + f;
            }
            WmiNumericModel mantissaModel = null;
            WmiMathOperatorModel negativeModel = null;
            if (f.length() > 0) {
                if (f.charAt(0) == '-') {
                    negativeModel = new WmiMathOperatorModel(docModel, "&uminus0;", "&uminus0;", context);
                    composite.appendChild(negativeModel);
                    f = f.substring(1);
                }
                mantissaModel = new WmiNumericModel(docModel, f, f, context);
                composite.appendChild(mantissaModel);
            }
            WmiModel exponentModel = null;
            WmiAbstractModel baseModel = null;
            WmiAbstractModel multiplyModel = null;
            String sciNotexp = formatted.getExponent();
            if (sciNotexp != null) {
                char firstChar = sciNotexp.charAt(0);
                String sign = "";
                if (firstChar == '-' || firstChar == '+') {
                    sciNotexp = sciNotexp.substring(1);
                    sign = Character.toString(firstChar);
                }
                if (!context.isEngineeringNotation() || Long.parseLong(sciNotexp) != 0L) {
                    multiplyModel = new WmiMathOperatorModel(docModel, "&times;", "&times;", context);
                    baseModel = new WmiNumericModel(docModel, ten, ten, context);
                    if (sign.length() == 0) {
                        exponentModel = new WmiNumericModel(docModel, sciNotexp, sciNotexp, context);
                    } else {
                        WmiNumericModel sciExponentNumberModel = new WmiNumericModel(docModel, sciNotexp, sciNotexp, context);
                        WmiMathOperatorModel sciSignModel = new WmiMathOperatorModel(docModel, sign, sign, context);
                        exponentModel = new WmiInlineMathModel(docModel);
                        ((WmiInlineMathModel)exponentModel).appendChild(sciSignModel);
                        ((WmiInlineMathModel)exponentModel).appendChild(sciExponentNumberModel);
                    }
                    if (context.useProcRules()) {
                        composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, "&sdot;", context));
                        composite.appendChild(baseModel);
                        composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, EXPLICIT_EXPONENTIATION_OPERATOR, context));
                        composite.appendChild(exponentModel);
                    } else {
                        if (!noMantissa) {
                            composite.appendChild(multiplyModel);
                        }
                        WmiSuperscriptModel sm = new WmiSuperscriptModel(docModel, baseModel, exponentModel, context);
                        composite.appendChild(sm);
                    }
                }
            }
            float[] colorarray = formatted.getRGBColor();
            Color color = null;
            if (colorarray != null) {
                color = new Color(colorarray[0], colorarray[1], colorarray[2]);
            } else if (context.getStyle() != null) {
                color = new Color(context.getStyle().getForeground());
            }
            if (color != null) {
                if (mantissaModel != null) {
                    mantissaModel.addAttribute("foreground", color);
                }
                if (exponentModel != null) {
                    multiplyModel.addAttribute("foreground", color);
                    exponentModel.addAttribute("foreground", color);
                    baseModel.addAttribute("foreground", color);
                }
            }
            WmiMathActionModel wrapper = new WmiMathActionModel(docModel);
            wrapper.addAttribute("actiontype", "maplesoft:numeric_formatting");
            wrapper.setSemantics(new WmiAssignedSemantics(dag));
            try {
                try {
                    WmiModelLock.writeLock(wrapper, true);
                    wrapper.addChild(model, 0);
                }
                catch (WmiNoWriteAccessException e) {
                    e.printStackTrace();
                    WmiModelLock.writeUnlock(wrapper);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    e.printStackTrace();
                    WmiModelLock.writeUnlock(wrapper);
                }
            }
            finally {
                WmiModelLock.writeUnlock(wrapper);
            }
            return wrapper;
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            return null;
        }
    }

    public static class WmiRationalBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        private static final WmiInlineRationalSemantics INLINE_RATIONAL_SEMANTICS = new WmiInlineRationalSemantics();

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            boolean negate = false;
            Dag numeratorDag = dag.getChild(0);
            if (DagUtil.isNegative(numeratorDag)) {
                negate = true;
                numeratorDag = DagUtil.negate(numeratorDag);
            }
            WmiMathModel numerator = WmiMathFactory.createMath(docModel, numeratorDag, context);
            WmiMathModel denominator = WmiMathFactory.createMath(docModel, dag.getChild(1), context);
            WmiMathModel model = null;
            if (context.useProcRules()) {
                model = WmiRationalBuilder.createInlineFraction(docModel, numerator, denominator, context);
            } else {
                model = new WmiFractionModel(docModel, numerator, denominator, context);
                model.setSemantics(new WmiAssignedSemantics(dag));
            }
            if (negate) {
                WmiModel[] kids = new WmiMathModel[2];
                String prefix = context.useProcRules() ? "\u2212" : "&uminus0;";
                kids[0] = new WmiMathOperatorModel(docModel, prefix, prefix, context);
                kids[1] = model;
                try {
                    model = new WmiInlineMathModel(docModel, kids);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            return model;
        }

        public static WmiMathModel createInlineFraction(WmiMathDocumentModel docModel, WmiMathModel numerator, WmiMathModel denominator, WmiMathContext context) throws WmiNoWriteAccessException {
            WmiInlineMathModel model = new WmiInlineMathModel(docModel);
            WmiModel[] children = new WmiMathModel[]{numerator, WmiMathFactory.createMathOperatorToken(docModel, "/", context), denominator};
            try {
                model.replaceChildren(children, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            model.setSemantics(INLINE_RATIONAL_SEMANTICS);
            return model;
        }

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            WmiMathModel numerator = (WmiMathModel)composite.getChild(0);
            WmiMathModel denominator = (WmiMathModel)composite.getChild(1);
            Dag[] children = new Dag[]{numerator.toDag(), denominator.toDag()};
            return Dag.createDag(3, children, null, false);
        }
    }
}

