/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import java.util.HashMap;

public class WmiOverModel
extends WmiTwoArgumentMathModel {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiOverModel(WmiMathDocumentModel docModel, WmiModel center, WmiModel over, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, center, over);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiOverModel(WmiMathDocumentModel docModel) {
        super(docModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_OVER;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics semantics = this.getSemantics();
        return semantics != null ? semantics.toDag(this) : null;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiOverAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiOverAttributeSet();
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        boolean scriptSize = false;
        if (this.getChildCount() > 0 && child != this.getChild(0)) {
            WmiAttributeSet set = this.getAttributesForRead();
            scriptSize = !WmiOverAttributeSet.ACCENT_KEY.getBooleanValue(set);
        }
        return scriptSize;
    }

    public static class WmiOverAttributeSet
    extends WmiUnderOverModel.WmiUnderOverAttributeSet {
        public static final WmiAttributeKey ACCENT_KEY = new OverKey();
        public static final WmiAttributeKey[] OVER_KEYS = new WmiAttributeKey[]{ACCENT_KEY};
        public static final WmiAttributeKey[] EXTENDED_KEYS_OVER = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), OVER_KEYS);
        private static final int ACCENT_HASH_BIT = 128;
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();

        public WmiOverAttributeSet() {
        }

        public WmiOverAttributeSet(WmiOverAttributeSet attribs) {
            super(attribs);
            this.accentProperty = attribs.accentProperty;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiOverAttributeSet(this);
        }

        @Override
        public boolean getAccent() {
            return this.accentProperty;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiOverAttributeSet) {
                WmiOverAttributeSet source = (WmiOverAttributeSet)set;
                this.accentProperty = source.accentProperty;
            } else if (set instanceof WmiUnderOverModel.WmiUnderOverAttributeSet) {
                WmiUnderOverModel.WmiUnderOverAttributeSet source = (WmiUnderOverModel.WmiUnderOverAttributeSet)set;
                this.accentProperty = source.accentProperty;
            }
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiOverAttributeSet) {
                WmiOverAttributeSet ref = (WmiOverAttributeSet)obj;
                equals = ref.accentProperty == this.accentProperty;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            return code ^= this.accentProperty ? 128 : 0;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_OVER;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class OverKey
        extends WmiBooleanAttributeKey {
            public OverKey() {
                super("accent", false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return set instanceof WmiOverAttributeSet ? ((WmiOverAttributeSet)set).getAccent() : false;
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                if (set instanceof WmiOverAttributeSet) {
                    ((WmiOverAttributeSet)set).accentProperty = value;
                }
            }
        }
    }
}

