/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;

public class WmiPowerBuilder
implements WmiMathModelBuilder,
WmiSpecialFunctionBuilder,
WmiMathSemantics {
    public static final String SQUARE_ROOT_FUNCTION_NAME = "sqrt";
    public static final String NTH_ROOT_FUNCTION_NAME = "surd";
    private static final int INLINE_FRAC_THRESHOLD = 2;
    private static final int BASE_DAG_INDEX = 0;
    private static final int EXPONENT_DAG_INDEX = 1;
    private static final int NUMERATOR_DAG_INDEX = 0;
    private static final int DENOMINATOR_DAG_INDEX = 1;
    private static final int INLINE_POWER_SIZE = 3;
    public static final String CARET_EXPONENT_OPERATOR = "^";
    private static final WmiMathSemantics ROOT_SEMANTICS = new WmiRootSemantics();
    private static final String LINEBREAK_CONTEXT_NAME = "power";

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = null;
        Dag baseDag = dag.getChild(0);
        Dag exponentDag = dag.getChild(1);
        WmiMathModel base = WmiMathFactory.createMath(docModel, baseDag, context);
        model = context.useProcRules() ? this.createInlinePowerModel(docModel, base, dag, baseDag, exponentDag, context) : (DagUtil.isOneHalf(exponentDag) ? this.createSquareRootModel(docModel, base, context) : (baseDag.getType() == 10 ? this.createSubSupPower(docModel, dag, baseDag, exponentDag, context) : this.createPowerModel(docModel, base, dag, baseDag, exponentDag, context)));
        if (context.shouldSubExpressionLabel(model, dag)) {
            model = context.createSubexpressionLabel(model, dag);
        }
        return model;
    }

    private WmiMathModel createInlinePowerModel(WmiMathDocumentModel docModel, WmiMathModel base, Dag dag, Dag baseDag, Dag exponentDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel powerModel = new WmiInlineMathModel(docModel);
        WmiModel[] children = new WmiMathModel[3];
        WmiMathModel exponent = WmiMathFactory.createMath(docModel, exponentDag, context);
        if (WmiPrecedenceRules.areBracketsRequired(baseDag, dag, 1)) {
            base = WmiMathFactory.addBrackets(base, context);
        }
        if (WmiPrecedenceRules.areBracketsRequired(exponentDag, dag, 1)) {
            exponent = WmiMathFactory.addBrackets(exponent, context);
        }
        children[0] = base;
        children[1] = WmiMathFactory.createMathOperatorToken(docModel, CARET_EXPONENT_OPERATOR, context);
        children[2] = exponent;
        try {
            powerModel.replaceChildren(children, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        return powerModel;
    }

    protected WmiMathModel createSubSupPower(WmiMathDocumentModel docModel, Dag dag, Dag baseDag, Dag exponentDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel exponent = this.createExponent(docModel, exponentDag, context);
        WmiMathModel centralComponent = WmiMathFactory.createMath(docModel, baseDag.getChild(0), context);
        WmiMathModel index = WmiMathFactory.createMath(docModel, baseDag.getChild(1), context);
        if (WmiPrecedenceRules.areBracketsRequired(exponentDag, dag, 1)) {
            exponent = WmiMathFactory.addBrackets(exponent, context);
        }
        WmiSubSupModel powerModel = new WmiSubSupModel(docModel, centralComponent, index, exponent, context);
        powerModel.setSemantics(this);
        return powerModel;
    }

    private WmiMathModel createExponent(WmiMathDocumentModel docModel, Dag exponentDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel exponent = null;
        if (exponentDag.getType() == 3) {
            Dag numerator = exponentDag.getChild(0);
            Dag denominator = exponentDag.getChild(1);
            if (numerator.getData().length() <= 2 && denominator.getData().length() <= 2) {
                exponent = new WmiInlineMathModel(docModel);
                ((WmiCompositeModel)((Object)exponent)).appendChild(WmiMathFactory.createMath(docModel, numerator, context));
                ((WmiCompositeModel)((Object)exponent)).appendChild(WmiMathFactory.createMathOperatorToken(docModel, "/", context));
                ((WmiCompositeModel)((Object)exponent)).appendChild(WmiMathFactory.createMath(docModel, denominator, context));
                exponent.setSemantics(WmiNumericModel.INLINE_RATIONAL_SEMANTICS);
            }
        }
        if (exponent == null) {
            exponent = WmiMathFactory.createMath(docModel, exponentDag, context);
        }
        return exponent;
    }

    protected WmiMathModel createPowerModel(WmiMathDocumentModel docModel, WmiMathModel base, Dag dag, Dag baseDag, Dag exponentDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel exponent = this.createExponent(docModel, exponentDag, context);
        if (base instanceof WmiRootModel || WmiPrecedenceRules.areBracketsRequired(baseDag, dag, 1)) {
            base = WmiMathFactory.addBrackets(base, context);
        }
        WmiSuperscriptModel powerModel = new WmiSuperscriptModel(docModel, base, exponent, context);
        powerModel.setSemantics(this);
        return powerModel;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel root = null;
        WmiMathModel base = WmiMathFactory.createMath(doc, argParent.getChild(0), context);
        if (funcName.equals(SQUARE_ROOT_FUNCTION_NAME)) {
            root = this.createSquareRootModel(doc, base, context);
        } else {
            WmiMathModel powModel = WmiMathFactory.createMath(doc, argParent.getChild(1), context);
            root = new WmiRootModel(doc, base, powModel, context);
            root.setSemantics(ROOT_SEMANTICS);
        }
        return root;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        int locationOfName;
        Dag name;
        boolean useTemplate;
        boolean bl = useTemplate = !context.useProcRules();
        if (useTemplate && !(name = dag.getChild(locationOfName = 0)).getData().equals(SQUARE_ROOT_FUNCTION_NAME)) {
            Dag power;
            int locationOfArguments = 1;
            int locationOfPowerInArguments = 1;
            Dag arguments = dag.getChild(locationOfArguments);
            useTemplate = arguments != null && arguments.getLength() > 1 ? (power = arguments.getChild(locationOfPowerInArguments)) != null && (power.getType() == 2 || power.getType() == 8) && power.getData().length() == 1 : false;
        }
        return useTemplate;
    }

    protected WmiMathModel createSquareRootModel(WmiMathDocumentModel docModel, WmiMathModel base, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiRootModel.WmiSquareRootModel root = new WmiRootModel.WmiSquareRootModel(docModel, (WmiModel)base, context);
        root.setSemantics(ROOT_SEMANTICS);
        return root;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        int size;
        Dag power = null;
        WmiCompositeModel composite = model instanceof WmiCompositeModel ? (WmiCompositeModel)((Object)model) : null;
        int n = size = composite != null ? composite.getChildCount() : 0;
        if (size == 2 && composite.getTag() == WmiModelTag.MATH_SUPERSCRIPT) {
            WmiMathModel base = (WmiMathModel)composite.getChild(0);
            WmiMathModel exponent = (WmiMathModel)composite.getChild(1);
            Dag[] kids = new Dag[]{base.toDag(), exponent.toDag()};
            power = Dag.createDag(13, kids, null, false);
        } else if (size == 3 && composite.getTag() == WmiModelTag.MATH_SUB_SUP) {
            WmiMathModel base = (WmiMathModel)composite.getChild(0);
            WmiMathModel sub = (WmiMathModel)composite.getChild(1);
            WmiMathModel sup = (WmiMathModel)composite.getChild(2);
            Dag[] children = new Dag[]{base.toDag(), sub.toDag()};
            WmiSemanticDagUtil.fillNullDags(children);
            Dag tableRef = Dag.createDag(10, children, null, false);
            children = new Dag[]{tableRef, sup.toDag()};
            WmiSemanticDagUtil.fillNullDags(children);
            power = Dag.createDag(13, children, null, false);
        }
        return power;
    }

    public static class WmiRootSemantics
    implements WmiMathSemantics {
        private static final String LINEBREAK_CONTEXT_NAME = "root";

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag dag = null;
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            WmiMathModel base = (WmiMathModel)composite.getChild(0);
            Dag[] children = new Dag[2];
            children[0] = base.toDag();
            int size = composite.getChildCount();
            if (size == 1) {
                children[1] = DagConstants.ONE_HALF;
                WmiSemanticDagUtil.fillNullDags(children);
                dag = Dag.createDag(13, children, null, false);
            } else if (size > 1) {
                WmiMathModel nroot = (WmiMathModel)composite.getChild(1);
                children[1] = nroot.toDag();
                WmiSemanticDagUtil.fillNullDags(children);
                Dag expseq = Dag.createDag(29, children, null, false);
                children = new Dag[]{Dag.createDag(8, null, WmiPowerBuilder.NTH_ROOT_FUNCTION_NAME, false), expseq};
                dag = Dag.createDag(18, children, null, false);
            }
            return dag;
        }
    }
}

