/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ModdefDagFactory;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;

public class WmiProcBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String PROC_OPERATOR = "proc";
    public static final String MODULE_OPERATOR = "module";
    public static final String PROC_TERMINATION_OPERATOR = "end proc";
    public static final String MODULE_TERMINATION_OPERATOR = "end module";
    public static final String PROC_SHORT_TERMINATION_OPERATOR = "end";
    public static final String SEMICOLON_STATEMENT_SEPARATOR_OPERATOR = ";";
    public static final String STATEMENT_SEQUENCE_BLANK_TERMINATION_OP = "";
    private static final int MAX_PROC_SIZE = 10;
    private static final int PARAMETER_INDEX = 0;
    private static final int LOCAL_INDEX = 1;
    private static final int OPTION_INDEX = 2;
    private static final int REMEMBER_TABLE_INDEX = 3;
    private static final int EXPORT_INDEX = 3;
    private static final int STATEMENT_INDEX = 4;
    private static final int DESCRIPTION_INDEX = 5;
    private static final int GLOBAL_INDEX = 6;
    private static final int LEXICAL_INDEX = 7;
    private static final int MODULE_NAME_INDEX = 8;
    private static final int DEFAULT_VERBOSEPROC_LEVEL = 1;
    public static final String ELIDED_PROC_ELIPSIS = "...";
    public static final String LOCAL_KEYWORD = "local";
    public static final String EXPORT_KEYWORD = "export";
    public static final String DESCRIPTION_KEYWORD = "description";
    public static final String GLOBAL_KEYWORD = "global";
    public static final String OPTION_KEYWORD = "option";
    public static final String ARROW_OPERATOR = "\u2192";
    private static final String OPERATOR_OPTION_NAME = "operator";
    private static final String ARROW_OPTION_NAME = "arrow";
    private static final String COPYRIGHT_OPTION_START = "Copyright";
    private static final int BASE_NORMAL_PROC_SIZE = 6;
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_INC_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_DEC_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    public static final WmiMathSpaceModel.WmiMathSpaceAttributeSet PROC_INDENT_LINEBREAK_ATTR = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
    private static final String POST_PROC_SPACE = "0.3em";

    static {
        PROC_INC_LINEBREAK_ATTR.addAttribute("linebreak", "increaseindentnewline");
        PROC_INC_LINEBREAK_ATTR.addAttribute("width", POST_PROC_SPACE);
        PROC_DEC_LINEBREAK_ATTR.addAttribute("linebreak", "decreaseindentnewline");
        PROC_INDENT_LINEBREAK_ATTR.addAttribute("linebreak", "firstprocnewline");
        PROC_INDENT_LINEBREAK_ATTR.addAttribute("width", POST_PROC_SPACE);
    }

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean renderStatements = false;
        boolean operatorProc = false;
        boolean arrowProc = false;
        if (dag.getType() == 40 && dag.getLength() > 2) {
            return this.createModel(dag.getChild(1), docModel, context);
        }
        WmiModel[] prockids = new WmiMathModel[10];
        WmiMathModel optionSpecification = null;
        int verbose = WmiProcBuilder.getVerboseProcProperty(docModel);
        WmiInlineMathModel model = new WmiInlineMathModel(docModel);
        Dag optionDag = dag.getChild(2);
        if (optionDag != null && optionDag.getLength() > 0) {
            renderStatements = this.isProcVisible(docModel, optionDag, context);
            operatorProc = this.isProcOption(optionDag, OPERATOR_OPTION_NAME);
            arrowProc = this.isProcOption(optionDag, ARROW_OPTION_NAME);
            optionSpecification = this.buildProcKeyword(optionDag, docModel, context, OPTION_KEYWORD);
        } else {
            renderStatements = verbose >= 1;
        }
        prockids = arrowProc && operatorProc ? this.buildArrowProcChildren(dag, docModel, context) : this.buildNormalProcChildren(dag, docModel, context, optionSpecification, renderStatements, verbose, operatorProc);
        try {
            model.replaceChildren(prockids, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmioe) {
            WmiErrorLog.log(wmioe);
        }
        context.decrementProcCounter();
        if (dag.getType() == 34) {
            ProcDagFactory.removeStacks(dag);
        } else {
            ProcDagFactory.removeStacks();
        }
        model.setSemantics(this);
        return model;
    }

    private boolean isProcOption(Dag optionDag, String option) {
        boolean operatorProc = false;
        if (optionDag != null && optionDag.getLength() > 0) {
            int optionLength = optionDag.getLength();
            int i = 0;
            while (i < optionLength) {
                Dag suboption = optionDag.getChild(i);
                String opName = suboption.getData();
                if (opName != null && opName.equals(option)) {
                    operatorProc = true;
                }
                ++i;
            }
        }
        return operatorProc;
    }

    private WmiMathModel[] buildArrowProcChildren(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (dag.getType() == 34) {
            ProcDagFactory.addToStacks(dag);
        } else if (dag.getType() == 39) {
            ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        }
        context.incrementProcCounter();
        context.setOperatorProc(true);
        Dag parameters = dag.getChild(0);
        WmiMathModel[] arrowProcKids = new WmiMathModel[3];
        if (parameters != null && parameters.getLength() == 1) {
            Dag child = parameters.getChild(0);
            arrowProcKids[0] = WmiMathFactory.createMath(docModel, child, context);
        } else {
            WmiMathModel parms = WmiMathFactory.createMath(docModel, parameters, context);
            arrowProcKids[0] = WmiMathFactory.addBrackets(parms, context);
        }
        arrowProcKids[1] = WmiMathFactory.createMathOperatorToken(docModel, ARROW_OPERATOR, context);
        Dag statements = dag.getChild(4);
        arrowProcKids[2] = this.buildStatementSeq(statements, docModel, context, true);
        context.setOperatorProc(false);
        return arrowProcKids;
    }

    private boolean isProcVisible(WmiMathDocumentModel docModel, Dag optionDag, WmiMathContext context) {
        boolean procVisible;
        boolean operatorProc = false;
        boolean copyrighted = false;
        int verbose = WmiProcBuilder.getVerboseProcProperty(docModel);
        boolean bl = procVisible = verbose > 0;
        if (optionDag != null && optionDag.getLength() > 0) {
            int optionLength = optionDag.getLength();
            int i = 0;
            while (i < optionLength) {
                Dag suboption = optionDag.getChild(i);
                String opName = suboption.getData();
                if (opName != null) {
                    if (opName.equals(OPERATOR_OPTION_NAME)) {
                        operatorProc = context.getProcCount() == 0;
                    } else if (opName.startsWith(COPYRIGHT_OPTION_START)) {
                        copyrighted = true;
                    }
                }
                ++i;
            }
        }
        boolean renderStatements = procVisible && (!copyrighted || verbose != 1);
        return renderStatements;
    }

    private WmiMathModel[] buildNormalProcChildren(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context, WmiMathModel optionSpecification, boolean renderStatements, int verbose, boolean operatorProc) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag paramList;
        int dagLength = dag.getLength();
        Dag possibleName = dag.getLength() > 8 ? dag.getChild(8) : null;
        Dag possibleLocal = dag.getChild(1);
        Dag possibleExport = dag.getChild(3);
        Dag possibleGlobal = dag.getChild(6);
        Dag possibleDesc = dag.getChild(5);
        Dag statements = dag.getChild(4);
        Dag rememberTable = dag.getChild(3);
        Dag returnTypeDag = null;
        if (dagLength > 8) {
            returnTypeDag = dag.getChild(dagLength - 1);
        }
        boolean namePresent = dag.getType() == 39 ? ModdefDagFactory.calculateLength(possibleName) > 0 : false;
        boolean localsPresent = possibleLocal.getLength() > 0;
        boolean exportsPresent = possibleExport.getLength() > 0 && dag.getType() == 39;
        boolean globalsPresent = possibleGlobal.getLength() > 0;
        boolean descPresent = possibleDesc.getLength() > 0;
        boolean rememberPresent = rememberTable.getLength() > 0 && dag.getType() == 34;
        boolean returnTypePresent = dag.getType() == 34 && ProcDagFactory.hasReturnType(dag);
        int childSize = 6;
        childSize += namePresent ? 2 : 0;
        if (renderStatements) {
            childSize += localsPresent ? 1 : 0;
            childSize += globalsPresent ? 1 : 0;
            childSize += rememberPresent && verbose > 2 ? 1 : 0;
            childSize += optionSpecification != null ? 1 : 0;
        }
        childSize += descPresent ? 1 : 0;
        childSize += exportsPresent ? 1 : 0;
        WmiMathModel[] prockids = new WmiMathModel[childSize += returnTypePresent ? 1 : 0];
        int addIndex = 0;
        String startOperator = dag.getType() == 34 ? PROC_OPERATOR : MODULE_OPERATOR;
        prockids[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, startOperator, context);
        if (namePresent) {
            prockids[addIndex] = new WmiMathSpaceModel(docModel);
            prockids[addIndex++].addAttribute("width", "0.5em");
            Dag name = dag.getChild(8);
            prockids[addIndex++] = WmiMathFactory.createMath(docModel, name, context);
        }
        if (dag.getType() == 34) {
            ProcDagFactory.addToStacks(dag);
        } else if (dag.getType() == 39) {
            ProcDagFactory.addToStacks(dag.getChild(0), dag.getChild(1), dag.getChild(7), dag.getChild(3));
        }
        context.incrementProcCounter();
        prockids[addIndex++] = dag.getType() == 34 ? ((paramList = DagUtil.formatProcParams(dag)) != null ? this.buildParameters(paramList, docModel, context) : this.buildParameters(dag.getChild(0), docModel, context)) : this.buildParameters(DagConstants.EMPTY, docModel, context);
        if (returnTypePresent) {
            WmiInlineMathModel lineModel = new WmiInlineMathModel(docModel);
            lineModel.appendChild(WmiMathFactory.createMathOperatorToken(docModel, "::", context));
            lineModel.appendChild(WmiMathFactory.createMathModel(docModel, returnTypeDag, context));
            lineModel.appendChild(WmiMathFactory.createMathOperatorToken(docModel, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, context));
            prockids[addIndex++] = lineModel;
        }
        WmiMathModel wmiMathModel = prockids[addIndex++] = context.getProcCount() == 1 ? WmiProcBuilder.createLinebreakIndicator(docModel, PROC_INDENT_LINEBREAK_ATTR) : WmiProcBuilder.createLinebreakIndicator(docModel, PROC_INC_LINEBREAK_ATTR);
        if (renderStatements) {
            if (optionSpecification != null) {
                prockids[addIndex++] = optionSpecification;
            }
            if (localsPresent) {
                if (possibleLocal.getType() == 30) {
                    possibleLocal.setType(29);
                }
                prockids[addIndex++] = this.buildProcKeyword(possibleLocal, docModel, context, LOCAL_KEYWORD);
            }
        }
        if (exportsPresent) {
            prockids[addIndex++] = this.buildProcKeyword(possibleExport, docModel, context, EXPORT_KEYWORD);
        }
        if (renderStatements && globalsPresent) {
            prockids[addIndex++] = this.buildProcKeyword(possibleGlobal, docModel, context, GLOBAL_KEYWORD);
        }
        if (descPresent) {
            prockids[addIndex++] = this.buildProcKeyword(possibleDesc, docModel, context, DESCRIPTION_KEYWORD);
        }
        if (operatorProc) {
            context.setOperatorProc(true);
        }
        prockids[addIndex++] = this.buildStatementSeq(statements, docModel, context, renderStatements);
        prockids[addIndex++] = WmiProcBuilder.createLinebreakIndicator(docModel, PROC_DEC_LINEBREAK_ATTR);
        String longTerminator = dag.getType() == 34 ? PROC_TERMINATION_OPERATOR : MODULE_TERMINATION_OPERATOR;
        prockids[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, WmiProcBuilder.getLongDelimProperty(docModel) ? longTerminator : PROC_SHORT_TERMINATION_OPERATOR, context);
        if (operatorProc) {
            context.setOperatorProc(false);
        }
        if (renderStatements && verbose > 2 && rememberPresent) {
            prockids[addIndex++] = WmiMathFactory.createMath(docModel, rememberTable, context);
        }
        return prockids;
    }

    WmiMathModel buildProcKeyword(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context, String keyword) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel keyRow = new WmiInlineMathModel(docModel);
        WmiModel[] children = new WmiMathModel[5];
        children[0] = WmiMathFactory.createMathOperatorToken(docModel, keyword, context);
        children[1] = new WmiMathSpaceModel(docModel);
        children[1].addAttribute("width", "0.5em");
        children[2] = WmiMathFactory.createMath(docModel, dag, context);
        children[3] = WmiMathFactory.createMathOperatorToken(docModel, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, context);
        children[4] = WmiProcBuilder.createLinebreakIndicator(docModel, PROC_INDENT_LINEBREAK_ATTR);
        try {
            keyRow.replaceChildren(children, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        return keyRow;
    }

    static int getVerboseProcProperty(WmiMathDocumentModel model) {
        int verboseproc = 0;
        if (model instanceof DagRenderContext) {
            verboseproc = ((DagRenderContext)((Object)model)).getInterfaceProperty("verboseproc", 1);
        }
        return verboseproc;
    }

    static boolean getLongDelimProperty(WmiMathDocumentModel model) {
        boolean longdelim = false;
        if (model instanceof DagRenderContext) {
            longdelim = ((DagRenderContext)((Object)model)).getInterfaceProperty("longdelim", true);
        }
        return longdelim;
    }

    WmiMathModel buildParameters(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel bracketedParams = new WmiInlineMathModel(docModel);
        WmiMathModel params = WmiMathFactory.createMath(docModel, dag, context);
        bracketedParams = WmiMathFactory.addBrackets(params, context);
        return bracketedParams;
    }

    WmiMathModel buildStatementSeq(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context, boolean renderStatements) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel statements = WmiMathFactory.createMathOperatorToken(docModel, ELIDED_PROC_ELIPSIS, context);
        if (renderStatements) {
            statements = WmiProcBuilder.createStatementSequenceRow(dag, docModel, context);
        }
        return statements;
    }

    public static WmiMathModel createStatementSequenceRow(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathFactory.createMath(docModel, dag, context);
    }

    public static WmiMathModel createStatementSequenceRow(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context, boolean linebreakHint) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel product = null;
        product = WmiMathFactory.createMath(docModel, dag, context);
        if (dag.getLength() <= 0 || dag.getType() != 46) {
            product = WmiProcBuilder.addStatementSeparator(product, context, STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, linebreakHint);
        }
        return product;
    }

    public static WmiMathModel createLinebreakIndicator(WmiMathDocumentModel docModel, WmiMathSpaceModel.WmiMathSpaceAttributeSet set) {
        WmiMathSpaceModel model = new WmiMathSpaceModel(docModel, STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, (WmiAttributeSet)set);
        try {
            model.addAttribute("width", "0.5em");
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return model;
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel statement, WmiMathContext context, boolean linebreakHint) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(statement, context, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, linebreakHint);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel statement, WmiMathContext context) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(statement, context, SEMICOLON_STATEMENT_SEPARATOR_OPERATOR, true);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel statement, WmiMathContext context, String separator) throws WmiNoWriteAccessException {
        return WmiProcBuilder.addStatementSeparator(statement, context, separator, true);
    }

    public static WmiMathModel addStatementSeparator(WmiMathModel statement, WmiMathContext context, String separator, boolean linebreakHint) throws WmiNoWriteAccessException {
        WmiMathModel separatedModel = null;
        if (!linebreakHint && separator.equals(STATEMENT_SEQUENCE_BLANK_TERMINATION_OP)) {
            separatedModel = statement;
        } else {
            WmiMathDocumentModel doc = statement.getDocument();
            separatedModel = new WmiInlineMathModel(doc);
            int childsize = linebreakHint ? 3 : 2;
            WmiModel[] children = new WmiMathModel[childsize];
            children[0] = statement;
            children[1] = WmiMathFactory.createMathOperatorToken(doc, separator, context);
            if (linebreakHint) {
                children[2] = WmiProcBuilder.createLinebreakIndicator(doc, PROC_INDENT_LINEBREAK_ATTR);
            }
            try {
                ((WmiInlineMathModel)separatedModel).replaceChildren(children, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        return separatedModel;
    }

    @Override
    public Dag toDag(WmiMathModel model) {
        return null;
    }

    public static class WmiStatementSequenceBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiInlineMathModel statements = new WmiInlineMathModel(docModel);
            int dagLength = dag.getLength();
            int lastDag = dagLength - 1;
            WmiModel[] statementChildren = new WmiMathModel[dagLength];
            int i = 0;
            while (i < lastDag) {
                statementChildren[i] = WmiProcBuilder.addStatementSeparator(WmiMathFactory.createMath(docModel, dag.getChild(i), context), context);
                ++i;
            }
            statementChildren[lastDag] = WmiProcBuilder.addStatementSeparator(WmiMathFactory.createMath(docModel, dag.getChild(lastDag), context), context, WmiProcBuilder.STATEMENT_SEQUENCE_BLANK_TERMINATION_OP, false);
            try {
                statements.replaceChildren(statementChildren, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            statements.setSemantics(this);
            return statements;
        }

        @Override
        public Dag toDag(WmiMathModel model) {
            return null;
        }
    }
}

