/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.model.math.WmiBinaryOperatorBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathContext;

public abstract class WmiRelationalBuilder
extends WmiBinaryOperatorBuilder {
    public static final String EQUALS_OPERATOR = "=";
    public static final String NOT_EQUALS_OPERATOR = "&ne;";
    public static final String NOT_EQUALS_IN_PROC = "<>";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String LESS_THAN_OR_EQUAL_TO_OPERATOR = "&le;";
    public static final String LESS_THAN_OR_EQUAL_IN_PROC = "<=";

    @Override
    protected String getOperator(WmiMathContext context) {
        return EQUALS_OPERATOR;
    }

    @Override
    protected int getPrecedenceRule() {
        return 1;
    }

    public static class WmiEquationBuilder
    extends WmiRelationalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return WmiRelationalBuilder.EQUALS_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 20;
        }
    }

    public static class WmiInequalityBuilder
    extends WmiRelationalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return context.useProcRules() ? WmiRelationalBuilder.NOT_EQUALS_IN_PROC : WmiRelationalBuilder.NOT_EQUALS_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 21;
        }
    }

    public static class WmiLessThanBuilder
    extends WmiRelationalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return WmiRelationalBuilder.LESS_THAN_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 23;
        }
    }

    public static class WmiLessThanEqualsBuilder
    extends WmiLessThanBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return context.useProcRules() ? WmiRelationalBuilder.LESS_THAN_OR_EQUAL_IN_PROC : WmiRelationalBuilder.LESS_THAN_OR_EQUAL_TO_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 22;
        }
    }
}

