/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;

public class WmiRootModel
extends WmiTwoArgumentMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private static final int[] TRAVERSAL_ORDER_MAPPINGS;
    public static final String[] ATTRS;

    static {
        int[] nArray = new int[2];
        nArray[0] = 1;
        TRAVERSAL_ORDER_MAPPINGS = nArray;
        ATTRS = new String[]{"foreground", "background"};
    }

    public WmiRootModel(WmiMathDocumentModel docModel, WmiModel base, WmiModel exponent, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, base, exponent);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(context.createAttributes(2));
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiRootModel(WmiMathDocumentModel docModel, WmiMathContext context) {
        super(docModel);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(context.createAttributes(2));
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_NROOT;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public void replaceChildren(WmiModel[] replacement, int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (first >= 0) {
            super.replaceChildren(replacement, first, span);
        }
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public WmiModel getChildInTraversalOrder(int index) throws WmiNoReadAccessException {
        if (-1 < index && index < TRAVERSAL_ORDER_MAPPINGS.length) {
            return this.getChild(TRAVERSAL_ORDER_MAPPINGS[index]);
        }
        return this.getChild(index);
    }

    @Override
    public int indexOfInTraversalOrder(WmiModel child) throws WmiNoReadAccessException {
        int index = this.indexOf(child);
        int i = 0;
        while (i < TRAVERSAL_ORDER_MAPPINGS.length) {
            if (TRAVERSAL_ORDER_MAPPINGS[i] == index) {
                return i;
            }
            ++i;
        }
        return index;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiRootDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return this.getChildCount() > 0 ? child != this.getChild(0) : false;
    }

    public class WmiRootDeleteHandler
    extends WmiTwoArgumentMathModel.WmiTwoArgumentMathDeleteHandler {
        public WmiRootDeleteHandler(WmiRootModel arg) {
            super(WmiRootModel.this, arg);
        }

        @Override
        public boolean forceDeleteHandling() {
            return true;
        }

        @Override
        protected void processRestructure(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel restructured = null;
                WmiCompositeModel modelParent = WmiRootModel.this.getParent();
                int index = modelParent.indexOf(this.model);
                if (WmiRootModel.this.getChild(0) instanceof WmiDeletePlaceholderModel) {
                    WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.model.getAttributesForRead());
                    WmiIdentifierModel im = (WmiIdentifierModel)WmiMathFactory.createMathIdentifierToken(this.model.getDocument(), "", context);
                    restructured = im;
                } else if (WmiRootModel.this.getChild(1) instanceof WmiDeletePlaceholderModel) {
                    restructured = WmiRootModel.this.getChild(0);
                }
                modelParent.replaceChild(restructured, index);
            }
        }
    }

    public static class WmiSquareRootModel
    extends WmiRootModel {
        public WmiSquareRootModel(WmiMathDocumentModel docModel, WmiModel base, WmiMathContext context) throws WmiNoWriteAccessException {
            super(docModel, base, null, context);
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_SQUARE_ROOT;
        }

        @Override
        public int getChildCount() throws WmiNoReadAccessException {
            return super.getChildCount() > 1 ? 1 : super.getChildCount();
        }

        public int getChildCountForParsing() throws WmiNoReadAccessException {
            return super.getChildCount();
        }

        @Override
        public WmiModel getChildInTraversalOrder(int index) throws WmiNoReadAccessException {
            return this.getChild(index);
        }

        @Override
        public int indexOfInTraversalOrder(WmiModel child) throws WmiNoReadAccessException {
            return this.indexOf(child);
        }
    }
}

