/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiTryStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String TRY_KEYWORD = "try";
    public static final String END_TRY_KEYWORD = "end try";
    public static final String END_TRY_SHORT_KEYWORD = "end";
    public static final String CATCH_KEYWORD = "catch";
    public static final String FINALLY_KEYWORD = "finally";
    public static final String CATCH_DELIM_OP = ":";
    private static final int STATEMENT_INDEX = 0;
    private static final int CATCH_START_INDEX = 1;
    private static final int CHILD_CATCH_INDEX = 4;
    private static final WmiMathSemantics CATCH_LINE_SEMANTICS = new WmiCatchSemantics();

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel trycatch = new WmiInlineMathModel(docModel);
        int dagLength = dag.getLength();
        int childSize = 5 + dagLength / 2;
        boolean finallyPresent = (dagLength & 1) == 0;
        WmiModel[] children = new WmiMathModel[childSize += finallyPresent ? 1 : 0];
        children[0] = WmiMathFactory.createMathOperatorToken(docModel, TRY_KEYWORD, context);
        children[1] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        children[2] = WmiProcBuilder.createStatementSequenceRow(dag.getChild(0), docModel, context);
        children[3] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        int addIndex = 4;
        int iterationEndOffset = finallyPresent ? 2 : 1;
        int i = 1;
        while (i < dagLength - iterationEndOffset) {
            children[addIndex++] = this.createCatchRow(docModel, dag.getChild(i), dag.getChild(i + 1), context);
            i += 2;
        }
        if (finallyPresent) {
            WmiInlineMathModel finallyStatement = new WmiInlineMathModel(docModel);
            WmiModel[] finKids = new WmiMathModel[]{WmiMathFactory.createMathOperatorToken(docModel, FINALLY_KEYWORD, context), WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR), WmiProcBuilder.createStatementSequenceRow(dag.getChild(dagLength - 1), docModel, context), WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR)};
            try {
                finallyStatement.replaceChildren(finKids, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            finallyStatement.setSemantics(CATCH_LINE_SEMANTICS);
            children[addIndex++] = finallyStatement;
        }
        children[children.length - 1] = WmiMathFactory.createMathOperatorToken(docModel, WmiProcBuilder.getLongDelimProperty(docModel) ? END_TRY_KEYWORD : END_TRY_SHORT_KEYWORD, context);
        try {
            trycatch.replaceChildren(children, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        trycatch.setSemantics(this);
        return trycatch;
    }

    private WmiMathModel createCatchRow(WmiMathDocumentModel docModel, Dag condition, Dag actions, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int tryBaseSize = 4;
        WmiInlineMathModel catchModel = new WmiInlineMathModel(docModel);
        boolean conditionEmpty = DagUtil.isNull(condition);
        boolean actionsEmpty = actions.getLength() <= 0;
        int childSize = tryBaseSize;
        childSize += conditionEmpty ? 0 : 2;
        WmiModel[] children = new WmiMathModel[childSize += actionsEmpty ? 0 : 1];
        int addIndex = 0;
        children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, CATCH_KEYWORD, context);
        if (!conditionEmpty) {
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiMathFactory.createMath(docModel, condition, context);
        }
        children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, CATCH_DELIM_OP, context);
        children[addIndex++] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        if (!actionsEmpty) {
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(actions, docModel, context);
        }
        children[addIndex++] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        try {
            catchModel.replaceChildren(children, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catchModel.setSemantics(CATCH_LINE_SEMANTICS);
        return catchModel;
    }

    @Override
    public Dag toDag(WmiMathModel model) {
        return null;
    }

    public static class WmiCatchSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) {
            return null;
        }
    }
}

