/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import java.util.HashMap;

public class WmiUnderModel
extends WmiTwoArgumentMathModel {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiUnderModel(WmiMathDocumentModel docModel, WmiModel center, WmiModel under, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, center, under);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiUnderModel(WmiMathDocumentModel docModel) {
        super(docModel);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_UNDER;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiUnderAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiUnderAttributeSet();
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        boolean scriptSize = false;
        if (this.getChildCount() > 0 && child != this.getChild(0)) {
            WmiAttributeSet set = this.getAttributesForRead();
            scriptSize = !WmiUnderAttributeSet.ACCENT_KEY.getBooleanValue(set);
        }
        return scriptSize;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics semantics = this.getSemantics();
        return semantics != null ? semantics.toDag(this) : null;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public static class WmiUnderAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"accentunder"};
        public static final WmiAttributeKey ACCENT_KEY = new UnderKey();
        public static final WmiAttributeKey[] UNDER_KEYS = new WmiAttributeKey[]{ACCENT_KEY};
        public static final WmiAttributeKey[] EXTENDED_KEYS_UNDER = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), UNDER_KEYS);
        private static final int ACCENT_UNDER_HASH_BIT = 32;
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected boolean accentUnderProperty = false;

        public WmiUnderAttributeSet() {
        }

        public WmiUnderAttributeSet(WmiUnderAttributeSet attribs) {
            super(attribs);
            this.accentUnderProperty = attribs.accentUnderProperty;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiUnderAttributeSet(this);
        }

        public boolean getAccentUnder() {
            return this.accentUnderProperty;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiUnderAttributeSet) {
                WmiUnderAttributeSet source = (WmiUnderAttributeSet)set;
                this.accentUnderProperty = source.accentUnderProperty;
            } else if (set instanceof WmiUnderOverModel.WmiUnderOverAttributeSet) {
                WmiUnderOverModel.WmiUnderOverAttributeSet source = (WmiUnderOverModel.WmiUnderOverAttributeSet)set;
                this.accentUnderProperty = source.accentUnderProperty;
            }
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiUnderAttributeSet) {
                WmiUnderAttributeSet ref = (WmiUnderAttributeSet)obj;
                equals = ref.accentUnderProperty == this.accentUnderProperty;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            return code ^= this.accentUnderProperty ? 32 : 0;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_UNDER;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class UnderKey
        extends WmiBooleanAttributeKey {
            public UnderKey() {
                super("accentunder", false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return set instanceof WmiUnderAttributeSet ? ((WmiUnderAttributeSet)set).accentUnderProperty : false;
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                if (set instanceof WmiUnderAttributeSet) {
                    ((WmiUnderAttributeSet)set).accentUnderProperty = value;
                }
            }
        }
    }
}

