/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiConjugateBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int CONJUGATE_TERM_INDEX = 0;
    public static final String CONJUGATE_OVERBAR_OPERATOR = "\u0305";
    private static final WmiMathSemantics CONJUGATE_SEMANTICS = new WmiConjugateSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag term = argParent.getChild(0);
        WmiMathModel under = WmiMathFactory.createMath(doc, term, context);
        WmiMathTokenModel over = WmiMathFactory.createMathOperatorToken(doc, CONJUGATE_OVERBAR_OPERATOR, context);
        WmiOverModel model = new WmiOverModel(doc, under, over, context);
        WmiAttributeSet set = model.getAttributesForRead();
        WmiOverModel.WmiOverAttributeSet.ACCENT_KEY.setBooleanValue(set, true);
        model.setSemantics(CONJUGATE_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        useTemplate = useTemplate && dag.getChild(1) != null && dag.getChild(1).getLength() == 1;
        return useTemplate;
    }

    public static class WmiConjugateSemantics
    implements WmiMathSemantics {
        private static final int CONJUGATE_ARG_INDEX = 0;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel comp;
            WmiMathModel args;
            Dag function = null;
            if (model.isComposite() && (args = (WmiMathModel)(comp = (WmiCompositeModel)((Object)model)).getChild(0)) != null) {
                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.CONJUGATE_FUNC_NAME, args.toDag());
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

