/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiDiffBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String D_OPERATOR = "&DifferentialD;";
    public static final String DI_OPERATOR = "&PartialD;";
    public static final int FUNC_DAG_INDEX = 0;
    private static final int LAST_ORDER_POSITION = -1;
    private static final WmiMathSemantics DIFF_SEMANTICS = new WmiDiffSemantics();
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiDiffBuilder() {
        this(false);
    }

    public WmiDiffBuilder(boolean state) {
        this.isInert = state;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String[] labels;
        int[] order;
        Dag[] orderDags;
        WmiInlineMathModel model = null;
        int maxSize = this.extractMaxVariables(argParent, 1);
        Dag[] vars = new Dag[maxSize];
        boolean extractionWorked = this.extractVariables(argParent, 1, vars, orderDags = new Dag[maxSize], order = new int[maxSize], labels = new String[maxSize]);
        if (extractionWorked) {
            model = new WmiInlineMathModel(doc);
            WmiAbstractArrayCompositeModel composite = model;
            Dag function = argParent.getChild(0);
            WmiMathModel diffModel = this.buildDiffModel(doc, function, vars, orderDags, order, labels, context);
            WmiMathModel functionModel = WmiMathFactory.createMath(doc, function, context);
            if (WmiPrecedenceRules.areBracketsRequired(function, 3, 0)) {
                functionModel = WmiMathFactory.addBrackets(functionModel, context);
            }
            composite.appendChild(diffModel);
            composite.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&InvisibleTimes;", context));
            composite.appendChild(functionModel);
            model.setSemantics(DIFF_SEMANTICS);
        }
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        useTemplate = useTemplate && dag.getLength() == 2 && dag.getChild(1) != null && dag.getChild(1).getLength() >= 2 && this.extractMaxVariables(dag.getChild(1), 1) > 0;
        return useTemplate;
    }

    private WmiMathModel buildDiffModel(WmiMathDocumentModel doc, Dag function, Dag[] vars, Dag[] orderDags, int[] order, String[] labels, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFractionModel diffModel = null;
        Dag orderDag = null;
        Dag lastDag = null;
        int totalOrder = 0;
        int numvars = 0;
        int i = 0;
        boolean firstLabel = true;
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < vars.length) {
            if (vars[i] == null) break;
            ++numvars;
            if (order[i] > -1) {
                totalOrder += order[i];
                if (labels[i] != null) {
                    if (!firstLabel) {
                        buffer.append("+");
                    }
                    buffer.append(labels[i]);
                    firstLabel = false;
                }
            } else {
                lastDag = orderDags[i];
            }
            ++i;
        }
        if (totalOrder > 0) {
            orderDag = DagUtil.createIntDag(totalOrder);
            if (lastDag != null) {
                orderDag = Dag.createDag(16, new Dag[]{orderDag, DagUtil.createIntDag(1), lastDag, DagUtil.createIntDag(1)}, null, false);
            }
        } else if (lastDag != null) {
            orderDag = lastDag;
        }
        if (buffer.length() == 0) {
            buffer = null;
        }
        boolean dNotation = numvars == 1 ? this.numFunctionVars(function, vars[0]) == 0 : false;
        WmiMathModel numeratorModel = this.buildTopVarBox(doc, orderDag, buffer != null ? buffer.toString() : null, dNotation, context);
        WmiInlineMathModel denomModel = new WmiInlineMathModel(doc);
        boolean firstVariable = true;
        i = vars.length - 1;
        while (i > -1) {
            if (vars[i] != null) {
                if (!firstVariable) {
                    denomModel.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&InvisibleTimes;", context));
                }
                firstVariable = false;
                denomModel.appendChild(this.buildBottomVarBox(doc, vars[i], orderDags[i], order[i], dNotation, context));
            }
            --i;
        }
        diffModel = new WmiFractionModel(doc, numeratorModel, denomModel, context);
        return diffModel;
    }

    private void buildDBoxRun(WmiMathDocumentModel doc, Dag var, boolean dNotation, WmiMathContext context, WmiMathModel[] result) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String op;
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        WmiMathModel base = null;
        String string = op = dNotation ? D_OPERATOR : DI_OPERATOR;
        if (var == null) {
            base = WmiMathFactory.createMathOperatorToken(doc, op, context);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)base);
            }
        } else {
            base = WmiMathFactory.createMathOperatorToken(doc, op, context);
            if (this.isInert) {
                this.inertize((WmiMathOperatorModel)base);
            }
            model.appendChild(base);
            base = WmiMathFactory.createMath(doc, var, context);
        }
        result[0] = model;
        result[1] = base;
    }

    private WmiMathModel buildTopVarBox(WmiMathDocumentModel doc, Dag order, String label, boolean dNotation, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel[] dbox = new WmiMathModel[2];
        this.buildDBoxRun(doc, null, dNotation, context, dbox);
        WmiCompositeModel model = (WmiCompositeModel)((Object)dbox[0]);
        WmiMathModel base = dbox[1];
        if (order != null && DagUtil.isInt(order)) {
            int iorder = DagUtil.parseInt(order);
            if (iorder != 1 || label != null) {
                String value = null;
                value = label == null ? Integer.toString(iorder) : (iorder == 0 ? label : String.valueOf(Integer.toString(iorder)) + "+" + label);
                WmiMathTokenModel exp = WmiMathFactory.createMathNumericToken(doc, value, context);
                model.appendChild(new WmiSuperscriptModel(doc, base, exp, context));
            } else {
                model.appendChild(base);
            }
        } else if (order != null) {
            WmiMathModel exp = WmiMathFactory.createMath(doc, order, context);
            model.appendChild(new WmiSuperscriptModel(doc, base, exp, context));
        } else {
            model.appendChild(base);
        }
        return (WmiMathModel)((Object)model);
    }

    private WmiMathModel buildBottomVarBox(WmiMathDocumentModel doc, Dag var, Dag orderDag, int order, boolean dNotation, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel[] dbox = new WmiMathModel[2];
        this.buildDBoxRun(doc, var, dNotation, context, dbox);
        WmiCompositeModel model = (WmiCompositeModel)((Object)dbox[0]);
        WmiMathModel base = dbox[1];
        if (orderDag == null && order > 1) {
            orderDag = DagUtil.createIntDag(order);
        }
        if (orderDag != null && !DagUtil.isOne(orderDag)) {
            WmiMathModel exp = WmiMathFactory.createMath(doc, orderDag, context);
            model.appendChild(new WmiSuperscriptModel(doc, base, exp, context));
        } else {
            model.appendChild(base);
        }
        return (WmiMathModel)((Object)model);
    }

    private int extractMaxVariables(Dag arg, int start) {
        int count = 0;
        if (arg.getLength() > 0 && arg.getType() != 18) {
            int length = arg.getLength();
            int j = start;
            while (j < length) {
                count += this.extractMaxVariables(arg.getChild(j), 0);
                ++j;
            }
        } else {
            ++count;
        }
        return count;
    }

    private boolean extractVariables(Dag args, int startPos, Dag[] vars, Dag[] orderDags, int[] order, String[] labels) {
        boolean success = true;
        Dag varDiff = null;
        Dag varOrder = null;
        Dag name = null;
        int position = 0;
        int length = args.getLength();
        int i = startPos;
        while (i < length && success) {
            int type;
            Dag arg = args.getChild(i);
            int n = type = arg != null ? arg.getType() : -1;
            if (type == 8 || type == 10 || type == 9) {
                this.findVariableUpdateOrder(arg, vars, order);
            } else if (type == 30) {
                success = this.extractVariables(arg, 0, vars, orderDags, order, labels);
            } else {
                if (type != 18) {
                    success = false;
                    break;
                }
                name = arg.getChild(0);
                if (name.getData().equals("$")) {
                    if (arg.getLength() > 1) {
                        Dag varDag = arg.getChild(1);
                        varDiff = varDag.getChild(0);
                        varOrder = varDag.getChild(1);
                        position = this.findVariable(vars, varDiff);
                        if (position < 0) {
                            position = this.addVariable(vars, varDiff);
                        }
                    } else {
                        position = -1;
                    }
                    if (position >= 0) {
                        if (varOrder.getType() == 2) {
                            int value = Integer.parseInt(varOrder.getData());
                            int n2 = position;
                            order[n2] = order[n2] + value;
                        } else {
                            order[position] = -1;
                        }
                        orderDags[position] = varOrder;
                    }
                }
            }
            ++i;
        }
        if (success) {
            success = false;
            i = 0;
            while (i < order.length) {
                if (order[i] != 0) {
                    success = true;
                    break;
                }
                ++i;
            }
        }
        return success;
    }

    private int findVariable(Dag[] vars, Dag varDiff) {
        int position = -1;
        int i = 0;
        while (i < vars.length) {
            if (vars[i] == varDiff) {
                position = i;
                break;
            }
            if (vars[i] == null) break;
            ++i;
        }
        return position;
    }

    private int addVariable(Dag[] vars, Dag varDiff) {
        int position = -1;
        int i = 0;
        while (i < vars.length) {
            if (vars[i] == null) {
                vars[i] = varDiff;
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private void findVariableUpdateOrder(Dag arg, Dag[] vars, int[] order) {
        String data;
        boolean acceptVariable = true;
        if (arg.getType() == 8 && (data = arg.getData()) != null && data.equals("Pi")) {
            acceptVariable = false;
        }
        if (acceptVariable) {
            int i = 0;
            while (i < vars.length) {
                if (vars[i] == arg) {
                    int n = i;
                    order[n] = order[n] + 1;
                    break;
                }
                if (vars[i] == null) {
                    vars[i] = arg;
                    order[i] = 1;
                    break;
                }
                ++i;
            }
        }
    }

    private int numFunctionVars(Dag dag, Dag var) {
        int numvars = 0;
        boolean checkSubDags = false;
        int base = 0;
        int i = 0;
        if (dag == null) {
            numvars = 0;
        } else {
            String value = dag.getData();
            switch (dag.getType()) {
                case 8: {
                    if (value != null && value.equals("Pi")) break;
                }
                case 10: {
                    numvars = DagBuilder.lPrint(dag).equals(DagBuilder.lPrint(var)) ? 0 : 1;
                    break;
                }
                case 18: 
                case 34: {
                    base = 1;
                    checkSubDags = true;
                    break;
                }
                case 13: 
                case 14: 
                case 16: 
                case 29: {
                    base = 0;
                    checkSubDags = true;
                    break;
                }
                default: {
                    numvars = 0;
                }
            }
            if (checkSubDags) {
                int length = dag.getLength();
                i = base;
                while (i < length) {
                    numvars += this.numFunctionVars(dag.getChild(i), var);
                    ++i;
                }
            }
        }
        return numvars;
    }

    public static class WmiDiffSemantics
    implements WmiMathSemantics {
        private static final int OUTER_DIFF_FRAC_INDEX = 0;
        private static final int OUTER_DIFF_ARG_INDEX = 2;
        private static final int FRAC_DENOM_INDEX = 1;
        private static final int DVAR_VAR_INDEX = 1;
        private static final int VAR_SUP_VAR_INDEX = 0;
        private static final int VAR_SUP_ORDER_INDEX = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiModel denomModel;
                WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
                WmiMathModel arg = (WmiMathModel)comp.getChild(2);
                WmiModel frac = comp.getChild(0);
                if (frac != null && frac.isComposite() && arg != null && (denomModel = ((WmiCompositeModel)frac).getChild(1)) != null && denomModel.isComposite()) {
                    WmiCompositeModel denom = (WmiCompositeModel)denomModel;
                    int diffArgSize = 1 + denom.getChildCount() / 2;
                    Dag[] diffArgKids = new Dag[diffArgSize];
                    diffArgKids[0] = arg.toDag();
                    int i = 1;
                    int j = diffArgKids.length - 1;
                    while (i < denom.getChildCount()) {
                        WmiMathModel var = (WmiMathModel)denom.getChild(i);
                        if (var.isComposite()) {
                            WmiCompositeModel dvar = (WmiCompositeModel)((Object)var);
                            var = (WmiMathModel)dvar.getChild(1);
                        }
                        diffArgKids[j] = this.extractVarAndDegree(var);
                        i += 2;
                        --j;
                    }
                    function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.DIFF_FUNC_NAME, diffArgKids);
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }

        private Dag extractVarAndDegree(WmiMathModel var) throws WmiNoReadAccessException {
            Dag result = null;
            if (var != null) {
                WmiModelTag tag = var.getTag();
                if (tag == WmiModelTag.MATH_IDENTIFIER) {
                    Dag idDag;
                    result = idDag = var.toDag();
                } else if (var.isComposite()) {
                    WmiCompositeModel varComp = (WmiCompositeModel)((Object)var);
                    WmiMathModel id = (WmiMathModel)varComp.getChild(0);
                    WmiMathModel order = (WmiMathModel)varComp.getChild(1);
                    if (id != null && order != null) {
                        result = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.DOLLAR_SIGN_FUNC_NAME, id.toDag(), order.toDag());
                    }
                }
            }
            return result;
        }
    }
}

