/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiFactorialBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int FAC_TERM_INDEX = 0;
    private static final String FACTORIAL_OPERATOR = "!";
    private static final WmiMathSemantics FACTORIAL_SEMANTICS = new WmiFactorialSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        WmiAbstractArrayCompositeModel composite = model;
        Dag termDag = argParent.getChild(0);
        WmiMathModel term = WmiMathFactory.createMath(doc, termDag, context);
        if (WmiPrecedenceRules.areBracketsRequired(termDag, 3, 0)) {
            term = WmiMathFactory.addBrackets(term, context);
        }
        composite.appendChild(term);
        composite.appendChild(WmiMathFactory.createMathOperatorToken(doc, FACTORIAL_OPERATOR, context));
        model.setSemantics(FACTORIAL_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        useTemplate = useTemplate && dag.getChild(1) != null && dag.getChild(1).getLength() == 1;
        return useTemplate;
    }

    public static class WmiFactorialSemantics
    implements WmiMathSemantics {
        private static final int FACTORIAL_ARG_INDEX = 0;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel comp;
            WmiMathModel expArg;
            Dag function = null;
            if (model != null && model.isComposite() && (expArg = (WmiMathModel)(comp = (WmiCompositeModel)((Object)model)).getChild(0)) != null) {
                Dag arg = expArg.toDag();
                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.FACTORIAL_FUNC_NAME, arg);
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

