/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiFunctionSeriesBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int SUM_INDEX = 0;
    private static final int BASE_INDEX = 1;
    private static final int POWER_INDEX = 2;
    private static final String BIG_O_OPERATOR = "O";
    private static final WmiMathSemantics SERIES_SEMANTICS = new WmiFunctionSeriesSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel model = null;
        Dag sum = argParent.getChild(0);
        Dag base = argParent.getChild(1);
        Dag power = argParent.getChild(2);
        Dag term = base;
        if (new Integer(power.getData()) != 1) {
            term = PowerDagFactory.create(base, power);
        }
        WmiMathModel termModel = WmiMathFactory.createMath(doc, term, context);
        termModel = WmiMathFactory.addBrackets(termModel, context);
        WmiInlineMathModel orderModel = new WmiInlineMathModel(doc);
        orderModel.appendChild(WmiMathFactory.createMathIdentifierToken(doc, BIG_O_OPERATOR, context));
        orderModel.appendChild(termModel);
        WmiMathModel sumModel = WmiMathFactory.createMath(doc, sum, context);
        WmiInlineMathModel inlineModel = model = new WmiInlineMathModel(doc);
        inlineModel.appendChild(sumModel);
        if (sum instanceof BranchDag && ((BranchDag)sum).getLength() > 0) {
            inlineModel.appendChild(WmiMathFactory.createMathOperatorToken(doc, "+", context));
        }
        inlineModel.appendChild(orderModel);
        model.setSemantics(SERIES_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        return shouldBeUsed && args != null && args.getLength() == 3;
    }

    public static class WmiFunctionSeriesSemantics
    implements WmiMathSemantics {
        private static int SUM_INDEX = 0;
        private static int BIG_O_INDEX = 0;
        private static int BIG_O_TERM_INDEX = 2;
        private static int BIG_O_AGRGUMENT_INDEX = 1;
        private static int TERM_IN_ARGUMENT_INDEX = 1;
        private static int BASE_INDEX = 0;
        private static int EXPONENT_INDEX = 1;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            WmiMathModel sum = (WmiMathModel)WmiSemanticDagUtil.getModelSafely(model, SUM_INDEX);
            WmiModel bigOTerm = WmiSemanticDagUtil.getModelSafely(model, BIG_O_TERM_INDEX);
            WmiModel bigOModel = WmiSemanticDagUtil.getModelSafely(bigOTerm, BIG_O_INDEX);
            if (bigOModel instanceof WmiTextModel && WmiFunctionSeriesBuilder.BIG_O_OPERATOR.equals(((WmiTextModel)bigOModel).getText())) {
                WmiModel bigOArgument = WmiSemanticDagUtil.getModelSafely(bigOTerm, BIG_O_AGRGUMENT_INDEX);
                WmiModel msup = WmiSemanticDagUtil.getModelSafely(bigOArgument, TERM_IN_ARGUMENT_INDEX);
                WmiMathModel base = (WmiMathModel)WmiSemanticDagUtil.getModelSafely(msup, BASE_INDEX);
                WmiMathModel exponent = (WmiMathModel)WmiSemanticDagUtil.getModelSafely(msup, EXPONENT_INDEX);
                if (sum != null && base != null && exponent != null) {
                    function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.SERIES_FUNC_NAME, sum.toDag(), base.toDag(), exponent.toDag());
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

