/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiIntegralBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String INTEGRAL_OPERATOR = "\u222b";
    private static final int FUNCTION_DAG_INDEX = 0;
    private static final int EVAL_DAG_INDEX = 1;
    private static final int LHS_DAG_INDEX = 0;
    private static final int RHS_DAG_INDEX = 1;
    private static final int FROM_DAG_INDEX = 0;
    private static final int TO_DAG_INDEX = 1;
    private static final WmiMathSemantics INTEGRAL_SEMANTICS = new WmiIntegralSemantics();
    public static final boolean INERT = true;
    public static final boolean NONINERT = false;
    private boolean isInert;

    public WmiIntegralBuilder() {
        this(false);
    }

    public WmiIntegralBuilder(boolean state) {
        this.isInert = state;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean error = true;
        WmiInlineMathModel model = new WmiInlineMathModel(doc);
        WmiAbstractArrayCompositeModel composite = model;
        Dag function = argParent.getChild(0);
        Dag evalPoint = argParent.getChild(1);
        Dag from = null;
        Dag to = null;
        Dag var = evalPoint;
        WmiMathModel functionModel = WmiMathFactory.createMath(doc, function, context);
        if (DagBuilder.getPrecedence(function) >= 6) {
            functionModel = WmiMathFactory.addBrackets(functionModel, context);
        }
        WmiMathTokenModel integralSign = WmiMathFactory.createMathOperatorToken(doc, INTEGRAL_OPERATOR, context);
        if (this.isInert) {
            this.inertize((WmiMathOperatorModel)integralSign);
        }
        WmiMathTokenModel diffD = WmiMathFactory.createMathOperatorToken(doc, "&DifferentialD;", context);
        if (this.isInert) {
            this.inertize((WmiMathOperatorModel)diffD);
        }
        WmiMathSpaceModel space = new WmiMathSpaceModel(doc);
        space.addAttribute("width", "0.3em");
        if (evalPoint.getType() == 20) {
            Dag range;
            var = evalPoint.getChild(0);
            if (var.getType() == 8 && (range = evalPoint.getChild(1)).getType() == 35) {
                error = false;
                from = range.getChild(0);
                to = range.getChild(1);
                WmiMathModel upper = WmiMathFactory.createMath(doc, to, context);
                WmiMathModel lower = WmiMathFactory.createMath(doc, from, context);
                WmiSubSupModel center = new WmiSubSupModel(doc, integralSign, lower, upper, context);
                center.addAttribute("superscriptshift", "2");
                WmiMathModel varModel = WmiMathFactory.createMath(doc, var, context);
                composite.appendChild(center);
                composite.appendChild(functionModel);
                composite.appendChild(space);
                composite.appendChild(diffD);
                composite.appendChild(varModel);
            }
        } else if (evalPoint.getType() == 30) {
            Dag d;
            error = false;
            int i = 0;
            while (i < evalPoint.getLength()) {
                d = evalPoint.getChild(i);
                Dag range = d.getChild(1);
                from = range.getChild(0);
                to = range.getChild(1);
                WmiMathModel upper = WmiMathFactory.createMath(doc, to, context);
                WmiMathModel lower = WmiMathFactory.createMath(doc, from, context);
                WmiSubSupModel center = new WmiSubSupModel(doc, integralSign, lower, upper, context);
                center.addAttribute("superscriptshift", "2");
                composite.appendChild(center);
                ++i;
            }
            composite.appendChild(functionModel);
            composite.appendChild(space);
            i = 0;
            while (i < evalPoint.getLength()) {
                d = evalPoint.getChild(i);
                var = d.getChild(0);
                WmiMathModel varModel = WmiMathFactory.createMath(doc, var, context);
                composite.appendChild(diffD);
                composite.appendChild(varModel);
                ++i;
            }
        } else if (evalPoint.getType() == 8) {
            error = false;
            composite.appendChild(integralSign);
            composite.appendChild(functionModel);
            composite.appendChild(space);
            composite.appendChild(diffD);
            WmiMathModel varModel = WmiMathFactory.createMath(doc, var, context);
            composite.appendChild(varModel);
        }
        if (argParent.getLength() > 2) {
            error = true;
        } else if (!error) {
            model.setSemantics(INTEGRAL_SEMANTICS);
        }
        return error ? null : model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean useTemplate = super.shouldBeUsed(dag, context);
        if (useTemplate) {
            Dag argDags = dag.getChild(1);
            boolean bl = useTemplate = argDags != null && argDags.getLength() >= 2;
            if (useTemplate) {
                Dag eval = argDags.getChild(1);
                if (eval.getType() == 20) {
                    useTemplate = eval.getLength() == 2 && eval.getChild(1) != null && eval.getChild(1).getType() == 35;
                } else if (eval.getType() == 30) {
                    int n = eval.getLength();
                    if (n == 0) {
                        useTemplate = false;
                    } else {
                        int i = 0;
                        while (i < n) {
                            Dag d = eval.getChild(i);
                            if (d.getType() != 20) {
                                useTemplate = false;
                                break;
                            }
                            Dag rhs = d.getChild(1);
                            if (rhs == null || rhs.getType() != 35) {
                                useTemplate = false;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (argDags.getLength() > 2) {
                    int i = 2;
                    while (i < argDags.getLength()) {
                        if (argDags.getChild(i).getType() != 8) {
                            useTemplate = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return useTemplate;
    }

    public static class WmiIntegralSemantics
    implements WmiMathSemantics {
        private static final int OPERATOR_MODEL_INDEX = 0;
        private static final int ITEGRAND_MODEL_INDEX = 1;
        private static final int VARIABLE_MODEL_INDEX = 4;
        private static final int OPTIONS_MODEL_INDEX = 6;
        private static final int SUB_SUP_LOWER_RANGE_MODEL_INDEX = 1;
        private static final int SUB_SUP_UPPER_RANGE_MODEL_INDEX = 2;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel acModel;
            WmiModel functionModel;
            Dag function = null;
            if (model != null && model.isComposite() && ((WmiCompositeModel)((Object)model)).getChildCount() > 4 && (functionModel = (acModel = (WmiCompositeModel)((Object)model)).getChild(1)) != null) {
                WmiModel optModel;
                Dag functionDag = WmiImpliedSemantics.getDagFromModel(functionModel);
                WmiMathModel operatorModel = (WmiMathModel)acModel.getChild(0);
                Dag rangeOrVarDag = null;
                WmiModel var = this.findVariableModel(acModel);
                WmiModelTag opTag = operatorModel.getTag();
                Dag optDag = null;
                if (opTag == WmiModelTag.MATH_OPERATOR && var != null) {
                    rangeOrVarDag = WmiImpliedSemantics.getDagFromModel(var);
                } else if (opTag == WmiModelTag.MATH_SUB_SUP) {
                    rangeOrVarDag = this.createRangeDag(operatorModel, var);
                }
                if (acModel.getChildCount() >= 6 && (optModel = acModel.getChild(6)) != null) {
                    optDag = WmiImpliedSemantics.getDagFromModel(optModel);
                }
                Dag functionName = WmiSemanticDagUtil.INTEGRAL_FUNC_NAME;
                function = optDag != null ? WmiSemanticDagUtil.createFunction(functionName, functionDag, rangeOrVarDag, optDag) : WmiSemanticDagUtil.createFunction(functionName, functionDag, rangeOrVarDag);
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }

        private WmiModel findVariableModel(WmiCompositeModel acModel) throws WmiNoReadAccessException {
            WmiModel varModel = null;
            int childCount = acModel.getChildCount();
            int index = 0;
            while (index < childCount) {
                String text;
                WmiModel child = acModel.getChild(index);
                if (child instanceof WmiMathOperatorModel && "d".equals(text = ((WmiMathOperatorModel)child).getText())) break;
                ++index;
            }
            if (index > 0 && index + 1 < childCount) {
                varModel = acModel.getChild(index + 1);
            }
            return varModel;
        }

        private Dag createRangeDag(WmiMathModel subSup, WmiModel var) throws WmiNoReadAccessException {
            Dag answer = null;
            if (subSup != null && subSup.isComposite()) {
                WmiCompositeModel compSubSup = (WmiCompositeModel)((Object)subSup);
                WmiModel lowerRange = compSubSup.getChild(1);
                WmiModel upperRange = compSubSup.getChild(2);
                if (var != null && lowerRange != null && upperRange != null) {
                    Dag identifierDag = WmiImpliedSemantics.getDagFromModel(var);
                    Dag[] rangeDagKids = new Dag[]{WmiImpliedSemantics.getDagFromModel(lowerRange), WmiImpliedSemantics.getDagFromModel(upperRange)};
                    WmiSemanticDagUtil.fillNullDags(rangeDagKids);
                    Dag rangeDag = Dag.createDag(35, rangeDagKids, null, false);
                    Dag[] equationDagKids = new Dag[]{identifierDag, rangeDag};
                    WmiSemanticDagUtil.fillNullDags(equationDagKids);
                    answer = Dag.createDag(20, equationDagKids, null, false);
                }
            }
            return answer;
        }
    }
}

