/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiPiecewiseBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final WmiMathSemantics PEICEWISE_SEMANTICS = new WmiPeicewiseSemantics();

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel model = null;
        int rowCount = argParent.getLength();
        WmiModel[] rows = new WmiMathTableModel.WmiMathTableRowModel[rowCount];
        int i = 0;
        while (i < rowCount) {
            WmiModel[] cells = new WmiMathTableModel.WmiMathTableDataModel[]{new WmiMathTableModel.WmiMathTableDataModel(doc, WmiMathFactory.createMath(doc, argParent.getChild(i).getChild(0), context)), new WmiMathTableModel.WmiMathTableDataModel(doc, WmiMathFactory.createMath(doc, argParent.getChild(i).getChild(1), context))};
            rows[i] = new WmiMathTableModel.WmiMathTableRowModel(doc, cells);
            ++i;
        }
        WmiMathTableModel table = new WmiMathTableModel(doc, rows);
        table.addAttribute("columnspacing", "2em");
        model = new WmiInlineMathModel(doc);
        model.appendChild(WmiMathFactory.createMathOperatorToken(doc, "{", context));
        model.appendChild(table);
        model.setSemantics(PEICEWISE_SEMANTICS);
        return model;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        boolean shouldBeUsed = super.shouldBeUsed(dag, context);
        Dag args = dag.getChild(1);
        int argLength = args.getLength();
        return shouldBeUsed && args != null && argLength > 0;
    }

    public static class WmiPeicewiseSemantics
    implements WmiMathSemantics {
        private static final int TABLE_INDEX = 1;
        private static final int VALUE_INDEX_IN_ROW = 0;
        private static final int CONDITION_INDEX_IN_ROW = 2;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite;
            WmiModel table;
            Dag function = null;
            if (model != null && model.isComposite() && (table = (composite = (WmiCompositeModel)((Object)model)).getChild(1)) != null && table.isComposite()) {
                int rowCount = ((WmiCompositeModel)table).getChildCount();
                Dag[] args = new Dag[rowCount];
                int i = 0;
                while (i < rowCount) {
                    WmiCompositeModel row = (WmiCompositeModel)((WmiCompositeModel)table).getChild(i);
                    if (row != null && row.isComposite()) {
                        Dag[] listArgs = new Dag[2];
                        WmiModel valueCell = row.getChild(0);
                        WmiModel conditionCell = row.getChild(2);
                        if (valueCell != null && valueCell.isComposite() && conditionCell != null && conditionCell.isComposite()) {
                            WmiMathModel valueCellChild = (WmiMathModel)((WmiCompositeModel)valueCell).getChild(0);
                            WmiMathModel conditionCellChild = (WmiMathModel)((WmiCompositeModel)conditionCell).getChild(0);
                            if (valueCellChild != null && conditionCellChild != null) {
                                listArgs[0] = valueCellChild.toDag();
                                listArgs[1] = conditionCellChild.toDag();
                                args[i] = WmiSemanticDagUtil.createList(listArgs);
                            }
                        }
                    }
                    ++i;
                }
                function = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.PIECEWISE_FUNC_NAME, args);
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

