/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiRTableIDManager {
    private static HashMap rtableMap = new HashMap();
    private static HashMap idTranslationMap = new HashMap();
    private static HashMap idAliasMap = new HashMap();

    private static boolean containsRTableID(long value) {
        return rtableMap.containsKey(new Long(value));
    }

    private static long identifyRTableFunction(Dag dag) {
        long rtableID = -1L;
        if (dag.getType() == 18) {
            Dag child;
            Dag paramSeq;
            String value;
            int length = dag.getLength();
            boolean isRtable = false;
            if (length > 0 && (value = dag.getChild(0).getData()) != null && value.equals("RTABLE")) {
                isRtable = true;
            }
            if (isRtable && (paramSeq = dag.getChild(1)).getLength() > 0 && (child = paramSeq.getChild(0)).getType() == 2) {
                String id = child.getData();
                try {
                    rtableID = Long.parseLong(id);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return rtableID;
    }

    private static void release(long value) {
        Long iValue = new Long(value);
        rtableMap.remove(iValue);
        idAliasMap.remove(iValue);
    }

    private static void updateRTableID(Dag function, long value) {
        Dag expseq = function.getChild(1);
        expseq.setChild(0, Dag.createDag(2, null, Long.toString(value), false));
    }

    protected static void getRTables(Dag dag, ArrayList rtableIds) {
        if (DagUtil.isBranchDag(dag)) {
            int length = dag.getLength();
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                long id = WmiRTableIDManager.identifyRTableFunction(child);
                if (id > 0L) {
                    long correctedID = WmiRTableIDManager.getCorrectedRTableID(id);
                    if (id != correctedID) {
                        WmiRTableIDManager.updateRTableID(child, correctedID);
                        id = correctedID;
                    }
                    rtableIds.add(new Long(id));
                }
                WmiRTableIDManager.getRTables(child, rtableIds);
                ++i;
            }
        }
    }

    public static void addRTableID(long value, Dag function) {
        Long iValue = new Long(value);
        if (idTranslationMap.containsKey(iValue)) {
            Long newValue = (Long)idTranslationMap.get(iValue);
            idAliasMap.put(iValue, newValue);
            iValue = newValue;
            if (iValue != null) {
                WmiRTableIDManager.updateRTableID(function, iValue);
                rtableMap.put(iValue, function);
            }
            idTranslationMap.remove(iValue);
        }
        rtableMap.put(iValue, function);
    }

    public static void addRTableTranslation(long oldValue, long newValue) {
        if (WmiRTableIDManager.containsRTableID(oldValue)) {
            Long iOldValue = new Long(oldValue);
            Long iNewValue = new Long(newValue);
            Dag dag = (Dag)rtableMap.get(iOldValue);
            if (dag != null) {
                WmiRTableIDManager.updateRTableID(dag, newValue);
                rtableMap.remove(iOldValue);
                idAliasMap.put(iOldValue, iNewValue);
                rtableMap.put(iNewValue, dag);
            }
        } else {
            idTranslationMap.put(new Long(oldValue), new Long(newValue));
        }
    }

    public static long getCorrectedRTableID(long value) {
        long correctedValue = value;
        Long iValue = new Long(value);
        if (!rtableMap.containsKey(iValue) && idAliasMap.containsKey(iValue)) {
            correctedValue = (Long)idAliasMap.get(iValue);
        }
        return correctedValue;
    }

    public static void getRTables(WmiMathWrapperModel math, ArrayList rtableIds) throws WmiNoReadAccessException {
        Dag dag;
        if (rtableIds != null && math != null && (dag = math.getDag()) != null) {
            WmiRTableIDManager.getRTables(dag, rtableIds);
        }
    }

    public static void releaseRTables(Dag dag) {
        if (DagUtil.isBranchDag(dag)) {
            int length = dag.getLength();
            int i = 0;
            while (i < length) {
                Dag child = dag.getChild(i);
                if (child != null) {
                    long id = WmiRTableIDManager.identifyRTableFunction(child);
                    if (id > 0L) {
                        WmiRTableIDManager.release(id);
                    }
                    WmiRTableIDManager.releaseRTables(child);
                }
                ++i;
            }
        }
    }
}

