/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiRtableBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String BROWSE_RTABLE_ACTION_TYPE = "browsertable";
    public static final String RTABLE_ADDRESS_ACTION = "rtableaddress";
    public static final String RTABLE_ID_ATTR_KEY = "rtableid";
    private static final int DIMENSION_COUNT_POS = 6;
    private static final int LOWER_RANGE_POS = 0;
    private static final int UPPER_RANGE_POS = 1;
    private static final int FUNC_DAG_INDEX = 1;
    private static final int NAME_DAG_INDEX = 2;
    private static final int TYPE_DAG_INDEX_IN_TABLEREF = 1;
    private static final int EXP_SEQ_INDEX = 1;
    private static final int BASIS_LIST_INDEX_IN_EXP_SEQ = 1;
    private static final int RTABLE_ID_INDEX = 0;
    private static final int DATA_TYPE_INDEX = 1;
    private static final int ARRAY_TYPE_INDEX = 2;
    private static final int STORAGE_TYPE_INDEX = 3;
    private static final int ORDER_TYPE_INDEX = 4;
    private static final int RTABLE_SIZE = 4;
    private static final String DATA_TYPE_KEY = "Data Type: ";
    private static final String STORAGE_TYPE_KEY = "Storage: ";
    private static final String ORDER_TYPE_KEY = "Order: ";
    private static final WmiMathSemantics RTABLE_SEMANTICS = new WmiRTableWrapperSemantics();
    private static final WmiMathSemantics COLLAPSED_RTABLE_SEMANTICS = new WmiCollapsedRtableSemantics();
    private static final WmiMathSemantics MATRIX_SEMANTICS = new WmiMatrixSemantics();
    private static final WmiMathSemantics ROW_VECTOR_SEMANTICS = new WmiRowVectorSemantics();
    private static final WmiMathSemantics COLUMN_VECTOR_SEMANTICS = new WmiColumnVectorSemantics();
    private static final WmiMathSemantics ARRAY_MATRIX_SEMANTICS = new WmiArrayMatrixSemantics();
    private static final WmiMathSemantics ARRAY_VECTOR_SEMANTICS = new WmiArrayVectorSemantics();
    private static final WmiMathSemantics BASIS_VECTOR_SEMANTICS = new WmiImpliedSemantics();
    private static final String MATRIX_NAME = "Matrix";
    private static final String ARRAY_NAME = "Array";
    private static final String MATRIX_NAME_IN_DAG = "MATRIX";
    private static final String ROW_NAME = "row";
    private static final String COLUMN_NAME = "column";
    private static final String VECTOR_NAME = "Vector";
    private static final String VECTOR_NAME_IN_DAG = "VECTOR";
    private static final int INDEX_OF_INLINE = 1;
    private static final int INDEX_OF_TABLE_IN_INLINE = 0;
    private static final int INDEX_OF_DATA_IN_TABLE_CELL = 0;

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        boolean summaryForm = this.isSummaryForm(argParent);
        Dag function = argParent.getChild(1);
        WmiMathModel model = null;
        if (!summaryForm) {
            model = WmiMathFactory.createMath(doc, function, context);
            if (argParent.getLength() >= 3) {
                Dag nameDag = argParent.getChild(2);
                if (nameDag.getLength() == 0) {
                    String name = nameDag.getData();
                    if (MATRIX_NAME.equals(name)) {
                        this.setSemantics(model, MATRIX_SEMANTICS, MATRIX_NAME);
                    } else if (ARRAY_NAME.equals(name)) {
                        String functionName = function.getChild(0).getData();
                        if (MATRIX_NAME_IN_DAG.equals(functionName)) {
                            this.setSemantics(model, ARRAY_MATRIX_SEMANTICS, MATRIX_NAME);
                        } else if (VECTOR_NAME_IN_DAG.equals(functionName)) {
                            this.setSemantics(model, ARRAY_VECTOR_SEMANTICS, VECTOR_NAME);
                        }
                    }
                } else {
                    Dag expSeq = function.getChild(1);
                    boolean isBasisVector = expSeq.getLength() == 2;
                    Dag typeDag = nameDag.getChild(1);
                    String type = typeDag.getChild(0).getData();
                    if (ROW_NAME.equals(type)) {
                        if (isBasisVector) {
                            this.setSemantics(model, BASIS_VECTOR_SEMANTICS, VECTOR_NAME);
                        } else {
                            this.setSemantics(model, ROW_VECTOR_SEMANTICS, "RowVector");
                        }
                    } else if (isBasisVector) {
                        this.setSemantics(model, BASIS_VECTOR_SEMANTICS, VECTOR_NAME);
                    } else {
                        this.setSemantics(model, COLUMN_VECTOR_SEMANTICS, "ColVector");
                    }
                }
            } else {
                this.setSemantics(model, COLUMN_VECTOR_SEMANTICS, "ColVector");
            }
        } else {
            WmiModel[] rows = new WmiModel[4];
            WmiMathTableModel tmodel = new WmiMathTableModel(doc);
            rows[0] = this.createArraySizeRow(doc, argParent, context, "", 2);
            rows[1] = this.createKeyValueRow(doc, argParent, context, DATA_TYPE_KEY, 1);
            rows[2] = this.createKeyValueRow(doc, argParent, context, STORAGE_TYPE_KEY, 3);
            rows[3] = this.createKeyValueRow(doc, argParent, context, ORDER_TYPE_KEY, 4);
            try {
                tmodel.replaceChildren(rows, 0, 0);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            model = WmiMathFactory.addBrackets(tmodel, "[", "]", context);
            this.setReadOnly(model);
            model.setSemantics(COLLAPSED_RTABLE_SEMANTICS);
        }
        model = new WmiMathActionModel(doc, model);
        model.addAttribute("actiontype", summaryForm ? BROWSE_RTABLE_ACTION_TYPE : RTABLE_ADDRESS_ACTION);
        Dag idDag = argParent.getChild(0);
        String idData = idDag.getData();
        model.addAttribute(RTABLE_ID_ATTR_KEY, idData);
        if (model != null) {
            model.setSemantics(RTABLE_SEMANTICS);
        }
        return model;
    }

    private void setSemantics(WmiMathModel model, WmiMathSemantics semantics, String typesetSemantics) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        model.setSemantics(semantics);
        WmiAttributeSet attrs = model.getAttributes();
        if (attrs instanceof WmiMathAttributeSet) {
            attrs.addAttribute("Typesetting:-msemantics", typesetSemantics);
            model.setAttributes(attrs);
        }
    }

    private boolean isSummaryForm(Dag rtableExpSeqDag) {
        return rtableExpSeqDag.getLength() > 3;
    }

    private void setReadOnly(WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        model.addAttribute(WmiFontAttributeSet.READ_ONLY_KEY, Boolean.TRUE);
        if (model instanceof WmiCompositeModel) {
            WmiCompositeModel c = (WmiCompositeModel)model;
            int i = 0;
            while (i < c.getChildCount()) {
                this.setReadOnly(c.getChild(i));
                ++i;
            }
        }
    }

    private WmiModel createArraySizeRow(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, String key, int validx) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        boolean error = false;
        Dag dimensionDag = argParent.getChild(6);
        int numberOfDimensions = Integer.parseInt(DagBuilder.lPrint(dimensionDag));
        StringBuffer sizes = new StringBuffer(" ");
        boolean isArray = ARRAY_NAME.equals(argParent.getChild(validx).getData());
        if (numberOfDimensions == 1) {
            Dag range = argParent.getChild(7);
            sizes.append(DagBuilder.lPrint(range));
        } else {
            int dim = 1;
            while (dim <= numberOfDimensions) {
                Dag range = argParent.getChild(6 + dim);
                if (range.getType() == 35) {
                    Dag lower = range.getChild(0);
                    Dag upper = range.getChild(1);
                    if (isArray) {
                        sizes.append(DagBuilder.lPrint(lower));
                        sizes.append("..");
                    }
                    sizes.append(DagBuilder.lPrint(upper));
                    if (dim < numberOfDimensions) {
                        sizes.append(" x ");
                    }
                } else {
                    error = true;
                    break;
                }
                ++dim;
            }
        }
        sizes.append(" ");
        return this.createKeyValueRow(doc, argParent, context, sizes.toString(), validx);
    }

    private WmiModel createKeyValueRow(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, String key, int validx) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiModel[] data = new WmiModel[]{WmiMathFactory.createMathIdentifierToken(doc, key, context), WmiMathFactory.createMath(doc, argParent.getChild(validx), context)};
        WmiInlineMathModel rowData = new WmiInlineMathModel(doc, data);
        WmiMathTableModel.WmiMathTableDataModel thisRow = new WmiMathTableModel.WmiMathTableDataModel(doc, rowData);
        return new WmiMathTableModel.WmiMathTableRowModel(doc, thisRow);
    }

    public static String getRtableId(WmiModel model) throws WmiNoReadAccessException {
        WmiModel firstNonTransferChild = model;
        while (firstNonTransferChild instanceof WmiTransferModel && ((WmiTransferModel)firstNonTransferChild).getChildCount() != 0) {
            firstNonTransferChild = ((WmiTransferModel)firstNonTransferChild).getChild(0);
        }
        WmiCompositeModel action = WmiModelUtil.findAncestorOfTag(firstNonTransferChild, WmiModelTag.MATH_ACTION);
        String id = "0";
        if (action != null) {
            WmiAttributeSet attrs = action.getAttributesForRead();
            id = (String)attrs.getAttribute(RTABLE_ID_ATTR_KEY);
        }
        return id;
    }

    public static boolean getCellDags(Dag[] targetArray, WmiModel rowModel) throws WmiNoReadAccessException {
        boolean success = true;
        if (rowModel != null && rowModel.isComposite()) {
            WmiCompositeModel row = (WmiCompositeModel)rowModel;
            int colCount = row.getChildCount();
            Dag[] cellDags = new Dag[colCount];
            int j = 0;
            while (j < colCount) {
                WmiModel cell = row.getChild(j);
                if (cell != null && cell.isComposite()) {
                    WmiMathModel data = (WmiMathModel)((WmiCompositeModel)cell).getChild(0);
                    if (data != null) {
                        targetArray[j] = data.toDag();
                    } else {
                        success = false;
                    }
                } else {
                    success = false;
                }
                ++j;
            }
        } else {
            success = false;
        }
        return success;
    }

    public static class WmiArrayMatrixSemantics
    extends WmiTableSemantics {
        @Override
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.ARRAY_NAME, false);
        }
    }

    public static class WmiArrayVectorSemantics
    extends WmiVectorSemantics {
        @Override
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.ARRAY_NAME, false);
        }
    }

    public static class WmiCollapsedRtableSemantics
    implements WmiMathSemantics {
        private static final int INDEX_OF_TABLE = 1;
        private static final int INDEX_OF_SIZE_AND_TYPE_ROW = 0;
        private static final int INDEX_OF_TYPE_IN_INLINE = 1;
        private static final int INDEX_OF_SIZE_IN_INLINE = 0;
        private static final int INDEX_OF_DATA_TYPE_ROW = 1;
        private static final int INDEX_OF_DATA_TYPE_IN_INLINE = 1;
        private static final int INDEX_OF_STORAGE_ROW = 2;
        private static final int INDEX_OF_STORAGE_IN_INLINE = 1;
        private static final int INDEX_OF_ORDER_ROW = 3;
        private static final int INDEX_OF_ORDER_IN_INLINE = 1;
        private static final int INDEX_OF_TYPE_IN_SUBSCRIPT = 0;
        private static final int INDEX_OF_SUBTYPE_IN_SUBSCRIPT = 1;
        private static final int ARG_LENGTH_BEFORE_RANGES = 7;
        private static final int ID_IN_DAG = 0;
        private static final int DATA_TYPE_IN_DAG = 1;
        private static final int TYPE_IN_DAG = 2;
        private static final int STORAGE_IN_DAG = 3;
        private static final int ORDER_IN_DAG = 4;
        private static final int LIST_IN_DAG = 5;
        private static final int DIMENTION_IN_DAG = 6;

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            String sizeString;
            WmiCompositeModel table;
            WmiModel sizeModel;
            WmiModel tableModel;
            Dag answer = null;
            if (model != null && model.isComposite() && (tableModel = ((WmiCompositeModel)((Object)model)).getChild(1)) != null && tableModel.isComposite() && (sizeModel = this.getModelForRowAndIdentifier(0, 0, table = (WmiCompositeModel)tableModel)) instanceof WmiTextModel && (sizeString = ((WmiTextModel)sizeModel).getText()) != null) {
                String[] tokens = sizeString.split("x");
                int dimension = tokens.length;
                Dag[] args = new Dag[7 + dimension];
                String id = WmiRtableBuilder.getRtableId(model);
                args[0] = WmiSemanticDagUtil.createIntpos(id);
                WmiModel typeModel = this.getModelForRowAndIdentifier(0, 1, table);
                args[2] = null;
                if (typeModel instanceof WmiTextModel) {
                    String typeString = ((WmiTextModel)typeModel).getText();
                    args[2] = WmiSemanticDagUtil.createName(typeString);
                } else if (typeModel instanceof WmiCompositeModel) {
                    args[2] = this.getArgWithSubType((WmiCompositeModel)typeModel);
                }
                args[1] = this.getNameDagForRowAndIdentifier(1, 1, table);
                args[3] = this.getNameDagForRowAndIdentifier(2, 1, table);
                args[4] = this.getNameDagForRowAndIdentifier(3, 1, table);
                args[5] = Dag.createDag(30, null, null, false);
                args[6] = WmiSemanticDagUtil.createIntpos(Integer.toString(dimension));
                int i = 0;
                while (i < dimension) {
                    int position = tokens[i].indexOf(46);
                    String lower = null;
                    String upper = null;
                    if (position == -1) {
                        lower = "1";
                        upper = tokens[i];
                    } else {
                        lower = tokens[i].substring(0, position);
                        upper = tokens[i].substring(position + 2);
                    }
                    Dag[] rangeChildren = new Dag[]{"1".equals(lower) ? DagConstants.ONE : WmiSemanticDagUtil.createIntpos(lower), WmiSemanticDagUtil.createIntpos(upper)};
                    args[7 + i] = Dag.createDag(35, rangeChildren, null, false);
                    ++i;
                }
                boolean success = true;
                int i2 = 1;
                while (i2 < 7) {
                    if (args[i2] == null) {
                        success = false;
                    }
                    ++i2;
                }
                if (success) {
                    answer = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, args);
                }
            }
            answer = WmiSemanticDagUtil.handleNullDag(answer, model);
            return answer;
        }

        private Dag getArgWithSubType(WmiCompositeModel compositeTypeModel) throws WmiNoReadAccessException {
            Dag answer = null;
            WmiModel typeModel = compositeTypeModel.getChild(0);
            if (typeModel instanceof WmiTextModel) {
                WmiModel subTypeModel;
                String typeString = ((WmiTextModel)typeModel).getText();
                WmiModel inline = compositeTypeModel.getChild(1);
                if (inline != null && inline.isComposite() && (subTypeModel = ((WmiCompositeModel)inline).getChild(0)) instanceof WmiTextModel) {
                    String subtypeString = ((WmiTextModel)subTypeModel).getText();
                    Dag[] exprSeqKids = new Dag[]{WmiSemanticDagUtil.createName(subtypeString)};
                    Dag[] tablerefDagKids = new Dag[]{WmiSemanticDagUtil.createName(typeString), Dag.createDag(29, exprSeqKids, null, false)};
                    answer = Dag.createDag(10, tablerefDagKids, null, false);
                }
            }
            return answer;
        }

        private Dag getNameDagForRowAndIdentifier(int rowPosition, int identifierPosition, WmiCompositeModel table) throws WmiNoReadAccessException {
            Dag answer = null;
            WmiModel model = this.getModelForRowAndIdentifier(rowPosition, identifierPosition, table);
            if (model instanceof WmiTextModel) {
                String text = ((WmiTextModel)model).getText();
                answer = WmiSemanticDagUtil.createName(text);
            }
            return answer;
        }

        private WmiModel getModelForRowAndIdentifier(int rowPosition, int identifierPosition, WmiCompositeModel table) throws WmiNoReadAccessException {
            WmiModel inline;
            WmiModel cell;
            WmiModel answer = null;
            WmiModel row = table.getChild(rowPosition);
            if (row != null && row.isComposite() && (cell = ((WmiCompositeModel)row).getChild(0)) != null && cell.isComposite() && (inline = ((WmiCompositeModel)cell).getChild(0)) != null && inline.isComposite()) {
                answer = ((WmiCompositeModel)inline).getChild(identifierPosition);
            }
            return answer;
        }
    }

    public static class WmiColumnVectorSemantics
    extends WmiTableSemantics {
        @Override
        protected Dag getFunctionType() {
            Dag[] expseqKids = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.COLUMN_NAME, false)};
            Dag expseq = Dag.createDag(29, expseqKids, null, false);
            Dag[] tablerefKids = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.VECTOR_NAME, false), expseq};
            return Dag.createDag(10, tablerefKids, null, false);
        }
    }

    public static class WmiMatrixSemantics
    extends WmiTableSemantics {
        @Override
        protected Dag getFunctionType() {
            return Dag.createDag(8, null, WmiRtableBuilder.MATRIX_NAME, false);
        }
    }

    public static class WmiRTableWrapperSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag answer = null;
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            answer = ((WmiMathModel)composite.getChild(0)).toDag();
            return answer;
        }
    }

    public static class WmiRowVectorSemantics
    extends WmiVectorSemantics {
        @Override
        protected Dag getFunctionType() {
            Dag[] expseqKids = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.ROW_NAME, false)};
            Dag expseq = Dag.createDag(29, expseqKids, null, false);
            Dag[] tablerefKids = new Dag[]{Dag.createDag(8, null, WmiRtableBuilder.VECTOR_NAME, false), expseq};
            return Dag.createDag(10, tablerefKids, null, false);
        }
    }

    public static abstract class WmiTableSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiModel inline;
            Dag rTable = null;
            boolean success = true;
            if (model != null && model.isComposite() && (inline = ((WmiCompositeModel)((Object)model)).getChild(1)) != null && inline.isComposite()) {
                WmiModel tableModel;
                int indexOfTable = 0;
                if (WmiModelUtil.isEmptyIdentifierModel(((WmiCompositeModel)inline).getChild(indexOfTable))) {
                    ++indexOfTable;
                }
                if ((tableModel = ((WmiCompositeModel)inline).getChild(indexOfTable)) != null && tableModel.isComposite()) {
                    WmiCompositeModel table = (WmiCompositeModel)tableModel;
                    int rowCount = table.getChildCount();
                    Dag[] rowDags = new Dag[rowCount];
                    int i = 0;
                    while (i < rowCount) {
                        WmiModel rowModel = table.getChild(i);
                        if (rowModel != null && rowModel.isComposite()) {
                            WmiCompositeModel row = (WmiCompositeModel)rowModel;
                            int colCount = row.getChildCount();
                            Dag[] cellDags = new Dag[colCount];
                            if (!WmiRtableBuilder.getCellDags(cellDags, row)) {
                                success = false;
                            }
                            rowDags[i] = WmiSemanticDagUtil.createList(cellDags);
                        } else {
                            success = false;
                        }
                        ++i;
                    }
                    Dag list = WmiSemanticDagUtil.createList(rowDags);
                    Dag matrix = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.MATRIX_FUNC_NAME, list);
                    String id = WmiRtableBuilder.getRtableId(model);
                    Dag intPos = WmiSemanticDagUtil.createIntpos(id);
                    rTable = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, intPos, matrix, this.getFunctionType());
                    rTable = WmiSemanticDagUtil.handleNullDag(rTable, model);
                }
            }
            if (!success) {
                rTable = null;
            }
            rTable = WmiSemanticDagUtil.handleNullDag(rTable, model);
            return rTable;
        }

        protected abstract Dag getFunctionType();
    }

    public static abstract class WmiVectorSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiModel tableModel;
            Dag rTable = null;
            boolean success = true;
            if (model != null && model.isComposite() && (tableModel = ((WmiCompositeModel)((Object)model)).getChild(1)) != null && tableModel.isComposite()) {
                WmiCompositeModel table = (WmiCompositeModel)tableModel;
                int rowCount = table.getChildCount();
                Dag[] rowDags = new Dag[rowCount];
                WmiModel rowModel = table.getChild(0);
                if (rowModel != null && rowModel.isComposite()) {
                    WmiCompositeModel row = (WmiCompositeModel)rowModel;
                    int colCount = row.getChildCount();
                    Dag[] cellDags = new Dag[colCount];
                    if (!WmiRtableBuilder.getCellDags(cellDags, row)) {
                        success = false;
                    }
                    Dag list = WmiSemanticDagUtil.createList(cellDags);
                    Dag vector = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.VECTOR_FUNC_NAME, list);
                    String id = WmiRtableBuilder.getRtableId(model);
                    Dag intPos = Dag.createDag(2, null, id, false);
                    rTable = WmiSemanticDagUtil.createFunction(WmiSemanticDagUtil.RTABLE_FUNC_NAME, intPos, vector, this.getFunctionType());
                }
            }
            if (!success) {
                rTable = null;
            }
            rTable = WmiSemanticDagUtil.handleNullDag(rTable, model);
            return rTable;
        }

        protected abstract Dag getFunctionType();
    }
}

