/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAmbiguousModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathErrorModel;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiPrintslashSemantics;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class WmiTypesettingBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String TYPESETTING_LEADER = "Typesetting:-";
    public static final int TYPESETTING_LEAD_LENGTH = "Typesetting:-".length();
    private static final HashMap TAG_BUILDERS = new HashMap();
    private static final WmiTypesetBuilder DEFAULT_BUILDER = new WmiDefaultTagBuilder();
    private boolean quoteHack = false;

    static {
        TAG_BUILDERS.put("math", new WmiMathTagBuilder());
        TAG_BUILDERS.put("mfrac", new WmiMFracTagBuilder());
        TAG_BUILDERS.put("mi", new WmiMiTagBuilder());
        TAG_BUILDERS.put("mmultiscripts", new WmiMMultiscriptTagBuilder());
        TAG_BUILDERS.put("mscripts", new WmiMScriptTagBuilder());
        TAG_BUILDERS.put("mn", new WmiMnTagBuilder());
        TAG_BUILDERS.put("mo", new WmiMoTagBuilder());
        TAG_BUILDERS.put("mover", new WmiMOverTagBuilder());
        TAG_BUILDERS.put("mambiguous", new WmiMAmbiguousTagBuilder());
        TAG_BUILDERS.put("maction", new WmiMActionTagBuilder());
        TAG_BUILDERS.put("mroot", new WmiMRootTagBuilder());
        TAG_BUILDERS.put("mrow", new WmiMRowTagBuilder());
        TAG_BUILDERS.put("mspace", new WmiMSpaceTagBuilder());
        TAG_BUILDERS.put("msqrt", new WmiMSqrtTagBuilder());
        TAG_BUILDERS.put("ms", new WmiMsTagBuilder());
        TAG_BUILDERS.put("mstyle", new WmiMStyleTagBuilder());
        TAG_BUILDERS.put("msub", new WmiMSubTagBuilder());
        TAG_BUILDERS.put("msubsup", new WmiMSubSupTagBuilder());
        TAG_BUILDERS.put("msup", new WmiMSupTagBuilder());
        TAG_BUILDERS.put("mtext", new WmiMTextTagBuilder());
        TAG_BUILDERS.put("merror", new WmiMErrorTagBuilder());
        TAG_BUILDERS.put("munder", new WmiMUnderTagBuilder());
        TAG_BUILDERS.put("mpadded", new WmiMPaddedTagBuilder());
        TAG_BUILDERS.put("mphantom", new WmiMPhantomTagBuilder());
        TAG_BUILDERS.put("munderover", new WmiMUnderOverTagBuilder());
        TAG_BUILDERS.put("mprescripts", new WmiMPrescriptsTagBuilder());
        TAG_BUILDERS.put("none", new WmiNoneTagBuilder());
        TAG_BUILDERS.put("mfenced", new WmiMFencedTagBuilder());
        TAG_BUILDERS.put("mtable", new WmiMTableTagBuilder());
        TAG_BUILDERS.put("mtr", new WmiMTableRowTagBuilder());
        TAG_BUILDERS.put("mlabeledtr", new WmiMTableLabeledRowTagBuilder());
        TAG_BUILDERS.put("mtd", new WmiMTableDataTagBuilder());
        TAG_BUILDERS.put("mprintslash", new WmiMPrintslashBuilder());
        TAG_BUILDERS.put("mparsed", new WmiMParsedBuilder());
        TAG_BUILDERS.put("mverbatim", new WmiMVerbatimBuilder());
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiMathModel mathModel = (WmiMathModel)this.buildModelFromTypeset(doc, funcName, argParent, context);
        return mathModel;
    }

    private WmiModel buildModelFromTypeset(WmiMathDocumentModel doc, String currentFunction, Dag arguments, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        context.incrementTypesettingCounter();
        String typesettingTag = currentFunction.startsWith(TYPESETTING_LEADER) ? currentFunction.substring(TYPESETTING_LEAD_LENGTH) : currentFunction;
        WmiTypesetBuilder build = (WmiTypesetBuilder)TAG_BUILDERS.get(typesettingTag);
        build = build == null ? DEFAULT_BUILDER : build;
        WmiFontAttributeSet fontStyle = context.getStyle();
        if (fontStyle != null) {
            String fontStyleName = fontStyle.getFontStyleName();
            this.quoteHack = "2D Output".equals(fontStyleName);
        } else {
            this.quoteHack = false;
        }
        WmiModel builtModel = build.build(doc, arguments, context, this);
        context.decrementTypesettingCounter();
        return builtModel;
    }

    protected static abstract class WmiAbstractTagBuilder
    implements WmiTypesetBuilder {
        protected WmiAbstractTagBuilder() {
        }

        public WmiModel buildForChildFunction(WmiMathDocumentModel doc, Dag dag, WmiMathContext context, WmiTypesettingBuilder pbuilder, int index) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            WmiModel built = null;
            if (dag.getType() == 18) {
                Dag funcName = dag.getChild(0);
                String tag = funcName.getData();
                Dag args = dag.getChild(1);
                built = pbuilder.buildModelFromTypeset(doc, tag, args, context);
            }
            return built;
        }
    }

    protected static class WmiDefaultTagBuilder
    implements WmiTypesetBuilder {
        protected WmiDefaultTagBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return WmiMathFactory.createMathIdentifierToken(doc, "?", context);
        }
    }

    protected static abstract class WmiGenericTagBuilder
    extends WmiAbstractTagBuilder {
        public static final String LOAD_ERROR_TEXT = "Error loading this structure.";
        protected static final int PRE_BUILD = 0;
        protected static final int POST_BUILD = 1;

        protected WmiGenericTagBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            boolean opaque;
            int background;
            WmiFontAttributeSet fontAttribs;
            int foreground;
            WmiAttributeSet set;
            int argumentLength = this.getArgumentLength(argParent);
            int dagLength = argParent.getLength();
            int requiredArgs = this.getRequiredArguments();
            if (argumentLength < requiredArgs) {
                throw new IllegalArgumentException("Insufficient arguments in typeset builder - " + this.getClass() + "- found: " + argumentLength + " -Required: " + requiredArgs);
            }
            WmiModel finalModel = null;
            StringBuffer dagData = new StringBuffer();
            LinkedList<Dag> cachedAttributes = new LinkedList<Dag>();
            int arraySize = requiredArgs > 0 ? requiredArgs : argumentLength;
            WmiModel[] children = new WmiModel[arraySize];
            int i = 0;
            while (i < dagLength) {
                Dag child = argParent.getChild(i);
                int dagType = child.getType();
                if (dagType == 18) {
                    --requiredArgs;
                    this.modifyContextForIndex(i, context, 0);
                    if (i < children.length) {
                        children[i] = this.buildForChildFunction(doc, child, context, pbuilder, i);
                    } else if (!DagUtil.isFunctionNamed(child, "Typesetting:-mi") || child.getChild(1).getChild(0).getData().length() != 0) {
                        children[children.length - 1] = new WmiMathErrorModel(doc, LOAD_ERROR_TEXT);
                        context.recordRecoverableError(new ArrayIndexOutOfBoundsException("Builder  for " + this + " had too many arguments."));
                    }
                    this.modifyContextForIndex(i, context, 1);
                } else if (dagType == 7 || dagType == 8) {
                    dagData.append(child.getData());
                    if (finalModel == null && --requiredArgs <= 0) {
                        children = this.trimNullsFromChildren(children);
                        finalModel = this.assembleModel(doc, children, dagData.toString(), context, pbuilder);
                    }
                } else if (dagType == 20) {
                    if (finalModel == null && requiredArgs <= 0) {
                        children = this.trimNullsFromChildren(children);
                        finalModel = this.assembleModel(doc, children, dagData.toString(), context, pbuilder);
                    }
                    if (finalModel == null) {
                        cachedAttributes.add(child);
                    } else {
                        this.addAttribute(finalModel, child);
                    }
                } else {
                    --requiredArgs;
                }
                ++i;
            }
            if (finalModel == null) {
                children = this.trimNullsFromChildren(children);
                finalModel = this.assembleModel(doc, children, dagData.toString(), context, pbuilder);
            }
            if (finalModel != null && cachedAttributes.size() > 0) {
                for (Dag attributeDag : cachedAttributes) {
                    this.addAttribute(finalModel, attributeDag);
                }
            }
            if ((set = finalModel.getAttributesForRead()) instanceof WmiFontAttributeSet && (foreground = (fontAttribs = (WmiFontAttributeSet)set).getForeground()) == (background = fontAttribs.getBackground()) && (opaque = fontAttribs.isOpaque())) {
                fontAttribs = (WmiFontAttributeSet)finalModel.getAttributes();
                fontAttribs.setStyle(32, false);
                finalModel.setAttributes(fontAttribs);
            }
            return finalModel;
        }

        protected int getArgumentLength(Dag argParent) {
            int totalLength = argParent.getLength();
            int arguments = 0;
            int i = 0;
            while (i < totalLength) {
                if (DagUtil.isFunction(argParent.getChild(i)) || DagUtil.isString(argParent.getChild(i)) || DagUtil.isName(argParent.getChild(i))) {
                    ++arguments;
                }
                ++i;
            }
            return arguments;
        }

        protected void addAttribute(WmiModel model, Dag eqnDag) throws WmiNoWriteAccessException {
            Dag lhs = eqnDag.getChild(0);
            Dag rhs = eqnDag.getChild(1);
            String key = lhs.getData();
            String value = rhs.getData();
            value = this.conditionValues(key, value);
            key = this.conditionKeyNames(key);
            model.addAttribute(key, value);
        }

        protected String conditionKeyNames(String key) {
            String returned = key;
            if (key.equals("color")) {
                returned = "foreground";
            }
            return returned;
        }

        private boolean isHex(char c) {
            if (Character.isDigit(c = Character.toUpperCase(c))) {
                return true;
            }
            return Character.isLetter(c) && (c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F');
        }

        protected String conditionValues(String key, String value) {
            String possibleColour;
            if (key.equals("rtableid")) {
                return value;
            }
            if (value.startsWith("java.awt.Color")) {
                StringBuffer al = new StringBuffer("[");
                value = value.substring(15);
                value = value.substring(0, value.length() - 1);
                StringTokenizer tok = new StringTokenizer(value, ",");
                int finval = 0;
                int lcount = 0;
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    token = token.substring(2);
                    al.append(token);
                    if (tok.hasMoreTokens()) {
                        al.append(",");
                    } else {
                        al.append("]");
                    }
                    int tval = Integer.parseInt(token);
                    finval += (tval <<= (lcount += 8));
                }
                value = al.toString();
            }
            if ((possibleColour = WmiMathAttributeSet.getColour(value)).length() == 0) {
                boolean isHexi = true;
                int count = 0;
                int i = value.length() - 1;
                while (i >= 0 && isHexi && count < 6) {
                    if (this.isHex(value.charAt(i))) {
                        ++count;
                    } else {
                        isHexi = false;
                    }
                    --i;
                }
                if (count == 6 && isHexi) {
                    possibleColour = "0x" + value.substring(value.length() - 6).toUpperCase();
                }
            }
            if (possibleColour.length() > 0) {
                StringBuffer newVal = new StringBuffer("[");
                String redTok = possibleColour.substring(2, 4);
                String grnTok = possibleColour.substring(4, 6);
                String bluTok = possibleColour.substring(6, 8);
                newVal.append(Integer.toString(Integer.parseInt(redTok, 16)));
                newVal.append(",");
                newVal.append(Integer.toString(Integer.parseInt(grnTok, 16)));
                newVal.append(",");
                newVal.append(Integer.toString(Integer.parseInt(bluTok, 16)));
                newVal.append("]");
                value = newVal.toString();
            }
            return value;
        }

        protected WmiModel[] trimNullsFromChildren(WmiModel[] children) {
            WmiModel[] newKids = children;
            int lastNull = children.length;
            int i = children.length - 1;
            while (i >= 0) {
                if (children[i] != null) break;
                lastNull = i--;
            }
            if (lastNull != children.length) {
                newKids = new WmiModel[lastNull];
                System.arraycopy(children, 0, newKids, 0, lastNull);
            }
            return newKids;
        }

        protected void modifyContextForIndex(int index, WmiMathContext context, int stage) {
        }

        protected abstract int getRequiredArguments();

        protected abstract WmiModel assembleModel(WmiMathDocumentModel var1, WmiModel[] var2, String var3, WmiMathContext var4, WmiTypesettingBuilder var5) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException;
    }

    protected static class WmiMActionTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMActionTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathActionModel(doc, children);
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            WmiModel built = null;
            String builderKey = null;
            int i = 0;
            while (i < argParent.getLength()) {
                Dag searchDag = argParent.getChild(i);
                if (DagUtil.isEquation(searchDag) && "actiontype".toString().equals(searchDag.getChild(0).getData())) {
                    builderKey = searchDag.getChild(1).getData();
                }
                ++i;
            }
            if (WmiMathActionModel.specialActions.hasBuilder(builderKey)) {
                WmiMathActionModel.WmiSpecialActionBuilder actionBuilder = WmiMathActionModel.specialActions.getBuilder(builderKey);
                built = actionBuilder.buildModel(argParent.getChildrenAsArray(), doc);
            } else {
                built = super.build(doc, argParent, context, pbuilder);
            }
            return built;
        }
    }

    protected static class WmiMAmbiguousTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMAmbiguousTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathAmbiguousModel(doc, children);
        }
    }

    protected static class WmiMErrorTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMErrorTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathErrorModel(doc, data);
        }
    }

    protected static class WmiMFencedTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMFencedTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathFencedModel(doc, children, context);
        }
    }

    protected static class WmiMFracTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiMFracTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiFractionModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMMultiscriptTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMMultiscriptTagBuilder() {
        }

        @Override
        public void modifyContextForIndex(int index, WmiMathContext context, int stage) {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel(doc, children);
        }
    }

    protected static class WmiMOverTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMOverTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiOverModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMPaddedTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMPaddedTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathPaddedModel(doc, children);
        }
    }

    protected static class WmiMParsedBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMParsedBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Dag typesettingDag = argParent.getChild(0);
            Dag meaningDag = argParent.getChild(1);
            WmiModel model = this.buildForChildFunction(doc, typesettingDag, context, pbuilder, 0);
            WmiAssignedSemantics meaningSemantics = new WmiAssignedSemantics(meaningDag);
            ((WmiMathModel)model).setSemantics(meaningSemantics);
            return model;
        }
    }

    protected static class WmiMPhantomTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMPhantomTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathPhantomModel(doc, children);
        }
    }

    protected static class WmiMPrescriptsTagBuilder
    implements WmiTypesetBuilder {
        protected WmiMPrescriptsTagBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel.WmiMathPrescriptModel(doc);
        }
    }

    protected static class WmiMPrintslashBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMPrintslashBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Dag typesettingDag = argParent.getChild(0);
            typesettingDag = typesettingDag.getLength() > 1 ? DagUtil.createExpSeqDag(typesettingDag.getChildrenAsArray()) : typesettingDag.getChild(0);
            WmiMathModel model = WmiMathFactory.createMathModel(doc, typesettingDag, context);
            Dag meaningDag = argParent.getChild(1);
            if (meaningDag.getLength() > 0) {
                meaningDag = meaningDag.getLength() > 1 ? DagUtil.createExpSeqDag(meaningDag.getChildrenAsArray()) : meaningDag.getChild(0);
            }
            WmiPrintslashSemantics meaningSemantics = new WmiPrintslashSemantics(meaningDag);
            model.setSemantics(meaningSemantics);
            return model;
        }
    }

    protected static class WmiMRootTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiMRootTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiRootModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMRowTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiInlineMathModel(doc, children);
        }
    }

    protected static class WmiMScriptTagBuilder
    extends WmiGenericTagBuilder {
        private static final int CENTER_IDX = 0;
        private static final int SUBSCRIPT_IDX = 1;
        private static final int SUPERSCRIPT_IDX = 2;
        private static final int UNDER_IDX = 3;
        private static final int OVER_IDX = 4;
        private static final int PRESUB_IDX = 5;
        private static final int PRESUP_IDX = 6;

        protected WmiMScriptTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 7;
        }

        @Override
        public void modifyContextForIndex(int index, WmiMathContext context, int stage) {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            WmiModel finalModel = null;
            boolean overModel = !(children[4] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean underModel = !(children[3] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean supModel = !(children[2] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean subModel = !(children[1] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            boolean preScriptModel = !(children[5] instanceof WmiMathMultiscriptModel.WmiMathNoneModel) || !(children[6] instanceof WmiMathMultiscriptModel.WmiMathNoneModel);
            WmiModel centerModel = null;
            centerModel = overModel && underModel ? new WmiUnderOverModel(doc, children[0], children[3], children[4], context) : (overModel ? new WmiOverModel(doc, children[0], children[4], context) : (underModel ? new WmiUnderModel(doc, children[0], children[3], context) : children[0]));
            if (preScriptModel) {
                WmiModel[] assembleChildren = new WmiModel[]{centerModel, children[1], children[2], new WmiMathMultiscriptModel.WmiMathPrescriptModel(doc), children[5], children[6]};
                finalModel = new WmiMathMultiscriptModel(doc, assembleChildren);
            } else {
                finalModel = supModel && subModel ? new WmiSubSupModel(doc, centerModel, children[1], children[2], context) : (supModel ? new WmiSuperscriptModel(doc, centerModel, children[2], context) : (subModel ? new WmiSubscriptModel(doc, centerModel, children[1], context) : centerModel));
            }
            return finalModel;
        }
    }

    protected static class WmiMSpaceTagBuilder
    extends WmiGenericTagBuilder {
        protected WmiMSpaceTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 0;
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathSpaceModel(doc);
        }
    }

    protected static class WmiMSqrtTagBuilder
    extends WmiGenericTagBuilder {
        protected WmiMSqrtTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 1;
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiRootModel.WmiSquareRootModel(doc, children[0], context);
        }
    }

    protected static class WmiMStyleTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMStyleTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathStyleModel(doc, children, new WmiMathStyleModel.WmiMathStyleAttributeSet());
        }

        @Override
        protected void addAttribute(WmiModel model, Dag eqnDag) throws WmiNoWriteAccessException {
            Dag lhs = eqnDag.getChild(0);
            Dag rhs = eqnDag.getChild(1);
            String key = lhs.getData();
            String value = rhs.getData();
            value = this.conditionValues(key, value);
            ((WmiMathStyleModel)model).addAttribute(key, value, true);
        }
    }

    protected static class WmiMSubSupTagBuilder
    extends WmiThreeArgumentScriptTagBuilder {
        protected WmiMSubSupTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiSubSupModel(doc, children[0], children[1], children[2], context);
        }
    }

    protected static class WmiMSubTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMSubTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiSubscriptModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMSupTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMSupTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiSuperscriptModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMTableDataTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableDataTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableDataModel(doc, children[0]);
        }
    }

    protected static class WmiMTableLabeledRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableLabeledRowTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableLabeledRowModel(doc, children);
        }
    }

    protected static class WmiMTableRowTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableRowTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel.WmiMathTableRowModel(doc, children);
        }
    }

    protected static class WmiMTableTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTableTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiMathTableModel(doc, children);
        }
    }

    protected static class WmiMTextTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMTextTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathTextModel(doc, data, context);
        }
    }

    protected static class WmiMUnderOverTagBuilder
    extends WmiThreeArgumentScriptTagBuilder {
        protected WmiMUnderOverTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException {
            return new WmiUnderOverModel(doc, children[0], children[1], children[2], context);
        }
    }

    protected static class WmiMUnderTagBuilder
    extends WmiSecondScriptTagBuilder {
        protected WmiMUnderTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            return new WmiUnderModel(doc, children[0], children[1], context);
        }
    }

    protected static class WmiMVerbatimBuilder
    extends WmiAbstractTagBuilder {
        protected WmiMVerbatimBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            Dag child = argParent.getChild(0);
            if (DagUtil.isString(child)) {
                String dotmData = child.getData();
                try {
                    child = DagBuilder.createDag(dotmData);
                    if (child != null) {
                        child = DagBuilder.normalize(child);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            WmiMathModel model = WmiMathFactory.createMathModel(doc, child, context);
            return model;
        }
    }

    protected static class WmiMathTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMathTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoWriteAccessException {
            WmiMathWrapperModel wrapper = new WmiMathWrapperModel(doc);
            try {
                wrapper.addChildren(children, 0);
                WmiFontAttributeSet attrs = context.getStyle();
                wrapper.setAttributes(attrs);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            return wrapper;
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, IllegalArgumentException, WmiNoWriteAccessException, WmiNoReadAccessException {
            int argumentLength = this.getArgumentLength(argParent);
            int dagLength = argParent.getLength();
            int requiredArgs = this.getRequiredArguments();
            if (argumentLength < requiredArgs) {
                throw new IllegalArgumentException("Insufficient arguments in typeset builder - " + this.getClass() + "- found: " + argumentLength + " -Required: " + requiredArgs);
            }
            WmiModel finalModel = null;
            StringBuffer dagData = new StringBuffer();
            LinkedList<Dag> cachedAttributes = new LinkedList<Dag>();
            int arraySize = requiredArgs > 0 ? requiredArgs : argumentLength;
            WmiModel[] children = new WmiModel[arraySize];
            int i = argumentLength;
            while (i < dagLength) {
                Dag child = argParent.getChild(i);
                int dagType = child.getType();
                if (dagType == 20) {
                    cachedAttributes.add(child);
                }
                ++i;
            }
            WmiFontAttributeSet wrapperAttrs = new WmiFontAttributeSet();
            for (Dag attrDag : cachedAttributes) {
                Dag lhs = attrDag.getChild(0);
                Dag rhs = attrDag.getChild(1);
                String key = lhs.getData();
                String value = rhs.getData();
                value = this.conditionValues(key, value);
                key = this.conditionKeyNames(key);
                wrapperAttrs.addAttribute(key, value);
            }
            context = new WmiMathContext(wrapperAttrs);
            int i2 = 0;
            while (i2 < dagLength) {
                Dag child = argParent.getChild(i2);
                int dagType = child.getType();
                if (dagType == 18) {
                    --requiredArgs;
                    this.modifyContextForIndex(i2, context, 0);
                    if (i2 < children.length) {
                        children[i2] = this.buildForChildFunction(doc, child, context, pbuilder, i2);
                    } else if (!DagUtil.isFunctionNamed(child, "Typesetting:-mi") || child.getChild(1).getChild(0).getData().length() != 0) {
                        children[children.length - 1] = new WmiMathErrorModel(doc, "Error loading this structure.");
                        context.recordRecoverableError(new ArrayIndexOutOfBoundsException("Builder  for " + this + " had too many arguments."));
                    }
                    this.modifyContextForIndex(i2, context, 1);
                } else if (dagType == 7 || dagType == 8) {
                    dagData.append(child.getData());
                    if (finalModel == null && --requiredArgs <= 0) {
                        children = this.trimNullsFromChildren(children);
                        finalModel = this.assembleModel(doc, children, dagData.toString(), context, pbuilder);
                    }
                } else {
                    --requiredArgs;
                }
                ++i2;
            }
            if (finalModel == null) {
                children = this.trimNullsFromChildren(children);
                finalModel = this.assembleModel(doc, children, dagData.toString(), context, pbuilder);
            }
            return finalModel;
        }
    }

    protected static class WmiMiTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMiTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            if (data.startsWith("`") && data.endsWith("`") && pbuilder.quoteHack) {
                data = data.substring(1, data.length() - 1);
            }
            if (data.length() == 1 && MathTokenizer.containsOperator(data) && !data.startsWith("`")) {
                data = "`" + data + "`";
            }
            return WmiMathFactory.createMathIdentifierToken(doc, data, context);
        }
    }

    protected static class WmiMnTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMnTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return WmiMathFactory.createMathNumericToken(doc, data, context);
        }
    }

    protected static class WmiMoTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMoTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return WmiMathFactory.createMathOperatorToken(doc, data, context);
        }
    }

    protected static class WmiMsTagBuilder
    extends WmiUnlimitedArgumentTagBuilder {
        protected WmiMsTagBuilder() {
        }

        @Override
        public WmiModel assembleModel(WmiMathDocumentModel doc, WmiModel[] children, String data, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiInvalidModelInitializationException, WmiNoWriteAccessException {
            return new WmiMathStringModel(doc, data, context);
        }
    }

    protected static class WmiNoneTagBuilder
    implements WmiTypesetBuilder {
        protected WmiNoneTagBuilder() {
        }

        @Override
        public WmiModel build(WmiMathDocumentModel doc, Dag argParent, WmiMathContext context, WmiTypesettingBuilder pbuilder) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
            return new WmiMathMultiscriptModel.WmiMathNoneModel(doc);
        }
    }

    protected static abstract class WmiOneArgumentTagBuilder
    extends WmiGenericTagBuilder {
        private static final int ONE_CHILD = 1;
        protected static final int FIRST_CHILD = 0;

        protected WmiOneArgumentTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 1;
        }
    }

    protected static abstract class WmiSecondScriptTagBuilder
    extends WmiTwoArgumentTagBuilder {
        protected WmiSecondScriptTagBuilder() {
        }

        @Override
        protected void modifyContextForIndex(int index, WmiMathContext context, int stage) {
        }
    }

    protected static abstract class WmiThreeArgumentScriptTagBuilder
    extends WmiGenericTagBuilder {
        private static final int THREE_CHILDREN = 3;
        protected static final int FIRST_CHILD = 0;
        protected static final int SECOND_CHILD = 1;
        protected static final int THIRD_CHILD = 2;

        protected WmiThreeArgumentScriptTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 3;
        }

        @Override
        protected void modifyContextForIndex(int index, WmiMathContext context, int stage) {
        }
    }

    protected static abstract class WmiTwoArgumentTagBuilder
    extends WmiGenericTagBuilder {
        private static final int TWO_CHILDREN = 2;
        protected static final int FIRST_CHILD = 0;
        protected static final int SECOND_CHILD = 1;

        protected WmiTwoArgumentTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return 2;
        }
    }

    protected static interface WmiTypesetBuilder {
        public WmiModel build(WmiMathDocumentModel var1, Dag var2, WmiMathContext var3, WmiTypesettingBuilder var4) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException;
    }

    protected static abstract class WmiUnlimitedArgumentTagBuilder
    extends WmiGenericTagBuilder {
        public static final int UNLIMITED_ARGUMENTS = -1;

        protected WmiUnlimitedArgumentTagBuilder() {
        }

        @Override
        public int getRequiredArguments() {
            return -1;
        }
    }
}

