/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiVectorBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final String ROW_VECTOR = "<|>";
    private static final String QUOTED_ROW_VECTOR = "`<|>`";
    private static final String VECTOR_LEFT_BRACKET = "&LeftAngleBracket;";
    private static final String VECTOR_RIGHT_BRACKET = "&RightAngleBracket;";
    private static final String PROC_VECTOR_LEFT_BRACKET = "<";
    private static final String PROC_VECTOR_RIGHT_BRACKET = ">";
    private static final String ROW_VECTOR_OP = "|";
    private static final String COLUMN_VECTOR_OP = ",";

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel result = new WmiInlineMathModel(doc);
        String theOp = COLUMN_VECTOR_OP;
        if (funcName.equals(ROW_VECTOR) || funcName.equals(QUOTED_ROW_VECTOR)) {
            theOp = ROW_VECTOR_OP;
        }
        int i = 0;
        while (i < argParent.getLength()) {
            result.appendChild(WmiMathFactory.createMath(doc, argParent.getChild(i), context));
            if (i < argParent.getLength() - 1) {
                result.appendChild(WmiMathFactory.createMathOperatorToken(doc, theOp, context));
            }
            ++i;
        }
        WmiMathModel container = context.useProcRules() ? WmiMathFactory.addBrackets(result, PROC_VECTOR_LEFT_BRACKET, PROC_VECTOR_RIGHT_BRACKET, context) : WmiMathFactory.addBrackets(result, VECTOR_LEFT_BRACKET, VECTOR_RIGHT_BRACKET, context);
        return container;
    }

    @Override
    public boolean shouldBeUsed(Dag dag, WmiMathContext context) {
        return dag.getLength() > 1 && dag.getChild(1) != null;
    }
}

