/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiVectorDerivativesBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String CROSS_PRODUCT = "\u00d7";
    public static final String DOT_PRODUCT = "\u00b7";
    private static final WmiMathSemantics VECTOR_DERIVATIVE_SEMANTIC = new WmiVectorDerivativeSemantics();
    private String operator = "";
    private String NABLA = "\u2207";

    public WmiVectorDerivativesBuilder(String op) {
        this.operator = op;
    }

    @Override
    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel doc, String funcName, Dag argParent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel result = new WmiInlineMathModel(doc);
        result.appendChild(WmiMathFactory.createMathIdentifierToken(doc, this.NABLA, context));
        result.appendChild(WmiMathFactory.createMathIdentifierToken(doc, this.operator, context));
        WmiMathModel rhs = WmiMathFactory.createMath(doc, argParent.getChild(0), context);
        if (WmiPrecedenceRules.areBracketsRequired(argParent.getChild(0), 3, 0)) {
            rhs = WmiMathFactory.addBrackets(rhs, context);
        }
        result.appendChild(rhs);
        result.setSemantics(VECTOR_DERIVATIVE_SEMANTIC);
        return result;
    }

    public static class WmiVectorDerivativeSemantics
    implements WmiMathSemantics {
        private static final int INDEX_OF_OPERATOR = 1;
        private static final int INDEX_OF_OPERAND = 2;
        private static final String SPACE = " ";

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            Dag function = null;
            if (model != null && model.isComposite()) {
                WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
                WmiModel operatorModel = composite.getChild(1);
                WmiMathModel operandModel = (WmiMathModel)composite.getChild(2);
                if (operatorModel instanceof WmiTextModel && operandModel != null) {
                    Dag operandDag = operandModel.toDag();
                    String operatorString = ((WmiTextModel)operatorModel).getText();
                    Dag functionName = null;
                    if (WmiVectorDerivativesBuilder.CROSS_PRODUCT.equals(operatorString)) {
                        functionName = WmiSemanticDagUtil.CURL_FUNC_NAME;
                    } else if (WmiVectorDerivativesBuilder.DOT_PRODUCT.equals(operatorString)) {
                        functionName = WmiSemanticDagUtil.GRADIENT_FUNC_NAME;
                    } else if (SPACE.equals(operatorString)) {
                        functionName = WmiSemanticDagUtil.DIVERGENCE_FUNC_NAME;
                    }
                    function = WmiSemanticDagUtil.createFunction(functionName, operandDag);
                }
            }
            function = WmiSemanticDagUtil.handleNullDag(function, model);
            return function;
        }
    }
}

