/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class WmiComboBoxUIFactory {
    public static final int LIGHT_COLOR = 1;
    public static final int DARK_COLOR = 2;
    public static Paint LIGHT_BACKGROUND_PAINT = null;
    public static Paint LIGHT_SELECTED_BACKGROUND_PAINT = null;
    public static Paint DARK_BACKGROUND_PAINT = null;
    public static Paint DARK_SELECTED_BACKGROUND_PAINT = null;

    private static void createPaints() {
        LIGHT_SELECTED_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.GRAY, new Point(0, 20), Color.LIGHT_GRAY);
        LIGHT_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.LIGHT_GRAY.brighter(), new Point(0, 20), Color.LIGHT_GRAY);
        DARK_SELECTED_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.GRAY, new Point(0, 20), Color.WHITE);
        DARK_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.LIGHT_GRAY, new Point(0, 20), Color.GRAY);
    }

    public static ComboBoxUI createUI(int color) {
        if (LIGHT_BACKGROUND_PAINT == null) {
            WmiComboBoxUIFactory.createPaints();
        }
        return new OvalComboBoxUI(color);
    }

    private WmiComboBoxUIFactory() {
    }

    protected static class ListItemRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer {
        protected ListItemRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            BasicComboBoxRenderer c = (BasicComboBoxRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            c.setOpaque(isSelected);
            return c;
        }
    }

    private static class OvalComboBoxUI
    extends BasicComboBoxUI {
        private int color;

        public OvalComboBoxUI(int color) {
            this.color = color;
        }

        @Override
        public void installUI(JComponent c) {
            this.currentValuePane = new TransparentCellRendererPane();
            super.installUI(c);
            c.setOpaque(false);
            c.setBorder(null);
            ((JComboBox)c).setRenderer(new ListItemRenderer());
        }

        @Override
        protected JButton createArrowButton() {
            return new TransparentArrowButton();
        }

        @Override
        protected Insets getInsets() {
            Insets i = super.getInsets();
            i.left += 8;
            return i;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Rectangle bounds = c.getBounds();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isPopupVisible(this.comboBox)) {
                g2.setPaint(this.color == 1 ? LIGHT_SELECTED_BACKGROUND_PAINT : DARK_SELECTED_BACKGROUND_PAINT);
            } else {
                g2.setPaint(this.color == 1 ? LIGHT_BACKGROUND_PAINT : DARK_BACKGROUND_PAINT);
            }
            g2.fillRoundRect(0, 0, bounds.width - 1, bounds.height - 1, bounds.height, bounds.height);
            super.paint(g2, c);
            g2.setColor(this.color == 1 ? Color.GRAY : Color.DARK_GRAY);
            g2.drawRoundRect(0, 0, bounds.width - 1, bounds.height - 1, bounds.height, bounds.height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
            super.paintCurrentValue(g, bounds, hasFocus);
        }

        @Override
        public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        }

        @Override
        protected Dimension getDisplaySize() {
            Dimension d = super.getDisplaySize();
            d.width = Math.min(d.width, 100);
            d.height = 20;
            return d;
        }

        public void setPopupVisible(JComboBox c, boolean v) {
            super.setPopupVisible(c, v);
            c.repaint();
        }
    }

    private static class TransparentArrowButton
    extends BasicArrowButton {
        public TransparentArrowButton() {
            super(5, null, Color.GRAY, Color.DARK_GRAY, null);
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = isPressed || this.isEnabled();
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        }
    }

    private static class TransparentCellRendererPane
    extends CellRendererPane {
        private TransparentCellRendererPane() {
        }

        @Override
        public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
            OvalComboBoxUI ui;
            Color foreground = Color.BLACK;
            if (p instanceof JComboBox && (ui = (OvalComboBoxUI)((JComboBox)p).getUI()).color == 2) {
                foreground = Color.BLACK;
            }
            c.setForeground(foreground);
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
            super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
        }
    }
}

