/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiDropDownButton;
import com.maplesoft.mathdoc.platform.WmiToolBarButtonUIFactory;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;

public class WmiDropDownButtonUIFactory {
    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacDropDownButtonUI();
        }
        return new WindowsUnixDropDownButtonUI();
    }

    static void paintDropDownArrow(Graphics g, WmiDropDownButton b) {
        Icon icon = b.getDropDownIcon();
        if (icon != null) {
            int x = b.getWidth() - icon.getIconWidth() - 3;
            int y = (b.getHeight() - icon.getIconHeight()) / 2 + 2;
            icon.paintIcon(b, g, x, y);
        }
    }

    private WmiDropDownButtonUIFactory() {
    }

    public static class MacDropDownButtonUI
    extends WmiToolBarButtonUIFactory.MacToolBarButtonUI {
        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 15));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            WmiDropDownButton b = (WmiDropDownButton)c;
            WmiDropDownButtonUIFactory.paintDropDownArrow(g, b);
        }
    }

    public static class WindowsUnixDropDownButtonUI
    extends WmiToolBarButtonUIFactory.WindowsUnixToolBarButtonUI {
        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 15));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            WmiDropDownButton b = (WmiDropDownButton)c;
            WmiDropDownButtonUIFactory.paintDropDownArrow(g, b);
        }

        @Override
        protected void paintBackground(Graphics g, AbstractButton b) {
            super.paintBackground(g, b);
            if (((WmiDropDownButton)b).isMenuVisible()) {
                g.setColor(Color.GRAY);
                int x = b.getWidth() - 15 + 2;
                g.fillRoundRect(x, 0, 15, b.getHeight(), 2, 2);
                g.fillRect(x, 0, 2, b.getHeight());
            }
        }

        @Override
        protected void paintBorder(Graphics g, AbstractButton b) {
            super.paintBorder(g, b);
            ButtonModel model = b.getModel();
            if (model.isSelected() || model.isRollover() || model.isPressed()) {
                g.setColor(Color.GRAY);
                int x = b.getWidth() - 15 + 2;
                g.drawLine(x, 0, x, b.getHeight());
                g.setColor(b.getBackground().brighter());
                g.drawLine(x + 1, 1, x + 1, b.getHeight() - 2);
            }
        }
    }
}

