/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.mathdoc.util.WmiNamedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;

public class WmiRawFileWriter
extends Writer
implements WmiNamedWriter {
    private String superFilename = null;
    private FileOutputStream ostream = null;

    public WmiRawFileWriter(String filename) throws IOException {
        this.ostream = new FileOutputStream(filename);
        this.superFilename = filename;
    }

    public WmiRawFileWriter(File file) throws IOException {
        this.ostream = new FileOutputStream(file);
        this.superFilename = file.getAbsolutePath();
    }

    @Override
    public String getFilename() {
        return this.superFilename;
    }

    @Override
    public void close() throws IOException {
        this.ostream.flush();
        this.ostream.close();
    }

    @Override
    public void flush() throws IOException {
        this.ostream.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int length = len - off;
        byte[] writeBytes = new byte[length];
        int i = 0;
        while (length > i) {
            writeBytes[i] = (byte)cbuf[i + off];
            ++i;
        }
        this.ostream.write(writeBytes);
    }
}

