/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class WmiResourcePackage {
    public static final int SEARCH_REQUIRE_LOCALIZED = 0;
    public static final int SEARCH_PREFER_LOCALIZED = 1;
    public static final int SEARCH_PREFER_COMMON = 3;
    public static final int SEARCH_REQUIRE_COMMON = 4;
    private static final String LOCALIZED_FILE_NAME_SUFFIX = "_Localized";
    private static final String RESOURCE_PACKAGE_KEY = "package";
    private static final String RESOURCE_CLASS_LIST_KEY = "classes";
    private static final String SUFFIX_MAC = ".mac";
    private static final String SUFFIX_WIN = ".win";
    private static final String SUFFIX_UNIX = ".unix";
    private static final String ENCODING_KEY = "__encoding";
    private static boolean DEBUG = false;
    private static String resourceDir;
    private static String platformSuffix;
    private ResourceBundle commonBundle = null;
    private ResourceBundle localizedBundle = null;
    private boolean isCommonUtf8 = false;
    private boolean isLocalizedUtf8 = false;

    static {
        WmiResourcePackage.setPlatformSuffix();
    }

    protected WmiResourcePackage(String bundleName) {
        if (bundleName != null) {
            try {
                this.commonBundle = ResourceBundle.getBundle(bundleName);
            }
            catch (MissingResourceException mre) {
                this.commonBundle = null;
            }
            try {
                Locale bndlLocale = RuntimeLocale.getDisplayLocale();
                this.localizedBundle = WmiResourcePackage.getLocalizedResourceBundle(bundleName, bndlLocale);
            }
            catch (MissingResourceException mre) {
                this.localizedBundle = null;
            }
            this.isCommonUtf8 = WmiResourcePackage.isUtf8(this.commonBundle);
            this.isLocalizedUtf8 = WmiResourcePackage.isUtf8(this.localizedBundle);
        }
    }

    private static ResourceBundle getLocalizedResourceBundle(String bundleName, Locale locale) {
        ResourceBundle bundle;
        block14: {
            bundle = null;
            if (resourceDir == null) {
                bundle = ResourceBundle.getBundle(String.valueOf(bundleName) + LOCALIZED_FILE_NAME_SUFFIX, locale);
            } else {
                locale = RuntimeLocale.normalize(locale);
                StringBuffer buffy = new StringBuffer();
                buffy.append(resourceDir);
                buffy.append(File.separatorChar);
                buffy.append(bundleName.replace('.', '/'));
                buffy.append(LOCALIZED_FILE_NAME_SUFFIX);
                buffy.append('_');
                buffy.append(locale.toString());
                buffy.append(".properties");
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(buffy.toString());
                        bundle = new PropertyResourceBundle(fis);
                    }
                    catch (IOException ioe) {
                        System.err.println("file not found: " + buffy);
                        bundle = ResourceBundle.getBundle(String.valueOf(bundleName) + LOCALIZED_FILE_NAME_SUFFIX, locale);
                        if (fis == null) break block14;
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return bundle;
    }

    private static boolean isUtf8(ResourceBundle b) {
        boolean isUtf8 = false;
        if (b != null) {
            try {
                String s = b.getString(ENCODING_KEY);
                isUtf8 = s != null && s.equals("UTF-8");
            }
            catch (MissingResourceException mre) {
                isUtf8 = false;
            }
        }
        return isUtf8;
    }

    public static WmiResourcePackage getResourcePackage(String bundleName) {
        if (DEBUG) {
            return new WmiDebugResourcePackage(bundleName);
        }
        return new WmiResourcePackage(bundleName);
    }

    public static void setPlatformSuffix() {
        platformSuffix = RuntimePlatform.isMac() ? SUFFIX_MAC : (RuntimePlatform.isWindows() ? SUFFIX_WIN : SUFFIX_UNIX);
    }

    public static String getPlatformSuffix() {
        return platformSuffix;
    }

    public static void setResourceDebug(boolean debug) {
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static void setResourceDir(String s) {
    }

    public String getEnglishLocalizedString(String key) {
        return null;
    }

    public String getPackageName() {
        return null;
    }

    public String getStringForKey(String key) {
        return this.getStringForKey(key, 1);
    }

    public String[] getStringsForKeyArray(String[] keys) {
        String[] s = new String[keys.length];
        int i = 0;
        while (i < s.length) {
            s[i] = this.getStringForKey(keys[i]);
            ++i;
        }
        return s;
    }

    public String getStringForKey(String key, int searchCmd) {
        ResourceBundle b1 = null;
        ResourceBundle b2 = null;
        boolean decode1 = false;
        boolean decode2 = false;
        switch (searchCmd) {
            case 0: {
                b1 = this.localizedBundle;
                decode1 = this.isLocalizedUtf8;
                b2 = null;
                break;
            }
            case 1: {
                b1 = this.localizedBundle;
                decode1 = this.isLocalizedUtf8;
                b2 = this.commonBundle;
                decode2 = this.isCommonUtf8;
                break;
            }
            case 3: {
                b1 = this.commonBundle;
                decode1 = this.isCommonUtf8;
                b2 = this.localizedBundle;
                decode2 = this.isLocalizedUtf8;
                break;
            }
            case 4: {
                b1 = this.commonBundle;
                decode1 = this.isCommonUtf8;
                b2 = null;
                break;
            }
            default: {
                b1 = this.localizedBundle;
                decode1 = this.isLocalizedUtf8;
                b2 = this.commonBundle;
                decode2 = this.isCommonUtf8;
            }
        }
        String result = null;
        if (b1 != null) {
            result = this.doPlatformBundleSearch(b1, key);
            if (decode1) {
                result = UTF8Encoder.convertUtf8ToUnicode(result);
            }
        }
        if (result == null && b2 != null) {
            result = this.doPlatformBundleSearch(b2, key);
            if (decode2) {
                result = UTF8Encoder.convertUtf8ToUnicode(result);
            }
        }
        return result;
    }

    public String getStringForKey(String key, String arg, int searchCmd) {
        String value = this.getStringForKey(key, searchCmd);
        if (value != null) {
            value = value.replaceAll("%1", arg);
        }
        return value;
    }

    public String getStringForKey(String key, String arg) {
        return this.getStringForKey(key, arg, 1);
    }

    public String getStringForKey(String name, String[] arg, int searchCmd) {
        String value = this.getStringForKey(name, searchCmd);
        if (value != null) {
            int i = 0;
            while (i < arg.length) {
                String replaceLabel = "%" + (i + 1);
                value = value.replaceAll(replaceLabel, arg[i]);
                ++i;
            }
        }
        return value;
    }

    public String getStringForKey(String name, String[] arg) {
        return this.getStringForKey(name, arg, 1);
    }

    public int getIntForKey(String name) {
        return this.getIntForKey(name, -1);
    }

    public double getDoubleForKey(String name) {
        return this.getDoubleForKey(name, -1.0);
    }

    public int getIntForKey(String name, int defaultInt) {
        int returnVal = defaultInt;
        String value = this.getStringForKey(name);
        if (value != null) {
            try {
                returnVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                returnVal = defaultInt;
            }
        }
        return returnVal;
    }

    public double getDoubleForKey(String name, double defaultDouble) {
        double returnVal = defaultDouble;
        String value = this.getStringForKey(name);
        if (value != null) {
            try {
                returnVal = Double.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                returnVal = defaultDouble;
            }
        }
        return returnVal;
    }

    public boolean getBooleanForKey(String name) {
        return this.getBooleanForKey(name, false);
    }

    public boolean getBooleanForKey(String name, boolean defaultBool) {
        boolean returnVal = defaultBool;
        String value = this.getStringForKey(name);
        if (value != null) {
            returnVal = Boolean.valueOf(value);
        }
        return returnVal;
    }

    public boolean instantiateClasses(HashMap classMap) {
        boolean loadOkay = true;
        String packageName = this.getStringForKey(RESOURCE_PACKAGE_KEY, 3);
        String classList = this.getStringForKey(RESOURCE_CLASS_LIST_KEY, 3);
        if (packageName == null || classList == null) {
            loadOkay = false;
        }
        if (loadOkay) {
            String[] classNames = classList.split("  *");
            int i = 0;
            while (i < classNames.length) {
                String[] pair = classNames[i].split(":");
                assert (pair.length == 1 || pair.length == 2);
                assert (pair[0].length() > 0) : "this should be <class>:<command name> but isn't: " + classNames[i] + " index " + i + " from [" + classList + "]";
                String className = String.valueOf(packageName) + "." + pair[0];
                try {
                    Object obj;
                    if (pair.length == 1) {
                        Class<?> cls = Class.forName(className.trim());
                        obj = cls.newInstance();
                    } else {
                        assert (pair[1].length() > 0);
                        String commandName = pair[1];
                        obj = new WmiCommandProxy(commandName, className, this);
                    }
                    if (classMap != null) {
                        classMap.put(className, obj);
                    }
                }
                catch (Exception exc) {
                    loadOkay = false;
                    WmiErrorLog.log(exc);
                }
                ++i;
            }
        }
        return loadOkay;
    }

    public boolean instantiateClasses() {
        return this.instantiateClasses(null);
    }

    public void release() {
        this.commonBundle = null;
        this.localizedBundle = null;
    }

    protected String doPlatformBundleSearch(ResourceBundle bndl, String key) {
        String result = null;
        result = this.doBundleSearch(bndl, String.valueOf(key) + platformSuffix);
        if (result == null) {
            result = this.doBundleSearch(bndl, key);
        }
        return result;
    }

    protected String doBundleSearch(ResourceBundle bndl, String key) {
        String keyValue = null;
        if (bndl != null) {
            try {
                keyValue = bndl.getString(key);
            }
            catch (MissingResourceException mre) {
                keyValue = null;
            }
        }
        return keyValue;
    }

    private static class WmiDebugResourcePackage
    extends WmiResourcePackage {
        private String name = null;
        private ResourceBundle englishBundle = null;

        protected WmiDebugResourcePackage(String bundleName) {
            super(bundleName);
            this.name = bundleName;
            try {
                this.englishBundle = ResourceBundle.getBundle(String.valueOf(bundleName) + WmiResourcePackage.LOCALIZED_FILE_NAME_SUFFIX, Locale.ENGLISH);
            }
            catch (MissingResourceException mre) {
                this.englishBundle = null;
            }
        }

        @Override
        public String getEnglishLocalizedString(String key) {
            String english = null;
            if (this.englishBundle != null) {
                try {
                    english = this.englishBundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    english = null;
                }
            }
            return english;
        }

        @Override
        public String getPackageName() {
            return this.name;
        }
    }
}

