/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class WmiArrayCompositeView
extends WmiGenericView
implements WmiCompositeView,
WmiPositionedView {
    private static final float GROWTH_FACTOR = 1.5f;
    private static final int DEFAULT_INDENT = 2;
    protected static final int SEARCH_VERTICAL = 1;
    protected static final int SEARCH_HORIZONTAL = 2;
    protected static final int SEARCH_BOTH = 3;
    protected WmiView[] children;
    protected int length = 0;
    private int baseIndex = 0;

    public WmiArrayCompositeView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    public WmiArrayCompositeView(WmiModel model, WmiMathDocumentView docView, WmiCompositeView parent) {
        super(model, docView, parent);
    }

    @Override
    public void appendView(WmiView view) {
        this.ensureCapacity(this.length + 1);
        this.children[this.length++] = view;
        if (view != null) {
            view.setParentView(this);
        }
    }

    @Override
    public void removeChild(int index) {
        WmiView[] newChildren = new WmiView[this.children.length - 1];
        int j = 0;
        int i = 0;
        while (i < this.children.length) {
            if (i != index) {
                newChildren[j] = this.children[i];
                ++j;
            }
            ++i;
        }
        --this.length;
        this.children = newChildren;
    }

    @Override
    public void insertView(WmiView view, int index) {
        if ((index += this.baseIndex) < this.length) {
            this.ensureCapacity(this.length + 1);
            System.arraycopy(this.children, index, this.children, index + 1, this.length - index);
            ++this.length;
            this.children[index] = view;
            view.setParentView(this);
        } else {
            this.appendView(view);
        }
    }

    public void insertViews(WmiView[] views, int span, int index) {
        this.ensureCapacity(this.length + span);
        if (this.length > index) {
            System.arraycopy(this.children, index, this.children, index + span, this.length - index);
        }
        int i = 0;
        while (i < span) {
            views[i].setParentView(this);
            ++i;
        }
        System.arraycopy(views, 0, this.children, index, span);
        this.length += span;
    }

    @Override
    public int indexOf(WmiView child) {
        int index = -1;
        if (this.children != null) {
            int i = this.baseIndex;
            while (i < this.children.length) {
                if (this.children[i] == child) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index - this.baseIndex;
    }

    @Override
    public WmiView getChild(int index) {
        WmiView child = null;
        if (this.children != null && (index += this.baseIndex) >= this.baseIndex && index < this.length) {
            child = this.children[index];
        }
        return child;
    }

    @Override
    public int getChildCount() {
        return this.length - this.baseIndex;
    }

    @Override
    public void replaceChild(WmiView view, int position) {
        this.children[position += this.baseIndex] = view;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        this.validateChildren();
        super.layoutView();
    }

    @Override
    public void updateView() throws WmiNoReadAccessException {
        try {
            WmiModel model = this.getModel();
            if (model instanceof WmiCompositeModel) {
                WmiCompositeModel cmodel = (WmiCompositeModel)model;
                if (this.length == 0) {
                    this.initializeView(cmodel);
                } else if (cmodel.getChildCount() == 1 && this.length == 1) {
                    this.singleChildUpdate(cmodel);
                } else {
                    this.compoundUpdate(cmodel);
                }
                int pos = 0;
                while (pos < this.length) {
                    if (this.children[pos] == null) {
                        if (pos < this.length - 1) {
                            System.arraycopy(this.children, pos + 1, this.children, pos, this.length - pos - 1);
                        }
                        --this.length;
                        continue;
                    }
                    ++pos;
                }
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        super.updateView();
    }

    public static boolean hasUniqueViewObserver(WmiModel model, WmiMathDocumentView docView) {
        int count = 0;
        if (model != null) {
            WmiModelObserver observer = model.getObserver();
            while (observer != null) {
                if (observer instanceof WmiView && ((WmiView)((Object)observer)).getDocumentView() == docView) {
                    ++count;
                }
                observer = observer.getNextObserver();
            }
        }
        return count == 1;
    }

    @Override
    public String debugPrint(int indent) throws WmiNoReadAccessException {
        StringBuffer sb = new StringBuffer();
        String name = this.getDebugName();
        sb.append("\n");
        sb.append(this.createIndent(indent));
        sb.append("<");
        sb.append(name);
        sb.append(" x = ");
        sb.append(this.getHorizontalOffset());
        sb.append(" y = ");
        sb.append(this.getVerticalOffset());
        sb.append(" width = ");
        sb.append(this.width);
        sb.append(" height = ");
        sb.append(this.height);
        if (this.length == 0) {
            sb.append("/>");
        } else {
            sb.append(">");
            int i = this.baseIndex;
            while (i < this.length) {
                WmiView child = this.children[i];
                if (child != null) {
                    sb.append(child.debugPrint(indent + 2));
                } else {
                    sb.append("<NULL/>");
                }
                ++i;
            }
            sb.append("\n");
            sb.append(this.createIndent(indent));
            sb.append("</");
            sb.append(name);
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public WmiView copyView() {
        WmiArrayCompositeView copy = (WmiArrayCompositeView)super.copyView();
        int size = this.length - this.baseIndex;
        copy.children = new WmiView[size];
        int i = 0;
        while (i < size) {
            WmiView child = this.children[i + this.baseIndex];
            copy.children[i] = child = child.copyView();
            child.setParentView(copy);
            ++i;
        }
        copy.length = size;
        copy.addNavigationLinks();
        return copy;
    }

    @Override
    public WmiView splitView(int offset, int consume) {
        WmiArrayCompositeView copy = null;
        try {
            copy = (WmiArrayCompositeView)this.clone();
        }
        catch (CloneNotSupportedException e) {
            WmiErrorLog.log(e);
        }
        WmiView[] leftKids = new WmiView[offset];
        System.arraycopy(this.children, this.baseIndex, leftKids, 0, offset);
        Arrays.fill(this.children, this.baseIndex, this.baseIndex + offset + consume, null);
        this.baseIndex += offset + consume;
        copy.length = offset;
        copy.children = leftKids;
        copy.locations = null;
        copy.neighbors = null;
        copy.baseIndex = 0;
        int i = 0;
        while (i < offset) {
            WmiView child = copy.children[i];
            child.setParentView(copy);
            ++i;
        }
        this.markInvalid(1);
        copy.markInvalid(1);
        return copy;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        path.push(this.getHorizontalOffset(), this.getVerticalOffset());
        this.drawChildren(g, path, bounds);
        path.pop();
    }

    protected void drawChildren(Graphics g, WmiRenderPath path, Rectangle bounds) {
        int i = 0;
        while (i < this.length) {
            WmiPositionedView child = (WmiPositionedView)this.children[i];
            if (child != null) {
                child.draw(g, path, bounds);
            }
            path.next();
            ++i;
        }
    }

    @Override
    public WmiPositionedView getChildView(Point pt) {
        WmiPositionedView view = null;
        int i = 0;
        while (i < this.length) {
            Rectangle childBounds;
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView && (childBounds = ((WmiPositionedView)child).getBounds()) != null && childBounds.contains(pt)) {
                view = (WmiPositionedView)child;
                break;
            }
            ++i;
        }
        return view;
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, 3);
    }

    protected int getChildError(Point pt, WmiPositionedView child, int searchType, boolean[] biases) {
        int error = 0;
        Rectangle childBounds = child.getBounds();
        int dy = 0;
        int dx = 0;
        if (childBounds.x > pt.x) {
            dx = childBounds.x - pt.x;
            if (searchType == 2 || searchType == 3) {
                biases[0] = true;
            }
        } else if (childBounds.x + childBounds.width < pt.x) {
            dx = pt.x - childBounds.x - childBounds.width;
        }
        if (childBounds.y > pt.y) {
            dy = childBounds.y - pt.y;
            if (searchType == 1 || searchType == 3) {
                biases[1] = true;
            }
        } else if (childBounds.y + childBounds.height < pt.y) {
            dy = pt.y - childBounds.y - childBounds.height;
        }
        if (searchType == 3) {
            error = dx * dx + dy * dy;
        } else if (searchType == 2) {
            error = Math.abs(dx);
        } else if (searchType == 1) {
            error = Math.abs(dy);
        }
        return error;
    }

    protected WmiPositionedView getNearestChildView(Point pt, int searchType) {
        WmiPositionedView view = null;
        WmiPositionedView closestView = null;
        int minError = Integer.MAX_VALUE;
        boolean biasLeft = false;
        boolean biasUp = false;
        int i = 0;
        while (i < this.length) {
            Rectangle childBounds;
            int error = 0;
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView && ((WmiPositionedView)child).isNavagableView() && (childBounds = ((WmiPositionedView)child).getBounds()) != null) {
                if (childBounds.contains(pt)) {
                    view = (WmiPositionedView)child;
                    break;
                }
                boolean[] biases = new boolean[2];
                biases[1] = false;
                biases[0] = false;
                error = this.getChildError(pt, (WmiPositionedView)child, searchType, biases);
                biasLeft = biases[0];
                biasUp = biases[1];
                if (error < minError) {
                    minError = error;
                    closestView = (WmiPositionedView)child;
                } else if (error == minError && (!biasLeft && !biasUp || closestView == null)) {
                    closestView = (WmiPositionedView)child;
                }
            }
            ++i;
        }
        if (view == null) {
            view = closestView;
        }
        return view;
    }

    public void drawStub(Graphics g, WmiRenderPath path, Rectangle bounds) {
    }

    protected void validateChildren() throws WmiNoReadAccessException {
        int i = 0;
        while (i < this.length) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView && !child.isLayoutValid()) {
                ((WmiPositionedView)child).layoutView();
                ((WmiPositionedView)child).checkRepaint();
            }
            ++i;
        }
    }

    @Override
    public void resetPaintFlags() {
        super.resetPaintFlags();
        int i = 0;
        while (i < this.length) {
            WmiPositionedView posView;
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView && ((posView = (WmiPositionedView)child).getCheckRepaint() || posView.getForceRepaint())) {
                posView.resetPaintFlags();
            }
            ++i;
        }
    }

    protected void initializeView(WmiCompositeModel model) throws WmiNoReadAccessException {
        this.length = model.getChildCount();
        WmiView[] views = new WmiView[this.length];
        WmiViewFactory factory = this.getViewFactory();
        if (factory != null) {
            int i = 0;
            while (i < this.length) {
                WmiModel child = model.getChild(i);
                if (child != null && child.isVisible()) {
                    views[i] = factory.createView(model.getChild(i), this);
                }
                ++i;
            }
        } else {
            WmiErrorLog.log(new Exception("Unable to locate view factory"));
        }
        this.children = views;
    }

    protected void ensureCapacity(int size) {
        if (this.children == null) {
            this.children = new WmiView[size];
        } else if (this.children.length < size) {
            int newLength = (int)(1.5f * (float)this.children.length) + 1;
            if (newLength < size) {
                newLength = size;
            }
            WmiView[] newArray = new WmiView[newLength];
            System.arraycopy(this.children, 0, newArray, 0, this.length);
            this.children = newArray;
        }
    }

    private void singleChildUpdate(WmiCompositeModel model) throws WmiNoReadAccessException {
        WmiViewFactory factory;
        WmiModel child = model.getChild(0);
        WmiView childView = this.children[0];
        if (childView == null) {
            return;
        }
        WmiModel childModel = childView.getModel();
        if (childModel != null && !childModel.isVisible()) {
            childView.release();
            this.children[0] = null;
            return;
        }
        if (!(childModel == child && WmiArrayCompositeView.hasUniqueViewObserver(child, this.getDocumentView()) || (factory = this.getViewFactory()) == null)) {
            childView.release();
            this.children[0] = factory.createView(child, this);
        }
    }

    private void compoundUpdate(WmiCompositeModel model) throws WmiNoReadAccessException {
        int j;
        WmiMathDocumentView docView = this.getDocumentView();
        int oldLength = this.length;
        int size = model.getChildCount();
        WmiView[] views = new WmiView[size];
        int[] viewIndex = new int[oldLength];
        int viewOffset = 0;
        WmiViewFactory factory = this.getViewFactory();
        int i = 0;
        while (i < oldLength) {
            viewIndex[i] = i;
            ++i;
        }
        i = 0;
        while (i < size) {
            WmiModel child = model.getChild(i);
            if (child != null) {
                j = viewOffset;
                while (j < oldLength) {
                    int index = viewIndex[j];
                    WmiView view = this.children[index];
                    if (view != null && view.getModel() == child && WmiArrayCompositeView.hasUniqueViewObserver(child, docView)) {
                        views[i] = view;
                        if (j != viewOffset) {
                            viewIndex[j] = viewIndex[viewOffset];
                            viewIndex[viewOffset] = index;
                        }
                        ++viewOffset;
                        break;
                    }
                    ++j;
                }
                if (child.isVisible()) {
                    if (views[i] == null && factory != null) {
                        views[i] = factory.createView(child, this);
                    }
                } else if (views[i] != null) {
                    views[i].release();
                    views[i] = null;
                }
            }
            ++i;
        }
        j = viewOffset;
        while (j < oldLength) {
            this.children[viewIndex[j]].release();
            ++j;
        }
        this.length = size;
        this.children = views;
    }

    protected WmiViewFactory getViewFactory() {
        WmiViewFactory factory = null;
        WmiMathDocumentView docView = this.getDocumentView();
        if (docView != null) {
            factory = docView.getViewFactory();
        }
        return factory;
    }

    @Override
    public void release() {
        this.release(true);
    }

    public void release(boolean recursive) {
        if (recursive && this.children != null) {
            int i = 0;
            while (i < this.length) {
                WmiView child = this.children[i];
                if (child != null) {
                    child.release();
                    this.children[i] = null;
                }
                ++i;
            }
        }
        this.children = null;
        this.length = 0;
        super.release();
    }

    @Override
    public boolean mergeFragmentsOnUpdate() {
        return false;
    }
}

