/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;

public class WmiCaret
implements WmiPositionMarker {
    private static final int TIMER_UNINITIALIZED = -1;
    private static final int DEFAULT_TIMER_DELAY = 600;
    private static int timerDelay = -1;
    protected WmiMathDocumentView docView;
    protected WmiScrollableContainerView container;
    private int left = 0;
    private int right = 0;
    private int top = 0;
    private int bottom = 0;
    private boolean visible = false;
    private boolean blinkOn = true;
    private WmiPositionedView caretView = null;
    private WmiModel caretModel = null;
    private int offset = 0;
    private long blinkTime = 0L;
    private static Timer timer = new Timer();

    public WmiCaret(WmiMathDocumentView view) {
        this.docView = view;
        this.container = this.docView;
        if (timerDelay == -1 && (timerDelay = UIManager.getInt("TextPane.caretBlinkRate")) == 0) {
            timerDelay = 600;
        }
    }

    public static void resetTimer() {
        timer = new Timer();
    }

    public static void cancelTimer() {
        timer.cancel();
    }

    protected void repaint() {
        if (this.container != null && this.bottom > 0) {
            Point cOffset = WmiViewUtil.offsetForContainer(this.container);
            Point borderOffset = this.container.getContainerOffset();
            int x = this.left + borderOffset.x;
            int y = this.top + cOffset.y + borderOffset.y;
            int width = this.right - this.left + 1;
            int height = this.bottom - this.top + 1;
            this.docView.repaint(x, y, width, height);
        }
    }

    public void updateCaretBounds(WmiScrollableContainerView view, int x1, int y1, int x2, int y2) {
        boolean wasVisible = this.visible;
        WmiScrollableContainerView wmiScrollableContainerView = this.container = view != null ? view : this.docView;
        if (wasVisible) {
            this.hide();
        }
        this.left = x1;
        this.right = x2;
        this.top = y1;
        this.bottom = y2;
        if (wasVisible) {
            this.show();
        }
    }

    protected void drawCaret(Graphics g) {
        Color saveColor = g.getColor();
        g.setColor(Color.BLACK);
        Point offset = WmiViewUtil.offsetForContainer(this.container);
        g.drawLine(this.getRight() + offset.x, this.getTop() + offset.y, this.getLeft() + offset.x, this.getBottom() + offset.y);
        g.setColor(saveColor);
    }

    protected int getBottom() {
        return this.bottom;
    }

    protected int getLeft() {
        return this.left;
    }

    protected int getRight() {
        return this.right;
    }

    protected int getTop() {
        return this.top;
    }

    public void updateView(WmiPositionedView view, int position) throws WmiNoReadAccessException {
        WmiScrollableContainerView container;
        WmiModel myModel;
        WmiModel originalModel = null;
        int originalOffset = this.offset;
        if (this.caretView != null) {
            originalModel = this.caretView.getModel();
        }
        this.caretView = view;
        WmiModel wmiModel = this.caretModel = view != null ? view.getModel() : null;
        if (position == -1) {
            position = view instanceof WmiCompositeView ? ((WmiCompositeView)((Object)view)).getChildCount() : (view instanceof WmiTraversableView ? ((WmiTraversableView)view).getTraversableCount() : 0);
        }
        this.offset = position;
        if (view != null && (myModel = view.getModel()) != null && (myModel != originalModel || this.offset != originalOffset)) {
            WmiMathDocumentModel doc = myModel.getDocument();
            while (myModel instanceof WmiCompositeModel) {
                WmiCompositeModel comp = (WmiCompositeModel)myModel;
                int size = comp.getChildCount();
                if (size <= 0) break;
                WmiModel wmiModel2 = myModel = this.offset == 0 ? comp.getChild(0) : comp.getChild(size - 1);
            }
            doc.getActiveEditAttributes().addAttributes(myModel.getAttributes());
        }
        if ((container = WmiViewUtil.findEnclosingContainer(this.caretView)) != null && this.docView != null) {
            this.docView.setActiveContainer(container);
        }
        this.docView.notifyMarkerPositionChanged();
    }

    @Override
    public Rectangle getBounds() {
        Point cOffset = WmiViewUtil.offsetForContainer(this.container);
        return new Rectangle(this.left + cOffset.x, this.top + cOffset.y, this.right - this.left, this.bottom - this.top);
    }

    @Override
    public WmiViewPath getViewPath() {
        WmiViewPath path = null;
        if (this.visible && this.caretView != null) {
            path = new WmiViewPath(this.caretView);
            if (this.offset > 0 && this.caretView instanceof WmiCompositeView) {
                path.push(-1);
            } else {
                path.push(this.offset);
            }
        }
        return path;
    }

    @Override
    public WmiModelPosition getModelPosition() {
        WmiModelPosition position = null;
        if (this.caretView != null && this.caretModel != null) {
            int modelOffset = this.offset;
            if (this.caretView instanceof WmiTextView) {
                modelOffset += ((WmiTextView)this.caretView).getStartOffset();
            }
            position = new WmiModelPosition(this.caretModel, modelOffset);
        }
        return position;
    }

    @Override
    public void hide() {
        this.blinkOn = false;
        this.visible = false;
        this.docView.setFocusedView(null);
        this.repaint();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void paint(Graphics g) {
        if (this.visible) {
            long time;
            if (this.blinkOn) {
                this.drawCaret(g);
            }
            if (this.blinkTime < (time = System.currentTimeMillis())) {
                this.blinkOn = !this.blinkOn;
                this.blinkTime = time + (long)timerDelay;
            }
            timer.schedule((TimerTask)new CaretRepainter(), timerDelay);
        }
    }

    @Override
    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.container, new Rectangle(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1));
    }

    @Override
    public void scrollToTop() {
        WmiDocumentScroller.scrollToTop(this.container, new Rectangle(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1));
    }

    @Override
    public void updateMarkerPosition(WmiModel model, int newOffset) throws WmiNoReadAccessException {
        WmiView view;
        this.offset = newOffset;
        if (model instanceof WmiTextModel) {
            int limit = ((WmiTextModel)model).getLength();
            if (newOffset < 0) {
                this.offset = limit;
            }
            while (this.offset > limit) {
                int index;
                WmiCompositeModel parent = model.getParent();
                int n = index = parent != null ? parent.indexOf(model) : -1;
                if (index >= 0 && index < parent.getChildCount() - 1) {
                    WmiModel sibling = parent.getChild(index + 1);
                    if (sibling instanceof WmiTextModel) {
                        this.offset -= limit;
                        model = sibling;
                        limit = ((WmiTextModel)model).getLength();
                        continue;
                    }
                    this.offset = limit;
                    continue;
                }
                this.offset = limit;
            }
        }
        if ((view = WmiViewUtil.modelToView(this.docView, model, this.offset)) instanceof WmiPositionedView) {
            if (view instanceof WmiTextView) {
                this.offset = this.offset >= 0 ? (this.offset -= ((WmiTextView)view).getStartOffset()) : ((WmiTextView)view).getLength();
            }
            ((WmiPositionedView)view).setPositionMarker(this.offset);
        } else {
            this.docView.setPositionMarker(null);
        }
    }

    @Override
    public void resync() throws WmiNoReadAccessException {
        if (this.caretView != null && this.caretModel != null) {
            int modelOffset = this.offset;
            if (this.caretView instanceof WmiTextView) {
                modelOffset += ((WmiTextView)this.caretView).getStartOffset();
            }
            this.updateMarkerPosition(this.caretModel, modelOffset);
        } else {
            this.caretView = null;
            this.caretModel = null;
        }
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        Object object = this.docView.getTreeLock();
        synchronized (object) {
            Timer timer = WmiCaret.timer;
            synchronized (timer) {
                this.blinkOn = true;
                this.visible = true;
                if (this.caretView != null) {
                    this.docView.setFocusedView(this.caretView);
                }
                this.repaint();
                this.blinkTime = System.currentTimeMillis() + (long)timerDelay;
                WmiCaret.timer.schedule((TimerTask)new CaretRepainter(), timerDelay);
            }
        }
    }

    @Override
    public WmiPositionedView getView() {
        return this.caretView;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean isReadOnly() throws WmiNoReadAccessException {
        boolean readonly = false;
        if (this.docView != null && this.caretModel != null) {
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)this.docView.getModel();
            readonly = !docModel.isMutableModel(this.caretModel);
        }
        return readonly;
    }

    public class CaretRepainter
    extends TimerTask {
        @Override
        public void run() {
            WmiCaret.this.repaint();
        }
    }
}

