/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizeDecorator;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class WmiEightPointResizer
extends WmiResizeDecorator {
    public static final int BORDER_THICKNESS = 0;
    public static final int HOTSPOT_DRAWING_SIZE = 5;
    public static final int HOTSPOT_GRAB_SIZE = 10;

    public WmiEightPointResizer(WmiMathDocumentView view) {
        super(view);
    }

    @Override
    protected int selectedHotspot(int x, int y, Rectangle bounds) {
        int hotspot = 0;
        int curWidth = bounds.width;
        int curHeight = bounds.height;
        if (x > 0 && y > 0 && x < curWidth && y < curHeight) {
            if (y < 10) {
                if (x < 10) {
                    hotspot = 1;
                } else if (x > curWidth - 10) {
                    hotspot = 3;
                } else if (x > curWidth / 2 - 5 && x < curWidth / 2 + 5) {
                    hotspot = 2;
                }
            } else if (y > curHeight - 10) {
                if (x < 10) {
                    hotspot = 6;
                } else if (x > curWidth - 10) {
                    hotspot = 8;
                } else if (x > curWidth / 2 - 5 && x < curWidth / 2 + 5) {
                    hotspot = 7;
                }
            } else if (y > curHeight / 2 - 5 && y < curHeight / 2 + 5) {
                if (x < 10) {
                    hotspot = 4;
                } else if (x > curWidth - 10) {
                    hotspot = 5;
                }
            }
        }
        return hotspot;
    }

    @Override
    public void drawBounds(Graphics g, int xPos, int yPos, int xSize, int ySize) {
        super.drawBounds(g, xPos, yPos, xSize, ySize);
        g.translate(xPos - 1, yPos - 1);
        g.fillRect(1, 1, 5, 5);
        g.fillRect(xSize / 2 - 2, 1, 5, 5);
        g.fillRect(xSize - 5, 1, 5, 5);
        g.fillRect(1, ySize / 2 - 2, 5, 5);
        g.fillRect(xSize - 5, ySize / 2 - 2, 5, 5);
        g.fillRect(1, ySize - 5, 5, 5);
        g.fillRect(xSize / 2 - 2, ySize - 5, 5, 5);
        g.fillRect(xSize - 5, ySize - 5, 5, 5);
        g.translate(-xPos + 1, -yPos + 1);
    }

    public static boolean isEventInResizeRegion(MouseEvent e) {
        Point p = e.getPoint();
        WmiPositionedView view = (WmiPositionedView)e.getSource();
        return p.x < 5 || p.y < 5 || p.x > view.getWidth() - 5 || p.y > view.getHeight() - 5;
    }
}

