/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.view.WmiAccessibleContext;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class WmiGenericView
implements WmiPositionedView,
WmiModelObserver {
    private WmiMathDocumentView docView = null;
    private WmiModel model;
    private WmiCompositeView parent;
    protected int height = 0;
    protected int width = 0;
    protected int x = 0;
    protected int y = 0;
    protected int baseline = 0;
    private int validated = 0;
    protected WmiPositionedView[] neighbors = null;
    protected WmiPositionedView[] locations = null;
    private WmiModelObserver nextObserver = null;

    public WmiGenericView(WmiModel model, WmiMathDocumentView docView) {
        this(model, docView, null);
    }

    public WmiGenericView(WmiModel model, WmiMathDocumentView docView, WmiCompositeView parent) {
        this.model = model;
        this.parent = parent;
        this.docView = docView;
        this.registerObserver();
    }

    @Override
    public WmiModel getModel() {
        return this.model;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public WmiCompositeView getParentView() {
        return this.parent;
    }

    @Override
    public void setParentView(WmiCompositeView parent) {
        this.parent = parent;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    @Override
    public void setHorizontalOffset(int x) {
        this.x = x;
    }

    @Override
    public void setVerticalOffset(int y) {
        this.y = y;
    }

    @Override
    public int getHorizontalOffset() {
        return this.x;
    }

    @Override
    public int getVerticalOffset() {
        return this.y;
    }

    @Override
    public boolean isLayoutValid() {
        return (this.validated & 1) != 0;
    }

    @Override
    public boolean isContentValid() {
        return (this.validated & 2) != 0;
    }

    @Override
    public void markValid(int flag) {
        this.validated |= flag;
    }

    @Override
    public void markInvalid(int flag) {
        this.validated &= ~flag;
    }

    @Override
    public void resetPaintFlags() {
        this.validated &= 0xFFFFFFF3;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
    }

    @Override
    public void invalidate(int flag) {
        this.validated &= ~flag;
        if ((flag & 1) != 0 && this.parent != null && this.parent.isLayoutValid()) {
            this.parent.invalidate(1);
        }
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        this.markValid(1);
        this.checkRepaint();
    }

    @Override
    public void paintDirty() {
        if ((this.validated & 0xC) != 0) {
            this.getDocumentView();
            Point pt = WmiViewUtil.getAbsoluteOffset(this);
            this.docView.repaint(pt.x - 1, pt.y - 1, this.width + 2, this.height + 2);
        }
        this.resetPaintFlags();
    }

    @Override
    public boolean getForceRepaint() {
        return (this.validated & 4) != 0;
    }

    @Override
    public boolean getCheckRepaint() {
        return (this.validated & 8) != 0;
    }

    @Override
    public void forceRepaint() {
        this.validated |= 4;
    }

    @Override
    public void checkRepaint() {
        this.validated |= 8;
    }

    @Override
    public void updateView() throws WmiNoReadAccessException {
        this.invalidate(1);
        this.markValid(2);
    }

    @Override
    public void release() {
        WmiViewFactory factory;
        WmiMathDocumentView doc = this.getDocumentView();
        if (doc != null && (factory = doc.getViewFactory()) != null) {
            factory.releaseView(this);
        }
        this.quickRelease();
    }

    public void quickRelease() {
        this.releaseObserver();
        this.model = null;
        this.parent = null;
        this.docView = null;
    }

    @Override
    public String debugPrint(int indent) throws WmiNoReadAccessException {
        StringBuffer sb = new StringBuffer();
        String name = this.getModel().getTag().toString();
        sb.append(this.createIndent(indent));
        sb.append("<");
        sb.append(name);
        sb.append(" x = ");
        sb.append(this.x);
        sb.append(" y = ");
        sb.append(this.y);
        sb.append(" width = ");
        sb.append(this.width);
        sb.append(" height = ");
        sb.append(this.height);
        sb.append("/>");
        return sb.toString();
    }

    @Override
    public String getDebugName() {
        WmiModelTag tag = null;
        tag = this.getModel().getTag();
        String name = tag != null ? tag.toString() : this.getClass().toString();
        return name;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return null;
    }

    protected AccessibleContext createAccessibleContext() {
        return new WmiAccessibleContext();
    }

    @Override
    public void setPositionMarker(int offset) {
    }

    @Override
    public WmiPositionedView getChildView(Point pt) {
        return null;
    }

    @Override
    public boolean getIntersectingChildViews(Shape shape, WmiAggregateSelection selection, int selectionOp) {
        return false;
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        return this.getNearestChildView(pt);
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return null;
    }

    @Override
    public WmiMathDocumentView getDocumentView() {
        if (this.docView == null) {
            this.docView = WmiViewUtil.getDocumentView(this);
        }
        return this.docView;
    }

    @Override
    public WmiView copyView() {
        WmiGenericView view = null;
        try {
            view = (WmiGenericView)this.clone();
            view.registerObserver();
        }
        catch (CloneNotSupportedException e) {
            WmiErrorLog.log(e);
        }
        return view;
    }

    @Override
    public int getZoomFactor() {
        int zoom = 133;
        WmiCompositeView parent = this.getParentView();
        if (parent instanceof WmiPositionedView) {
            zoom = ((WmiPositionedView)((Object)parent)).getZoomFactor();
        }
        return zoom;
    }

    protected void verifyReadLock() throws WmiNoReadAccessException {
        if (this.model == null || !WmiModelLock.hasLock(this.model, 0) && !WmiModelLock.ownsWriteLock(this.model)) {
            throw new WmiNoReadAccessException(this.model);
        }
    }

    protected void verifyUpdateLock() throws WmiNoUpdateAccessException {
        if (this.model == null || !WmiModelLock.hasLock(this.model, 2)) {
            throw new WmiNoUpdateAccessException(this.model);
        }
    }

    protected boolean hasUpdateLock() {
        return this.model != null && WmiModelLock.hasLock(this.model, 2);
    }

    protected String createIndent(int indent) {
        byte[] array = new byte[indent];
        Arrays.fill(array, (byte)32);
        return new String(array);
    }

    @Override
    public WmiPositionedView getNextView(int direction) {
        WmiPositionedView next = null;
        if (direction >= 0) {
            if (this.neighbors != null) {
                next = this.neighbors[direction];
            }
        } else if (this.locations != null) {
            int index = direction * -1 - 1;
            next = this.locations[index];
        }
        return next;
    }

    @Override
    public void setNextView(WmiPositionedView view, int direction) {
        WmiPositionedView nextView = view;
        if (nextView != null && !nextView.isNavagableView()) {
            nextView = null;
        }
        if (direction >= 0) {
            if (this.neighbors == null) {
                this.neighbors = new WmiPositionedView[4];
            }
            this.neighbors[direction] = nextView;
        } else {
            if (this.locations == null) {
                this.locations = new WmiPositionedView[4];
            }
            int index = direction * -1 - 1;
            this.locations[index] = nextView;
        }
    }

    @Override
    public void addNavigationLinks() {
    }

    @Override
    public boolean isNavagableView() {
        return true;
    }

    @Override
    public WmiModelObserver getNextObserver() {
        return this.nextObserver;
    }

    @Override
    public void setNextObserver(WmiModelObserver observer) {
        this.nextObserver = observer;
    }

    @Override
    public void registerObserver() {
        if (this.model != null) {
            this.model.addObserver(this);
        }
    }

    @Override
    public void releaseObserver() {
        if (this.model != null) {
            this.model.releaseObserver(this);
        }
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        WmiCompositeView composite = this.getParentView();
        int index = composite.indexOf(this);
        if (index >= 0) {
            success = 2;
            if (paragraph.isStartOfLine(this)) {
                paragraph.split(composite, index + 1, 0);
            } else {
                paragraph.split(composite, index, 0);
            }
        }
        return success;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public boolean hasGoodBreakpoint(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return false;
    }

    public static WmiPositionedView addBrackets(WmiPositionedView view) throws WmiNoReadAccessException {
        WmiGenericView fenced = null;
        WmiMathDocumentView docView = view.getDocumentView();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiModel fractionModel = view.getModel();
        WmiCompositeModel wrapper = WmiModelUtil.findAncestorOfTag(fractionModel, WmiModelTag.MATH);
        WmiAttributeSet set = wrapper != null ? wrapper.getAttributesForRead() : null;
        String styleName = set != null ? (String)set.getAttribute("font_style_name") : null;
        WmiMathContext context = new WmiMathContext(docModel.getFontStyle(styleName));
        try {
            WmiModel[] kids = new WmiModel[]{};
            WmiMathFencedModel model = new WmiMathFencedModel(docModel, kids, context);
            fenced = new WmiFencedView(model, view.getDocumentView());
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        WmiCompositeView parent = view.getParentView();
        int index = parent.indexOf(view);
        if (fenced != null && index >= 0) {
            ((WmiArrayCompositeView)fenced).appendView(view);
            parent.replaceChild(fenced, index);
            fenced.setParentView(parent);
        }
        fenced.releaseObserver();
        ((WmiFencedView)fenced).layoutView();
        return fenced != null ? fenced : view;
    }

    public static boolean areBracketsRequired(WmiModel model) throws WmiNoReadAccessException {
        boolean required = false;
        if (model instanceof WmiCompositeModel && model.getTag() == WmiModelTag.MATH_ROW) {
            int count = ((WmiCompositeModel)model).getChildCount();
            if (count == 1) {
                required = WmiGenericView.areBracketsRequired(((WmiCompositeModel)model).getChild(0));
            } else if (count > 1) {
                required = true;
            }
        }
        return required;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.parent.setCursor(cursor);
    }

    @Override
    public int getHeightConstraint() {
        int heightConstraint = -1;
        if (this.parent instanceof WmiPositionedView) {
            heightConstraint = ((WmiPositionedView)((Object)this.parent)).getHeightConstraint();
        }
        return heightConstraint;
    }

    @Override
    public int getWidthConstraint(boolean ignoreTopLevelView) {
        int widthConstraint = -1;
        if (this.parent instanceof WmiPositionedView) {
            widthConstraint = ((WmiPositionedView)((Object)this.parent)).getWidthConstraint(ignoreTopLevelView);
        }
        return widthConstraint;
    }

    protected class WmiAccessibleGenericView
    extends AccessibleContext
    implements AccessibleComponent {
        protected Boolean viewIsPhysical = null;

        public WmiAccessibleGenericView() {
            this(null);
        }

        public WmiAccessibleGenericView(String name, String description) {
            this(name);
            if (description != null) {
                this.setAccessibleDescription(description);
            }
        }

        public WmiAccessibleGenericView(String name) {
            WmiModelTag tag;
            WmiModel accModel;
            if (name == null && (accModel = WmiGenericView.this.getModel()) != null && (tag = accModel.getTag()) != null) {
                name = tag.getName();
            }
            this.setAccessibleName(name);
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public int getAccessibleIndexInParent() {
            int index = -1;
            Accessible accParent = this.getAccessibleParent();
            if (accParent != null) {
                AccessibleContext parentContext = accParent.getAccessibleContext();
                int children = parentContext.getAccessibleChildrenCount();
                int i = 0;
                while (i < children && index < 0) {
                    if (parentContext.getAccessibleChild(i).getAccessibleContext() == this) {
                        index = i;
                    }
                    ++i;
                }
            }
            return index;
        }

        @Override
        public Accessible getAccessibleParent() {
            return WmiGenericView.this.getParentView();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            WmiCaret caret;
            AccessibleStateSet set = new AccessibleStateSet();
            set.add(AccessibleState.VISIBLE);
            set.add(AccessibleState.FOCUSABLE);
            set.add(AccessibleState.TRANSIENT);
            WmiModel viewModel = WmiGenericView.this.getModel();
            if (WmiGenericView.this.docView != null && (caret = WmiGenericView.this.docView.getCaret()) != null && WmiGenericView.this == caret.getView()) {
                set.add(AccessibleState.FOCUSED);
            }
            if (viewModel != null) {
                WmiMathDocumentModel docModel = viewModel.getDocument();
                boolean locked = WmiModelLock.readLock(docModel, true);
                try {
                    try {
                        if (docModel.isMutableModel(viewModel)) {
                            set.add(AccessibleState.EDITABLE);
                        }
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        if (locked) {
                            WmiModelLock.readUnlock(docModel);
                        }
                    }
                }
                finally {
                    if (locked) {
                        WmiModelLock.readUnlock(docModel);
                    }
                }
            }
            return set;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }

        @Override
        public void addFocusListener(FocusListener l) {
        }

        @Override
        public boolean contains(Point p) {
            boolean result = false;
            Rectangle bounds = this.getBounds();
            if (p != null && bounds != null) {
                result = bounds.contains(p);
            }
            return result;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            WmiMathDocumentView view = WmiGenericView.this.getDocumentView();
            WmiPositionedView child = view.getNearestChildView(p);
            return child;
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public Rectangle getBounds() {
            return WmiGenericView.this.getBounds();
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public Font getFont() {
            return null;
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        @Override
        public Color getForeground() {
            return null;
        }

        @Override
        public Point getLocation() {
            return new Point(WmiGenericView.this.getHorizontalOffset(), WmiGenericView.this.getVerticalOffset());
        }

        @Override
        public Point getLocationOnScreen() {
            WmiMathDocumentView currentDocView = WmiGenericView.this.getDocumentView();
            Point p = currentDocView.getLocationOnScreen();
            Point offset = WmiViewUtil.getAbsoluteOffset(WmiGenericView.this);
            p.translate((int)offset.getX(), (int)offset.getY());
            return p;
        }

        @Override
        public Dimension getSize() {
            return WmiGenericView.this.getSize();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void removeFocusListener(FocusListener l) {
            System.err.println("Attempt to remove focus listener to view " + this.getAccessibleName());
        }

        @Override
        public void requestFocus() {
            System.err.println("Attempt to request focus on view " + this.getAccessibleName());
        }

        @Override
        public void setBackground(Color c) {
        }

        @Override
        public void setBounds(Rectangle r) {
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void setFont(Font f) {
        }

        @Override
        public void setForeground(Color c) {
        }

        @Override
        public void setLocation(Point p) {
        }

        @Override
        public void setSize(Dimension d) {
        }

        @Override
        public void setVisible(boolean b) {
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public boolean isPhysicalView() {
            if (this.viewIsPhysical == null) {
                WmiRowView physical;
                boolean isPhysicalView = true;
                WmiSwitchableCompositeView switchView = (WmiSwitchableCompositeView)WmiViewUtil.findAncestorOfClass(WmiGenericView.this, WmiSwitchableCompositeView.class);
                if (switchView != null && (physical = switchView.getRootPhysicalView()) != null) {
                    isPhysicalView = WmiViewUtil.isViewAncestorOfView(physical, WmiGenericView.this);
                }
                this.viewIsPhysical = isPhysicalView;
            }
            return this.viewIsPhysical;
        }
    }
}

