/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.renderers.WmiIntegralRenderer;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiInlineView
extends WmiArrayCompositeView
implements WmiPositionedView,
WmiAdjustableTextBounds {
    public static final int LEFT_INDENT = 0;
    public static final int RIGHT_INDENT = 1;
    public static final int TOP_INDENT = 2;
    public static final int BOTTOM_INDENT = 3;
    private static final int PAD_DIRECTIONS = 4;
    private int[] insets = null;
    private boolean useMathRules = false;
    private boolean resizeStretchyOps = false;
    private int childShift = 0;
    private int baselineAdjust = 0;
    private boolean containsBreakHints = false;
    private boolean elideOnBreak = false;

    public WmiInlineView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        path.push(this.x - this.childShift, this.y);
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiPositionedView child = (WmiPositionedView)this.getChild(i);
            if (child != null) {
                child.draw(g, path, bounds);
            }
            path.next();
            ++i;
        }
        path.pop();
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (this.useMathRules) {
            this.layoutViewForMath();
        } else {
            this.layoutViewForText();
        }
    }

    public void setBaselineAdjustment(int adjust) {
        this.baselineAdjust = adjust;
    }

    public void updateLayout(boolean rightFragment) {
        int size = this.getChildCount();
        this.childShift = 0;
        WmiPositionedView startView = null;
        WmiPositionedView endView = null;
        if (size > 0) {
            startView = (WmiPositionedView)this.getChild(0);
            endView = (WmiPositionedView)this.getChild(size - 1);
            this.childShift = startView.getHorizontalOffset() - this.getPadding(0);
            this.width = endView.getHorizontalOffset() + endView.getWidth() - this.childShift;
        } else {
            this.width = 0;
        }
        if (startView != null) {
            startView.setNextView(null, 2);
            this.setNextView(startView, -4);
        }
        if (endView != null) {
            endView.setNextView(null, 3);
            this.setNextView(endView, -3);
        }
        this.markValid(1);
    }

    public void removeChildShift() {
        this.childShift -= this.getChildShiftAdjustment();
        if (this.childShift != 0) {
            int size = this.getChildCount();
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)this.getChild(i);
                child.setHorizontalOffset(child.getHorizontalOffset() - this.childShift);
                ++i;
            }
            this.childShift = 0;
        }
    }

    protected int getChildShiftAdjustment() {
        return 0;
    }

    @Override
    public WmiView splitView(int offset, int consume) {
        WmiInlineView fragment = (WmiInlineView)super.splitView(offset, consume);
        this.updateLayout(true);
        fragment.updateLayout(false);
        return fragment;
    }

    @Override
    public void addNavigationLinks() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size - 1) {
            WmiPositionedView base = (WmiPositionedView)this.getChild(i);
            if (base.isNavagableView()) {
                int j = i + 1;
                WmiPositionedView next = (WmiPositionedView)this.getChild(j);
                while (next == null || !next.isNavagableView()) {
                    if (++j < size) {
                        next = (WmiPositionedView)this.getChild(j);
                        continue;
                    }
                    next = null;
                    break;
                }
                base.setNextView(next, 3);
                if (next != null) {
                    next.setNextView(base, 2);
                }
            }
            ++i;
        }
        if (size > 0) {
            ((WmiPositionedView)this.getChild(0)).setNextView(null, 2);
            ((WmiPositionedView)this.getChild(size - 1)).setNextView(null, 3);
        }
        boolean startFound = false;
        WmiPositionedView startView = null;
        WmiPositionedView endView = null;
        int i2 = 0;
        while (i2 < size) {
            WmiPositionedView view = (WmiPositionedView)this.getChild(i2);
            if (view.isNavagableView()) {
                if (!startFound) {
                    startView = view;
                    startFound = true;
                }
                endView = view;
            }
            ++i2;
        }
        if (startView != null) {
            startView.setNextView(null, 2);
            this.setNextView(startView, -4);
        }
        if (endView != null) {
            endView.setNextView(null, 3);
            this.setNextView(endView, -3);
        }
    }

    @Override
    public void setPositionMarker(int offset) {
        try {
            if (offset == 0) {
                WmiView firstChild = this.getChild(0);
                if (firstChild != null && firstChild instanceof WmiTraversableView) {
                    ((WmiTraversableView)firstChild).setPositionMarker(0);
                } else {
                    WmiTextView view = (WmiTextView)WmiViewUtil.findFirstDescendantOfClass(this, WmiTextView.class);
                    if (view != null) {
                        view.setPositionMarker(0);
                    }
                }
            } else {
                WmiView lastChild = this.getChild(this.getChildCount() - 1);
                if (lastChild != null && lastChild instanceof WmiTraversableView) {
                    ((WmiTraversableView)lastChild).setPositionMarker(-1);
                } else {
                    WmiTextView view = (WmiTextView)WmiViewUtil.findLastDescendantOfClass(this, WmiTextView.class);
                    if (view != null) {
                        int length = view.getLength();
                        view.setPositionMarker(length);
                    }
                }
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    public void setPadding(int padding, int direction) {
        if (this.insets == null) {
            this.insets = new int[4];
        }
        if (direction >= 0 && direction < 4) {
            this.insets[direction] = padding;
        }
    }

    public int getPadding(int direction) {
        int padding = 0;
        if (this.insets != null && direction >= 0 && direction < 4) {
            padding = this.insets[direction];
        }
        return padding;
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, 2);
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            view = this.getNearestChildView(pt);
        }
        if (view == null || !view.isNavagableView()) {
            int direction = location * -1 - 1;
            view = this.getNextView(direction);
        }
        return view;
    }

    public void layoutViewForText() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiPositionedView child;
            this.childShift = 0;
            this.width = this.getPadding(0);
            this.height = 0;
            this.baseline = 0;
            int descent = 0;
            int maxDescent = 0;
            this.addNavigationLinks();
            int size = this.getChildCount();
            int i = 0;
            while (i < size) {
                WmiPositionedView child2 = (WmiPositionedView)this.getChild(i);
                if (child2 != null) {
                    child2.layoutView();
                }
                ++i;
            }
            boolean preKern = false;
            i = 0;
            while (i < size) {
                WmiPositionedView next;
                child = (WmiPositionedView)this.getChild(i);
                WmiPositionedView wmiPositionedView = next = i < size - 1 ? (WmiPositionedView)this.getChild(i + 1) : null;
                if (child != null) {
                    if (child instanceof WmiTextView) {
                        WmiTextView textChild = (WmiTextView)child;
                        if (next instanceof WmiTextView) {
                            WmiTextView first = textChild;
                            WmiTextView second = (WmiTextView)next;
                            if (first.getAdjustedBaseline() > second.getAdjustedBaseline()) {
                                first.applyKerningAdjustment(preKern, true);
                                preKern = true;
                            } else {
                                first.applyKerningAdjustment(preKern, false);
                                preKern = false;
                            }
                        } else {
                            textChild.applyKerningAdjustment(preKern, true);
                            preKern = true;
                        }
                        WmiTextLayout layout = textChild.getLayout();
                        if (layout != null && layout.containsTabs()) {
                            layout.setHorizontalOffset(this.width);
                        }
                    }
                    int childWidth = child.getWidth();
                    int childHeight = child.getHeight();
                    int childBaseline = child.getBaseline();
                    if (this.shouldConstrainChildPrintSize(child)) {
                        float ratio = ((WmiResizableContainerView)child).getConstrainedSizeRatio();
                        childWidth = (int)((float)childWidth * ratio);
                        childHeight = (int)((float)childHeight * ratio);
                        childBaseline = (int)((float)childBaseline * ratio);
                    }
                    descent = childHeight - childBaseline;
                    if (childBaseline > this.baseline) {
                        this.baseline = childBaseline;
                    }
                    if (descent > maxDescent) {
                        maxDescent = descent;
                    }
                    child.setHorizontalOffset(this.width);
                    this.width += childWidth;
                }
                ++i;
            }
            this.baseline += this.baselineAdjust + this.getPadding(2);
            this.height = this.baseline + maxDescent + this.getPadding(3);
            i = 0;
            while (i < size) {
                child = (WmiPositionedView)this.getChild(i);
                if (child != null) {
                    int childBaseline = child.getBaseline();
                    if (this.shouldConstrainChildPrintSize(child)) {
                        float ratio = ((WmiResizableContainerView)child).getConstrainedSizeRatio();
                        childBaseline = (int)((float)childBaseline * ratio);
                    }
                    child.setVerticalOffset(this.baseline - this.baselineAdjust - childBaseline);
                }
                ++i;
            }
            this.width += this.getPadding(1);
            super.layoutView();
        }
    }

    private boolean shouldConstrainChildPrintSize(WmiPositionedView child) {
        boolean constrain = false;
        if (this.getDocumentView().isPrintView() && child instanceof WmiResizableContainerView) {
            WmiResizableContainerView rc = (WmiResizableContainerView)child;
            constrain = rc.shouldConstrainPrintSize();
        }
        return constrain;
    }

    public void layoutViewForMath() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.childShift = 0;
            if (this.resizeStretchyOps) {
                int size = this.getChildCount();
                int i = 0;
                while (i < size) {
                    WmiView child = this.getChild(i);
                    if (child instanceof WmiMathOperatorView) {
                        ((WmiMathOperatorView)child).resetStretchy();
                    } else if (!this.containsBreakHints && child instanceof WmiMathSpaceView) {
                        this.containsBreakHints = WmiMathSpaceView.isCandidateExplicitBreakSpace((WmiMathSpaceView)child);
                    }
                    ++i;
                }
                this.validateChildren();
                this.addNavigationLinks();
                this.layoutMathRow();
                boolean applyStretchy = false;
                i = 0;
                while (i < size) {
                    WmiView candidateOperator;
                    WmiView child = this.getChild(i);
                    if (child instanceof WmiMathOperatorView) {
                        WmiMathOperatorView operator = (WmiMathOperatorView)child;
                        if (operator.layoutStretchView(this.height)) {
                            applyStretchy = true;
                            operator.setBaseline(this.getBaseline());
                        }
                    } else {
                        WmiModelTag tag;
                        WmiModel childModel = child.getModel();
                        WmiModelTag wmiModelTag = tag = childModel != null ? childModel.getTag() : null;
                        if (tag == WmiModelTag.MATH_SUB_SUP || tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT) {
                            int height;
                            WmiMathOperatorView operator;
                            WmiModelTag grandChildTag;
                            WmiView grandChild = ((WmiCompositeView)child).getChild(0);
                            WmiModel grandChildModel = grandChild != null ? grandChild.getModel() : null;
                            WmiModelTag wmiModelTag2 = grandChildTag = grandChildModel != null ? grandChildModel.getTag() : null;
                            if (grandChildTag == WmiModelTag.MATH_STYLE && ((WmiCompositeView)grandChild).getChildCount() == 1) {
                                grandChild = ((WmiCompositeView)grandChild).getChild(0);
                            }
                            if (grandChild instanceof WmiMathOperatorView && (operator = (WmiMathOperatorView)grandChild).layoutStretchView(height = operator.getHeight())) {
                                applyStretchy = true;
                                operator.setBaseline(this.getBaseline());
                                if (operator.getHeight() != height) {
                                    ((WmiGenericView)child).markInvalid(1);
                                    if (operator.getParentView() != child) {
                                        ((WmiGenericView)((Object)operator.getParentView())).markInvalid(1);
                                    }
                                    ((WmiPositionedView)child).layoutView();
                                }
                            }
                        }
                    }
                    if (child instanceof WmiInlineView && (candidateOperator = WmiViewUtil.findFirstDescendantOfTag(child, WmiModelTag.MATH_OPERATOR)) instanceof WmiMathOperatorView) {
                        WmiMathOperatorView opView = (WmiMathOperatorView)candidateOperator;
                        boolean mstyleOnly = true;
                        WmiCompositeView parent = opView.getParentView();
                        while (parent != this) {
                            if (!(parent instanceof WmiInlineView) || !(parent.getModel() instanceof WmiMathStyleModel)) {
                                mstyleOnly = false;
                                break;
                            }
                            parent = parent.getParentView();
                        }
                        if (mstyleOnly) {
                            if (opView.layoutStretchView(this.height)) {
                                applyStretchy = true;
                                opView.setBaseline(this.getBaseline());
                            }
                            parent = opView.getParentView();
                            while (parent != this) {
                                if (parent instanceof WmiInlineView) {
                                    WmiInlineView inline = (WmiInlineView)parent;
                                    inline.setWidth(opView.getWidth());
                                    inline.setHeight(opView.getHeight());
                                    inline.setBaseline(opView.getBaseline());
                                }
                                parent = parent.getParentView();
                            }
                        }
                    }
                    ++i;
                }
                if (applyStretchy) {
                    this.layoutMathRow();
                }
            } else {
                this.layoutMathRow();
            }
            if (this.height == 0) {
                WmiMathTextView.setDefaultHeight(this);
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    public void layoutMathRow() throws WmiNoReadAccessException {
        WmiPositionedView child;
        WmiModelTag parentTag;
        this.width = this.getPadding(0);
        this.height = 0;
        this.baseline = 0;
        int descent = 0;
        int maxDescent = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiPositionedView child2 = (WmiPositionedView)this.getChild(i);
            if (child2 != null) {
                child2.layoutView();
            }
            ++i;
        }
        boolean forcePreKernAdjustment = false;
        boolean forcePostKernAdjustment = false;
        int pendingPostKern = 0;
        WmiModel model = this.getModel();
        WmiCompositeModel parentModel = model != null ? model.getParent() : null;
        WmiModelTag wmiModelTag = parentTag = parentModel != null ? parentModel.getTag() : null;
        if (parentTag == WmiModelTag.MATH_FENCED) {
            forcePreKernAdjustment = true;
        }
        i = 0;
        while (i < size) {
            child = (WmiPositionedView)this.getChild(i);
            if (child != null && child.isLayoutValid()) {
                int childWidth = child.getWidth();
                if (child instanceof WmiMathOperatorView) {
                    if (childWidth > 0) {
                        WmiMathOperatorView op = (WmiMathOperatorView)child;
                        forcePreKernAdjustment = op.forcePreKernAdjustment();
                        forcePostKernAdjustment = op.forcePostKernAdjustment();
                        if (forcePostKernAdjustment && pendingPostKern > 0) {
                            this.width += pendingPostKern;
                            pendingPostKern = 0;
                        }
                    }
                } else if (child instanceof WmiFencedView) {
                    forcePreKernAdjustment = true;
                    forcePostKernAdjustment = true;
                    if (pendingPostKern > 0) {
                        this.width += pendingPostKern;
                        pendingPostKern = 0;
                    }
                } else if (childWidth > 0 && forcePreKernAdjustment && child instanceof WmiAdjustableTextBounds) {
                    this.width += ((WmiAdjustableTextBounds)((Object)child)).computePreKernAdjustment();
                    forcePostKernAdjustment = false;
                    forcePreKernAdjustment = false;
                }
                descent = child.getHeight() - child.getBaseline();
                if (child.getBaseline() > this.baseline) {
                    this.baseline = child.getBaseline();
                }
                if (descent > maxDescent) {
                    maxDescent = descent;
                }
                child.setHorizontalOffset(this.width);
                this.width += childWidth;
                if (childWidth > 0 && child instanceof WmiAdjustableTextBounds) {
                    pendingPostKern = ((WmiAdjustableTextBounds)((Object)child)).computePostKernAdjustment();
                }
            }
            ++i;
        }
        if (parentTag == WmiModelTag.MATH_FENCED) {
            this.width += pendingPostKern;
        }
        this.baseline += this.baselineAdjust + this.getPadding(2);
        this.height = this.baseline + maxDescent + this.getPadding(3);
        i = 0;
        while (i < size) {
            child = (WmiPositionedView)this.getChild(i);
            if (child != null) {
                child.setVerticalOffset(this.baseline - child.getBaseline());
            }
            ++i;
        }
        this.width += this.getPadding(1);
    }

    public void applyMathRules(boolean state) {
        this.useMathRules = state;
    }

    public void lockOperatorSize(boolean state) {
        this.resizeStretchyOps = !state;
    }

    @Override
    public void invalidate(int flag) {
        super.invalidate(flag);
        if (this.useMathRules && flag == 1 && this.resizeStretchyOps && this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                WmiView child = this.children[i];
                if (child instanceof WmiMathOperatorView) {
                    child.invalidate(flag);
                }
                ++i;
            }
        }
    }

    @Override
    public int computePreKernAdjustment() {
        int adjustment = 0;
        int size = this.getChildCount();
        if (size > 0) {
            int base = 0;
            WmiPositionedView candidate = (WmiPositionedView)this.getChild(0);
            if (candidate.getWidth() == 0 && size > 1) {
                base = 1;
            }
            adjustment = WmiTextAdjustmentUtils.computePreKernAdjustment(this, base);
        }
        return adjustment;
    }

    @Override
    public int computePostKernAdjustment() {
        int adjustment = 0;
        int size = this.getChildCount();
        if (size > 0) {
            int base = size - 1;
            WmiPositionedView candidate = (WmiPositionedView)this.getChild(base);
            if (candidate.getWidth() == 0 && base > 0) {
                --base;
            }
            adjustment = WmiTextAdjustmentUtils.computePostKernAdjustment(this, base);
        }
        return adjustment;
    }

    @Override
    public int computeSpaceAbove() {
        int size = this.getChildCount();
        int minBase = this.getHeight();
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView) {
                WmiPositionedView pos = (WmiPositionedView)child;
                int top = pos.getVerticalOffset();
                if (child instanceof WmiAdjustableTextBounds) {
                    top += ((WmiAdjustableTextBounds)((Object)child)).computeSpaceAbove();
                }
                if (top < minBase) {
                    minBase = top;
                }
            }
            ++i;
        }
        return minBase;
    }

    @Override
    public int computeSpaceBelow() {
        int size = this.getChildCount();
        int maxBase = 0;
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiPositionedView) {
                WmiPositionedView pos = (WmiPositionedView)child;
                int childHeight = pos.getHeight();
                if (this.shouldConstrainChildPrintSize(pos)) {
                    float ratio = ((WmiResizableContainerView)pos).getConstrainedSizeRatio();
                    childHeight = (int)((float)childHeight * ratio);
                }
                int bottom = pos.getVerticalOffset() + childHeight;
                if (child instanceof WmiAdjustableTextBounds) {
                    bottom -= ((WmiAdjustableTextBounds)((Object)child)).computeSpaceBelow();
                }
                if (bottom > maxBase) {
                    maxBase = bottom;
                }
            }
            ++i;
        }
        return this.getHeight() - maxBase;
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) throws WmiNoReadAccessException {
        int success = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiPositionedView child = (WmiPositionedView)this.getChild(i);
            success = child.doExplicitLinebreak(paragraph);
            if (success != 0) break;
            ++i;
        }
        return success;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        WmiPositionedView next;
        int childOffset;
        int success = 0;
        int childIndex = this.findSpanningView(horizontalOffset, breakWidth);
        if (childIndex >= 0 && (childOffset = (next = (WmiPositionedView)this.getChild(childIndex)).getHorizontalOffset() - this.childShift) >= 0) {
            success = next.doForcedLinebreak(paragraph, horizontalOffset + childOffset, breakWidth);
        }
        return success;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int childIndex;
        WmiParagraphView.WmiParagraphInlineView inline;
        int success = 0;
        WmiModel model = this.getModel();
        if (model != null && this.getChildCount() > 0 && model.getTag() == WmiModelTag.MATH && (inline = (WmiParagraphView.WmiParagraphInlineView)WmiViewUtil.findAncestorOfClass(this, WmiParagraphView.WmiParagraphInlineView.class)) != null && !inline.isMathMode()) {
            WmiCompositeView parent = this.getParentView();
            int index = parent != null ? parent.indexOf(this) : -1;
            WmiView centralFragment = null;
            if (index >= 0 && this.getWidth() > breakWidth) {
                paragraph.split(parent, index + 1, 0);
            }
            int n = index = (parent = this.getParentView()) != null ? parent.indexOf(this) : -1;
            if (index >= 0) {
                centralFragment = paragraph.split(parent, index, 0);
            }
            if (centralFragment instanceof WmiParagraphView.WmiParagraphInlineView) {
                ((WmiParagraphView.WmiParagraphInlineView)centralFragment).setMathMode();
            }
            success = 2;
        }
        if (success == 0 && this.containsBreakHints && WmiMathSpaceView.breakAtAllNewlines(paragraph, this, breakWidth)) {
            success = 1;
        }
        if (success == 0 && (childIndex = this.findSpanningView(horizontalOffset, breakWidth)) >= 0) {
            WmiPositionedView next = (WmiPositionedView)this.getChild(childIndex);
            int childOffset = next.getHorizontalOffset() - this.childShift;
            success = next.doImplicitLinebreak(paragraph, horizontalOffset + childOffset, breakWidth, thresholdCost);
            while (success == 0 && childIndex > 0) {
                success = this.breakAtDelimiter(paragraph, childIndex);
                if (success != 0) continue;
                next = (WmiPositionedView)this.getChild(--childIndex);
                childOffset = next.getHorizontalOffset() - this.childShift;
                success = next.doImplicitLinebreak(paragraph, horizontalOffset + childOffset, breakWidth, thresholdCost);
            }
        }
        return success;
    }

    protected int breakAtDelimiter(WmiParagraphView paragraph, int index) throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public boolean hasGoodBreakpoint(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        boolean success = false;
        int childIndex = this.findSpanningView(horizontalOffset, breakWidth);
        if (childIndex >= 0) {
            WmiPositionedView next = (WmiPositionedView)this.getChild(childIndex);
            int childOffset = next.getHorizontalOffset() - this.childShift;
            success = next.hasGoodBreakpoint(horizontalOffset + childOffset, breakWidth, thresholdCost);
            while (!success && childIndex > 0) {
                next = (WmiPositionedView)this.getChild(--childIndex);
                childOffset = next.getHorizontalOffset();
                success = next.hasGoodBreakpoint(horizontalOffset + childOffset, breakWidth, thresholdCost);
            }
        }
        return success;
    }

    protected int findSpanningView(int offset, int breakWidth) {
        int size = this.getChildCount();
        int index = -1;
        if ((offset -= this.childShift) < breakWidth) {
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)this.getChild(i);
                if (child.getHorizontalOffset() + offset > breakWidth) {
                    index = i - 1;
                    break;
                }
                if (child.getHorizontalOffset() + child.getWidth() + offset > breakWidth) {
                    index = i;
                    break;
                }
                if (i == size - 1) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    public void centerInline(int breakWidth) {
        WmiView child;
        int actualWidth = 0;
        int size = this.getChildCount();
        if (size > 0 && (child = this.getChild(size - 1)) instanceof WmiPositionedView) {
            WmiPositionedView lastKid = (WmiPositionedView)child;
            actualWidth = lastKid.getHorizontalOffset() + lastKid.getWidth() - this.childShift;
        }
        if (actualWidth < breakWidth) {
            this.childShift -= (breakWidth - actualWidth) / 2;
        }
    }

    public void adjustVerticalLayout() throws WmiNoReadAccessException {
        WmiPositionedView child;
        if (this.usesIntegralRenderers()) {
            return;
        }
        this.height = 0;
        this.baseline = 0;
        int descent = 0;
        int maxDescent = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            child = (WmiPositionedView)this.getChild(i);
            int childHeight = child.getHeight();
            int childBaseline = child.getBaseline();
            if (this.shouldConstrainChildPrintSize(child)) {
                float ratio = ((WmiResizableContainerView)child).getConstrainedSizeRatio();
                childHeight = (int)((float)childHeight * ratio);
                childBaseline = (int)((float)childBaseline * ratio);
            }
            descent = childHeight - childBaseline;
            if (childBaseline > this.baseline) {
                this.baseline = childBaseline;
            }
            if (descent > maxDescent) {
                maxDescent = descent;
            }
            ++i;
        }
        this.baseline += this.baselineAdjust + this.getPadding(2);
        this.height = this.baseline + maxDescent + this.getPadding(3);
        i = 0;
        while (i < size) {
            child = (WmiPositionedView)this.getChild(i);
            if (child != null) {
                int childBaseline = child.getBaseline();
                if (this.shouldConstrainChildPrintSize(child)) {
                    float ratio = ((WmiResizableContainerView)child).getConstrainedSizeRatio();
                    childBaseline = (int)((float)childBaseline * ratio);
                }
                child.setVerticalOffset(this.baseline - this.baselineAdjust - childBaseline);
            }
            ++i;
        }
    }

    private boolean usesIntegralRenderers() throws WmiNoReadAccessException {
        boolean fullLayout = false;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiMathOperatorView) {
                WmiMathOperatorView operator = (WmiMathOperatorView)child;
                if (operator.getRenderer() instanceof WmiIntegralRenderer) {
                    fullLayout = true;
                    break;
                }
            } else {
                WmiModelTag tag;
                WmiModel childModel = child.getModel();
                WmiModelTag wmiModelTag = tag = childModel != null ? childModel.getTag() : null;
                if (tag == WmiModelTag.MATH_SUB_SUP || tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT) {
                    WmiMathOperatorView operator;
                    WmiModelTag grandChildTag;
                    WmiView grandChild = ((WmiCompositeView)child).getChild(0);
                    WmiModel grandChildModel = grandChild != null ? grandChild.getModel() : null;
                    WmiModelTag wmiModelTag2 = grandChildTag = grandChildModel != null ? grandChildModel.getTag() : null;
                    if (grandChildTag == WmiModelTag.MATH_STYLE && ((WmiCompositeView)grandChild).getChildCount() == 1) {
                        grandChild = ((WmiCompositeView)grandChild).getChild(0);
                    }
                    if (grandChild instanceof WmiMathOperatorView && (operator = (WmiMathOperatorView)grandChild).getRenderer() instanceof WmiIntegralRenderer) {
                        fullLayout = true;
                        break;
                    }
                }
            }
            ++i;
        }
        return fullLayout;
    }
}

