/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class WmiPathHighlighter {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    private Rectangle top;
    private Rectangle bottom;
    private Rectangle fill;
    private WmiMathDocumentView docView;
    private Rectangle dirtyRegion;

    public WmiPathHighlighter(WmiMathDocumentView docView, WmiViewPathInterval interval) {
        this(docView, interval, null);
    }

    public WmiPathHighlighter(WmiMathDocumentView docView, WmiViewPathInterval interval, WmiPathHighlighter oldHighlighter) {
        this.docView = docView;
        WmiViewPath start = interval.getSelectionStartPath();
        WmiViewPath end = interval.getSelectionEndPath();
        int[] depthref = new int[1];
        WmiCompositeView parent = this.findSelectionParent(start, end, depthref);
        int depth = depthref[0];
        WmiInlineView startInline = this.findInline(parent, start, depth, 0);
        WmiInlineView endInline = this.findInline(parent, end, depth, 1);
        if (startInline != null && endInline != null) {
            int startOffset = this.findHorizontalOffset(parent, start, depth, 0);
            int endOffset = this.findHorizontalOffset(parent, end, depth, 1);
            Point pt = WmiViewUtil.getAbsoluteOffset(startInline);
            Point parentPosition = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
            int left = parentPosition.x;
            int fullWidth = ((WmiPositionedView)((Object)parent)).getWidth();
            int topWidth = endInline == startInline ? endOffset - startOffset : fullWidth - (startOffset - left);
            int bottomWidth = endInline == startInline ? 0 : endOffset - left;
            this.top = new Rectangle(startOffset, pt.y, topWidth, startInline.getHeight());
            if (endInline != startInline) {
                pt = WmiViewUtil.getAbsoluteOffset(endInline);
                this.bottom = new Rectangle(left, pt.y, bottomWidth, endInline.getHeight());
                if (this.bottom.y > this.top.y + this.top.height) {
                    this.fill = new Rectangle(left, this.top.y + this.top.height, fullWidth, this.bottom.y - (this.top.y + this.top.height));
                }
            }
        }
        this.computeDirtyRegions(oldHighlighter);
    }

    public void paint(Graphics g) {
        Color saveColor = g.getColor();
        Color background = this.getHighlightColor();
        g.setColor(background);
        if (this.top != null) {
            g.fillRect(this.top.x, this.top.y, this.top.width, this.top.height);
        }
        if (this.fill != null) {
            g.fillRect(this.fill.x, this.fill.y, this.fill.width, this.fill.height);
        }
        if (this.bottom != null) {
            g.fillRect(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height);
        }
        g.setColor(saveColor);
    }

    public void repaintDirtyRegions() {
        if (this.dirtyRegion != null) {
            this.docView.repaint(this.dirtyRegion);
        } else {
            this.docView.repaint();
        }
    }

    public void scrollVisible() {
        Rectangle bounds = this.computeBounds();
        WmiDocumentScroller.scrollVisible(this.docView, bounds);
    }

    public int getLeftBoundary(int yOffset) {
        int start = -1;
        if (this.top != null && yOffset >= this.top.y) {
            if (yOffset < this.top.y + this.top.height) {
                start = this.top.x;
            } else if (this.fill != null && yOffset < this.fill.y + this.fill.height) {
                start = this.fill.x;
            } else if (this.bottom != null && yOffset < this.bottom.y + this.bottom.height) {
                start = this.bottom.x;
            }
        }
        return start;
    }

    public int getRightBoundary(int yOffset) {
        int end = -1;
        if (this.top != null && yOffset >= this.top.y) {
            if (yOffset < this.top.y + this.top.height) {
                end = this.top.x + this.top.width;
            } else if (this.fill != null && yOffset < this.fill.y + this.fill.height) {
                end = this.fill.x + this.fill.width;
            } else if (this.bottom != null && yOffset < this.bottom.y + this.bottom.height) {
                end = this.bottom.x + this.bottom.width;
            }
        }
        return end;
    }

    protected Color getHighlightColor() {
        return this.docView.getColor(4);
    }

    private WmiCompositeView findSelectionParent(WmiViewPath start, WmiViewPath end, int[] depthref) {
        WmiCompositeView parent = null;
        int depth = 0;
        int startDepth = start != null ? start.depth() : 0;
        int endDepth = end != null ? end.depth() : 0;
        int minDepth = startDepth < endDepth ? startDepth : endDepth;
        parent = this.docView;
        while (depth < minDepth) {
            WmiView child;
            WmiRowView physical;
            int index = start.peek(depth);
            if (index != end.peek(depth)) break;
            if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                parent = physical;
            }
            if (!((child = parent.getChild(index)) instanceof WmiCompositeView)) break;
            parent = (WmiCompositeView)child;
            ++depth;
        }
        if (depthref != null && depthref.length > 0) {
            depthref[0] = depth;
        }
        return parent;
    }

    private WmiInlineView findInline(WmiCompositeView parent, WmiViewPath path, int start, int selectionMode) {
        WmiInlineView inline = null;
        int n = start;
        if (path != null) {
            int depth = path.depth();
            while (true) {
                WmiView child;
                WmiRowView physical;
                if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                    parent = physical;
                }
                WmiView wmiView = n < depth ? parent.getChild(path.peek(n)) : (child = selectionMode == 0 ? parent.getChild(0) : parent.getChild(parent.getChildCount() - 1));
                if (child instanceof WmiInlineView) {
                    inline = (WmiInlineView)child;
                    break;
                }
                if (!(child instanceof WmiCompositeView)) break;
                parent = (WmiCompositeView)child;
                ++n;
            }
            if (inline == null) {
                inline = this.findParentInline(parent);
            }
        }
        return inline;
    }

    private WmiInlineView findParentInline(WmiCompositeView view) {
        WmiInlineView inline = null;
        while (view != null) {
            if (view instanceof WmiInlineView) {
                inline = (WmiInlineView)view;
                break;
            }
            view = view.getParentView();
        }
        return inline;
    }

    private int findHorizontalOffset(WmiCompositeView parent, WmiViewPath path, int start, int selectionMode) {
        Point pt;
        int offset = 0;
        WmiView child = null;
        int depth = path.depth();
        int i = start;
        while (true) {
            WmiRowView physical;
            if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                parent = physical;
            }
            if (i >= depth) {
                child = null;
                pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
                offset = selectionMode == 0 ? pt.x : pt.x + ((WmiPositionedView)((Object)parent)).getWidth();
                break;
            }
            child = parent.getChild(path.peek(i));
            if (!(child instanceof WmiCompositeView)) break;
            parent = (WmiCompositeView)child;
            ++i;
        }
        if (child instanceof WmiPositionedView) {
            pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)child);
            offset = pt.x;
        }
        if (child instanceof WmiTextView) {
            if (++i < depth) {
                offset += ((WmiTextView)child).getHorizontalOffset(path.peek(i));
            } else if (selectionMode == 1) {
                offset += ((WmiPositionedView)child).getWidth();
            }
        } else if (child != null && selectionMode == 1) {
            offset += ((WmiPositionedView)child).getWidth();
        }
        return offset;
    }

    private void computeDirtyRegions(WmiPathHighlighter oldHighlighter) {
        this.dirtyRegion = this.computeBounds();
        if (this.dirtyRegion == null && oldHighlighter != null) {
            this.dirtyRegion = oldHighlighter.computeBounds();
        } else if (oldHighlighter != null) {
            Rectangle oldBounds = oldHighlighter.computeBounds();
            if (oldBounds == null) {
                return;
            }
            if (oldBounds.x != this.dirtyRegion.x || oldBounds.width != this.dirtyRegion.width) {
                this.dirtyRegion = SwingUtilities.computeUnion(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, this.dirtyRegion);
            } else if (oldBounds.y == this.dirtyRegion.y && oldBounds.height == this.dirtyRegion.height) {
                this.dirtyRegion = this.top.x != oldHighlighter.top.x || this.top.width != oldHighlighter.top.width ? SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, oldHighlighter.top) : (this.bottom != null && oldHighlighter.bottom != null ? SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, oldHighlighter.bottom) : null);
            } else if (this.dirtyRegion.y != oldBounds.y) {
                if (this.dirtyRegion.y + this.dirtyRegion.height == oldBounds.y + oldBounds.height) {
                    int top1 = this.dirtyRegion.y;
                    int top2 = oldBounds.y;
                    int yMin = Math.min(top1, top2);
                    int yMax = Math.max(top1 += this.top.height, top2 += oldHighlighter.top.height);
                    int xMin = Math.min(this.dirtyRegion.x, oldBounds.x);
                    int xMax = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, oldBounds.x + oldBounds.width);
                    this.dirtyRegion = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
                } else {
                    this.dirtyRegion = SwingUtilities.computeUnion(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, this.dirtyRegion);
                }
            } else {
                int bottom1 = this.dirtyRegion.y + this.dirtyRegion.height;
                int bottom2 = oldBounds.y + oldBounds.height;
                int yMax = Math.max(bottom1, bottom2);
                if (this.bottom != null) {
                    bottom1 -= this.bottom.height;
                }
                if (oldHighlighter.bottom != null) {
                    bottom2 -= oldHighlighter.bottom.height;
                }
                int yMin = Math.min(bottom1, bottom2);
                int xMin = Math.min(this.dirtyRegion.x, oldBounds.x);
                int xMax = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, oldBounds.x + oldBounds.width);
                this.dirtyRegion = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
            }
        }
    }

    private Rectangle computeBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.top != null ? new Rectangle(this.top.x, this.top.y, this.top.width, this.top.height) : null;
        if (r != null) {
            if (this.fill != null) {
                r = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, r);
            }
            if (this.bottom != null) {
                r = SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, r);
            }
        }
        return r;
    }

    public Point getPointAtEnd() {
        Point answer = null;
        if (this.bottom != null) {
            Rectangle r = this.bottom.getBounds();
            answer = new Point(r.x + r.width, r.height);
        } else if (this.top != null) {
            Rectangle r = this.top.getBounds();
            answer = new Point(r.x + r.width, r.height);
        }
        return answer;
    }
}

