/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.util.LinkedList;

public class WmiPostDeletePositionUpdateHandler
extends WmiDefaultPositionUpdateHandler {
    public static final int FORWARD_BIAS = 1;
    public static final int REVERSE_BIAS = -1;
    public static final int DEFAULT_BIAS = -1;
    private LinkedList forwardSearchPath;
    private LinkedList reverseSearchPath;
    private int bias = -1;

    public WmiPostDeletePositionUpdateHandler(WmiMathDocumentView docView, WmiModelPosition position) throws WmiNoReadAccessException {
        this(docView, position, -1);
    }

    public WmiPostDeletePositionUpdateHandler(WmiMathDocumentView docView, WmiModelPosition position, int bias) throws WmiNoReadAccessException {
        super(docView, position);
        WmiModel model = position.getModel();
        this.forwardSearchPath = this.createSearchPath(model, 1);
        this.reverseSearchPath = this.createSearchPath(model, -1);
        this.bias = bias;
    }

    private LinkedList createSearchPath(WmiModel model, int bias) throws WmiNoReadAccessException {
        LinkedList<SearchNode> searchPath = new LinkedList<SearchNode>();
        searchPath.add(new SearchNode(model));
        while (model != null) {
            WmiCompositeModel parent = model.getParent();
            if (parent != null) {
                SearchNode node = new SearchNode(parent);
                searchPath.add(node);
                int index = parent.indexOf(model);
                if (bias > 0) {
                    int size = parent.getChildCount();
                    int i = index + 1;
                    while (i < size) {
                        node.addChild(parent.getChild(i));
                        ++i;
                    }
                } else {
                    int i = index - 1;
                    while (i >= 0) {
                        node.addChild(parent.getChild(i));
                        --i;
                    }
                }
            }
            WmiCompositeModel wmiCompositeModel = parent = (model = parent) != null ? model.getParent() : null;
        }
        return searchPath;
    }

    @Override
    public void updatePosition() throws WmiNoReadAccessException {
        this.adjustPosition();
        super.updatePosition();
    }

    private void adjustPosition() throws WmiNoReadAccessException {
        this.adjustPosition(true);
    }

    private void adjustPosition(boolean firstAttempt) throws WmiNoReadAccessException {
        WmiModelPosition pos = this.getPosition();
        int offset = pos.getOffset();
        LinkedList searchPath = this.bias > 0 ? this.forwardSearchPath : this.reverseSearchPath;
        int size = searchPath.size();
        boolean done = false;
        int i = 0;
        while (i < size && !done) {
            SearchNode node = (SearchNode)searchPath.get(i);
            WmiModel parent = node.parent;
            if (this.isLiveModel(parent) && parent.isVisible()) {
                LinkedList children = node.children;
                if (children != null) {
                    int childCount = children.size();
                    int j = 0;
                    while (j < childCount) {
                        WmiModel candidate = (WmiModel)children.get(j);
                        if (this.isLiveModel(candidate) && candidate.isVisible() && (candidate = this.getTraversableModel(candidate)) != null) {
                            pos = new WmiModelPosition(candidate, this.bias > 0 ? 0 : -1);
                            done = true;
                            break;
                        }
                        ++j;
                    }
                } else if (i == 0) {
                    pos = new WmiModelPosition(parent, offset);
                    done = true;
                    break;
                }
            }
            ++i;
        }
        if (done) {
            this.setPosition(pos);
        } else if (firstAttempt) {
            this.bias = -this.bias;
            this.adjustPosition(false);
        } else {
            this.setPosition(new WmiModelPosition(this.docView.getModel(), 0));
        }
    }

    private WmiModel getTraversableModel(WmiModel candidate) throws WmiNoReadAccessException {
        WmiView view = WmiViewUtil.modelToView(this.docView, candidate, 0);
        block0: while (!(view instanceof WmiTraversableView)) {
            int i;
            WmiCompositeModel comp;
            int size;
            if (!(candidate instanceof WmiCompositeModel) || (size = (comp = (WmiCompositeModel)candidate).getChildCount()) == 0) break;
            if (this.bias > 0) {
                i = 0;
                while (i < size) {
                    candidate = comp.getChild(i);
                    if (candidate != null && candidate.isVisible()) {
                        view = WmiViewUtil.modelToView(this.docView, candidate, 0);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            i = size - 1;
            while (i >= 0) {
                candidate = comp.getChild(i);
                if (candidate != null && candidate.isVisible()) {
                    view = WmiViewUtil.modelToView(this.docView, candidate, 0);
                    continue block0;
                }
                --i;
            }
        }
        return candidate;
    }

    private boolean isLiveModel(WmiModel model) throws WmiNoReadAccessException {
        boolean live = true;
        WmiMathDocumentModel docModel = model != null ? model.getDocument() : null;
        while (model != null && model != docModel) {
            int index;
            WmiCompositeModel parent = model.getParent();
            int n = index = parent != null ? parent.indexOf(model) : -1;
            if (index < 0) {
                live = false;
                break;
            }
            model = parent;
            parent = model.getParent();
        }
        return live;
    }

    private class SearchNode {
        private WmiModel parent;
        private LinkedList children;

        private SearchNode(WmiModel parent) {
            this.parent = parent;
        }

        private void addChild(WmiModel child) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            this.children.add(child);
        }
    }
}

