/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiEightPointResizer;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizeDecorator;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public abstract class WmiResizableContainerView
extends WmiArrayCompositeView
implements WmiContainerView {
    public static final int RESIZE_NO_CHANGE = -2;
    protected static WmiResizableContainerView resizingHold = null;
    protected static BufferedImage resizeImage = null;
    protected WmiResizeDecorator marker = null;
    protected boolean resizableByUser = true;

    protected WmiResizableContainerView(WmiModel model, WmiMathDocumentView docView) {
        this(model, docView, null);
    }

    protected WmiResizableContainerView(WmiModel model, WmiMathDocumentView docView, WmiCompositeView parent) {
        super(model, docView, parent);
    }

    protected void createResizeImage() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        resizeImage = config.createCompatibleImage(this.width, this.height);
        Graphics2D g = resizeImage.createGraphics();
        this.drawContents(g, this.width, this.height);
    }

    protected Point getAbsoluteCoordinates() {
        return WmiViewUtil.getAbsoluteOffset(this);
    }

    protected Rectangle getAbsoluteRegion() {
        Rectangle region = this.getBounds();
        region.setLocation(this.getAbsoluteCoordinates());
        return region;
    }

    protected void highlight(Graphics g, Color highlightColor) {
        Graphics2D g2d = (Graphics2D)g;
        Composite composite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(10, 0.5f));
        Color savedColor = g2d.getColor();
        if (highlightColor != null) {
            g2d.setColor(highlightColor);
        }
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(savedColor);
        if (composite != null) {
            g2d.setComposite(composite);
        }
    }

    public boolean shouldConstrainPrintSize() {
        return false;
    }

    public float getConstrainedSizeRatio() {
        return Math.min(1.0f, (float)this.getWidthConstraint(false) / (float)this.getWidth());
    }

    @Override
    public String debugPrint(int indent) throws WmiNoReadAccessException {
        return String.valueOf(System.getProperty("line.separator")) + super.debugPrint(indent);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid() && resizingHold != this) {
            WmiUndoManager undoManager;
            this.calculateRestrictedSize();
            super.layoutView();
            WmiModel thisModel = this.getModel();
            WmiMathDocumentModel doc = thisModel != null ? thisModel.getDocument() : null;
            WmiUndoManager wmiUndoManager = undoManager = doc != null ? doc.getUndoManager() : null;
            if (undoManager != null && !undoManager.isUndoingOrRedoing()) {
                this.resizeCanvasIfNecessary(this.getCanvasBounds());
                if (this.requiresCanvasResizeCommit()) {
                    SwingUtilities.invokeLater(new CanvasUpdater());
                }
            }
        }
    }

    protected void calculateRestrictedSize() throws WmiNoReadAccessException {
        this.height = this.getContentsVisibleHeight();
        this.width = this.getContentsVisibleWidth();
        this.baseline = this.height / 2;
        boolean isPrintView = this.getDocumentView() == null ? false : this.getDocumentView().isPrintView();
        if (this.applySizeConstraint(isPrintView || this.resizableByUser)) {
            this.resizeUpdate();
        }
        if (this.marker != null) {
            this.marker.updateView(this);
        }
    }

    protected void resizeUpdate() {
    }

    protected boolean applySizeConstraint(boolean constantAspect) throws WmiNoReadAccessException {
        boolean constrained = false;
        int originalWidth = this.width;
        int widthConstraint = this.getWidthConstraint(true);
        if (widthConstraint > 0 && widthConstraint < this.width) {
            this.width = widthConstraint;
            if (constantAspect) {
                double scale = (double)widthConstraint / (double)originalWidth;
                this.height = (int)((double)this.height * scale);
            }
            constrained = true;
        }
        return constrained;
    }

    protected boolean shouldDrawChildren() {
        return true;
    }

    protected boolean shouldDrawSelectionHighlight() {
        return true;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        int left = path.getHorizontalOffset() + this.x;
        int top = path.getVerticalOffset() + this.y;
        g.translate(left, top);
        path.applyShift(left, top);
        if (resizingHold == this && resizeImage != null) {
            g.drawImage(resizeImage, 0, 0, this.width, this.height, 0, 0, resizeImage.getWidth(), resizeImage.getHeight(), Color.WHITE, null);
        } else {
            this.drawContents(g, this.width, this.height);
        }
        Color highlightColor = null;
        if (this.shouldDrawSelectionHighlight() && path.isSelected(left, this.width)) {
            WmiMathDocumentView docView = this.getDocumentView();
            highlightColor = docView.getColor(4);
        } else if (resizingHold == this) {
            highlightColor = Color.WHITE;
        }
        if (highlightColor != null) {
            this.highlight(g, highlightColor);
        }
        g.translate(-left, -top);
        path.applyShift(-left, -top);
        if (this.shouldDrawChildren()) {
            super.draw(g, path, bounds);
        }
    }

    @Override
    public void release() {
        super.release();
        resizeImage = null;
        if (this.marker != null) {
            this.marker.hide();
            this.marker = null;
        }
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
        if (resizingHold == this && this.marker != null) {
            block9: {
                WmiMathDocumentModel doc;
                Dimension resize = this.marker.onMouseDragged(e);
                this.width = (int)resize.getWidth();
                this.height = (int)resize.getHeight();
                WmiModel model = this.getModel();
                if (model != null && (doc = model.getDocument()) != null && WmiModelLock.readLock(doc, true)) {
                    try {
                        try {
                            WmiMathDocumentView docView;
                            this.applySizeConstraint(false);
                            this.marker.updateView(this);
                            WmiCompositeView parent = this.getParentView();
                            if (parent != null) {
                                parent.invalidate(1);
                            }
                            if ((docView = this.getDocumentView()) != null) {
                                docView.layoutView();
                                docView.repaint();
                                WmiSelection wmiSelection = docView.getSelection();
                            }
                        }
                        catch (WmiNoReadAccessException readE) {
                            WmiErrorLog.log(readE);
                            WmiModelLock.readUnlock(doc);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        WmiModelLock.readUnlock(doc);
                        throw throwable;
                    }
                    WmiModelLock.readUnlock(doc);
                }
            }
            e.consume();
        }
    }

    @Override
    public void onMouseExited(MouseEvent e) {
        this.setCursor(null);
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
        Cursor cursor = null;
        if (this.marker != null && this.marker.isVisible()) {
            cursor = this.marker.onMouseMoved(e);
        }
        if (cursor != null) {
            this.setCursor(cursor);
            e.consume();
        }
    }

    @Override
    public void onMousePressed(MouseEvent e) {
        resizingHold = null;
        resizeImage = null;
        if (this.marker != null && this.marker.isVisible() && (e.getModifiers() & 0x10) != 0 && this.marker.onMousePressed(e)) {
            WmiMathDocumentView docView = this.getDocumentView();
            WmiMathDocumentMouseListener docListener = docView.getMouseListener();
            docListener.setMouseDragView(this);
            resizingHold = this;
            this.createResizeImage();
            e.consume();
        }
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
        if (resizingHold == this) {
            if (this.marker != null) {
                this.marker.onMouseReleased(e);
            }
            resizingHold = null;
            resizeImage = null;
            this.resizeModel(this.width, this.height, true);
            e.consume();
        }
    }

    protected Rectangle getCanvasBounds() {
        return this.getBounds();
    }

    protected void resizeCanvasIfNecessary(Rectangle before) {
        int i = 0;
        while (i < this.getChildCount()) {
            WmiView wmiView = this.getChild(i);
            ++i;
        }
    }

    protected boolean requiresCanvasResizeCommit() {
        return false;
    }

    protected void commitCanvasResize() throws WmiNoWriteAccessException, WmiNoUpdateAccessException {
    }

    @Override
    public void setFocus(boolean newValue) {
    }

    @Override
    public void setPositionMarker(int offset) {
        WmiMathDocumentView docView = this.getDocumentView();
        if (docView != null) {
            if (this.marker == null || !this.marker.equals(docView.getPositionMarker())) {
                WmiResizeDecorator newMarker = this.createResizeDecorator(docView);
                if (newMarker != null) {
                    docView.setPositionMarker(newMarker);
                    newMarker.updateView(this);
                    newMarker.show();
                    this.marker = newMarker;
                    docView.setFocusedView(this);
                }
            } else if (this.marker != null) {
                this.marker.updateView(this);
            }
            docView.repaint();
        }
    }

    public void setMarker(WmiResizeDecorator marker) {
        this.marker = marker;
    }

    protected abstract WmiResizeDecorator createResizeDecorator(WmiMathDocumentView var1);

    protected abstract void drawContents(Graphics var1, int var2, int var3);

    protected abstract int getContentsVisibleHeight() throws WmiNoReadAccessException;

    protected abstract int getContentsVisibleWidth() throws WmiNoReadAccessException;

    protected int getContentsFullWidth() throws WmiNoReadAccessException {
        return this.getContentsVisibleWidth();
    }

    protected int getContentsFullHeight() throws WmiNoReadAccessException {
        return this.getContentsVisibleHeight();
    }

    public abstract void resizeModel(int var1, int var2, boolean var3);

    public void setUserResizable(boolean isResizable) {
        this.resizableByUser = isResizable;
    }

    @Override
    public WmiPositionedView getChildView(Point pt) {
        WmiMathDocumentView wks = this.getDocumentView();
        MouseEvent fakeMouseEvent = new MouseEvent(wks, 0, 0L, 0, pt.x, pt.y, 1, false);
        fakeMouseEvent.setSource(this);
        WmiPositionedView view = this.marker != null && WmiEightPointResizer.isEventInResizeRegion(fakeMouseEvent) ? null : super.getChildView(pt);
        return view;
    }

    private class CanvasUpdater
    implements Runnable {
        private CanvasUpdater() {
        }

        @Override
        public void run() {
            WmiModel thisModel = WmiResizableContainerView.this.getModel();
            if (thisModel == null) {
                return;
            }
            WmiMathDocumentModel doc = thisModel.getDocument();
            if (doc == null) {
                return;
            }
            WmiUndoManager undoManager = doc.getUndoManager();
            undoManager.makeLastEditCoalescable(true);
            if (WmiModelLock.writeLock(doc, true)) {
                block10: {
                    try {
                        WmiResizableContainerView.this.commitCanvasResize();
                    }
                    catch (WmiNoWriteAccessException nwae) {
                        WmiErrorLog.log(nwae);
                        WmiModelLock.writeUnlock(doc);
                        break block10;
                    }
                    catch (WmiNoUpdateAccessException nuae) {
                        try {
                            WmiErrorLog.log(nuae);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            WmiModelLock.writeUnlock(doc);
                        }
                    }
                    WmiModelLock.writeUnlock(doc);
                }
                undoManager.makeLastEditCoalescable(true);
                undoManager.coalesceLastEdits();
                undoManager.makeLastEditCoalescable(false);
            }
        }
    }
}

