/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiRowView
extends WmiArrayCompositeView
implements WmiPositionedView {
    private String debugName = null;

    public WmiRowView(WmiModel model, WmiMathDocumentView docView) {
        this(model, docView, (String)null);
    }

    public WmiRowView(WmiModel model, WmiMathDocumentView docView, String name) {
        super(model, docView);
        this.debugName = name;
    }

    @Override
    public String getDebugName() {
        return this.debugName != null ? this.debugName : super.getDebugName();
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            this.checkRepaint();
            int oldHeight = this.height;
            int oldWidth = this.width;
            this.width = 0;
            this.height = this.getTopMargin();
            boolean previousHeightChanged = false;
            int i = 0;
            while (i < this.length) {
                WmiPositionedView child = (WmiPositionedView)this.children[i];
                if (child != null) {
                    int childOffset = child.getVerticalOffset();
                    int childIndent = child.getHorizontalOffset();
                    child.setVerticalOffset(this.height);
                    child.setHorizontalOffset(this.getLeftIndent());
                    int childWidth = child.getWidth() + this.getLeftIndent() + this.getRightIndent();
                    if (childWidth > this.width) {
                        this.width = childWidth;
                    }
                    if (previousHeightChanged || childIndent != child.getHorizontalOffset()) {
                        child.forceRepaint();
                    } else if (this.height != childOffset) {
                        child.forceRepaint();
                        previousHeightChanged = true;
                    }
                    this.height += child.getHeight();
                }
                ++i;
            }
            if (this.length > 0) {
                WmiPositionedView child = (WmiPositionedView)this.children[0];
                this.baseline = child.getVerticalOffset() + child.getBaseline();
            }
            this.addNavigationLinks();
            super.layoutView();
            if (this.height != oldHeight || this.width != oldWidth) {
                this.forceRepaint();
            }
        }
    }

    @Override
    public void paintDirty() {
        WmiMathDocumentView docView = this.getDocumentView();
        if (docView != null) {
            if (this.getForceRepaint()) {
                Point pt = WmiViewUtil.getAbsoluteOffset(this);
                docView.repaint(pt.x - 1, pt.y - 1, this.width + 2, this.height + 2);
            } else if (this.getCheckRepaint()) {
                Point pt = WmiViewUtil.getAbsoluteOffset(this);
                int i = 0;
                while (i < this.length) {
                    WmiPositionedView child = (WmiPositionedView)this.children[i];
                    if (child.getForceRepaint()) {
                        docView.repaint(pt.x - 1, pt.y + child.getVerticalOffset() - 1, this.width + 2, child.getHeight() + 2);
                        child.resetPaintFlags();
                    } else {
                        child.paintDirty();
                    }
                    ++i;
                }
            }
        }
        this.resetPaintFlags();
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        int topBounds = bounds != null ? bounds.y : Integer.MIN_VALUE;
        int bottomBounds = bounds != null ? topBounds + bounds.height : Integer.MAX_VALUE;
        int topView = path.getVerticalOffset() + this.y;
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            if (topBounds < clip.y) {
                topBounds = clip.y;
            }
            if (bottomBounds > clip.y + clip.height) {
                bottomBounds = clip.y + clip.height;
            }
        }
        int bottomView = topView + this.height;
        if (topView < bottomBounds && bottomView > topBounds) {
            path.push(this.x, this.y);
            int i = 0;
            while (i < this.length) {
                WmiPositionedView child = (WmiPositionedView)this.children[i];
                if (child != null) {
                    int topChild = topView + child.getVerticalOffset();
                    int bottomChild = topChild + child.getHeight();
                    if (topChild < bottomBounds && bottomChild > topBounds) {
                        child.draw(g, path, bounds);
                    }
                }
                path.next();
                ++i;
            }
            path.pop();
        }
    }

    public int getLeftIndent() {
        return 0;
    }

    public int getRightIndent() {
        return 0;
    }

    public int getTopMargin() {
        return 0;
    }

    @Override
    public void addNavigationLinks() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiPositionedView next;
            WmiPositionedView child = (WmiPositionedView)this.getChild(i);
            if (i < size - 1) {
                next = (WmiPositionedView)this.getChild(i + 1);
                child.setNextView(next, 1);
                child.setNextView(next, 3);
            }
            if (i > 0) {
                next = (WmiPositionedView)this.getChild(i - 1);
                child.setNextView(next, 0);
                child.setNextView(next, 2);
            }
            if (size > 0) {
                child = (WmiPositionedView)this.getChild(0);
                child.setNextView(null, 0);
                child.setNextView(null, 2);
                child = (WmiPositionedView)this.getChild(size - 1);
                child.setNextView(null, 1);
                child.setNextView(null, 3);
            }
            ++i;
        }
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, 1);
    }

    @Override
    public int getWidthConstraint(boolean ignoreTopLevelView) {
        int widthConstraint = super.getWidthConstraint(ignoreTopLevelView);
        if (widthConstraint >= 0) {
            widthConstraint -= this.getLeftIndent();
            if ((widthConstraint -= this.getRightIndent()) < 0) {
                widthConstraint = 0;
            }
        }
        return widthConstraint;
    }
}

