/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.util.Set;

public class WmiSelectionBuilder {
    private WmiMathDocumentView docView;

    public WmiSelectionBuilder(WmiMathDocumentView docView) {
        this.setDocument(docView);
    }

    public void setDocument(WmiMathDocumentView docView) {
        this.docView = docView;
    }

    public WmiMathDocumentView getDocumentView() {
        return this.docView;
    }

    public void updateSelection(WmiView view, int offset) throws WmiNoReadAccessException {
        WmiMathDocumentView docView = view.getDocumentView();
        if (docView != null) {
            WmiViewPath newPath = new WmiViewPath(view);
            if (view instanceof WmiTraversableView) {
                newPath.push(offset);
            } else if (offset != 0 && view instanceof WmiCompositeView) {
                newPath.push(-1);
            }
            WmiSelection selection = docView.getSelection();
            if (selection == null) {
                WmiViewPath path;
                WmiPositionMarker marker = docView.getPositionMarker();
                if (marker != null && (path = marker.getViewPath()) != null) {
                    selection = this.createSelection(path, newPath);
                    docView.setSelection(selection);
                }
            } else {
                selection.updateSelection(newPath);
            }
            if (selection != null) {
                selection.repaintDirtyRegions();
            }
        }
    }

    public WmiSelection createAggregateSelection(Set selectedModels) {
        WmiAggregateSelection selection = new WmiAggregateSelection(this.docView);
        this.populateAggregateSelection(selectedModels, selection);
        return selection;
    }

    protected void populateAggregateSelection(Set s, WmiAggregateSelection selection) {
        if (s != null) {
            try {
                try {
                    WmiModelLock.readLock(this.docView.getModel(), true);
                    for (WmiModel model : s) {
                        WmiView view = WmiViewUtil.modelToView(this.docView, model, 0);
                        selection.add(view);
                    }
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    WmiModelLock.readUnlock(this.docView.getModel());
                }
            }
            finally {
                WmiModelLock.readUnlock(this.docView.getModel());
            }
        }
    }

    public WmiSelection createSelection(WmiViewPath bound1, WmiViewPath bound2) {
        WmiViewPathInterval selection = new WmiViewPathInterval(this.docView, bound1, bound2);
        this.docView.setSelection(selection);
        selection.repaintDirtyRegions();
        return selection;
    }

    public WmiSelection createSelection(WmiModel startModel, int startOffset, WmiModel endModel, int endOffset) throws WmiNoReadAccessException {
        WmiViewPathInterval selection = new WmiViewPathInterval(this.docView);
        selection.updateSelection(startModel, startOffset, endModel, endOffset);
        this.docView.setSelection(selection);
        selection.repaintDirtyRegions();
        return selection;
    }

    public WmiSelection selectModel(WmiModel model) throws WmiNoReadAccessException {
        return this.createSelection(model, 0, model, -1);
    }
}

