/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.view.WmiAbstractInlineWrapperView;
import com.maplesoft.mathdoc.view.WmiAbstractSelectionHighlighter;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class WmiSelectionHighlighter
extends WmiAbstractSelectionHighlighter {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    public static final int REPAINT_BORDER = 1;
    private Rectangle top;
    private Rectangle bottom;
    private Rectangle fill;
    private WmiMathDocumentView docView;
    private Rectangle dirtyRegion;

    public WmiSelectionHighlighter(WmiMathDocumentView docView, WmiViewPathInterval interval, WmiSelectionHighlighter oldHighlighter) {
        WmiRowView physical;
        this.docView = docView;
        WmiViewPath start = interval.getSelectionStartPath();
        WmiViewPath end = interval.getSelectionEndPath();
        int[] depthref = new int[1];
        WmiCompositeView parent = this.findSelectionParent(start, end, depthref);
        int depth = depthref[0];
        int startOffset = this.findHorizontalOffset(parent, start, depth, 0);
        int endOffset = this.findHorizontalOffset(parent, end, depth, 1);
        if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
            parent = physical;
        }
        if (parent instanceof WmiRowView || parent instanceof WmiMathDocumentView || parent instanceof WmiAbstractInlineWrapperView) {
            this.createMultiRowSelection(parent, start, end, depth, startOffset, endOffset);
        } else {
            this.createWithinRowSelection(parent, start, end, depth, startOffset, endOffset);
        }
        this.computeDirtyRegions(oldHighlighter);
        this.repaintDirtyRegions();
    }

    private void createMultiRowSelection(WmiCompositeView parent, WmiViewPath start, WmiViewPath end, int depth, int startOffset, int endOffset) {
        WmiPositionedView topView = this.findRow(parent, start, depth, 0);
        WmiPositionedView bottomView = this.findRow(parent, end, depth, 1);
        this.bottom = null;
        this.fill = null;
        this.top = null;
        if (topView != null && bottomView != null) {
            Point topPoint = WmiViewUtil.getAbsoluteOffset(topView);
            if (topView == bottomView) {
                this.top = this.constructRect(topView, startOffset, endOffset);
            } else {
                Point parentPoint = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
                this.top = this.constructRect(topView, startOffset, parentPoint.x + ((WmiPositionedView)((Object)parent)).getWidth());
                this.bottom = this.constructRect(bottomView, parentPoint.x, endOffset);
                if (this.bottom.y > this.top.y + this.top.height) {
                    this.fill = new Rectangle(parentPoint.x, this.top.y + this.top.height, ((WmiPositionedView)((Object)parent)).getWidth(), this.bottom.y - (topPoint.y + this.top.height));
                }
            }
        }
    }

    private void createWithinRowSelection(WmiCompositeView parent, WmiViewPath start, WmiViewPath end, int depth, int startOffset, int endOffset) {
        WmiView reference = parent;
        int minDepth = start.depth() < end.depth() ? start.depth() : end.depth();
        while (depth < minDepth && reference instanceof WmiCompositeView) {
            int index = start.peek(depth);
            if (start.peek(depth) != end.peek(depth)) break;
            if (index < 0) {
                index = reference.getChildCount() - 1;
            }
            reference = reference.getChild(index);
            ++depth;
        }
        WmiPositionedView topView = (WmiPositionedView)reference;
        this.bottom = null;
        this.fill = null;
        this.top = null;
        this.top = this.constructRect(topView, startOffset, endOffset);
    }

    private Rectangle constructRect(WmiPositionedView view, int startOffset, int endOffset) {
        Rectangle rect = null;
        if (view != null) {
            WmiTextLayout layout;
            Point pt = WmiViewUtil.getAbsoluteOffset(view);
            boolean useTextMetrics = false;
            if (view instanceof WmiTextView && (layout = ((WmiTextView)view).getLayout()) != null) {
                Font font = layout.getFont();
                FontRenderContext frc = layout.getFontRenderContext();
                WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
                int topOffset = ((WmiTextView)view).getAdjustedBaseline() - metrics.getFontProperty(3, frc);
                rect = new Rectangle(startOffset, pt.y + topOffset, endOffset - startOffset + 1, layout.getHeight());
                useTextMetrics = true;
            }
            if (!useTextMetrics) {
                rect = new Rectangle(startOffset, pt.y, endOffset - startOffset + 1, view.getHeight());
            }
        }
        return rect;
    }

    @Override
    public void paint(Graphics g) {
        Color saveColor = g.getColor();
        Color background = this.docView.getColor(4);
        g.setColor(background);
        if (this.top != null) {
            g.fillRect(this.top.x, this.top.y, this.top.width, this.top.height);
        }
        if (this.fill != null) {
            g.fillRect(this.fill.x, this.fill.y, this.fill.width, this.fill.height);
        }
        if (this.bottom != null) {
            g.fillRect(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height);
        }
        g.setColor(saveColor);
    }

    public void repaintDirtyRegions() {
        if (this.dirtyRegion != null) {
            this.docView.repaint(this.dirtyRegion.x - 1, this.dirtyRegion.y - 1, this.dirtyRegion.width + 2, this.dirtyRegion.height + 2);
        } else {
            this.docView.repaint();
        }
    }

    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.docView, this.getBounds());
    }

    @Override
    public int getLeftBoundary(int yOffset) {
        int start = -1;
        if (this.top != null && yOffset >= this.top.y) {
            if (yOffset < this.top.y + this.top.height) {
                start = this.top.x;
            } else if (this.fill != null && yOffset < this.fill.y + this.fill.height) {
                start = this.fill.x;
            } else if (this.bottom != null && yOffset < this.bottom.y + this.bottom.height) {
                start = this.bottom.x;
            }
        }
        return start;
    }

    @Override
    public int getRightBoundary(int yOffset) {
        int end = -1;
        if (this.top != null && yOffset >= this.top.y) {
            if (yOffset < this.top.y + this.top.height) {
                end = this.top.x + this.top.width;
            } else if (this.fill != null && yOffset < this.fill.y + this.fill.height) {
                end = this.fill.x + this.fill.width;
            } else if (this.bottom != null && yOffset < this.bottom.y + this.bottom.height) {
                end = this.bottom.x + this.bottom.width;
            }
        }
        return end;
    }

    @Override
    public int getTopBoundary(int xOffset) {
        int boundary = -1;
        if (this.top != null && this.top.x < xOffset) {
            if (xOffset < this.top.x + this.top.width) {
                boundary = this.top.y;
            }
        } else if (this.fill != null && this.fill.x < xOffset) {
            if (xOffset < this.fill.x + this.fill.width) {
                boundary = this.fill.y;
            }
        } else if (this.bottom != null && this.bottom.x < xOffset && xOffset < this.bottom.x + this.bottom.width) {
            boundary = this.bottom.y;
        }
        return boundary;
    }

    @Override
    public int getBottomBoundary(int xOffset) {
        int boundary = -1;
        if (this.bottom != null && this.bottom.x < xOffset) {
            if (xOffset < this.bottom.x + this.bottom.width) {
                boundary = this.bottom.y + this.bottom.height;
            }
        } else if (this.fill != null && this.fill.x < xOffset) {
            if (xOffset < this.fill.x + this.fill.width) {
                boundary = this.fill.y + this.fill.height;
            }
        } else if (this.top != null && this.top.x < xOffset && xOffset < this.top.x + this.top.width) {
            boundary = this.top.y + this.top.height;
        }
        return boundary;
    }

    private WmiCompositeView findSelectionParent(WmiViewPath start, WmiViewPath end, int[] depthref) {
        WmiCompositeView parent = null;
        int depth = 0;
        int startDepth = start != null ? start.depth() : 0;
        int endDepth = end != null ? end.depth() : 0;
        int minDepth = startDepth < endDepth ? startDepth : endDepth;
        parent = this.docView;
        while (depth < minDepth) {
            WmiView child;
            WmiRowView physical;
            int index = start.peek(depth);
            if (index != end.peek(depth)) break;
            if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                parent = physical;
            }
            if (index < 0) {
                index = parent.getChildCount() - 1;
            }
            if (!((child = parent.getChild(index)) instanceof WmiCompositeView)) break;
            parent = (WmiCompositeView)child;
            ++depth;
        }
        if (depthref != null && depthref.length > 0) {
            depthref[0] = depth;
        }
        return parent;
    }

    private WmiPositionedView findRow(WmiView parent, WmiViewPath path, int depth, int mode) {
        WmiPositionedView row = null;
        if (path != null) {
            WmiRowView linebroken;
            int pathDepth = path.depth();
            if (parent instanceof WmiSwitchableCompositeView && (linebroken = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                parent = linebroken;
            }
            if (parent instanceof WmiRowView || parent instanceof WmiMathDocumentView) {
                WmiCompositeView cparent = (WmiCompositeView)parent;
                if (depth < pathDepth) {
                    int index = path.peek(depth);
                    if (index < 0) {
                        index = cparent.getChildCount() - 1;
                    }
                    row = this.findRow(cparent.getChild(index), path, depth + 1, mode);
                } else if (cparent.getChildCount() > 0) {
                    row = mode == 0 ? this.findRow(cparent.getChild(0), path, depth + 1, mode) : this.findRow(cparent.getChild(cparent.getChildCount() - 1), path, depth + 1, mode);
                }
            }
            if (row == null) {
                row = (WmiPositionedView)parent;
            }
        }
        return row;
    }

    private int findHorizontalOffset(WmiCompositeView parent, WmiViewPath path, int start, int selectionMode) {
        int offset = 0;
        WmiView child = null;
        int depth = path.depth();
        int i = start;
        while (true) {
            int index;
            WmiRowView physical;
            boolean parentIsSubcontainer = false;
            if (parent instanceof WmiScrollableContainerView) {
                boolean bl = parentIsSubcontainer = !((WmiScrollableContainerView)((Object)parent)).isDocumentView();
            }
            if (parentIsSubcontainer) {
                child = null;
                Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
                offset = selectionMode == 0 ? pt.x : pt.x + ((WmiPositionedView)((Object)parent)).getWidth();
                break;
            }
            if (parent instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView()) != null) {
                parent = physical;
            }
            if (i < depth) {
                index = path.peek(i);
                int limit = parent.getChildCount();
                if (index < 0 || index >= limit && limit > 0) {
                    child = null;
                    Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
                    offset = pt.x + ((WmiPositionedView)((Object)parent)).getWidth();
                    break;
                }
                if (index >= limit) break;
            } else {
                child = null;
                Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)parent));
                offset = selectionMode == 0 ? pt.x : pt.x + ((WmiPositionedView)((Object)parent)).getWidth();
                break;
            }
            child = parent.getChild(index);
            if (!(child instanceof WmiCompositeView)) break;
            parent = (WmiCompositeView)child;
            ++i;
        }
        if (child instanceof WmiPositionedView) {
            Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)child);
            offset = pt.x;
            if (child instanceof WmiTextView) {
                if (++i < depth) {
                    int index = path.peek(i);
                    offset = index < 0 ? (offset += ((WmiPositionedView)child).getWidth()) : (offset += ((WmiTextView)child).getHorizontalOffset(index));
                } else if (selectionMode == 1) {
                    offset += ((WmiPositionedView)child).getWidth();
                }
            } else if (child != null && selectionMode == 1) {
                offset += ((WmiPositionedView)child).getWidth();
            }
        }
        return offset;
    }

    public void computeDirtyRegions(WmiHighlightPainter oldHighlighter) {
        this.dirtyRegion = this.computeBounds();
        if (this.dirtyRegion == null && oldHighlighter != null) {
            this.dirtyRegion = oldHighlighter.getBounds();
        } else if (oldHighlighter != null) {
            Rectangle oldBounds = oldHighlighter.getBounds();
            if (oldBounds == null) {
                return;
            }
            if (oldBounds.x != this.dirtyRegion.x || oldBounds.width != this.dirtyRegion.width || !(oldHighlighter instanceof WmiSelectionHighlighter)) {
                this.dirtyRegion = SwingUtilities.computeUnion(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, this.dirtyRegion);
            } else if (oldBounds.y == this.dirtyRegion.y && oldBounds.height == this.dirtyRegion.height) {
                WmiSelectionHighlighter oldSelectionHighlighter = (WmiSelectionHighlighter)oldHighlighter;
                this.dirtyRegion = this.top.x != oldSelectionHighlighter.top.x || this.top.width != oldSelectionHighlighter.top.width ? SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, oldSelectionHighlighter.top) : (this.bottom != null && oldSelectionHighlighter.bottom != null ? SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, oldSelectionHighlighter.bottom) : null);
            } else {
                WmiSelectionHighlighter oldSelectionHighlighter = (WmiSelectionHighlighter)oldHighlighter;
                if (this.dirtyRegion.y != oldBounds.y) {
                    if (this.dirtyRegion.y + this.dirtyRegion.height == oldBounds.y + oldBounds.height) {
                        int top1 = this.dirtyRegion.y;
                        int top2 = oldBounds.y;
                        int yMin = Math.min(top1, top2);
                        int yMax = Math.max(top1 += this.top.height, top2 += oldSelectionHighlighter.top.height);
                        int xMin = Math.min(this.dirtyRegion.x, oldBounds.x);
                        int xMax = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, oldBounds.x + oldBounds.width);
                        this.dirtyRegion = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
                    } else {
                        this.dirtyRegion = SwingUtilities.computeUnion(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, this.dirtyRegion);
                    }
                } else {
                    int bottom1 = this.dirtyRegion.y + this.dirtyRegion.height;
                    int bottom2 = oldBounds.y + oldBounds.height;
                    int yMax = Math.max(bottom1, bottom2);
                    if (this.bottom != null) {
                        bottom1 -= this.bottom.height;
                    }
                    if (oldSelectionHighlighter.bottom != null) {
                        bottom2 -= oldSelectionHighlighter.bottom.height;
                    }
                    int yMin = Math.min(bottom1, bottom2);
                    int xMin = Math.min(this.dirtyRegion.x, oldBounds.x);
                    int xMax = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, oldBounds.x + oldBounds.width);
                    this.dirtyRegion = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
                }
            }
        }
    }

    private Rectangle computeBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.top != null ? new Rectangle(this.top.x, this.top.y, this.top.width, this.top.height) : null;
        if (r != null) {
            if (this.fill != null) {
                r = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, r);
            }
            if (this.bottom != null) {
                r = SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, r);
            }
        }
        return r;
    }

    @Override
    public Rectangle[] intersect(int x, int y, int width, int height) {
        ArrayList<Rectangle> rArray = new ArrayList<Rectangle>();
        Rectangle r = this.intersection(x, y, width, height, this.top);
        if (r != null) {
            rArray.add(r);
        }
        if ((r = this.intersection(x, y, width, height, this.fill)) != null) {
            rArray.add(r);
        }
        if ((r = this.intersection(x, y, width, height, this.bottom)) != null) {
            rArray.add(r);
        }
        Rectangle[] result = null;
        if (rArray.size() > 0) {
            result = new Rectangle[rArray.size()];
            int i = 0;
            while (i < rArray.size()) {
                result[i] = (Rectangle)rArray.get(i);
                ++i;
            }
        }
        return result;
    }

    private Rectangle intersection(int x, int y, int width, int height, Rectangle r) {
        Rectangle result = null;
        if (r != null) {
            result = new Rectangle(x, y, width, height);
            SwingUtilities.computeIntersection(r.x, r.y, r.width, r.height, result);
            if (result.width == 0) {
                result = null;
            }
        }
        return result;
    }

    public Rectangle computeLeftMarginBounds() {
        Rectangle r;
        Rectangle rectangle = r = this.bottom != null ? new Rectangle(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height) : null;
        if (this.fill != null) {
            r = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, r);
        }
        if (this.top != null && r != null && this.top.x == r.x) {
            r = SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, r);
        }
        return r;
    }

    @Override
    public Rectangle getBounds() {
        return this.computeBounds();
    }

    public Color getSelectionForeground() {
        return this.docView.getColor(3);
    }

    public Point getPointAtEnd() {
        Point answer = null;
        if (this.bottom != null) {
            Rectangle r = this.bottom.getBounds();
            answer = new Point(r.x + r.width, r.y);
        } else if (this.top != null) {
            Rectangle r = this.top.getBounds();
            answer = new Point(r.x + r.width, r.y);
        }
        return answer;
    }
}

