/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTableModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTableCellView;
import com.maplesoft.mathdoc.view.WmiTableColumnView;
import com.maplesoft.mathdoc.view.WmiTableRowView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;

public class WmiTableView
extends WmiArrayCompositeView {
    private static final int TABLE_TOP_MARGIN = 4;
    private static final int TABLE_BOTTOM_MARGIN = 4;
    public static final Stroke BORDER_STROKE = new BasicStroke(1.0f);
    public static final Color VISIBLE_BORDER_COLOR = Color.BLACK;
    public static final Color FOCUS_BORDER_COLOR = Color.LIGHT_GRAY;
    public static final int LEFT_SIDE = 1;
    public static final int TOP_SIDE = 2;
    public static final int RIGHT_SIDE = 4;
    public static final int BOTTOM_SIDE = 8;
    public static final int DYNAMIC_BORDER = 16;
    public static final int ALL_SIDES = 15;
    protected static WmiTableView focusedTable = null;
    private int[] columnWidth = null;
    private int[] rowHeight = null;
    private WmiTableCellView[] rowBuilder = null;
    private ArrayList multiRowCells = null;
    private int columns = 0;
    private int rows = 0;
    private int borders = 15;
    private boolean showGroups = true;
    private boolean showInput = true;
    private boolean showLabels = true;
    private boolean useRandomRowOrder = false;
    private ArrayList rowOrderList;
    private int pagebreak = 0;
    private int leftIndent = 0;
    private boolean mutable = true;

    public WmiTableView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        path.push(this.x, this.y);
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                ((WmiTableRowView)childView).draw(g, path, bounds);
            }
            path.next();
            ++i;
        }
        path.pop();
        this.drawStub(g, path, bounds);
    }

    @Override
    public void drawStub(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke saveStroke = g2d.getStroke();
        Color saveColor = g.getColor();
        g2d.setStroke(BORDER_STROKE);
        int xOffset = path.getHorizontalOffset();
        int yOffset = path.getVerticalOffset();
        int left = xOffset + this.x + this.leftIndent;
        int top = yOffset + this.y + this.getTopMargin();
        int right = left + this.width - this.leftIndent;
        int bottom = top + this.height - this.getTopMargin() - this.getBottomMargin();
        boolean focus = this.hasFocus();
        WmiSelection selection = path.getSelection();
        WmiHighlightPainter highlighter = selection != null ? selection.getSelectionHighlighter() : null;
        Color highlightColor = highlighter != null ? this.getDocumentView().getColor(3) : null;
        WmiTableView.drawBorder(g, this.borders, 2, focus, left, top, right, top, highlighter, highlightColor);
        WmiTableView.drawBorder(g, this.borders, 8, focus, right, bottom, left, bottom, highlighter, highlightColor);
        g2d.setColor(saveColor);
        g2d.setStroke(saveStroke);
    }

    public static void drawBorder(Graphics g, int borders, int side, boolean focus, int x1, int y1, int x2, int y2, WmiHighlightPainter highlighter, Color highlightColor) {
        Color drawColor = null;
        if ((borders & side) != 0) {
            drawColor = VISIBLE_BORDER_COLOR;
        } else if (focus) {
            drawColor = FOCUS_BORDER_COLOR;
        }
        if (drawColor != null) {
            if (highlighter != null && highlightColor != null) {
                if (y1 == y2) {
                    int selectLeft = highlighter.getLeftBoundary(y1);
                    int selectRight = highlighter.getRightBoundary(y1);
                    if (selectRight > x1 && selectLeft < x2) {
                        if (x1 < selectLeft && x2 > selectLeft) {
                            WmiTableView.drawLine(g, x1, y1, selectLeft, y2, drawColor);
                        }
                        if (x2 > selectRight && selectRight > x1) {
                            WmiTableView.drawLine(g, selectRight, y1, x2, y2, drawColor);
                        }
                        if (selectLeft < x1) {
                            selectLeft = x1;
                        }
                        if (selectRight > x2) {
                            selectRight = x2;
                        }
                        WmiTableView.drawLine(g, selectLeft, y1, selectRight, y2, highlightColor);
                    } else {
                        WmiTableView.drawLine(g, x1, y1, x2, y2, drawColor);
                    }
                } else if (x1 == x2) {
                    int selectTop = highlighter.getTopBoundary(x1);
                    int selectBottom = highlighter.getBottomBoundary(x1);
                    if (selectBottom > y1 && selectTop < y2) {
                        if (y1 < selectTop && y2 > selectTop) {
                            WmiTableView.drawLine(g, x1, y1, x2, selectTop, drawColor);
                        }
                        if (y2 > selectBottom && selectBottom > y1) {
                            WmiTableView.drawLine(g, x1, selectBottom, x2, y2, drawColor);
                        }
                        if (selectTop < y1) {
                            selectTop = y1;
                        }
                        if (selectBottom > y2) {
                            selectBottom = y2;
                        }
                        WmiTableView.drawLine(g, x1, selectTop, x2, selectBottom, highlightColor);
                    } else {
                        WmiTableView.drawLine(g, x1, y1, x2, y2, drawColor);
                    }
                }
            } else {
                WmiTableView.drawLine(g, x1, y1, x2, y2, drawColor);
            }
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, Color c) {
        g.setColor(c);
        g.drawLine(x1, y1, x2, y2);
    }

    public int getBorderStyleIndex() {
        return this.borders;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiAttributeSet attributes = this.getModel().getAttributesForRead();
            if (attributes != null) {
                this.showGroups = this.parseBooleanAttribute(attributes, "showgroup");
                this.showInput = this.parseBooleanAttribute(attributes, "showinput");
                this.showLabels = this.parseBooleanAttribute(attributes, "showlabel");
                this.useRandomRowOrder = this.parseBooleanAttribute(attributes, "randomized");
                if (this.useRandomRowOrder) {
                    this.rowOrderList = (ArrayList)(attributes != null ? attributes.getAttribute("randomizedroworder") : null);
                }
            }
            this.extractBorderStyle();
            this.extractPagebreakOption();
            boolean forceRowUpdate = this.computeColumnWidths();
            this.adjustAlignment();
            this.layoutRows(forceRowUpdate);
            this.alignRows();
            this.addNavigationLinks();
            super.layoutView();
        }
        this.mutable = !this.isEntirelyResizable();
    }

    private void extractPagebreakOption() throws WmiNoReadAccessException {
        Object value;
        WmiAttributeSet attributes = this.getModel().getAttributesForRead();
        Object object = value = attributes != null ? attributes.getAttribute("pagebreak") : null;
        if (value != null) {
            String strValue = value.toString();
            this.pagebreak = strValue.equals("row") ? 1 : (strValue.equals("cell") ? 2 : 0);
        }
    }

    private void extractBorderStyle() throws WmiNoReadAccessException {
        Object value;
        WmiAttributeSet attributes = this.getModel().getAttributesForRead();
        Object object = value = attributes != null ? attributes.getAttribute("exterior") : null;
        if (value != null) {
            String strValue = value.toString();
            if (strValue.equals("all")) {
                this.borders = 15;
            } else if (strValue.equals("none")) {
                this.borders = 0;
            } else if (strValue.equals("left")) {
                this.borders = 1;
            } else if (strValue.equals("top")) {
                this.borders = 2;
            } else if (strValue.equals("right")) {
                this.borders = 4;
            } else if (strValue.equals("bottom")) {
                this.borders = 8;
            } else if (strValue.equals("horizontal")) {
                this.borders = 10;
            } else if (strValue.equals("vertical")) {
                this.borders = 5;
            }
        }
    }

    private boolean parseBooleanAttribute(WmiAttributeSet attributes, String name) {
        Object value;
        boolean set = true;
        Object object = value = attributes != null ? attributes.getAttribute(name) : null;
        if (value instanceof Boolean) {
            set = value.equals(Boolean.TRUE);
        } else if (value != null) {
            set = value.toString().equals("true");
        }
        return set;
    }

    private boolean computeColumnWidths() throws WmiNoReadAccessException {
        boolean columnWidthChange = false;
        int size = this.getChildCount();
        int totalWidth = ((WmiTableModel)this.getModel()).getAdjustedWidth(this.getZoomFactor(), this.getLinebreakWidth());
        int widthTally = 0;
        this.columns = 0;
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_COLUMN) {
                widthTally += ((WmiTableColumnView)childView).getProportionalWidth();
                ++this.columns;
            }
            ++i;
        }
        if (this.columnWidth == null || this.columns != this.columnWidth.length) {
            this.columnWidth = new int[this.columns];
            columnWidthChange = true;
        }
        int n = 0;
        double exactTally = 0.0;
        int roundTally = 0;
        int i2 = 0;
        while (i2 < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i2);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_COLUMN) {
                double exact = (double)(totalWidth * ((WmiTableColumnView)childView).getProportionalWidth()) / ((double)widthTally * 1.0);
                if (exact < 11.0) {
                    exact = 11.0;
                }
                int w = (int)Math.round((exactTally += exact) - (double)roundTally);
                roundTally += w;
                ((WmiTableColumnView)childView).setWidth(w);
                ((WmiTableColumnView)childView).layoutView();
                if (w != this.columnWidth[n]) {
                    columnWidthChange = true;
                    this.columnWidth[n] = w;
                }
                ++n;
            }
            ++i2;
        }
        this.width = totalWidth;
        return columnWidthChange;
    }

    private void adjustAlignment() throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiAttributeSet attributes = model.getAttributesForRead();
        Object value = attributes.getAttribute("alignment");
        if (value != null) {
            if (value.equals("center")) {
                int breakWidth = this.getLinebreakWidth();
                if (breakWidth > this.width) {
                    this.leftIndent = (breakWidth - this.width) / 2;
                    this.width += this.leftIndent;
                } else {
                    this.leftIndent = 0;
                }
            } else if (value.equals("right")) {
                int breakWidth = this.getLinebreakWidth();
                if (breakWidth > this.width) {
                    this.leftIndent = breakWidth - this.width;
                    this.width = breakWidth;
                } else {
                    this.leftIndent = 0;
                }
            } else {
                this.leftIndent = 0;
            }
        }
    }

    private void alignRows() {
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiTableRowView) {
                ((WmiTableRowView)child).setHorizontalOffset(this.leftIndent);
            }
            ++i;
        }
    }

    private void layoutRows(boolean forceUpdate) throws WmiNoReadAccessException {
        if (this.rowBuilder == null || this.rowBuilder.length <= this.getColumnCount()) {
            this.rowBuilder = new WmiTableCellView[this.getColumnCount() + 1];
        } else {
            Arrays.fill(this.rowBuilder, null);
        }
        if (this.multiRowCells != null) {
            this.multiRowCells.clear();
        }
        int size = this.getChildCount();
        this.rows = 0;
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                WmiTableRowView row = (WmiTableRowView)childView;
                if (!this.useRandomRowOrder) {
                    row.setRow(this.rows++);
                } else {
                    row.setRow(this.rowOrderList.indexOf(new Integer(this.rows++)));
                }
                if (forceUpdate) {
                    this.getDocumentView().invalidateAll(row);
                }
                row.layoutView();
            }
            ++i;
        }
        this.computeVerticalLayout();
        if (this.multiRowCells != null && this.multiRowCells.size() > 0 && this.adjustLayoutForRowSpan()) {
            this.computeVerticalLayout();
        }
    }

    private void computeVerticalLayout() {
        this.height = this.getTopMargin();
        int size = this.getChildCount();
        if (this.rowHeight == null || this.rows != this.rowHeight.length) {
            this.rowHeight = new int[this.rows];
        }
        int offset = this.getChildCount() - this.getRowCount();
        int n = 0;
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                if (this.useRandomRowOrder) {
                    childView = this.getChild(offset + (Integer)this.rowOrderList.get(n));
                }
                int h = ((WmiTableRowView)childView).getHeight();
                this.rowHeight[n++] = h;
                this.height += h;
            }
            ++i;
        }
        int rowOffset = this.getTopMargin();
        n = 0;
        i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                if (this.useRandomRowOrder) {
                    childView = this.getChild(offset + (Integer)this.rowOrderList.get(n));
                }
                ((WmiTableRowView)childView).setVerticalOffset(rowOffset);
                rowOffset += this.rowHeight[n++];
            }
            ++i;
        }
        this.height += this.getBottomMargin();
    }

    public int getColumnWidth(int column) {
        int w = 0;
        if (this.columnWidth != null && this.columnWidth.length > column && column >= 0) {
            w = this.columnWidth[column];
        }
        return w;
    }

    public int getRowHeight(int row) {
        int h = 0;
        if (this.rowHeight != null && this.rowHeight.length > row && row >= 0) {
            h = this.rowHeight[row];
        }
        return h;
    }

    public WmiTableCellView getActiveCell(int column) {
        return this.rowBuilder != null && column < this.columns ? this.rowBuilder[column] : null;
    }

    public void setActiveCell(int column, WmiTableCellView cell) {
        int rowspan;
        if (this.rowBuilder != null && column < this.columns) {
            this.rowBuilder[column] = cell;
        }
        int n = rowspan = cell == null ? 1 : cell.getRowSpan();
        if (rowspan > 1) {
            if (this.multiRowCells == null) {
                this.multiRowCells = new ArrayList();
            }
            this.multiRowCells.add(cell);
        }
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getRowCount() {
        return this.rows;
    }

    public WmiTableColumnView getColumn(int columnIndex) {
        WmiTableColumnView view = null;
        int size = this.getChildCount();
        int index = 0;
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_COLUMN) {
                if (index == columnIndex) {
                    view = (WmiTableColumnView)childView;
                    break;
                }
                ++index;
            }
            ++i;
        }
        return view;
    }

    public WmiTableCellView findCell(int row, int column) {
        WmiView child;
        WmiView cell = null;
        int size = this.getChildCount();
        WmiArrayCompositeView rowView = null;
        int i = 0;
        while (i < size) {
            child = this.getChild(i);
            if (child instanceof WmiTableRowView && ((WmiTableRowView)child).getRow() == row) {
                rowView = (WmiTableRowView)child;
                break;
            }
            ++i;
        }
        if (rowView != null) {
            size = rowView.getChildCount();
            i = 0;
            while (i < size) {
                child = (WmiTableCellView)rowView.getChild(i);
                if (((WmiTableCellView)child).getColumnIndex() == column) {
                    cell = child;
                    break;
                }
                ++i;
            }
        }
        return cell;
    }

    public void getExtremeBounds(int[] bounds) {
        if (bounds == null || bounds.length < 4) {
            throw new IllegalArgumentException("WmiTableView.getExtremeBounds argument must have length at least 4");
        }
        bounds[0] = 0;
        bounds[1] = 0;
        int size = this.getChildCount();
        WmiArrayCompositeView rowView = null;
        int rowNumber = 0;
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiTableRowView && ((WmiTableRowView)child).getRow() >= rowNumber) {
                rowView = (WmiTableRowView)child;
                rowNumber = ((WmiTableRowView)child).getRow();
            }
            ++i;
        }
        int columnNumber = 0;
        if (rowView != null) {
            size = rowView.getChildCount();
            int i2 = 0;
            while (i2 < size) {
                WmiTableCellView child = (WmiTableCellView)rowView.getChild(i2);
                if (child.getColumnIndex() >= columnNumber) {
                    columnNumber = child.getColumnIndex();
                }
                ++i2;
            }
        }
        bounds[2] = rowNumber;
        bounds[3] = columnNumber;
    }

    public WmiTableCellView findLastCell() {
        WmiTableCellView cell = null;
        int size = this.getChildCount();
        WmiArrayCompositeView rowView = null;
        int rowNumber = -1;
        int i = 0;
        while (i < size) {
            WmiView child = this.getChild(i);
            if (child instanceof WmiTableRowView && ((WmiTableRowView)child).getRow() > rowNumber) {
                rowView = (WmiTableRowView)child;
                rowNumber = ((WmiTableRowView)child).getRow();
            }
            ++i;
        }
        if (rowView != null) {
            size = rowView.getChildCount();
            int columnNumber = -1;
            int i2 = 0;
            while (i2 < size) {
                WmiTableCellView child = (WmiTableCellView)rowView.getChild(i2);
                if (child.getColumnIndex() > columnNumber) {
                    cell = child;
                    columnNumber = child.getColumnIndex();
                }
                ++i2;
            }
        }
        return cell;
    }

    private boolean adjustLayoutForRowSpan() {
        int j;
        boolean resize = false;
        int i = 0;
        while (i < this.multiRowCells.size()) {
            WmiTableCellView cell = (WmiTableCellView)this.multiRowCells.get(i);
            int currentHeight = 0;
            int span = cell.getRowSpan();
            int index = cell.getRowIndex();
            int j2 = 0;
            while (j2 < span) {
                currentHeight += this.rowHeight[index + j2];
                ++j2;
            }
            int cellHeight = cell.getHeight();
            if (currentHeight < cellHeight) {
                j = 0;
                while (j < span) {
                    this.rowHeight[index + j] = Math.round((float)this.rowHeight[index + j] * (float)cellHeight / (float)currentHeight);
                    resize = true;
                    ++j;
                }
            }
            ++i;
        }
        int size = this.getChildCount();
        int n = 0;
        i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                ((WmiTableRowView)childView).setHeight(this.rowHeight[n++]);
            }
            ++i;
        }
        i = 0;
        while (i < this.multiRowCells.size()) {
            WmiTableCellView cell = (WmiTableCellView)this.multiRowCells.get(i);
            int currentHeight = 0;
            int span = cell.getRowSpan();
            int index = cell.getRowIndex();
            j = 0;
            while (j < span) {
                currentHeight += this.rowHeight[index + j];
                ++j;
            }
            cell.setHeight(currentHeight);
            ++i;
        }
        return resize;
    }

    public int getTopMargin() {
        return 4;
    }

    public int getBottomMargin() {
        return 4;
    }

    public int getLeftMargin() {
        return this.leftIndent;
    }

    public int getLinebreakWidth() {
        int breakWidth = 400;
        WmiCompositeView parent = null;
        WmiTableCellView cell = (WmiTableCellView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE_CELL);
        if (cell != null) {
            breakWidth = cell.getBreakWidth();
        } else {
            breakWidth = this.getDocumentView().getBreakWidth();
            parent = this.getParentView();
            while (parent != null) {
                if (parent instanceof WmiRowView) {
                    breakWidth -= ((WmiRowView)parent).getLeftIndent();
                    breakWidth -= ((WmiRowView)parent).getRightIndent();
                }
                parent = parent.getParentView();
            }
        }
        return breakWidth;
    }

    public boolean hasFocus() {
        return focusedTable == this;
    }

    public boolean isInputVisible() {
        return this.showInput;
    }

    public boolean isGroupBracketVisible() {
        return this.showGroups;
    }

    public boolean isGroupLabelVisible() {
        return this.showLabels;
    }

    public boolean allowRowBreak() {
        return this.pagebreak != 0;
    }

    public boolean allowCellBreak() {
        return this.pagebreak == 2;
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView[] rowViews = new WmiPositionedView[this.rows];
        int size = this.getChildCount();
        int n = 0;
        int i = 0;
        while (i < size) {
            WmiModelTag childTag;
            WmiView childView = this.getChild(i);
            WmiModel childModel = childView != null ? childView.getModel() : null;
            WmiModelTag wmiModelTag = childTag = childModel != null ? childModel.getTag() : null;
            if (childTag == WmiModelTag.TABLE_ROW) {
                rowViews[n++] = (WmiTableRowView)childView;
            }
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            WmiPositionedView next;
            WmiPositionedView child = rowViews[i];
            if (i < this.rows - 1) {
                next = rowViews[i + 1];
                child.setNextView(next, 1);
                child.setNextView(next, 3);
            }
            if (i > 0) {
                next = rowViews[i - 1];
                child.setNextView(next, 0);
                child.setNextView(next, 2);
            }
            ++i;
        }
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        WmiPositionedView view = null;
        WmiPositionedView closestView = null;
        int minError = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.length) {
            int dy = 0;
            int dx = 0;
            int error = 0;
            WmiView child = this.getChild(i);
            if (child instanceof WmiTableRowView) {
                WmiTableRowView rowView = (WmiTableRowView)child;
                pt.x -= rowView.getHorizontalOffset();
                pt.y -= rowView.getVerticalOffset();
                int rowSize = rowView.getChildCount();
                int j = 0;
                while (j < rowSize) {
                    WmiPositionedView cell = (WmiPositionedView)((WmiCompositeView)child).getChild(j);
                    Rectangle cellBounds = cell.getBounds();
                    if (cellBounds != null && cellBounds.contains(pt)) {
                        view = cell;
                        break;
                    }
                    if (cellBounds.x > pt.x) {
                        dx = cellBounds.x - pt.x;
                    } else if (cellBounds.x + cellBounds.width < pt.x) {
                        dx = pt.x - cellBounds.x - cellBounds.width;
                    }
                    if (cellBounds.y > pt.y) {
                        dy = cellBounds.y - pt.y;
                    } else if (cellBounds.y + cellBounds.height < pt.y) {
                        dy = pt.y - cellBounds.y - cellBounds.height;
                    }
                    error = dx * dx + dy * dy;
                    if (error < minError) {
                        minError = error;
                        closestView = cell;
                    }
                    ++j;
                }
                pt.x += rowView.getHorizontalOffset();
                pt.y += rowView.getVerticalOffset();
                if (view != null) break;
            }
            ++i;
        }
        if (view == null) {
            view = closestView;
        }
        return view;
    }

    public void extendRangeForSpanningCells(WmiRowColumnRange range) {
        boolean done = false;
        while (!done) {
            done = true;
            int r = 0;
            while (r <= this.getRowCount()) {
                int c = 0;
                while (c <= this.getColumnCount()) {
                    WmiTableCellView cell = this.findCell(r, c);
                    if (cell != null) {
                        int rowIndex = cell.getRowIndex();
                        int columnIndex = cell.getColumnIndex();
                        int rowSpan = cell.getRowSpan();
                        int columnSpan = cell.getColumnSpan();
                        if ((columnSpan > 1 || rowSpan > 1) && rowIndex + rowSpan - 1 >= range.startRow && rowIndex <= range.endRow && columnIndex + columnSpan - 1 >= range.startColumn && columnIndex <= range.endColumn) {
                            if (range.startRow > rowIndex) {
                                range.startRow = rowIndex;
                                done = false;
                            }
                            if (range.endRow < rowIndex + rowSpan - 1) {
                                range.endRow = rowIndex + rowSpan - 1;
                                done = false;
                            }
                            if (range.startColumn > columnIndex) {
                                range.startColumn = columnIndex;
                                done = false;
                            }
                            if (range.endColumn < columnIndex + columnSpan - 1) {
                                range.endColumn = columnIndex + columnSpan - 1;
                                done = false;
                            }
                        }
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private boolean isEntirelyResizable() throws WmiNoReadAccessException {
        int childCount = this.getChildCount();
        boolean resizable = true;
        int i = 0;
        while (i < childCount) {
            WmiView row = this.getChild(i);
            if (row.getModel().getTag() == WmiModelTag.TABLE_ROW) {
                WmiTableRowView rowView = (WmiTableRowView)row;
                int i2 = 0;
                while (i2 < rowView.getChildCount()) {
                    WmiView cell = rowView.getChild(i2);
                    if (cell.getModel().getTag() == WmiModelTag.TABLE_CELL) {
                        WmiCompositeView comp = (WmiCompositeView)cell;
                        if (comp.getChildCount() > 1) {
                            resizable = false;
                            break;
                        }
                        if (comp.getChildCount() == 1 && !(comp.getChild(0) instanceof WmiResizableContainerView)) {
                            resizable = false;
                            break;
                        }
                    }
                    ++i2;
                }
            }
            ++i;
        }
        return resizable;
    }

    public class WmiRowColumnRange {
        public int startRow;
        public int startColumn;
        public int endRow;
        public int endColumn;

        public WmiRowColumnRange(int startRow, int startColumn, int endRow, int endColumn) {
            this.startRow = startRow;
            this.startColumn = startColumn;
            this.endRow = endRow;
            this.endColumn = endColumn;
        }
    }
}

