/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.awt.Font;

public class WmiTextFragmentView
extends WmiTextView {
    protected int startOffset;
    protected int endOffset;

    public WmiTextFragmentView(WmiModel model, WmiMathDocumentView docView, int start, int end) throws WmiNoReadAccessException {
        super(model, docView);
        this.startOffset = start;
        this.endOffset = end;
        this.markInvalid(2);
        this.layoutView();
    }

    public WmiTextFragmentView(WmiModel model, WmiMathDocumentView docView, int start) throws WmiNoReadAccessException {
        super(model, docView);
        this.startOffset = start;
        this.endOffset = this.getLength();
        this.markInvalid(2);
        this.layoutView();
    }

    public WmiTextFragmentView(WmiTextView source, WmiMathDocumentView docView) throws WmiNoReadAccessException {
        super(source.getModel(), docView);
        this.startOffset = source.getStartOffset();
        this.endOffset = source.getEndOffset();
        this.layout = source.layout;
        this.attributes = source.attributes;
    }

    public static WmiTextView[] splitTextView(WmiTextView text, int offset, int consume) throws WmiNoReadAccessException {
        WmiTextLayout rightLayout;
        WmiMathDocumentView docView = text.getDocumentView();
        WmiTextFragmentView left = new WmiTextFragmentView(text, docView);
        WmiTextFragmentView right = left.splitFragmentView(offset, consume);
        WmiTextLayout wmiTextLayout = rightLayout = right != null ? right.getLayout() : null;
        if (rightLayout != null && rightLayout.getWidth() == 0) {
            right.layout = null;
        }
        WmiTextView[] views = new WmiTextView[]{left, right};
        left.markInvalid(1);
        right.markInvalid(1);
        return views;
    }

    private WmiTextFragmentView splitFragmentView(int offset, int consume) throws WmiNoReadAccessException {
        WmiTextFragmentView fragment = new WmiTextFragmentView(this, this.getDocumentView());
        fragment.layout = this.layout != null ? this.layout.splitLayout(offset, consume) : null;
        this.endOffset = this.startOffset + offset;
        fragment.startOffset = this.endOffset + consume;
        if (fragment.endOffset < fragment.startOffset) {
            fragment.startOffset = fragment.endOffset;
        }
        fragment.markInvalid(1);
        this.markInvalid(1);
        return fragment;
    }

    @Override
    public String getText() throws WmiNoReadAccessException {
        String str = null;
        WmiModel m = this.getModel();
        if (m instanceof WmiTextModel) {
            try {
                str = ((WmiTextModel)m).getSubstring(this.startOffset, this.endOffset - this.startOffset);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        return str;
    }

    @Override
    public void insertString(String str, int offset) {
        super.insertString(str, offset += this.startOffset);
    }

    @Override
    public void delete(int offset, int length) {
        super.delete(offset += this.startOffset, length);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiModel model = this.getModel();
            boolean forPrint = this.getDocumentView().isPrintView();
            this.attributes = (WmiFontAttributeSet)model.getAttributesForRead();
            int zoom = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(this.attributes, zoom, forPrint);
            boolean superscript = this.attributes.isSuperscript();
            boolean subscript = this.attributes.isSubscript();
            if (this.layout == null && !this.isContentValid()) {
                String str = this.getText();
                if (str != null && str.length() > 0) {
                    boolean isMath = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH) != null;
                    this.layout = WmiTextLayout.createTextLayout(str, font, this.getDocumentView(), isMath);
                }
                this.markValid(2);
            }
            if (this.layout != null) {
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else {
                this.width = this.getEmptyTextWidth();
                WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
                this.baseline = metrics.getFontProperty(0, forPrint) + metrics.getFontProperty(3, forPrint);
                this.height = this.baseline + metrics.getFontProperty(4, forPrint);
            }
            this.baselineAdjust = 0;
            if (superscript) {
                this.baselineAdjust -= Math.round((float)this.height * 0.5f);
                this.height -= this.baselineAdjust;
                this.baseline -= this.baselineAdjust;
            } else if (subscript) {
                this.baselineAdjust += Math.round((float)this.height * 0.35f);
                this.height += this.baselineAdjust;
            }
            this.markValid(1);
        }
    }
}

