/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.WmiViewlessPositionMarker;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathPhantomView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class WmiFractionView
extends WmiArrayCompositeView
implements WmiTraversableView {
    private static final int ALIGN_CENTER = 0;
    private static final int ALIGN_LEFT = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final Stroke DEFAULT_PRINT_STROKE = new BasicStroke(0.5f);
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke ZOOM_STROKE = new BasicStroke(2.0f);
    private static final Stroke MARKER_STROKE = new BasicStroke(2.0f);
    private static final Stroke ZOOM_MARKER_STROKE = new BasicStroke(3.0f);
    private static final WmiAlignCalculation[] ALIGNMENT_CALCULATORS = new WmiAlignCalculation[]{new WmiCenterAlignment(), new WmiLeftAlignment(), new WmiRightAlignment()};
    public static final int FRACTION_VIEW_SIZE = 2;
    public static final int NUMERATOR_INDEX = 0;
    public static final int DENOMINATOR_INDEX = 1;
    private static final int BEVELLED_PADDING_TERM = 2;
    private static final int FRACTION_VERTICAL_PADDING_TERM = 1;
    private static final int FRACTION_HORIZONTAL_PADDING_TERM = 2;
    private static final float BASELINE_SCALE_FACTOR = 0.35f;
    private static final int THRESHOLD_ZOOM_FACTOR = 250;
    private static final int EMPTY_FRACTION_BAR_WIDTH = 5;
    private static final float LEADING_RATIONAL_CONVERT_THRESHOLD = 0.5f;
    private Color foreground = null;
    private int linethickness = 1;
    private Stroke lineStroke = null;
    private int baselineShift = 0;
    private boolean inLeadRationalLinebreak = false;
    WmiFractionBarView bar = null;

    public WmiFractionView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.inLeadRationalLinebreak = false;
    }

    private WmiFractionView(WmiModel model, WmiView numerator, WmiView bar, WmiView denominator, WmiMathDocumentView docView) {
        super(model, docView);
        this.children = new WmiView[2];
        this.children[0] = numerator;
        this.children[1] = denominator;
        this.bar = (WmiFractionBarView)bar;
        this.inLeadRationalLinebreak = true;
        this.length = 2;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            this.layoutStackOrInline();
            super.layoutView();
        }
    }

    private void layoutStackOrInline() {
        try {
            WmiAttributeSet set;
            WmiModel model = this.getModel();
            if (this.bar == null) {
                this.bar = new WmiFractionBarView(model, this.getDocumentView());
            }
            WmiFontAttributeSet attributes = (set = model.getAttributesForRead()) instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)set : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
            int numeratorAlignment = 0;
            int denominatorAlignment = 0;
            boolean bevelled = false;
            int zoom = this.getCorrectedZoomFactor();
            if (set instanceof WmiFractionModel.WmiFractionAttributeSet) {
                WmiFractionModel.WmiFractionAttributeSet fset = (WmiFractionModel.WmiFractionAttributeSet)set;
                String numAlign = (String)fset.getAttribute("numalign");
                String denomAlign = (String)fset.getAttribute("denomalign");
                numeratorAlignment = this.mapAlignment(numAlign);
                denominatorAlignment = this.mapAlignment(denomAlign);
                this.linethickness = fset.getLineThickness();
                bevelled = fset.isBevelled();
                if (this.linethickness != 1) {
                    int thickness = this.linethickness;
                    if (zoom > 250) {
                        ++thickness;
                    }
                    this.lineStroke = new BasicStroke(thickness);
                } else {
                    this.lineStroke = null;
                }
            }
            boolean forPrint = this.getDocumentView().isPrintView();
            Font font = WmiFontResolver.getFont(attributes, zoom, forPrint);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            int fontHeight = metrics.getFontProperty(5, forPrint);
            int fontWidth = metrics.getFontProperty(2, forPrint);
            this.baselineShift = Math.round(0.35f * (float)fontHeight);
            WmiPositionedView numerator = (WmiPositionedView)this.getChild(0);
            numerator.layoutView();
            WmiPositionedView denominator = (WmiPositionedView)this.getChild(1);
            denominator.layoutView();
            if (bevelled) {
                this.configureViewsForBevelled(numerator, this.bar, denominator);
            } else {
                this.configureViewsForFraction(numerator, this.bar, denominator, numeratorAlignment, denominatorAlignment, fontHeight, fontWidth);
            }
            this.foreground = new Color(attributes.getForeground());
            this.addNavigationLinks();
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    private void configureViewsForBevelled(WmiPositionedView numerator, WmiPositionedView bar, WmiPositionedView denominator) {
        this.height = numerator.getHeight();
        if (this.height < denominator.getHeight()) {
            this.height = denominator.getHeight();
        }
        bar.setHeight(this.height);
        int barWidth = this.height / 2;
        bar.setWidth(barWidth);
        numerator.setHorizontalOffset(0);
        int numeratorWidth = numerator.getWidth();
        bar.setHorizontalOffset(numeratorWidth + 2);
        denominator.setHorizontalOffset(numeratorWidth + barWidth + 4);
        this.width = barWidth + numeratorWidth + denominator.getWidth() + 4;
        this.baseline = numerator.getBaseline();
        if (denominator.getBaseline() > this.baseline) {
            this.baseline = denominator.getBaseline();
        }
        numerator.setVerticalOffset(this.baseline - numerator.getBaseline());
        denominator.setVerticalOffset(this.baseline - denominator.getBaseline());
        int barBaseline = numerator.getBaseline() > denominator.getBaseline() ? numerator.getBaseline() : denominator.getBaseline();
        bar.setBaseline(barBaseline);
        bar.setVerticalOffset(this.baseline - bar.getBaseline());
        ((WmiFractionBarView)bar).setBevelled(true);
    }

    private void configureViewsForFraction(WmiPositionedView numerator, WmiPositionedView bar, WmiPositionedView denominator, int numeratorAlignment, int denominatorAlignment, int fontHeight, int fontWidth) {
        int numeratorWidth = numerator.getWidth();
        int denominatorWidth = denominator.getWidth();
        int numeratorHeight = numerator.getHeight();
        int denominatorHeight = denominator.getHeight();
        if (numeratorHeight < fontHeight) {
            numeratorHeight = fontHeight;
        }
        this.width = numeratorWidth > denominatorWidth ? numeratorWidth : denominatorWidth;
        if (this.linethickness > 0) {
            this.width += fontWidth / 3;
            if (this.fractionPadding(numerator) || this.fractionPadding(denominator)) {
                this.width += fontWidth;
            }
        }
        int numeratorHOffs = ALIGNMENT_CALCULATORS[numeratorAlignment].calculateHOffset(this.width, numeratorWidth);
        numerator.setHorizontalOffset(numeratorHOffs);
        int denominatorHOffs = ALIGNMENT_CALCULATORS[denominatorAlignment].calculateHOffset(this.width, denominatorWidth);
        denominator.setHorizontalOffset(denominatorHOffs);
        this.baseline = numeratorHeight + this.baselineShift;
        if (numerator instanceof WmiMathPhantomView || denominator instanceof WmiMathPhantomView) {
            this.baseline = numerator.getBaseline();
        }
        bar.setHorizontalOffset(0);
        bar.setVerticalOffset(numeratorHeight + 1);
        bar.setWidth(this.width);
        bar.setHeight(this.linethickness);
        int denominatorOffset = numeratorHeight + this.linethickness + 2 - 1;
        denominator.setVerticalOffset(denominatorOffset);
        ((WmiFractionBarView)bar).setBevelled(false);
        this.height = denominatorOffset + denominatorHeight;
    }

    private boolean fractionPadding(WmiPositionedView view) {
        boolean extraPadding = false;
        if (view instanceof WmiFractionView) {
            extraPadding = true;
        }
        return extraPadding;
    }

    private int mapAlignment(String input) {
        int alignment = 0;
        if (input.equals("left")) {
            alignment = 1;
        } else if (input.equals("right")) {
            alignment = 2;
        }
        return alignment;
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView numerator = (WmiPositionedView)this.getChild(0);
        WmiPositionedView denominator = (WmiPositionedView)this.getChild(1);
        if (this.bar.isBevelled()) {
            numerator.setNextView(denominator, 3);
            numerator.setNextView(null, 1);
            denominator.setNextView(numerator, 2);
            denominator.setNextView(null, 0);
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(numerator, -4);
            this.setNextView(denominator, -3);
        } else {
            numerator.setNextView(denominator, 1);
            numerator.setNextView(null, 3);
            numerator.setNextView(null, 2);
            denominator.setNextView(numerator, 0);
            denominator.setNextView(null, 2);
            denominator.setNextView(null, 3);
            this.setNextView(numerator, -2);
            this.setNextView(denominator, -1);
            this.setNextView(numerator, -4);
            this.setNextView(denominator, -3);
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            view = this.getNearestChildView(pt);
        }
        return view;
    }

    protected int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int zoom = this.getZoomFactor();
        boolean scriptSize = false;
        WmiModel model = this.getModel();
        WmiCompositeModel parent = model.getParent();
        while (parent instanceof WmiMathModel) {
            scriptSize = ((WmiMathModel)((Object)parent)).useScriptSize(model);
            if (scriptSize) {
                zoom = Math.round((float)zoom * 0.8f);
                break;
            }
            model = parent;
            parent = model.getParent();
        }
        return zoom;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
        path.push(this.getHorizontalOffset(), this.getVerticalOffset());
        if (this.bar != null) {
            this.bar.draw(g, path, bounds);
        }
        path.pop();
    }

    public WmiFractionBarView getBar() {
        return this.bar;
    }

    @Override
    public void setPositionMarker(int offset) {
        WmiMathCaret.setBoundaryCaret(this, offset);
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, 1);
    }

    @Override
    public int getTraversalType() {
        return 6;
    }

    @Override
    public int getOffset(Point pt) {
        return 0;
    }

    @Override
    public int getTraversableCount() {
        return 2;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        if (this.bar.isBevelled()) {
            WmiInlineView inline = this.convertToInline();
            WmiCompositeView parent = this.getParentView();
            int index = parent.indexOf(this);
            if (index >= 0) {
                parent.replaceChild(inline, index);
                inline.setParentView(parent);
                success = inline.doImplicitLinebreak(paragraph, horizontalOffset, breakWidth, thresholdCost);
            }
        } else if (thresholdCost != 0 || this.getWidth() > breakWidth) {
            WmiPositionedView numerator = (WmiPositionedView)this.getChild(0);
            WmiPositionedView denominator = (WmiPositionedView)this.getChild(1);
            boolean convertToLeadingRational = false;
            if ((float)denominator.getWidth() < 0.5f * (float)breakWidth && numerator instanceof WmiCompositeView) {
                convertToLeadingRational = true;
            }
            if (convertToLeadingRational) {
                WmiInlineView inline;
                if (WmiFractionView.areBracketsRequired(numerator.getModel())) {
                    numerator = WmiFractionView.addBrackets(numerator);
                }
                if ((inline = this.convertToLeadingRationalInline()) != null) {
                    success = 1;
                }
            } else {
                if (WmiFractionView.areBracketsRequired(numerator.getModel())) {
                    numerator = WmiFractionView.addBrackets(numerator);
                }
                if (WmiFractionView.areBracketsRequired(denominator.getModel())) {
                    denominator = WmiFractionView.addBrackets(denominator);
                }
                this.configureViewsForBevelled(numerator, this.bar, denominator);
                success = 1;
            }
        }
        return success;
    }

    private WmiInlineView convertToInline() throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiMathDocumentView docView = this.getDocumentView();
        WmiInlineView inline = new WmiInlineView(model, docView);
        inline.releaseObserver();
        WmiPositionedView numerator = (WmiPositionedView)this.getChild(0);
        WmiPositionedView denominator = (WmiPositionedView)this.getChild(1);
        inline.appendView(this.createPaddedView(numerator));
        inline.appendView(this.bar);
        inline.appendView(this.createPaddedView(denominator));
        inline.layoutView();
        return inline;
    }

    private WmiInlineView convertToLeadingRationalInline() throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiAttributeSet attributes = model.getAttributesForRead();
        WmiMathDocumentView docView = this.getDocumentView();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiInlineView inline = new WmiInlineView(model, docView);
        inline.releaseObserver();
        WmiPositionedView numerator = (WmiPositionedView)this.getChild(0);
        WmiPositionedView denominator = (WmiPositionedView)this.getChild(1);
        WmiCompositeModel wrapper = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
        WmiAttributeSet set = wrapper != null ? wrapper.getAttributesForRead() : null;
        String styleName = set != null ? (String)set.getAttribute("font_style_name") : null;
        WmiMathContext context = new WmiMathContext(docModel.getFontStyle(styleName));
        WmiNumericModel one = new WmiNumericModel(docModel, "1", "1", context);
        WmiMathTextView oneView = new WmiMathTextView(one, docView);
        oneView.setParentView(this);
        oneView.layoutView();
        boolean forPrint = this.getDocumentView().isPrintView();
        int zoom = this.getCorrectedZoomFactor();
        Font font = WmiFontResolver.getFont((WmiFontAttributeSet)attributes, zoom, forPrint);
        WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
        int fontHeight = metrics.getFontProperty(5, forPrint);
        int fontWidth = metrics.getFontProperty(2, forPrint);
        this.replaceChild(oneView, 0);
        this.markInvalid(1);
        this.configureViewsForFraction(oneView, this.bar, denominator, 0, 0, fontHeight, fontWidth);
        WmiCompositeView parent = this.getParentView();
        int index = parent.indexOf(this);
        if (index >= 0) {
            inline.appendView(this);
            inline.appendView(numerator);
            this.setParentView(inline);
            numerator.setParentView(inline);
            parent.replaceChild(inline, index);
            inline.setParentView(parent);
        }
        inline.layoutView();
        parent = inline.getParentView();
        while (!(parent instanceof WmiParagraphView)) {
            parent.markInvalid(1);
            parent = parent.getParentView();
        }
        return inline;
    }

    private WmiInlineView createPaddedView(WmiPositionedView view) throws WmiNoReadAccessException {
        WmiInlineView inline = new WmiInlineView(view.getModel(), view.getDocumentView());
        inline.releaseObserver();
        inline.appendView(view);
        inline.setBaselineAdjustment(this.getBaseline() - view.getVerticalOffset() - view.getBaseline());
        inline.layoutView();
        return inline;
    }

    /* synthetic */ WmiFractionView(WmiModel wmiModel, WmiView wmiView, WmiView wmiView2, WmiView wmiView3, WmiMathDocumentView wmiMathDocumentView, WmiFractionView wmiFractionView) {
        this(wmiModel, wmiView, wmiView2, wmiView3, wmiMathDocumentView);
    }

    protected static class FractionBarMarker
    extends WmiViewlessPositionMarker {
        private WmiFractionBarView view;
        private boolean visible = false;

        protected FractionBarMarker(WmiFractionBarView view) {
            this.view = view;
        }

        @Override
        public Rectangle getBounds() {
            Rectangle bounds = null;
            if (this.view != null) {
                Point pt = WmiViewUtil.getAbsoluteOffset(this.view);
                bounds = new Rectangle(pt.x, pt.y, this.view.getWidth(), this.view.getHeight());
            }
            return bounds;
        }

        @Override
        public WmiModelPosition getModelPosition() {
            WmiModelPosition position = null;
            if (this.view != null) {
                WmiModel model = this.view.getModel();
                position = new WmiModelPosition(model, this.getOffset());
            }
            return position;
        }

        @Override
        public WmiViewPath getViewPath() throws WmiNoReadAccessException {
            return this.view != null ? new WmiViewPath(this.view) : null;
        }

        @Override
        public void hide() {
            this.visible = false;
            this.repaint();
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void resync() throws WmiNoReadAccessException {
            this.show();
        }

        @Override
        public void show() {
            WmiMathDocumentView docView;
            this.visible = true;
            if (this.view != null && (docView = this.view.getDocumentView()) != null) {
                docView.setFocusedView(this.view);
            }
            this.repaint();
        }

        @Override
        public void updateMarkerPosition(WmiModel model, int offset) throws WmiNoReadAccessException {
        }

        @Override
        public WmiPositionedView getView() {
            return this.view;
        }

        @Override
        public int getOffset() {
            return 0;
        }

        @Override
        public boolean isReadOnly() throws WmiNoReadAccessException {
            return true;
        }

        protected void repaint() {
            if (this.view != null) {
                WmiMathDocumentView docView = this.view.getDocumentView();
                Rectangle bounds = this.getBounds();
                docView.repaint(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
            }
        }
    }

    public static class LeadingRationalView
    extends WmiInlineView {
        public LeadingRationalView(WmiModel model, WmiView numerator, WmiView bar, WmiView denominator, WmiMathDocumentView docView) {
            super(model, docView);
            try {
                WmiFractionModel fracModel = (WmiFractionModel)model;
                WmiFractionModel innerFracModel = WmiFractionModel.createDenominatorModel(fracModel);
                WmiMathTextView innerNumerator = new WmiMathTextView(innerFracModel.getChild(0), docView);
                WmiFractionView innerFrac = new WmiFractionView(innerFracModel, innerNumerator, bar.copyView(), denominator.copyView(), docView, null);
                this.appendView(innerFrac);
                this.appendView(this.constructInvisibleTimes(numerator));
                this.appendView(numerator.copyView());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                // empty catch block
            }
        }

        public int getLeadWidth() {
            WmiView widthSource = (WmiCompositeView)this.getChild(0);
            widthSource = widthSource.getChild(2);
            return ((WmiPositionedView)widthSource).getWidth();
        }

        private WmiView constructInvisibleTimes(WmiView numerator) throws WmiNoReadAccessException {
            WmiMathOperatorView rView = null;
            WmiModel numModel = numerator.getModel();
            WmiFontAttributeSet attrs = (WmiFontAttributeSet)numModel.getAttributes();
            WmiMathContext context = new WmiMathContext(attrs);
            WmiMathOperatorModel invOp = new WmiMathOperatorModel(numModel.getDocument(), "&InvisibleTimes;", "&InvisibleTimes;", context, numModel.getParent());
            rView = new WmiMathOperatorView(invOp, numerator.getDocumentView());
            return rView;
        }

        @Override
        public void layoutView() throws WmiNoReadAccessException {
            super.layoutView();
            this.height = 0;
            WmiPositionedView leadFrac = (WmiPositionedView)this.getChild(0);
            WmiPositionedView invOp = (WmiPositionedView)this.getChild(1);
            WmiPositionedView numerator = (WmiPositionedView)this.getChild(2);
            int greatestFracWidth = leadFrac.getWidth();
            leadFrac.setVerticalOffset(0);
            leadFrac.setHorizontalOffset(0);
            int opWidth = invOp.getWidth();
            invOp.setHorizontalOffset(greatestFracWidth);
            numerator.setHorizontalOffset(greatestFracWidth + opWidth);
            this.width = greatestFracWidth;
            this.width += opWidth;
            this.width += numerator.getWidth();
        }
    }

    private static interface WmiAlignCalculation {
        public int calculateHOffset(int var1, int var2);
    }

    private static class WmiCenterAlignment
    implements WmiAlignCalculation {
        private WmiCenterAlignment() {
        }

        @Override
        public int calculateHOffset(int fracWidth, int targetWidth) {
            return (fracWidth - targetWidth) / 2;
        }
    }

    public class WmiFractionBarView
    extends WmiGenericView
    implements WmiPositionedView {
        private boolean bevelled;

        public WmiFractionBarView(WmiModel model, WmiMathDocumentView docView) {
            super(model, docView);
            this.bevelled = false;
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.width, WmiFractionView.this.linethickness);
        }

        public void setBevelled(boolean bevelled) {
            this.bevelled = bevelled;
        }

        public boolean isBevelled() {
            return this.bevelled;
        }

        public void addTraversableLinks() {
        }

        @Override
        public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
            Graphics2D g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
            Color saveColor = g.getColor();
            Color drawColor = WmiFractionView.this.foreground;
            WmiSelection selection = path.getSelection();
            WmiHighlightPainter highlighter = selection != null ? selection.getSelectionHighlighter() : null;
            Rectangle[] selectionBounds = null;
            g.setColor(drawColor);
            int horiz = this.getHorizontalOffset() + path.getHorizontalOffset() + 2;
            int vert = this.getVerticalOffset() + path.getVerticalOffset();
            if (highlighter != null) {
                selectionBounds = highlighter.intersect(horiz + path.getHorizontalShift(), vert + path.getVerticalShift(), this.width, this.height);
            }
            WmiMathDocumentView docView = this.getDocumentView();
            if (WmiFractionView.this.linethickness > 0) {
                int width;
                Stroke saveStroke = null;
                if (g2 != null) {
                    saveStroke = g2.getStroke();
                    WmiPositionMarker marker = docView.getPositionMarker();
                    int zoom = this.getZoomFactor();
                    if (marker != null && marker.getView() == this && docView.getSelection() == null) {
                        g2.setStroke(zoom > 250 ? ZOOM_MARKER_STROKE : MARKER_STROKE);
                    } else if (WmiFractionView.this.lineStroke != null) {
                        g2.setStroke(WmiFractionView.this.lineStroke);
                    } else {
                        g2.setStroke(zoom > 250 ? ZOOM_STROKE : (this.getDocumentView().isPrintView() ? DEFAULT_PRINT_STROKE : DEFAULT_STROKE));
                    }
                }
                if ((width = this.getWidth() - 4) == 0) {
                    width = (int)((float)(5 * docView.getZoomFactor()) / 100.0f);
                }
                if (this.bevelled) {
                    g.drawLine(horiz, vert + this.getHeight(), horiz + width, vert);
                } else {
                    g.drawLine(horiz, vert, horiz + width, vert);
                }
                if (selectionBounds != null) {
                    g.setColor(this.getDocumentView().getColor(3));
                    int i = 0;
                    while (i < selectionBounds.length) {
                        Rectangle saveClip = g.getClipBounds();
                        g.clipRect(selectionBounds[i].x - path.getHorizontalShift(), selectionBounds[i].y - path.getVerticalShift(), selectionBounds[i].width, selectionBounds[i].height);
                        if (this.bevelled) {
                            g.drawLine(horiz, vert + this.getHeight(), horiz + width, vert);
                        } else {
                            g.drawLine(horiz, vert, horiz + width, vert);
                        }
                        g.setClip(saveClip);
                        ++i;
                    }
                }
                if (g2 != null) {
                    g2.setStroke(saveStroke);
                }
            }
            g.setColor(saveColor);
        }

        @Override
        public void setPositionMarker(int offset) {
            WmiMathDocumentView docView = this.getDocumentView();
            if (docView != null) {
                FractionBarMarker marker = new FractionBarMarker(this);
                docView.setPositionMarker(marker);
                docView.notifyMarkerPositionChanged();
                marker.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }

        @Override
        public boolean isNavagableView() {
            return false;
        }

        @Override
        public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
            int success = 0;
            if (horizontalOffset + this.getWidth() < breakWidth) {
                WmiCompositeView parent = this.getParentView();
                int index = parent.indexOf(this);
                if (index >= 0) {
                    paragraph.split(parent, index + 1, 0);
                    success = 2;
                }
            } else if (thresholdCost > 0) {
                success = super.doImplicitLinebreak(paragraph, horizontalOffset, breakWidth, thresholdCost);
            }
            return success;
        }
    }

    private static class WmiLeftAlignment
    implements WmiAlignCalculation {
        private WmiLeftAlignment() {
        }

        @Override
        public int calculateHOffset(int fracWidth, int targetWidth) {
            return 0;
        }
    }

    private static class WmiRightAlignment
    implements WmiAlignCalculation {
        private WmiRightAlignment() {
        }

        @Override
        public int calculateHOffset(int fracWidth, int targetWidth) {
            return fracWidth - targetWidth;
        }
    }
}

