/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiMathInlineView
extends WmiInlineView {
    private Color background = null;

    public WmiMathInlineView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.applyMathRules(true);
        this.lockOperatorSize(false);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        int xOffset = path.getHorizontalOffset();
        int yOffset = path.getVerticalOffset();
        int selectionStart = path.getLeftSelectionBoundary();
        int selectionEnd = path.getRightSelectionBoundary();
        if (this.background != null && (selectionStart < 0 || selectionStart > this.x + xOffset || selectionEnd < this.x + xOffset + this.width) && selectionStart != -1 && selectionEnd != -1) {
            g.setColor(this.background);
            g.fillRect(xOffset + this.x, yOffset + this.y, this.width, this.height);
        }
        super.draw(g, path, bounds);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        WmiMathStyleModel.WmiMathStyleAttributeSet attributes;
        super.layoutView();
        if (this.getModel() instanceof WmiMathStyleModel && (attributes = (WmiMathStyleModel.WmiMathStyleAttributeSet)this.getModel().getAttributesForRead()).isOpaque()) {
            this.background = new Color(attributes.getBackground());
        }
    }

    public static float calculateScaleFactor(WmiMathStyleModel.WmiMathStyleAttributeSet attrs, float originalMultiplier, WmiMathDocumentView docView) {
        String scriptlevel = attrs.getScriptLevel();
        float scriptsizemultiplier = attrs.getScriptSizeMultiplier();
        WmiDimensionUnit scriptminsize = attrs.getScriptMinSize();
        int level = Math.max(1, Integer.parseInt(scriptlevel.substring(scriptlevel.indexOf("+") + 1)));
        float multiplier = originalMultiplier;
        if (scriptsizemultiplier != 0.71f) {
            multiplier = scriptsizemultiplier;
        }
        float zoomFactor = (float)Math.pow(multiplier, level);
        int minPixels = WmiMathViewUtil.getPixelValueForDimension(scriptminsize, attrs, docView.isPrintView());
        if (Math.round(WmiFontResolver.DPI_SCALE_FACTOR * zoomFactor * (float)attrs.getSize()) < minPixels) {
            zoomFactor = (float)minPixels / (WmiFontResolver.DPI_SCALE_FACTOR * (float)attrs.getSize());
        }
        return zoomFactor;
    }
}

