/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;

public class WmiMathSpaceView
extends WmiGenericView
implements WmiTraversableView {
    private static final HashSet PROC_BREAKS = new HashSet();
    private boolean canNavigate = true;

    static {
        PROC_BREAKS.add("increaseindentnewline");
        PROC_BREAKS.add("indentingnewline");
        PROC_BREAKS.add("decreaseindentnewline");
        PROC_BREAKS.add("newline");
        PROC_BREAKS.add("firstprocnewline");
    }

    public WmiMathSpaceView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            WmiMathSpaceModel model = (WmiMathSpaceModel)this.getModel();
            WmiMathSpaceModel.WmiMathSpaceAttributeSet attrs = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)model.getAttributes();
            int zoomFactor = this.getZoomFactor();
            boolean printView = this.getDocumentView().isPrintView();
            this.width = Math.round(WmiMathViewUtil.getPixelValueForDimension(attrs.getWidth(), attrs, printView) * zoomFactor / 100);
            int heightAttribute = Math.round(WmiMathViewUtil.getPixelValueForDimension(attrs.getHeight(), attrs, printView) * zoomFactor / 100);
            int depthAttribute = Math.round(WmiMathViewUtil.getPixelValueForDimension(attrs.getDepth(), attrs, printView) * zoomFactor / 100);
            this.baseline = heightAttribute;
            this.height = heightAttribute + depthAttribute;
            if (this.height == 0) {
                WmiMathTextView.setDefaultHeight(this);
            }
            if (this.width == 0 && !MathTokenizer.isLinebreakingMSpace(model)) {
                this.canNavigate = false;
            }
        }
    }

    @Override
    public boolean isNavagableView() {
        return this.canNavigate;
    }

    public boolean isDeletableSpace() {
        return true;
    }

    @Override
    public void setPositionMarker(int offset) {
        try {
            WmiMathDocumentView docView = this.getDocumentView();
            if (docView != null) {
                WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
                Point pt = WmiViewUtil.containerRelativeOffset(this, container);
                if (offset == -1) {
                    offset = 1;
                }
                int uprightOffset = offset == 0 ? 0 : this.getWidth();
                WmiCaret caret = docView.getCaret();
                boolean setMarker = false;
                if (!(caret instanceof WmiMathCaret)) {
                    caret = new WmiMathCaret(docView);
                    setMarker = true;
                }
                caret.updateCaretBounds(container, pt.x, pt.y, pt.x + this.getWidth(), pt.y + this.getHeight());
                ((WmiMathCaret)caret).setUprightPosition(pt.x + uprightOffset, pt.x + uprightOffset);
                caret.updateView(this, offset);
                if (setMarker) {
                    docView.setPositionMarker(caret);
                }
                caret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public int getTraversalType() {
        return this.canNavigate ? 2 : 8;
    }

    @Override
    public int getOffset(Point pt) {
        return 0;
    }

    @Override
    public int getTraversableCount() {
        return 0;
    }

    @Override
    public boolean isRepeatable() {
        return this.canNavigate;
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet spaceAttributes;
        String linebreak;
        WmiAttributeSet attributes;
        int success = 0;
        WmiModel model = this.getModel();
        WmiAttributeSet wmiAttributeSet = attributes = model != null ? model.getAttributesForRead() : null;
        if (attributes instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && (linebreak = (spaceAttributes = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)attributes).getLinebreak()).equals("newline")) {
            WmiCompositeView parent = this.getParentView();
            int index = parent.indexOf(this);
            paragraph.split(parent, index, 1);
            success = 2;
        }
        return success;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        WmiCompositeView parent = this.getParentView();
        int index = parent.indexOf(this);
        paragraph.split(parent, index, 1);
        return 2;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        if (WmiMathSpaceView.isGoodBreakSpace(this)) {
            success = this.doForcedLinebreak(paragraph, horizontalOffset, breakWidth);
        }
        return success;
    }

    @Override
    public boolean hasGoodBreakpoint(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return WmiMathSpaceView.isGoodBreakSpace(this);
    }

    public static boolean isGoodBreakSpace(WmiMathSpaceView view) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet spaceAttributes;
        String linebreak;
        WmiAttributeSet attributes;
        boolean goodBreak = false;
        WmiModel model = view.getModel();
        WmiAttributeSet wmiAttributeSet = attributes = model != null ? model.getAttributesForRead() : null;
        if (attributes instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && (linebreak = (spaceAttributes = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)attributes).getLinebreak()) != null && linebreak.length() > 0 && !linebreak.equals("badbreak") && !linebreak.equals("nobreak")) {
            goodBreak = true;
        }
        return goodBreak;
    }

    public static boolean isCandidateExplicitBreakSpace(WmiMathSpaceView view) throws WmiNoReadAccessException {
        WmiMathSpaceModel.WmiMathSpaceAttributeSet spaceAttributes;
        String linebreak;
        WmiAttributeSet attributes;
        boolean goodBreak = false;
        WmiModel model = view.getModel();
        WmiAttributeSet wmiAttributeSet = attributes = model != null ? model.getAttributesForRead() : null;
        if (attributes instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet && PROC_BREAKS.contains(linebreak = (spaceAttributes = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)attributes).getLinebreak())) {
            goodBreak = true;
        }
        return goodBreak;
    }

    public static boolean breakAtAllNewlines(WmiParagraphView paragraph, WmiCompositeView parent, int breakWidth) throws WmiNoReadAccessException {
        boolean found = false;
        ArrayList breaks = WmiMathSpaceView.breakAtAllNewlines(paragraph, parent, breakWidth, null);
        if (breaks != null) {
            found = true;
            int size = breaks.size();
            int i = 0;
            while (i < size) {
                int index;
                WmiMathSpaceView space = (WmiMathSpaceView)breaks.get(i);
                parent = space.getParentView();
                int n = index = parent != null ? parent.indexOf(space) : -1;
                if (index >= 0) {
                    WmiView fragment = paragraph.split(parent, index, 1);
                    space.adjustIndentation(fragment);
                }
                ++i;
            }
        }
        return found;
    }

    public static ArrayList breakAtAllNewlines(WmiParagraphView paragraph, WmiCompositeView parent, int breakWidth, ArrayList breaks) throws WmiNoReadAccessException {
        int size = parent.getChildCount();
        boolean traverseInlines = ((WmiPositionedView)((Object)parent)).getWidth() > breakWidth;
        int i = 0;
        while (i < size) {
            WmiView child = parent.getChild(i);
            if (child instanceof WmiMathSpaceView) {
                WmiMathSpaceView space = (WmiMathSpaceView)child;
                if (WmiMathSpaceView.isCandidateExplicitBreakSpace(space)) {
                    if (breaks == null) {
                        breaks = new ArrayList();
                    }
                    breaks.add(space);
                }
            } else if (traverseInlines && child instanceof WmiMathInlineView) {
                WmiInlineView inline = (WmiInlineView)child;
                breaks = WmiMathSpaceView.breakAtAllNewlines(paragraph, inline, breakWidth, breaks);
            }
            ++i;
        }
        return breaks;
    }

    private void adjustIndentation(WmiView view) throws WmiNoReadAccessException {
        if (view instanceof WmiParagraphView.WmiParagraphInlineView) {
            WmiAttributeSet set;
            WmiParagraphView.WmiParagraphInlineView inline = (WmiParagraphView.WmiParagraphInlineView)view;
            WmiModel model = this.getModel();
            WmiAttributeSet wmiAttributeSet = set = model != null ? model.getAttributesForRead() : null;
            if (set instanceof WmiMathSpaceModel.WmiMathSpaceAttributeSet) {
                WmiMathSpaceModel.WmiMathSpaceAttributeSet attribs = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)set;
                String linebreak = attribs.getLinebreak();
                if (linebreak.equals("increaseindentnewline")) {
                    inline.incrementIndentLevel();
                } else if (linebreak.equals("decreaseindentnewline")) {
                    inline.decrementIndentLevel();
                }
            }
        }
    }
}

