/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiNonSplitableInlineView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathTableCellView;
import com.maplesoft.mathdoc.view.math.WmiMathTableLabeledRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableView;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;

public class WmiMathTableRowView
extends WmiNonSplitableInlineView {
    private Integer rowAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private ArrayList columnAlignments = new ArrayList();
    private ArrayList alignGroupAlignments = new ArrayList();
    private int maxHeight = 0;
    private int cellMaxBaseline = 0;
    private boolean isLabelRow = false;

    public WmiMathTableRowView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    public boolean isLabelRow() {
        return this.isLabelRow;
    }

    public void setLabelRow(boolean label) {
        this.isLabelRow = label;
    }

    private WmiMathTableView getTableView() {
        WmiCompositeView parent = this.getParentView();
        return parent instanceof WmiMathTableView ? (WmiMathTableView)parent : null;
    }

    @Override
    protected void initializeView(WmiCompositeModel model) throws WmiNoReadAccessException {
        super.initializeView(model);
        WmiMathTableModel table = (WmiMathTableModel)model.getParent();
        WmiMathTableModel.WmiMathTableAttributeSet attrs = (WmiMathTableModel.WmiMathTableAttributeSet)table.getAttributesForRead();
        if (model.getTag() == WmiModelTag.MATH_TABLE_ROW && attrs.getSide().startsWith("left")) {
            WmiView[] newChildren = new WmiView[this.getChildCount() + 1];
            System.arraycopy(this.children, 0, newChildren, 1, this.getChildCount());
            WmiMathDocumentModel doc = model.getDocument();
            WmiTextModel textModel = new WmiTextModel(doc);
            WmiMathTableModel.WmiMathTableDataModel cellModel = new WmiMathTableModel.WmiMathTableDataModel(doc, textModel);
            WmiMathTableCellView cellView = new WmiMathTableCellView(cellModel, this.getDocumentView());
            cellView.updateView();
            cellView.setParentView(this);
            newChildren[0] = cellView;
            ++this.length;
            this.children = newChildren;
        }
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiMathTableView table = this.getTableView();
            int viewCount = this.getChildCount();
            this.maxHeight = 0;
            boolean matrix = table.isMatrix() && table.cellLinebroken;
            this.width = 0;
            if (matrix) {
                int i = 0;
                while (i < viewCount) {
                    WmiMathTableCellView cellView = (WmiMathTableCellView)this.getChild(i);
                    this.width += cellView.getWidth() + table.getColumnSpacing(i);
                    this.maxHeight = this.maxHeight > cellView.getHeight() ? this.maxHeight : cellView.getHeight();
                    ++i;
                }
                this.height = this.maxHeight;
            }
            WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet attrs = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)this.getModel().getAttributesForRead();
            this.getRowAlignment(attrs);
            this.getColumnAlignment(attrs);
            this.cellMaxBaseline = 0;
            int i = 0;
            while (i < viewCount) {
                int cellBaseline;
                WmiMathTableCellView cellView = (WmiMathTableCellView)this.getChild(i);
                if (((WmiMathTableModel)table.getModel()).containsAlignmentElement()) {
                    cellView.invalidate(1);
                    cellView.layoutView(false, true);
                }
                if (cellView.getChildCount() > 0 && (cellBaseline = ((WmiPositionedView)cellView.getChild(0)).getBaseline()) > this.cellMaxBaseline) {
                    this.cellMaxBaseline = cellBaseline;
                }
                this.maxHeight = this.maxHeight > cellView.getHeight() ? this.maxHeight : cellView.getHeight();
                ++i;
            }
            int maxWidth = 0;
            int i2 = 0;
            while (i2 < viewCount) {
                Integer cellHorizontalAlignment;
                WmiMathTableCellView cellView = (WmiMathTableCellView)this.getChild(i2);
                int columnSpan = cellView.getColumnSpan();
                int cellRowIndex = cellView.getRowIndex();
                int cellColumnIndex = cellView.getColumnIndex();
                int cellWidth = cellView.getWidth();
                int columnOffset = 0;
                int columnWidth = Integer.MAX_VALUE;
                if (table != null) {
                    int j = 0;
                    while (j < cellColumnIndex) {
                        columnOffset += table.getMaximumColumnWidth(j) + table.getColumnSpacing(j);
                        ++j;
                    }
                    if (this instanceof WmiMathTableLabeledRowView && cellColumnIndex == this.getChildCount() - 1) {
                        columnOffset = 0;
                        j = 0;
                        while (j < table.getMaxNumberOfColumns()) {
                            columnOffset += table.getMaximumColumnWidth(j) + table.getColumnSpacing(j);
                            ++j;
                        }
                    }
                    columnWidth = table.getMaximumColumnWidth(cellColumnIndex);
                    j = cellColumnIndex + 1;
                    while (j < cellColumnIndex + columnSpan) {
                        columnWidth += table.getMaximumColumnWidth(j) + table.getColumnSpacing(j);
                        ++j;
                    }
                    if (columnOffset + columnWidth > maxWidth) {
                        maxWidth = columnOffset + columnWidth;
                    }
                } else {
                    maxWidth = Integer.MAX_VALUE;
                }
                if ((cellHorizontalAlignment = cellView.getHorizontalAlignment()).equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    cellHorizontalAlignment = this.getColumnAlignment(i2);
                }
                if (cellHorizontalAlignment.equals(WmiMathTableView.ALIGN_STYLE_UNSET) && table != null) {
                    cellHorizontalAlignment = table.getColumnAlignment(cellColumnIndex);
                }
                if (cellHorizontalAlignment.equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    cellHorizontalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
                }
                int cellOffset = columnOffset;
                if (cellHorizontalAlignment.equals(WmiMathTableView.ALIGN_STYLE_CENTER)) {
                    if (cellWidth < columnWidth) {
                        cellOffset += (columnWidth - cellWidth) / 2;
                    }
                } else if (cellHorizontalAlignment.equals(WmiMathTableView.ALIGN_STYLE_RIGHT) && cellWidth < columnWidth) {
                    cellOffset += columnWidth - cellWidth;
                }
                cellView.setHorizontalOffset(cellOffset);
                ++i2;
            }
            i2 = 0;
            while (i2 < viewCount) {
                Integer cellVerticalAlignment;
                WmiMathTableCellView cellView = (WmiMathTableCellView)this.getChild(i2);
                int cellRowIndex = cellView.getRowIndex();
                int rowSpan = cellView.getRowSpan();
                int cellVerticalOffset = 0;
                int rowHeight = Integer.MAX_VALUE;
                if (table != null) {
                    rowHeight = table.getMaximumRowHeight(cellRowIndex);
                    if (rowHeight > this.maxHeight) {
                        this.maxHeight = rowHeight;
                    }
                    if (rowSpan > 1) {
                        int j = cellRowIndex + 1;
                        while (j < cellRowIndex + rowSpan) {
                            rowHeight += table.getMaximumRowHeight(j) + table.getRowSpacing(j);
                            ++j;
                        }
                    }
                } else {
                    this.maxHeight = Integer.MAX_VALUE;
                }
                if ((cellVerticalAlignment = cellView.getVerticalAlignment()).equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    cellVerticalAlignment = this.rowAlignment;
                }
                if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_UNSET) && table != null) {
                    cellVerticalAlignment = table.getRowAlignment(cellRowIndex);
                }
                if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    cellVerticalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
                }
                if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_TOP)) {
                    WmiTextView textView = (WmiTextView)WmiViewUtil.findFirstDescendantOfClass(cellView, WmiTextView.class);
                    if (textView != null) {
                        cellVerticalOffset = textView.computeSpaceAbove() * -1;
                        if (cellRowIndex == 0) {
                            cellVerticalOffset += table.getFrameSpacing(1);
                        }
                    }
                } else if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_BOTTOM)) {
                    cellVerticalOffset = this.maxHeight - cellView.getHeight();
                } else if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_CENTER)) {
                    cellVerticalOffset = (this.maxHeight - cellView.getHeight()) / 2;
                } else if (cellVerticalAlignment.equals(WmiMathTableView.ALIGN_STYLE_AXIS)) {
                    cellVerticalOffset = (this.maxHeight - cellView.getHeight()) / 2;
                }
                cellView.setVerticalOffset(cellVerticalOffset);
                ++i2;
            }
            this.addNavigationLinks();
            if (!matrix) {
                this.height = this.maxHeight;
                this.width = maxWidth;
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    @Override
    public void adjustVerticalLayout() throws WmiNoReadAccessException {
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Graphics2D g2 = (Graphics2D)g;
        int colspacing = 0;
        int width = 0;
        int columnSpan = 0;
        WmiMathTableView table = this.getTableView();
        int rowIndex = table.indexOf(this);
        if (table != null && !table.cellLinebroken && this.isLabelRow()) {
            return;
        }
        boolean skipFirstColumnForLabel = false;
        int childCount = this.getChildCount();
        if (table != null && table.containsLabeledRow()) {
            if (table.getSide() == WmiMathTableView.RIGHT_SIDE || table.getSide() == WmiMathTableView.RIGHT_OVERLAP_SIDE) {
                childCount = this instanceof WmiMathTableLabeledRowView ? (childCount -= 2) : --childCount;
            } else {
                skipFirstColumnForLabel = true;
            }
        }
        if (table != null) {
            int i = 0;
            while (i < childCount) {
                int index;
                Integer style = table.getColumnLineStyle(i);
                if (style != WmiMathTableView.LINE_STYLE_NONE && (index = table.getColumnIndex(rowIndex, i)) != table.getMaxNumberOfColumns() - 1) {
                    WmiMathTableCellView cell = (WmiMathTableCellView)this.getChild(i);
                    columnSpan = cell.getColumnSpan();
                    if (columnSpan > 1) {
                        int left = index;
                        int right = index + columnSpan < table.getMaxNumberOfColumns() ? index + columnSpan : table.getMaxNumberOfColumns();
                        int c = left;
                        while (c < right) {
                            if (c > 0) {
                                colspacing += table.getColumnSpacing(i) / 2;
                            }
                            width += table.getMaximumColumnWidth(c);
                            if (c < table.getMaxNumberOfColumns()) {
                                colspacing += table.getColumnSpacing(i + 1) / 2;
                            }
                            ++c;
                        }
                    } else {
                        width = 0;
                        colspacing = 0;
                        int j = 0;
                        while (j <= index) {
                            width += table.getMaximumColumnWidth(j);
                            colspacing += table.getColumnSpacing(j);
                            ++j;
                        }
                        colspacing -= table.getColumnSpacing(index) / 2;
                    }
                    int x = path.getHorizontalOffset() + this.getHorizontalOffset() + colspacing + width;
                    Stroke s = g2.getStroke();
                    if (style == WmiMathTableView.LINE_STYLE_DASHED) {
                        float[] dash = new float[]{1.5f};
                        g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 1.0f));
                    }
                    int top = 0;
                    int framespacing = 0;
                    int rowspacing = 0;
                    if (table.indexOf(this) == 0) {
                        top = path.getVerticalOffset() + table.getFrameSpacing(1);
                        if (table.getChildCount() > 1) {
                            rowspacing = table.getRowSpacing(table.indexOf(this)) / 2;
                            framespacing = table.getFrameSpacing(1);
                        } else {
                            framespacing = table.getFrameSpacing(1) * 2;
                        }
                    } else if (table.indexOf(this) == table.getChildCount() - 1) {
                        rowspacing = table.getRowSpacing(table.indexOf(this) - 1) / 2;
                        top = path.getVerticalOffset() + this.getVerticalOffset() - rowspacing;
                        framespacing = table.getFrameSpacing(1) * -1;
                    } else {
                        rowspacing = table.getRowSpacing(table.indexOf(this));
                        if (table.containsLabeledRow() && !table.drawOverlappedLabel() && !this.isLabelRow() && table.indexOf(this) == 1) {
                            top = path.getVerticalOffset();
                            framespacing = table.getFrameSpacing(1) * 2;
                        } else {
                            top = path.getVerticalOffset() + this.getVerticalOffset() - (rowspacing / 2 + 1);
                            framespacing = 0;
                        }
                    }
                    int height = 0;
                    int rowSpan = cell.getRowSpan();
                    if (rowSpan > 1) {
                        int r = 0;
                        while (r < rowSpan) {
                            height += table.getMaximumRowHeight(rowIndex + r);
                            if (rowIndex + r < table.getNumberOfRows() - 1) {
                                height += table.getRowSpacing(rowIndex + r);
                            }
                            ++r;
                        }
                    } else {
                        height = this.getHeight();
                    }
                    if (!(i + columnSpan >= table.getMaxNumberOfColumns() || table.getCellWidth(rowIndex, index) == 0 || i == 0 && skipFirstColumnForLabel || this.isLabelRow)) {
                        g2.drawLine(x, top, x, top + height + rowspacing + framespacing);
                    }
                    g2.setStroke(s);
                }
                ++i;
            }
        }
        super.draw(g, path, bounds);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public int getMaxBaseline() {
        return this.cellMaxBaseline;
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet attrs) {
        String alignment;
        String string = alignment = attrs.getRowAlign() != null ? attrs.getRowAlign() : "";
        this.rowAlignment = alignment.equals("top") ? WmiMathTableView.ALIGN_STYLE_TOP : (alignment.equals("bottom") ? WmiMathTableView.ALIGN_STYLE_BOTTOM : (alignment.equals("center") || alignment.equals("baseline") ? WmiMathTableView.ALIGN_STYLE_CENTER : (alignment.equals("axis") ? WmiMathTableView.ALIGN_STYLE_AXIS : WmiMathTableView.ALIGN_STYLE_UNSET)));
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String alignment = attrs.getColumnAlign() != null ? attrs.getColumnAlign() : "";
        String[] s = alignment.split(" ");
        Integer lastAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
        int kid = 0;
        while (kid < this.getChildCount()) {
            if (kid < s.length) {
                if (s[kid].equals("left")) {
                    this.columnAlignments.add(kid, WmiMathTableView.ALIGN_STYLE_LEFT);
                } else if (s[kid].equals("right")) {
                    this.columnAlignments.add(kid, WmiMathTableView.ALIGN_STYLE_RIGHT);
                } else if (s[kid].equals("center")) {
                    this.columnAlignments.add(kid, WmiMathTableView.ALIGN_STYLE_CENTER);
                } else {
                    this.columnAlignments.add(kid, WmiMathTableView.ALIGN_STYLE_UNSET);
                }
                lastAlignment = (Integer)this.columnAlignments.get(kid);
            } else {
                this.columnAlignments.add(lastAlignment);
            }
            ++kid;
        }
    }

    public void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String alignment = attrs.getGroupAlign() != null ? attrs.getGroupAlign() : "";
        String[] s = alignment.split("[\\{\\}]");
        int i = 0;
        while (i < s.length) {
            if (!s[i].trim().equals("")) {
                ArrayList<Integer> groupList = new ArrayList<Integer>();
                String[] list = s[i].split(" ");
                int j = 0;
                while (j < list.length) {
                    if (list[j].equals("left")) {
                        groupList.add(WmiMathTableView.ALIGN_STYLE_LEFT);
                    } else if (list[j].equals("right")) {
                        groupList.add(WmiMathTableView.ALIGN_STYLE_RIGHT);
                    } else if (list[j].equals("center")) {
                        groupList.add(WmiMathTableView.ALIGN_STYLE_CENTER);
                    } else {
                        groupList.add(WmiMathTableView.ALIGN_STYLE_DECIMALPOINT);
                    }
                    ++j;
                }
                this.alignGroupAlignments.add(groupList);
            }
            ++i;
        }
    }

    public ArrayList getAlignGroupAlignments(int columnIndex) {
        return columnIndex < this.alignGroupAlignments.size() ? this.alignGroupAlignments.get(columnIndex) : null;
    }

    public Integer getColumnAlignment(int index) {
        return (Integer)this.columnAlignments.get(index);
    }

    @Override
    public void addNavigationLinks() {
        int viewCount = this.getChildCount();
        if (viewCount > 0) {
            WmiMathTableCellView firstView = (WmiMathTableCellView)this.getChild(0);
            firstView.setNextView(null, 2);
            WmiMathTableCellView lastView = (WmiMathTableCellView)this.getChild(viewCount - 1);
            lastView.setNextView(null, 3);
        }
        int i = 0;
        while (i < viewCount - 1) {
            WmiMathTableCellView prevCellView = (WmiMathTableCellView)this.getChild(i);
            WmiMathTableCellView nextCellView = (WmiMathTableCellView)this.getChild(i + 1);
            prevCellView.setNextView(nextCellView, 3);
            nextCellView.setNextView(prevCellView, 2);
            ++i;
        }
    }
}

