/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathAlignGroupModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiCellView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignGroupView;
import com.maplesoft.mathdoc.view.math.WmiMathAlignMarkView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTableCellView;
import com.maplesoft.mathdoc.view.math.WmiMathTableLabeledRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;

public class WmiMathTableView
extends WmiLinebrokenView {
    public static final int FRAME_SPACING_HORIZONTAL = 0;
    public static final int FRAME_SPACING_VERTICAL = 1;
    public static final Integer LINE_STYLE_NONE = new Integer(0);
    public static final Integer LINE_STYLE_SOLID = new Integer(1);
    public static final Integer LINE_STYLE_DASHED = new Integer(2);
    public static final Integer ALIGN_STYLE_UNSET = new Integer(-1);
    public static final Integer ALIGN_STYLE_AXIS = new Integer(0);
    public static final Integer ALIGN_STYLE_TOP = new Integer(1);
    public static final Integer ALIGN_STYLE_BOTTOM = new Integer(2);
    public static final Integer ALIGN_STYLE_CENTER = new Integer(3);
    public static final Integer ALIGN_STYLE_LEFT = new Integer(4);
    public static final Integer ALIGN_STYLE_RIGHT = new Integer(5);
    public static final Integer ALIGN_STYLE_DECIMALPOINT = new Integer(6);
    public static final Integer RIGHT_SIDE = new Integer(0);
    public static final Integer LEFT_SIDE = new Integer(1);
    public static final Integer RIGHT_OVERLAP_SIDE = new Integer(2);
    public static final Integer LEFT_OVERLAP_SIDE = new Integer(3);
    private WmiFontAttributeSet fontAttributes;
    private int[] columnMaxWidth;
    private int[] rowMaxHeight;
    private int[][] cellWidths;
    public int[][] cellHeights;
    private int maxColumnCount;
    private int maxRowWidth = 0;
    private int zoomFactor;
    private boolean dontLineBreakCells = false;
    private Integer frameStyle = LINE_STYLE_NONE;
    private ArrayList rowlineStyles = new ArrayList();
    private ArrayList rowSpacing = new ArrayList();
    private ArrayList rowAlignments = new ArrayList();
    private ArrayList columnlineStyles = new ArrayList();
    private ArrayList columnSpacing = new ArrayList();
    private ArrayList columnAlignments = new ArrayList();
    private ArrayList alignGroupAlignments = new ArrayList();
    private int[] frameSpacing = new int[2];
    private Integer alignStyle = ALIGN_STYLE_AXIS;
    private int alignRow = 0;
    private boolean useEqualRows = false;
    private boolean useEqualColumns = false;
    private String tableWidth = "";
    private ArrayList columnWidth = new ArrayList();
    private boolean containsLabeledRow = false;
    private Integer side = RIGHT_SIDE;
    private int minLabelSpacing = 0;
    public boolean cellLinebroken = false;
    private int[] maxAlignGroupCount = null;
    public ArrayList[][] alignGroupWidths;
    public ArrayList[] maxAlignGroupWidths;

    public WmiMathTableView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView, docView.getBreakWidth());
        WmiMathDocumentView topView = this.getDocumentView();
        this.zoomFactor = topView != null ? topView.getZoomFactor() : 100;
        try {
            WmiMathWrapperModel wrapper = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
            this.fontAttributes = wrapper != null ? (WmiFontAttributeSet)wrapper.getAttributesForRead() : new WmiFontAttributeSet();
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public boolean isMatrix() throws WmiNoReadAccessException {
        WmiCompositeView parentView;
        boolean isMatrix = false;
        WmiFencedView fencedView = (WmiFencedView)(WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH_FENCED) != null ? WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH_FENCED) : null);
        if (fencedView != null) {
            WmiMathFencedModel fencedModel = (WmiMathFencedModel)fencedView.getModel();
            WmiMathTokenModel leftModel = (WmiMathTokenModel)fencedModel.getModelForLeft();
            WmiMathTokenModel rightModel = (WmiMathTokenModel)fencedModel.getModelForRight();
            if (leftModel.getTokenContents().equals("[") && rightModel.getTokenContents().equals("]")) {
                isMatrix = true;
            }
        }
        if (!isMatrix && (parentView = this.getParentView()) instanceof WmiMathInlineView) {
            WmiCompositeView grandParentView = parentView.getParentView();
            WmiCompositeView wmiCompositeView = parentView = grandParentView instanceof WmiMathInlineView ? grandParentView : parentView;
            if (parentView instanceof WmiMathInlineView && parentView.getChildCount() == 3 && parentView.getChild(0) instanceof WmiMathOperatorView && ((WmiMathOperatorView)parentView.getChild(0)).getText().equals("[") && parentView.getChild(2) instanceof WmiMathOperatorView && ((WmiMathOperatorView)parentView.getChild(2)).getText().equals("]")) {
                isMatrix = true;
            }
        }
        return isMatrix;
    }

    @Override
    protected void initializeView(WmiCompositeModel model) throws WmiNoReadAccessException {
        super.initializeView(model);
        WmiMathTableModel table = (WmiMathTableModel)model;
        WmiMathTableModel.WmiMathTableAttributeSet attrs = (WmiMathTableModel.WmiMathTableAttributeSet)table.getAttributesForRead();
        if (table.containsLabeledRow() && attrs.getSide().endsWith("overlap")) {
            int childCount = this.getChildCount();
            int i = 0;
            while (i < childCount) {
                WmiMathTableRowView rowView = (WmiMathTableRowView)this.getChild(i);
                if (rowView instanceof WmiMathTableLabeledRowView) {
                    WmiMathTableCellView cellView = attrs.getSide().equals("leftoverlap") ? (WmiMathTableCellView)rowView.getChild(0) : (WmiMathTableCellView)rowView.getChild(rowView.getChildCount() - 1);
                    WmiMathTableCellView newCellView = (WmiMathTableCellView)cellView.copyView();
                    WmiMathTableRowView newRowView = new WmiMathTableRowView(cellView.getModel().getParent(), this.getDocumentView());
                    newRowView.setLabelRow(true);
                    WmiMathDocumentModel doc = model.getDocument();
                    WmiTextModel textModel = new WmiTextModel(doc);
                    WmiMathTableModel.WmiMathTableDataModel cellModel = new WmiMathTableModel.WmiMathTableDataModel(doc, textModel);
                    WmiMathTableCellView emptyCellView = new WmiMathTableCellView(cellModel, this.getDocumentView());
                    emptyCellView.updateView();
                    emptyCellView.setParentView(newRowView);
                    if (attrs.getSide().equals("leftoverlap")) {
                        newRowView.appendView(emptyCellView);
                        newRowView.appendView(newCellView);
                    } else {
                        int c = 0;
                        while (c < rowView.getChildCount() - 2) {
                            newRowView.appendView(emptyCellView);
                            ++c;
                        }
                        newRowView.appendView(newCellView);
                    }
                    WmiMathTableModel.WmiMathTableLabeledRowModel rowModel = (WmiMathTableModel.WmiMathTableLabeledRowModel)rowView.getModel();
                    WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet rowAttrs = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)rowModel.getAttributesForRead();
                    if (rowAttrs.getRowAlign() != null && rowAttrs.getRowAlign().equals("top")) {
                        this.insertView(newRowView, i);
                    } else {
                        this.insertView(newRowView, i + 1);
                    }
                    ++childCount;
                    ++i;
                }
                ++i;
            }
        }
    }

    @Override
    public WmiInlineView createRow(WmiModel model, int width) {
        return new WmiMathTableRowView(model, this.getDocumentView());
    }

    public void dontLineBreakCells() {
        this.dontLineBreakCells = true;
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.initializeRowAndColumnBookkeeping();
            WmiMathTableModel table = (WmiMathTableModel)this.getModel();
            WmiMathTableModel.WmiMathTableAttributeSet attrs = (WmiMathTableModel.WmiMathTableAttributeSet)table.getAttributesForRead();
            this.getFrameStyle(attrs);
            this.getRowLineStyle(attrs);
            this.getRowSpacing(attrs);
            this.getRowAlignment(attrs);
            this.getColumnLineStyle(attrs);
            this.getColumnSpacing(attrs);
            this.getSide(attrs);
            this.getColumnAlignment(attrs);
            this.getFrameSpacing(attrs);
            this.getAlign(attrs);
            this.getEqualRows(attrs);
            this.getEqualColumns(attrs);
            this.getWidth(attrs);
            this.getColumnWidth(attrs);
            this.getMinLabelSpacing(attrs);
            this.getAlignGroupAlignments(attrs);
            int maxHeight = 0;
            int accumOffs = this.frameSpacing[1];
            if (!table.containsAlignmentElement()) {
                this.calculateMaxColumnWidths();
                this.cellLinebroken = false;
                this.linebreakCells();
                if (this.containsLabeledRow && this.side == LEFT_OVERLAP_SIDE || this.side == RIGHT_OVERLAP_SIDE) {
                    if (this.cellLinebroken) {
                        if (this.side == LEFT_OVERLAP_SIDE) {
                            this.columnWidth.set(0, new Integer(0));
                        } else {
                            this.columnWidth.set(this.columnWidth.size() - 1, new Integer(0));
                        }
                    }
                    this.calculateMaxColumnWidths();
                    this.linebreakCells();
                }
                this.calculateMaxRowHeights();
                this.maxRowWidth = 0;
                int i = 0;
                while (i < this.getChildCount()) {
                    WmiMathTableRowView rowView = (WmiMathTableRowView)this.getChild(i);
                    if (this.cellLinebroken || !rowView.isLabelRow()) {
                        rowView.layoutView();
                        rowView.setHorizontalOffset(this.frameSpacing[0]);
                        if (i != 0) {
                            accumOffs += this.getRowSpacing(i - 1);
                        }
                        rowView.setVerticalOffset(accumOffs);
                        accumOffs += rowView.getHeight();
                        this.maxRowWidth = this.maxRowWidth > rowView.getWidth() ? this.maxRowWidth : rowView.getWidth();
                        maxHeight = maxHeight > rowView.getHeight() ? maxHeight : rowView.getHeight();
                    }
                    ++i;
                }
                this.height = accumOffs + this.frameSpacing[1];
                this.width = this.maxRowWidth + this.frameSpacing[0] * 2;
            } else {
                this.calculateMaxColumnWidths();
                this.calculateAlignGroupWidths();
                this.calculateAlignGroupMaxWidths();
                this.calculateAlignedColumnWidths();
                this.calculateMaxRowHeights();
                this.maxRowWidth = 0;
                int i = 0;
                while (i < this.getChildCount()) {
                    WmiMathTableRowView rowView = (WmiMathTableRowView)this.getChild(i);
                    if (this.cellLinebroken || !rowView.isLabelRow()) {
                        rowView.layoutView();
                        rowView.setHorizontalOffset(this.frameSpacing[0]);
                        if (i != 0) {
                            accumOffs += this.getRowSpacing(i - 1);
                        }
                        rowView.setVerticalOffset(accumOffs);
                        accumOffs += rowView.getHeight();
                        this.maxRowWidth = this.maxRowWidth > rowView.getWidth() ? this.maxRowWidth : rowView.getWidth();
                        maxHeight = maxHeight > rowView.getHeight() ? maxHeight : rowView.getHeight();
                    }
                    ++i;
                }
                this.height = accumOffs + this.frameSpacing[1];
                this.width = this.maxRowWidth + this.frameSpacing[0] * 2;
            }
            this.adjustAlignment();
            if (this.useEqualRows) {
                this.adjustRowHeights(maxHeight);
            }
            this.addNavigationLinks();
            this.markValid(1);
            this.checkRepaint();
        }
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.frameStyle != LINE_STYLE_NONE) {
            Stroke s = g2.getStroke();
            if (this.frameStyle == LINE_STYLE_DASHED) {
                float[] dash = new float[]{1.5f};
                g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 1.0f));
            }
            int leftOffset = path.getHorizontalOffset() + this.getHorizontalOffset();
            int verticalOffset = path.getVerticalOffset() + this.getVerticalOffset();
            int w = this.width;
            int h = this.height;
            if (this.containsLabeledRow) {
                if (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE) {
                    leftOffset += this.columnMaxWidth[0] + this.frameSpacing[0] + this.getColumnSpacing(0) / 2;
                    w -= this.columnMaxWidth[0];
                } else {
                    int lastChildIndex = this.getMaxNumberOfColumns() - 1;
                    w -= this.columnMaxWidth[lastChildIndex] + this.frameSpacing[1] + this.getColumnSpacing(lastChildIndex - 1) / 2;
                }
            }
            g2.drawRect(leftOffset, verticalOffset, w, h - 1);
            g2.setStroke(s);
        }
        int lastRowIndex = this.getChildCount() - 1;
        if (this.containsLabeledRow && !this.drawOverlappedLabel()) {
            --lastRowIndex;
        }
        int i = 0;
        while (i < lastRowIndex) {
            Integer style;
            if (i >= this.rowlineStyles.size()) {
                // empty if block
            }
            Integer n = style = this.rowlineStyles != null && i < this.rowlineStyles.size() ? (Integer)this.rowlineStyles.get(i) : LINE_STYLE_NONE;
            if (style != LINE_STYLE_NONE) {
                WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(i);
                if (this.drawOverlappedLabel() || !row.isLabelRow()) {
                    int y = path.getVerticalOffset() + this.getVerticalOffset() + row.getVerticalOffset() + row.getHeight() + this.getRowSpacing(i) / 2;
                    Stroke s = g2.getStroke();
                    if (style == LINE_STYLE_DASHED) {
                        float[] dash = new float[]{1.5f};
                        g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 1.0f));
                    }
                    int x = path.getHorizontalOffset() + this.getHorizontalOffset() + this.getFrameSpacing(0);
                    int cellWidth = 0;
                    int rowIndex = i + 1;
                    int lastChildIndex = this.getMaxNumberOfColumns();
                    int c = 0;
                    while (c < lastChildIndex) {
                        boolean skipFirstColumnForLabel = false;
                        boolean skipLastColumnForLabel = false;
                        int frameSpacing = 0;
                        int columnSpacing = 0;
                        if (c == 0) {
                            if (this.containsLabeledRow && (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE)) {
                                skipFirstColumnForLabel = true;
                            }
                            frameSpacing = this.getFrameSpacing(0);
                            columnSpacing = this.getColumnSpacing(c) / 2;
                            if (c == lastChildIndex - 1) {
                                frameSpacing += this.getFrameSpacing(0);
                            }
                        } else if (c == lastChildIndex - 1) {
                            frameSpacing = this.getFrameSpacing(0) * -1;
                            columnSpacing = this.getColumnSpacing(c - 1) / 2;
                            if (this.containsLabeledRow) {
                                if (this.side == RIGHT_SIDE || this.side == RIGHT_OVERLAP_SIDE) {
                                    skipLastColumnForLabel = true;
                                } else {
                                    frameSpacing += this.getFrameSpacing(0);
                                    columnSpacing += this.getColumnSpacing(c - 1) / 2;
                                }
                            }
                        } else {
                            frameSpacing = 0;
                            columnSpacing = this.getColumnSpacing(c - 1) / 2 + this.getColumnSpacing(c) / 2;
                        }
                        cellWidth = this.columnMaxWidth[c] + columnSpacing + frameSpacing;
                        if ((this.cellHeights[rowIndex][c] != -1 || this.cellHeights[rowIndex][c] == -1 && this.cellWidths[rowIndex][c] == -1) && !skipFirstColumnForLabel && !skipLastColumnForLabel) {
                            g2.drawLine(x, y, x + cellWidth, y);
                        }
                        x += cellWidth;
                        ++c;
                    }
                    g2.setStroke(s);
                }
            }
            ++i;
        }
        super.draw(g, path, bounds);
    }

    @Override
    public void invalidate(int flag) {
        super.invalidate(flag);
        int len = this.getChildCount();
        int i = 0;
        while (i < len) {
            this.getChild(i).invalidate(flag);
            ++i;
        }
    }

    private void getFrameStyle(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String style;
        String string = style = attrs.getFrame() != null ? attrs.getFrame() : "";
        if (style.equals("solid")) {
            this.frameStyle = LINE_STYLE_SOLID;
        } else if (style.equals("dashed")) {
            this.frameStyle = LINE_STYLE_DASHED;
        }
    }

    private void getAlign(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String align = attrs.getAlign() != null ? attrs.getAlign() : "";
        String[] s = align.split(" ");
        this.alignStyle = s[0].equals("top") ? ALIGN_STYLE_TOP : (s[0].equals("bottom") ? ALIGN_STYLE_BOTTOM : (s[0].equals("center") || s[0].equals("baseline") ? ALIGN_STYLE_CENTER : ALIGN_STYLE_AXIS));
        if (s.length > 1) {
            try {
                this.alignRow = Integer.parseInt(s[1]);
                if (this.alignRow < 0) {
                    this.alignRow = this.getChildCount() + this.alignRow + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void getRowLineStyle(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String style = attrs.getRowLines() != null ? attrs.getRowLines() : "";
        String[] s = style.split(" ");
        Integer lastStyle = LINE_STYLE_NONE;
        int kid = 0;
        while (kid < this.getChildCount() - 1) {
            if (kid < s.length && !s[kid].equals("")) {
                if (s[kid].equals("solid")) {
                    this.rowlineStyles.add(kid, LINE_STYLE_SOLID);
                } else if (s[kid].equals("dashed")) {
                    this.rowlineStyles.add(kid, LINE_STYLE_DASHED);
                } else {
                    this.rowlineStyles.add(kid, LINE_STYLE_NONE);
                }
                lastStyle = (Integer)this.rowlineStyles.get(kid);
            } else {
                this.rowlineStyles.add(lastStyle);
            }
            ++kid;
        }
    }

    public void getRowSpacing(WmiMathTableModel.WmiMathTableAttributeSet attrs) throws WmiNoReadAccessException {
        String spacing = attrs.getRowSpacing() != null ? attrs.getRowSpacing() : "";
        String[] s = spacing.split(" ");
        int lastSpacing = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("1.0ex", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        int kid = 0;
        while (kid < this.getChildCount() - 1) {
            if (kid < s.length && !s[kid].equals("")) {
                int space = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(s[kid], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                this.rowSpacing.add(kid, new Integer(space));
                lastSpacing = space;
            } else {
                this.rowSpacing.add(kid, new Integer(lastSpacing));
            }
            ++kid;
        }
    }

    public int getRowSpacing(int index) {
        if (index < this.rowSpacing.size()) {
            return (Integer)this.rowSpacing.get(index);
        }
        return 0;
    }

    private void getFrameSpacing(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String spacing = attrs.getFrameSpacing() != null ? attrs.getFrameSpacing() : "";
        String[] s = spacing.split(" ");
        this.frameSpacing[0] = !s[0].equals("") ? Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(s[0], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100)) : Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.4em", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        this.frameSpacing[1] = s.length == 2 && !s[1].equals("") ? Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(s[1], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100)) : Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.5ex", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    public int getFrameSpacing(int index) {
        return this.frameSpacing[index];
    }

    private void getEqualRows(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        this.useEqualRows = attrs.getEqualRows();
    }

    private void getEqualColumns(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        this.useEqualColumns = attrs.getEqualColumns();
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String alignment = attrs.getRowAlign() != null ? attrs.getRowAlign() : "";
        String[] s = alignment.split(" ");
        Integer lastAlignment = ALIGN_STYLE_CENTER;
        int kid = 0;
        while (kid < this.getChildCount()) {
            if (kid < s.length && !s[kid].equals("")) {
                if (s[kid].equals("top")) {
                    this.rowAlignments.add(kid, ALIGN_STYLE_TOP);
                } else if (s[kid].equals("bottom")) {
                    this.rowAlignments.add(kid, ALIGN_STYLE_BOTTOM);
                } else if (s[kid].equals("center") || s[kid].equals("baseline")) {
                    this.rowAlignments.add(kid, ALIGN_STYLE_CENTER);
                } else {
                    this.rowAlignments.add(kid, ALIGN_STYLE_AXIS);
                }
                lastAlignment = (Integer)this.rowAlignments.get(kid);
            } else {
                this.rowAlignments.add(lastAlignment);
            }
            ++kid;
        }
    }

    public Integer getRowAlignment(int index) {
        return (Integer)this.rowAlignments.get(index);
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String alignment = attrs.getColumnAlign() != null ? attrs.getColumnAlign() : "";
        String[] s = alignment.split(" ");
        Integer lastAlignment = ALIGN_STYLE_CENTER;
        Integer labelAlignment = null;
        int labelIndex = -1;
        if (this.containsLabeledRow) {
            if (this.side == LEFT_SIDE || this.side == LEFT_OVERLAP_SIDE) {
                labelAlignment = ALIGN_STYLE_LEFT;
                labelIndex = 0;
            } else {
                labelAlignment = ALIGN_STYLE_RIGHT;
                labelIndex = this.getMaxNumberOfColumns() - 1;
            }
        }
        int kid = 0;
        while (kid < this.getMaxNumberOfColumns()) {
            if (kid == labelIndex) {
                this.columnAlignments.add(labelAlignment);
            } else if (kid < s.length && !s[kid].equals("")) {
                if (s[kid].equals("left")) {
                    this.columnAlignments.add(kid, ALIGN_STYLE_LEFT);
                } else if (s[kid].equals("right")) {
                    this.columnAlignments.add(kid, ALIGN_STYLE_RIGHT);
                } else {
                    this.columnAlignments.add(kid, ALIGN_STYLE_CENTER);
                }
                lastAlignment = (Integer)this.columnAlignments.get(kid);
            } else {
                this.columnAlignments.add(lastAlignment);
            }
            ++kid;
        }
    }

    private void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String alignment = attrs.getGroupAlign() != null ? attrs.getGroupAlign() : "";
        String[] s = alignment.split("[\\{\\}]");
        int i = 0;
        while (i < s.length) {
            if (!s[i].trim().equals("")) {
                ArrayList<Integer> groupList = new ArrayList<Integer>();
                String[] list = s[i].split(" ");
                int j = 0;
                while (j < list.length) {
                    if (list[j].equals("left")) {
                        groupList.add(ALIGN_STYLE_LEFT);
                    } else if (list[j].equals("right")) {
                        groupList.add(ALIGN_STYLE_RIGHT);
                    } else if (list[j].equals("center")) {
                        groupList.add(ALIGN_STYLE_CENTER);
                    } else {
                        groupList.add(ALIGN_STYLE_DECIMALPOINT);
                    }
                    ++j;
                }
                this.alignGroupAlignments.add(groupList);
            }
            ++i;
        }
    }

    public ArrayList getAlignGroupAlignments(int columnIndex) {
        return columnIndex < this.alignGroupAlignments.size() ? this.alignGroupAlignments.get(columnIndex) : null;
    }

    public Integer getColumnAlignment(int index) {
        return (Integer)this.columnAlignments.get(index);
    }

    public void getColumnSpacing(WmiMathTableModel.WmiMathTableAttributeSet attrs) throws WmiNoReadAccessException {
        String spacing = attrs.getColumnSpacing() != null ? attrs.getColumnSpacing() : "";
        String[] s = spacing.split(" ");
        int lastSpacing = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension("0.8em", null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
        int kid = 0;
        while (kid < this.getMaxNumberOfColumns() - 1) {
            if (kid < s.length && !s[kid].equals("")) {
                int space = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(s[kid], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                this.columnSpacing.add(kid, new Integer(space));
                lastSpacing = space;
            } else {
                this.columnSpacing.add(kid, new Integer(lastSpacing));
            }
            ++kid;
        }
    }

    public int getColumnSpacing(int index) {
        if (index < this.columnSpacing.size()) {
            return (Integer)this.columnSpacing.get(index);
        }
        return 0;
    }

    private void getColumnLineStyle(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String style = attrs.getColumnLines() != null ? attrs.getColumnLines() : "";
        String[] s = style.split(" ");
        Integer lastStyle = LINE_STYLE_NONE;
        int kid = 0;
        while (kid < this.getMaxNumberOfColumns()) {
            if (kid < s.length && !s[kid].equals("")) {
                if (s[kid].equals("solid")) {
                    this.columnlineStyles.add(kid, LINE_STYLE_SOLID);
                } else if (s[kid].equals("dashed")) {
                    this.columnlineStyles.add(kid, LINE_STYLE_DASHED);
                } else {
                    this.columnlineStyles.add(kid, LINE_STYLE_NONE);
                }
                lastStyle = (Integer)this.columnlineStyles.get(kid);
            } else {
                this.columnlineStyles.add(lastStyle);
            }
            ++kid;
        }
    }

    public Integer getColumnLineStyle(int index) {
        return index >= 0 && index < this.columnlineStyles.size() ? this.columnlineStyles.get(index) : LINE_STYLE_NONE;
    }

    private void getWidth(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        this.tableWidth = attrs.getWidth() != null ? attrs.getWidth() : "auto";
    }

    private void getColumnWidth(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String width = attrs.getColumnWidth() != null ? attrs.getColumnWidth() : "";
        String[] w = width.split(" ");
        String lastWidthObject = "auto";
        int kid = 0;
        while (kid < this.getMaxNumberOfColumns()) {
            if (kid < w.length && !w[kid].equals("")) {
                Object widthObject;
                if (!(w[kid].equals("auto") || w[kid].equals("fit") || w[kid].endsWith("%"))) {
                    int colWidth = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(w[kid], null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
                    widthObject = new Integer(colWidth);
                } else {
                    widthObject = w[kid];
                }
                this.columnWidth.add(kid, widthObject);
                lastWidthObject = widthObject;
            } else {
                this.columnWidth.add(kid, lastWidthObject);
            }
            ++kid;
        }
    }

    private void getSide(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String sideString;
        String string = sideString = attrs.getSide() != null ? attrs.getSide() : "";
        this.side = sideString.equals("left") ? LEFT_SIDE : (sideString.equals("rightoverlap") ? RIGHT_OVERLAP_SIDE : (sideString.equals("leftoverlap") ? LEFT_OVERLAP_SIDE : RIGHT_SIDE));
    }

    public Integer getSide() {
        return this.side;
    }

    public boolean containsLabeledRow() {
        return this.containsLabeledRow;
    }

    public boolean drawOverlappedLabel() {
        return this.containsLabeledRow && (this.side == LEFT_OVERLAP_SIDE || this.side == RIGHT_OVERLAP_SIDE) && this.cellLinebroken;
    }

    private void getMinLabelSpacing(WmiMathTableModel.WmiMathTableAttributeSet attrs) {
        String spacingString = attrs.getMinLabelSpacing() != null ? attrs.getMinLabelSpacing() : "0.8em";
        this.minLabelSpacing = Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(spacingString, null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    private void adjustAlignment() throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiAttributeSet attrs = model != null ? model.getAttributesForRead() : null;
        Font font = null;
        boolean printing = this.getDocumentView().isPrintView();
        font = attrs instanceof WmiFontAttributeSet ? WmiFontResolver.getFont((WmiFontAttributeSet)attrs, this.getZoomFactor(), printing) : WmiFontResolver.getFont(WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES, this.getZoomFactor(), printing);
        WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
        if (this.alignStyle == ALIGN_STYLE_AXIS) {
            this.setBaseline(this.height / 2 + metrics.getFontProperty(3, printing) / 2);
        } else if (this.alignStyle == ALIGN_STYLE_TOP) {
            this.setBaseline(this.getVerticalOffsetOfRow(this.alignRow));
        } else if (this.alignStyle == ALIGN_STYLE_BOTTOM) {
            this.setBaseline(this.getVerticalOffsetOfRow(this.alignRow) + this.getHeightOfRow(this.alignRow));
        } else if (this.alignStyle == ALIGN_STYLE_CENTER) {
            this.setBaseline(this.height / 2);
        }
        this.baseline = this.baseline >= 0 ? this.baseline : 0;
    }

    private void adjustRowHeights(int maxHeight) {
        WmiMathTableRowView rowView;
        int accumOffs = this.frameSpacing[1];
        int i = 0;
        while (i < this.getChildCount()) {
            rowView = (WmiMathTableRowView)this.getChild(i);
            if (i != 0) {
                accumOffs += this.getRowSpacing(i - 1);
            }
            rowView.setVerticalOffset(accumOffs);
            rowView.setHeight(maxHeight);
            rowView.setMaxHeight(maxHeight);
            accumOffs += rowView.getHeight();
            ++i;
        }
        this.setHeight(accumOffs + this.frameSpacing[1]);
        int r = 0;
        while (r < this.getChildCount()) {
            rowView = (WmiMathTableRowView)this.getChild(r);
            int c = 0;
            while (c < rowView.getChildCount()) {
                WmiMathTableCellView cellView = (WmiMathTableCellView)rowView.getChild(c);
                cellView.adjustVerticalAlignment(this, rowView);
                ++c;
            }
            ++r;
        }
    }

    private int getVerticalOffsetOfRow(int rowIndex) {
        if (rowIndex > 0) {
            return ((WmiMathTableRowView)this.getChild(rowIndex - 1)).getVerticalOffset();
        }
        return 0;
    }

    private int getHeightOfRow(int rowIndex) {
        if (rowIndex > 0) {
            return ((WmiMathTableRowView)this.getChild(rowIndex - 1)).getHeight();
        }
        return 0;
    }

    public int getMaxNumberOfColumns() {
        return this.maxColumnCount;
    }

    public int getNumberOfRows() {
        return this.getChildCount();
    }

    @Override
    public void addNavigationLinks() {
        int viewCount = this.getChildCount();
        if (viewCount > 0) {
            WmiMathTableRowView firstView = (WmiMathTableRowView)this.getChild(0);
            firstView.setNextView(null, 0);
            firstView.setNextView(null, 2);
            WmiMathTableRowView lastView = (WmiMathTableRowView)this.getChild(viewCount - 1);
            lastView.setNextView(null, 1);
            lastView.setNextView(null, 3);
        }
        int i = 0;
        while (i < viewCount - 1) {
            WmiMathTableRowView prevRowView = (WmiMathTableRowView)this.getChild(i);
            WmiMathTableRowView nextRowView = (WmiMathTableRowView)this.getChild(i + 1);
            prevRowView.setNextView(nextRowView, 1);
            prevRowView.setNextView(nextRowView, 3);
            nextRowView.setNextView(prevRowView, 0);
            nextRowView.setNextView(prevRowView, 2);
            ++i;
        }
    }

    public int getCellWidth(int rowIndex, int columnIndex) {
        return this.cellWidths[rowIndex][columnIndex];
    }

    public int getCellHeight(int rowIndex, int columnIndex) {
        return this.cellHeights[rowIndex][columnIndex];
    }

    /*
     * Unable to fully structure code
     */
    public void calculateMaxColumnWidths() throws WmiNoReadAccessException {
        v0 = tableWidthValue = this.dontLineBreakCells != false ? 0x7FFFFFFF : this.calculateTableWidth();
        if (!this.tableWidth.equals("auto")) {
            this.maxRowWidth = tableWidthValue - this.frameSpacing[0] * 2;
        }
        rowSpans = new int[this.maxColumnCount];
        Arrays.fill(rowSpans, 0);
        r = 0;
        while (r < this.getChildCount()) {
            rowView = (WmiMathTableRowView)this.getChild(r);
            rowCount = rowView.getChildCount();
            columnSpanTotal = 0;
            cellWidth = 0;
            c = 0;
            index = 0;
            ** GOTO lbl45
            {
                this.cellWidths[r][c] = cellWidth;
                ++c;
                do {
                    if (rowSpans[c] > 0) continue block1;
                    cellView = (WmiMathTableCellView)rowView.getChild(index);
                    cellView.invalidate(1);
                    cellView.setCellIndex(r, c);
                    cellView.layoutView(false);
                    cellWidth = cellView.getWidth();
                    cellHeight = cellView.getHeight();
                    columnSpan = cellView.getColumnSpan();
                    columnSpanTotal += columnSpan > 1 ? columnSpan - 1 : 0;
                    rowSpan = cellView.getRowSpan();
                    if (rowSpan > 1) {
                        rowSpans[c] = rowSpan;
                    }
                    if (this.containsLabeledRow && (c == 0 && (this.side == WmiMathTableView.LEFT_SIDE || this.side == WmiMathTableView.LEFT_OVERLAP_SIDE) || c == this.getMaxNumberOfColumns() - 1 && (this.side == WmiMathTableView.RIGHT_SIDE || this.side == WmiMathTableView.RIGHT_OVERLAP_SIDE))) {
                        cellWidth += this.minLabelSpacing;
                    }
                    if (columnSpan == 1) {
                        if (cellWidth > this.columnMaxWidth[c]) {
                            this.columnMaxWidth[c] = cellWidth;
                        }
                        this.cellWidths[r][c] = cellWidth;
                        this.cellHeights[r][c] = cellHeight;
                    } else {
                        i = c;
                        while (i < c + columnSpan) {
                            this.cellHeights[r][i] = cellHeight;
                            ++i;
                        }
                    }
                    c += columnSpan;
                    ++index;
lbl45:
                    // 2 sources

                } while (index < rowCount);
            }
            i = 0;
            while (i < this.maxColumnCount) {
                if (rowSpans[i] > 0) {
                    v1 = i;
                    rowSpans[v1] = rowSpans[v1] - 1;
                }
                ++i;
            }
            ++r;
        }
        preferredWidth = this.frameSpacing[0] * 2;
        totalColumnSpacing = 0;
        i = 0;
        while (i < this.columnMaxWidth.length) {
            preferredWidth += this.columnMaxWidth[i];
            ++i;
        }
        i = 0;
        while (i < this.columnSpacing.size()) {
            preferredWidth += this.getColumnSpacing(i);
            totalColumnSpacing += this.getColumnSpacing(i);
            ++i;
        }
        if (tableWidthValue == 0) {
            tableWidthValue = preferredWidth;
        }
        fitColumnCount = 0;
        explicitWidths = 0;
        i = 0;
        while (i < this.columnWidth.size()) {
            widthObject = this.columnWidth.get(i);
            if (widthObject instanceof String) {
                widthString = widthObject.toString();
                if (widthString.endsWith("%")) {
                    percentage = Integer.parseInt(widthString.substring(0, widthString.indexOf("%")));
                    this.columnMaxWidth[i] = Math.round((float)tableWidthValue * (float)((double)percentage * 0.01));
                    explicitWidths += this.columnMaxWidth[i];
                } else if (widthString.equals("fit") || preferredWidth > tableWidthValue && widthString.equals("auto")) {
                    ++fitColumnCount;
                }
            } else {
                this.columnMaxWidth[i] = width = ((Integer)widthObject).intValue();
                explicitWidths += this.columnMaxWidth[i];
            }
            ++i;
        }
        if (!(this.isMatrix() || fitColumnCount <= 0 && preferredWidth <= tableWidthValue)) {
            availableWidth = tableWidthValue - this.frameSpacing[0] * 2 - totalColumnSpacing - explicitWidths;
            fitColumnWidth = availableWidth / fitColumnCount;
            i = 0;
            while (i < this.columnMaxWidth.length) {
                if (fitColumnCount > 1 && this.columnMaxWidth[i] < fitColumnWidth) {
                    fitColumnWidth = (availableWidth -= this.columnMaxWidth[i]) / (fitColumnCount - 1);
                }
                ++i;
            }
            i = 0;
            while (i < this.columnWidth.size()) {
                widthObject = this.columnWidth.get(i);
                if (widthObject instanceof String && ((widthString = widthObject.toString()).equals("fit") || preferredWidth > tableWidthValue && widthString.equals("auto")) && this.getMaximumColumnWidth(i) > fitColumnWidth) {
                    this.columnMaxWidth[i] = fitColumnWidth;
                }
                ++i;
            }
        }
        if (tableWidthValue > preferredWidth && !this.tableWidth.equals("auto")) {
            i = 0;
            while (i < this.columnWidth.size()) {
                this.columnMaxWidth[i] = Math.round(tableWidthValue / this.columnWidth.size());
                ++i;
            }
        }
        if (this.useEqualColumns) {
            maxWidth = this.getMaxColumnWidth();
            r = 0;
            while (r < this.getChildCount()) {
                c = 0;
                while (c < this.maxColumnCount) {
                    this.columnMaxWidth[c] = maxWidth;
                    ++c;
                }
                ++r;
            }
        }
    }

    public void calculateAlignGroupWidths() throws WmiNoReadAccessException {
        int rowCount = this.getChildCount();
        int r = 0;
        while (r < rowCount) {
            WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(r);
            WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet rowAttrs = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)row.getModel().getAttributesForRead();
            row.getAlignGroupAlignments(rowAttrs);
            int cellCount = row.getChildCount();
            if (this.maxAlignGroupCount == null) {
                this.maxAlignGroupCount = new int[cellCount];
            }
            if (this.alignGroupWidths == null) {
                this.alignGroupWidths = new ArrayList[rowCount][cellCount];
            }
            int c = 0;
            while (c < cellCount) {
                this.alignGroupWidths[r][c] = new ArrayList();
                WmiMathTableCellView cell = (WmiMathTableCellView)row.getChild(c);
                WmiMathAlignGroupView alignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findFirstDescendantOfTag(cell, WmiModelTag.MATH_ALIGN_GROUP);
                WmiMathAlignGroupView nextAlignGroupView = null;
                if (alignGroupView != null) {
                    nextAlignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(cell, alignGroupView, WmiModelTag.MATH_ALIGN_GROUP);
                }
                int alignGroupCount = 0;
                while (alignGroupView != null) {
                    WmiMathAlignMarkView alignMarkView = (WmiMathAlignMarkView)WmiViewUtil.findNextDescendantOfTag(cell, alignGroupView, WmiModelTag.MATH_ALIGN_MARK);
                    WmiMathAlignMarkView wmiMathAlignMarkView = alignMarkView = nextAlignGroupView != null && WmiViewUtil.getRelativeOffset(alignMarkView, cell).getX() >= WmiViewUtil.getRelativeOffset(nextAlignGroupView, cell).getX() ? null : alignMarkView;
                    if (alignMarkView != null) {
                        Point pt = WmiViewUtil.getRelativeOffset(alignMarkView, cell);
                        Point groupPt = WmiViewUtil.getRelativeOffset(alignGroupView, cell);
                        this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(pt.x - groupPt.x));
                        if (nextAlignGroupView != null) {
                            Point nextPt = WmiViewUtil.getRelativeOffset(nextAlignGroupView, cell);
                            this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(nextPt.x - pt.x));
                        } else {
                            this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(cell.getWidth() - pt.x));
                        }
                    } else {
                        boolean embeddedAlignMark = false;
                        WmiCompositeView grandparent = alignGroupView.getParentView().getParentView();
                        WmiPositionedView tokenView = (WmiPositionedView)WmiViewUtil.findFirstDescendantOfClass(grandparent, WmiTextView.class);
                        tokenView = WmiViewUtil.getRelativeOffset(tokenView, cell).getX() < WmiViewUtil.getRelativeOffset(alignGroupView, cell).getX() ? null : tokenView;
                        while (tokenView != null) {
                            if (((WmiAbstractMathTokenModel)tokenView.getModel()).alignmarkIndex >= 0) {
                                int rightWidth;
                                int index = ((WmiAbstractMathTokenModel)tokenView.getModel()).alignmarkIndex;
                                Point tokenPt = WmiViewUtil.getRelativeOffset(tokenView, cell);
                                Point alignPt = WmiViewUtil.getRelativeOffset(alignGroupView, cell);
                                WmiTextLayout layout = ((WmiTextView)tokenView).getLayout();
                                int offset = layout.getCaretPosition(index, true);
                                int leftWidth = tokenPt.x - alignPt.x + offset;
                                this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(leftWidth));
                                if (nextAlignGroupView != null) {
                                    Point nextPt = WmiViewUtil.getRelativeOffset(nextAlignGroupView, cell);
                                    rightWidth = nextPt.x - tokenPt.x - offset;
                                } else {
                                    rightWidth = cell.getWidth() - tokenPt.x - offset;
                                }
                                this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(rightWidth));
                                alignGroupView.containsEmbeddedAlignMark = true;
                                embeddedAlignMark = true;
                                break;
                            }
                            WmiPositionedView wmiPositionedView = tokenView = WmiViewUtil.getRelativeOffset(tokenView = (WmiPositionedView)WmiViewUtil.findNextDescendantOfClass(grandparent, tokenView, WmiTextView.class), cell).getX() < WmiViewUtil.getRelativeOffset(alignGroupView, cell).getX() ? null : tokenView;
                        }
                        if (!embeddedAlignMark) {
                            WmiCompositeView parent;
                            WmiMathTextView numeric;
                            WmiMathAlignGroupModel alignGroup = (WmiMathAlignGroupModel)alignGroupView.getModel();
                            WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet groupAttrs = (WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet)alignGroup.getAttributesForRead();
                            Integer align = this.getGroupAlign(groupAttrs, c, alignGroupCount, row, cell);
                            if (align == ALIGN_STYLE_LEFT || align == ALIGN_STYLE_CENTER || align == ALIGN_STYLE_RIGHT) {
                                int groupWidth;
                                Point pt = WmiViewUtil.getRelativeOffset(alignGroupView, cell);
                                if (nextAlignGroupView != null) {
                                    Point nextPt = WmiViewUtil.getRelativeOffset(nextAlignGroupView, cell);
                                    groupWidth = nextPt.x - pt.x;
                                } else {
                                    groupWidth = cell.getWidth() - pt.x;
                                }
                                if (align == ALIGN_STYLE_LEFT) {
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(0));
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(groupWidth));
                                } else if (align == ALIGN_STYLE_CENTER) {
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(groupWidth / 2));
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(groupWidth / 2));
                                } else if (align == ALIGN_STYLE_RIGHT) {
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(groupWidth));
                                    this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(0));
                                }
                            } else if (align == ALIGN_STYLE_DECIMALPOINT && (numeric = (WmiMathTextView)WmiViewUtil.findNextDescendantOfTag(parent = alignGroupView.getParentView().getParentView(), alignGroupView, WmiModelTag.MATH_NUMERIC)) != null) {
                                int rightWidth;
                                Point decimalPt = WmiViewUtil.getRelativeOffset(numeric, cell);
                                Point alignPt = WmiViewUtil.getRelativeOffset(alignGroupView, cell);
                                int decimalOffset = decimalPt.x - alignPt.x;
                                String number = ((WmiNumericModel)numeric.getModel()).getText();
                                WmiTextLayout layout = numeric.getLayout();
                                int index = number.indexOf(".");
                                int offset = index >= 0 ? layout.getCaretPosition(number.indexOf("."), true) : layout.getWidth();
                                this.alignGroupWidths[r][c].add(alignGroupCount * 2, new Integer(decimalOffset + offset));
                                if (nextAlignGroupView != null) {
                                    Point nextPt = WmiViewUtil.getRelativeOffset(nextAlignGroupView, cell);
                                    rightWidth = nextPt.x - decimalPt.x - offset;
                                } else {
                                    rightWidth = cell.getWidth() - decimalPt.x - offset;
                                }
                                this.alignGroupWidths[r][c].add(alignGroupCount * 2 + 1, new Integer(rightWidth));
                            }
                        }
                    }
                    alignGroupView = nextAlignGroupView;
                    if (nextAlignGroupView != null) {
                        nextAlignGroupView = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(cell, nextAlignGroupView, WmiModelTag.MATH_ALIGN_GROUP);
                    }
                    ++alignGroupCount;
                }
                this.maxAlignGroupCount[c] = alignGroupCount > this.maxAlignGroupCount[c] ? alignGroupCount : this.maxAlignGroupCount[c];
                ++c;
            }
            ++r;
        }
    }

    public void calculateAlignGroupMaxWidths() {
        int rowCount = this.getChildCount();
        int r = 0;
        while (r < rowCount) {
            WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(r);
            int cellCount = row.getChildCount();
            if (this.maxAlignGroupWidths == null) {
                this.maxAlignGroupWidths = new ArrayList[cellCount];
            }
            int c = 0;
            while (c < cellCount) {
                if (this.maxAlignGroupWidths[c] == null) {
                    this.maxAlignGroupWidths[c] = new ArrayList(this.maxAlignGroupCount[c] * 2);
                    int i = 0;
                    while (i < this.maxAlignGroupCount[c] * 2) {
                        this.maxAlignGroupWidths[c].add(new Integer(0));
                        ++i;
                    }
                }
                ArrayList alignGroupList = this.alignGroupWidths[r][c];
                int i = 0;
                while (i < alignGroupList.size()) {
                    if ((Integer)alignGroupList.get(i) > (Integer)this.maxAlignGroupWidths[c].get(i)) {
                        this.maxAlignGroupWidths[c].set(i, alignGroupList.get(i));
                    }
                    ++i;
                }
                ++c;
            }
            ++r;
        }
    }

    public void calculateAlignedColumnWidths() {
        WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(0);
        int columnCount = row.getChildCount();
        int c = 0;
        while (c < columnCount) {
            this.columnMaxWidth[c] = 0;
            int i = 0;
            while (i < this.maxAlignGroupCount[c] * 2) {
                int n = c;
                this.columnMaxWidth[n] = this.columnMaxWidth[n] + (Integer)this.maxAlignGroupWidths[c].get(i);
                int n2 = c;
                this.columnMaxWidth[n2] = this.columnMaxWidth[n2] + (Integer)this.maxAlignGroupWidths[c].get(i + 1);
                i += 2;
            }
            ++c;
        }
    }

    private Integer getGroupAlign(WmiMathAlignGroupModel.WmiMathAlignGroupAttributeSet attrs, int columnIndex, int alignGroupIndex, WmiMathTableRowView row, WmiMathTableCellView cell) {
        Integer align = ALIGN_STYLE_LEFT;
        String alignAttr = attrs.getGroupAlign();
        if (!alignAttr.equals("")) {
            align = alignAttr.equals("left") ? ALIGN_STYLE_LEFT : (alignAttr.equals("right") ? ALIGN_STYLE_RIGHT : (alignAttr.equals("center") ? ALIGN_STYLE_CENTER : ALIGN_STYLE_DECIMALPOINT));
        } else {
            ArrayList alignList = cell.getAlignmentGroupAlignments();
            if (alignList != null && alignGroupIndex < alignList.size()) {
                align = (Integer)alignList.get(alignGroupIndex);
            } else {
                alignList = row.getAlignGroupAlignments(columnIndex);
                if (alignList != null) {
                    align = (Integer)alignList.get(alignGroupIndex);
                } else {
                    alignList = this.getAlignGroupAlignments(columnIndex);
                    if (alignList != null) {
                        align = (Integer)alignList.get(alignGroupIndex);
                    }
                }
            }
        }
        return align;
    }

    /*
     * Unable to fully structure code
     */
    public void linebreakCells() throws WmiNoReadAccessException {
        this.cellLinebroken = false;
        rowSpans = new int[this.maxColumnCount];
        Arrays.fill(rowSpans, 0);
        r = 0;
        while (r < this.getChildCount()) {
            rowView = (WmiMathTableRowView)this.getChild(r);
            rowCount = rowView.getChildCount();
            c = 0;
            index = 0;
            ** GOTO lbl27
            {
                ++c;
                do {
                    if (rowSpans[c] > 0) continue block1;
                    cellView = (WmiMathTableCellView)rowView.getChild(index);
                    columnSpan = cellView.getColumnSpan();
                    rowSpan = cellView.getRowSpan();
                    if (rowSpan > 1) {
                        rowSpans[c] = rowSpan;
                    }
                    if (columnSpan > 1) {
                        c += columnSpan - 1;
                    }
                    if (cellView.getWidth() > this.columnMaxWidth[c]) {
                        cellView.invalidate(1);
                        cellView.layoutView(this.isMatrix() == false);
                        this.cellLinebroken = true;
                    }
                    ++c;
                    ++index;
lbl27:
                    // 2 sources

                } while (index < rowCount);
            }
            i = 0;
            while (i < this.maxColumnCount) {
                if (rowSpans[i] > 0) {
                    v0 = i;
                    rowSpans[v0] = rowSpans[v0] - 1;
                }
                ++i;
            }
            ++r;
        }
    }

    private int calculateTableWidth() {
        if (this.tableWidth.equals("auto")) {
            this.breakWidth = this.getBreakWidth();
            return this.breakWidth;
        }
        if (this.tableWidth.endsWith("%")) {
            int percentage = Integer.parseInt(this.tableWidth.substring(0, this.tableWidth.indexOf("%")));
            return Math.round((float)this.breakWidth * (float)((double)percentage * 0.01));
        }
        return Math.round(WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(this.tableWidth, null), this.fontAttributes, this.getDocumentView().isPrintView()) * (this.zoomFactor / 100));
    }

    public void calculateMaxRowHeights() {
        int r = 0;
        while (r < this.getChildCount()) {
            int c = 0;
            while (c < this.maxColumnCount) {
                this.rowMaxHeight[r] = this.cellHeights[r][c] > this.rowMaxHeight[r] ? this.cellHeights[r][c] : this.rowMaxHeight[r];
                ++c;
            }
            ++r;
        }
        if (this.useEqualRows) {
            int maxHeight = this.getMaxRowHeight();
            int r2 = 0;
            while (r2 < this.getChildCount()) {
                this.rowMaxHeight[r2] = maxHeight;
                ++r2;
            }
        }
    }

    public int getColumnIndex(int rowIndex, int childIndex) {
        int columnIndex = 0;
        WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(rowIndex);
        int i = 0;
        while (i < childIndex) {
            WmiMathTableCellView cell = (WmiMathTableCellView)row.getChild(i);
            columnIndex += cell.getColumnSpan();
            ++i;
        }
        while (columnIndex < this.cellHeights[rowIndex].length && this.getCellHeight(rowIndex, columnIndex) == 0) {
            ++columnIndex;
        }
        return columnIndex;
    }

    public int getMaxColumnWidth() {
        int maxWidth = 0;
        int i = 0;
        while (i < this.columnMaxWidth.length) {
            maxWidth = this.columnMaxWidth[i] > maxWidth ? this.columnMaxWidth[i] : maxWidth;
            ++i;
        }
        return maxWidth;
    }

    public int getMaxRowHeight() {
        int maxHeight = 0;
        int i = 0;
        while (i < this.rowMaxHeight.length) {
            maxHeight = this.rowMaxHeight[i] > maxHeight ? this.rowMaxHeight[i] : maxHeight;
            ++i;
        }
        return maxHeight;
    }

    public int getMaxRowWidth() {
        return this.maxRowWidth;
    }

    public int getMaximumColumnWidth(int column) {
        if (column < this.columnMaxWidth.length) {
            return this.columnMaxWidth[column];
        }
        return this.columnMaxWidth[this.columnMaxWidth.length - 1];
    }

    public int getMaximumRowHeight(int row) {
        if (row < this.rowMaxHeight.length) {
            return this.rowMaxHeight[row];
        }
        return this.rowMaxHeight[this.rowMaxHeight.length - 1];
    }

    private void initializeRowAndColumnBookkeeping() {
        this.checkForLabeledRow();
        this.maxColumnCount = 0;
        int r = 0;
        while (r < this.getChildCount()) {
            WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(r);
            int columnCount = 0;
            int c = 0;
            while (c < row.getChildCount()) {
                WmiMathTableCellView cell = (WmiMathTableCellView)row.getChild(c);
                columnCount += cell.getColumnSpan();
                ++c;
            }
            this.maxColumnCount = columnCount > this.maxColumnCount ? columnCount : this.maxColumnCount;
            ++r;
        }
        this.cellWidths = new int[this.getChildCount()][this.maxColumnCount];
        r = 0;
        while (r < this.getChildCount()) {
            Arrays.fill(this.cellWidths[r], 0, this.maxColumnCount, -1);
            ++r;
        }
        this.columnMaxWidth = new int[this.maxColumnCount];
        this.cellHeights = new int[this.getChildCount()][this.maxColumnCount];
        r = 0;
        while (r < this.getChildCount()) {
            Arrays.fill(this.cellHeights[r], 0, this.maxColumnCount, -1);
            ++r;
        }
        this.rowMaxHeight = new int[this.getChildCount()];
        this.columnWidth = new ArrayList();
        this.columnSpacing = new ArrayList();
        this.rowSpacing = new ArrayList();
        this.rowlineStyles = new ArrayList();
        this.rowAlignments = new ArrayList();
        this.columnlineStyles = new ArrayList();
        this.columnAlignments = new ArrayList();
    }

    public void checkForLabeledRow() {
        int i = 0;
        while (i < this.getChildCount()) {
            WmiView row = this.getChild(i);
            if (row instanceof WmiMathTableLabeledRowView) {
                this.containsLabeledRow = true;
            }
            ++i;
        }
    }

    public void resize(int width) throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.initializeRowAndColumnBookkeeping();
        }
        int r = 0;
        while (r < this.getChildCount()) {
            WmiMathTableRowView row = (WmiMathTableRowView)this.getChild(r);
            int c = 0;
            while (c < row.getChildCount()) {
                WmiMathTableCellView cell = (WmiMathTableCellView)row.getChild(c);
                cell.invalidate(1);
                ++c;
            }
            ++r;
        }
        this.width = width;
        this.breakWidth = width;
        this.layoutView();
    }

    @Override
    public int getBreakWidth() {
        WmiCompositeView parent = this.getParentView();
        WmiCellView cell = null;
        while (parent != null) {
            if (parent instanceof WmiCellView) {
                cell = (WmiCellView)((Object)parent);
                break;
            }
            parent = parent.getParentView();
        }
        if (cell != null) {
            this.breakWidth = cell.getBreakWidth();
            parent = this.getParentView();
            while (parent != cell) {
                if (parent instanceof WmiRowView) {
                    this.breakWidth -= ((WmiRowView)parent).getLeftIndent();
                    this.breakWidth -= ((WmiRowView)parent).getRightIndent();
                }
                parent = parent.getParentView();
            }
        } else {
            this.breakWidth = super.getBreakWidth();
        }
        return this.breakWidth;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        if (thresholdCost >= 1 || this.getWidth() > breakWidth) {
            if (this.isMatrix()) {
                WmiMathContext context = this.getContext();
                WmiInlineView inline = this.convertToList(context);
                WmiCompositeView parent = this.getParentView();
                int index = parent.indexOf(this);
                parent.replaceChild(inline, index);
                inline.setParentView(parent);
                inline.applyMathRules(true);
                inline.lockOperatorSize(false);
                inline.markInvalid(1);
                inline.layoutView();
                success = 1;
            } else {
                this.resize(breakWidth - horizontalOffset);
                WmiCompositeView parent = this.getParentView();
                parent.markInvalid(1);
                ((WmiPositionedView)((Object)parent)).layoutView();
                int index = parent.indexOf(this);
                if (index >= 0) {
                    paragraph.split(parent, index + 1, 0);
                    success = 2;
                }
            }
        }
        return success;
    }

    private WmiInlineView convertToList(WmiMathContext context) throws WmiNoReadAccessException {
        WmiMathDocumentView docView = this.getDocumentView();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiInlineView inline = new WmiInlineView(this.getModel(), this.getDocumentView());
        inline.releaseObserver();
        int numRows = this.getChildCount();
        int i = 0;
        while (i < numRows) {
            WmiView child = this.getChild(i);
            if (numRows > 1) {
                this.addToken(inline, context, docModel, docView, "[");
            }
            if (child instanceof WmiCompositeView) {
                WmiCompositeView composite = (WmiCompositeView)child;
                int size = composite.getChildCount();
                int j = 0;
                while (j < size) {
                    WmiView grandChild = composite.getChild(j);
                    if (grandChild instanceof WmiMathTableCellView) {
                        this.appendCell(inline, (WmiMathTableCellView)grandChild);
                    } else {
                        inline.appendView(grandChild);
                    }
                    if (j < size - 1) {
                        this.addToken(inline, context, docModel, docView, ", ");
                    }
                    ++j;
                }
            }
            if (numRows > 1) {
                this.addToken(inline, context, docModel, docView, "]");
            }
            if (i < numRows - 1) {
                this.addToken(inline, context, docModel, docView, ", ");
                this.addNewline(inline, docModel, docView);
            }
            ++i;
        }
        return inline;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet attrs;
        WmiMathContext context = null;
        WmiView view = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (view != null && view.getModel() instanceof WmiMathWrapperModel && (attrs = view.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            context = new WmiMathContext((WmiFontAttributeSet)attrs);
        }
        if (context == null) {
            context = new WmiMathContext(null);
        }
        return context;
    }

    private void appendCell(WmiInlineView inline, WmiMathTableCellView cell) {
        int size = cell.getChildCount();
        int i = 0;
        while (i < size) {
            inline.appendView(cell.getChild(i));
            ++i;
        }
    }

    private void addToken(WmiInlineView inline, WmiMathContext context, WmiMathDocumentModel docModel, WmiMathDocumentView docView, String token) throws WmiNoReadAccessException {
        WmiMathTokenModel comma = WmiMathFactory.createMathOperatorToken(docModel, token, context);
        WmiMathOperatorView commaV = new WmiMathOperatorView(comma, docView);
        commaV.layoutView();
        inline.appendView(commaV);
    }

    private void addNewline(WmiInlineView inline, WmiMathDocumentModel docModel, WmiMathDocumentView docView) {
        WmiMathSpaceModel spaced = new WmiMathSpaceModel(docModel);
        try {
            spaced.addAttribute("linebreak", "newline");
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        WmiMathSpaceView spaceView = new WmiMathSpaceView(spaced, docView);
        inline.appendView(spaceView);
    }
}

