/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathTextFragmentView;
import java.awt.Font;
import java.awt.Point;

public class WmiMathTextView
extends WmiTextView {
    public WmiMathTextView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void setPositionMarker(int offset) {
        block11: {
            if (WmiModelLock.readLock(this.getModel(), true)) {
                try {
                    try {
                        WmiMathDocumentView docView;
                        if (offset == -1) {
                            offset = this.getTraversableCount();
                        }
                        if ((docView = this.getDocumentView()) != null) {
                            int[] mcaretBounds;
                            WmiCaret caret = docView.getCaret();
                            boolean setMarker = false;
                            if (!(caret instanceof WmiMathCaret)) {
                                caret = new WmiMathCaret(docView);
                                setMarker = true;
                            }
                            WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
                            int[] obounds = super.getCaretBounds(container, offset);
                            if (caret instanceof WmiMathCaret) {
                                ((WmiMathCaret)caret).setUprightPosition(obounds[0], obounds[2]);
                            }
                            int n = (mcaretBounds = this.getCaretBounds(offset))[2] > obounds[2] ? mcaretBounds[2] : obounds[2];
                            mcaretBounds[2] = n;
                            caret.updateCaretBounds(container, mcaretBounds[0], mcaretBounds[1], mcaretBounds[2], mcaretBounds[3]);
                            caret.updateView(this, offset);
                            if (setMarker) {
                                docView.setPositionMarker(caret);
                            }
                            caret.show();
                            break block11;
                        }
                        WmiErrorLog.log(new Exception("unable to find document view"));
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.readUnlock(this.getModel());
                    }
                }
                finally {
                    WmiModelLock.readUnlock(this.getModel());
                }
            }
        }
    }

    public int[] getCaretBounds(int offset) throws WmiNoReadAccessException {
        WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
        Point leftBound = WmiViewUtil.getRelativeOffset(this, container);
        int[] bounds = super.getCaretBounds(container, offset);
        bounds[0] = leftBound.x;
        bounds[2] = leftBound.x + this.getWidth();
        return bounds;
    }

    @Override
    public WmiView createViewFragment(int startIndex, int endIndex) throws WmiNoReadAccessException {
        return new WmiMathTextFragmentView(this.getModel(), this.getDocumentView(), startIndex, endIndex);
    }

    @Override
    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        return WmiMathTextView.getCorrectedZoomFactor(this);
    }

    public static int getCorrectedZoomFactor(WmiPositionedView view) throws WmiNoReadAccessException {
        WmiMathDocumentView docView = view.getDocumentView();
        int zoom = view.getZoomFactor();
        boolean scriptSize = false;
        WmiModel model = view.getModel();
        WmiCompositeModel parent = model.getParent();
        while (parent instanceof WmiMathModel) {
            scriptSize = ((WmiMathModel)((Object)parent)).useScriptSize(model);
            if (scriptSize) {
                WmiMathStyleModel mstyle = (WmiMathStyleModel)WmiModelUtil.findAncestorOfTag((WmiModel)parent, WmiModelTag.MATH_STYLE);
                if (mstyle != null) {
                    WmiMathStyleModel.WmiMathStyleAttributeSet attrs = (WmiMathStyleModel.WmiMathStyleAttributeSet)mstyle.getAttributesForRead();
                    zoom = Math.round((float)zoom * WmiMathInlineView.calculateScaleFactor(attrs, 0.8f, docView));
                    break;
                }
                zoom = Math.round((float)zoom * 0.8f);
                break;
            }
            model = parent;
            parent = model.getParent();
        }
        return zoom;
    }

    public static void setDefaultHeight(WmiPositionedView view) throws WmiNoReadAccessException {
        WmiAttributeSet attrs;
        WmiModel model = view.getModel();
        WmiAttributeSet wmiAttributeSet = attrs = model != null ? model.getAttributesForRead() : null;
        if (attrs instanceof WmiFontAttributeSet) {
            int zoomFactor = WmiMathTextView.getCorrectedZoomFactor(view);
            Font font = WmiFontResolver.getFont((WmiFontAttributeSet)attrs, zoomFactor, false);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            view.setBaseline(metrics.getFontProperty(3));
            view.setHeight(metrics.getFontProperty(5));
        }
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = thresholdCost > 0 ? super.doImplicitLinebreak(paragraph, horizontalOffset, breakWidth, thresholdCost) : 0;
        return success;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        boolean found = false;
        WmiMathDocumentView docView = this.getDocumentView();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiMathTokenModel terminatorModel = WmiMathFactory.createMathOperatorToken(docModel, "\\", this.getContext());
        WmiMathOperatorView terminatorView = new WmiMathOperatorView(terminatorModel, docView);
        terminatorView.layoutView();
        int limit = breakWidth - horizontalOffset - terminatorView.getWidth();
        Point pt = new Point(limit, 0);
        int textOffset = this.getOffset(pt);
        if (textOffset > 0) {
            int index;
            found = true;
            WmiTextView[] fragments = WmiMathTextFragmentView.splitMathTextView(this, textOffset, 0);
            WmiCompositeView parent = this.getParentView();
            int n = index = parent != null ? parent.indexOf(this) : -1;
            if (index >= 0) {
                parent.replaceChild(fragments[0], index);
                fragments[0].setParentView(parent);
                parent.insertView(terminatorView, index + 1);
                parent.insertView(fragments[1], index + 2);
                parent.markInvalid(1);
                ((WmiPositionedView)((Object)parent)).layoutView();
                paragraph.split(parent, index + 2, 0);
                found = true;
                this.release();
            }
        }
        return found ? 2 : 0;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet attrs;
        WmiMathContext context = null;
        WmiView view = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (view != null && view.getModel() instanceof WmiMathWrapperModel && (attrs = view.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            context = new WmiMathContext((WmiFontAttributeSet)attrs);
        }
        if (context == null) {
            context = new WmiMathContext(null);
        }
        return context;
    }
}

