/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathPaddedView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyRenderer;
import java.awt.Point;

public class WmiOverView
extends WmiTraversableCompositeMathView {
    public static final int CENTER_INDEX = 0;
    public static final int OVER_INDEX = 1;

    public WmiOverView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiPositionedView over = (WmiPositionedView)this.getChild(1);
            WmiPositionedView center = (WmiPositionedView)this.getChild(0);
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(over)) {
                ((WmiGenericView)over).markInvalid(1);
            } else {
                over.layoutView();
            }
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(center)) {
                ((WmiGenericView)center).markInvalid(1);
            } else {
                center.layoutView();
            }
            super.layoutView();
            this.validateChildren();
            boolean layoutAsSuperscript = false;
            WmiOverModel model = (WmiOverModel)this.getModel();
            WmiModel centerModel = model.getChild(0);
            WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
            WmiMathOperatorModel operator = WmiMathModelUtil.getEmbellishedOperator(centerModel);
            if (operator != null) {
                WmiMathOperatorModel.WmiMathOperatorAttributeSet opAttrs = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)operator.getAttributesForRead();
                if (opAttrs.hasMovableLimits()) {
                    layoutAsSuperscript = true;
                }
                boolean displayStyle = false;
                if (layoutAsSuperscript && !displayStyle) {
                    layoutAsSuperscript = false;
                }
            }
            over.setVerticalOffset(0);
            int overHeight = over.getHeight();
            if (!layoutAsSuperscript) {
                if (!(center instanceof WmiMathPaddedView)) {
                    int adjust;
                    if (over instanceof WmiAdjustableTextBounds && over.getWidth() > 0) {
                        int adjust2;
                        int topPadding = ((WmiAdjustableTextBounds)((Object)over)).computeSpaceAbove();
                        if (topPadding > 0) {
                            overHeight -= topPadding;
                            over.setVerticalOffset(-topPadding);
                        }
                        if ((adjust2 = ((WmiAdjustableTextBounds)((Object)over)).computeSpaceBelow()) > 1) {
                            overHeight -= adjust2 - 1;
                        }
                    }
                    if (center instanceof WmiAdjustableTextBounds && center.getWidth() > 0 && (adjust = ((WmiAdjustableTextBounds)((Object)center)).computeSpaceAbove()) > 1) {
                        overHeight -= adjust - 1;
                    }
                }
                center.setVerticalOffset(overHeight);
                int centerWidth = center.getWidth();
                int overWidth = over.getWidth();
                this.width = Math.max(centerWidth, overWidth);
                int centerOffset = this.width == centerWidth ? 0 : this.width / 2 - centerWidth / 2;
                int hOffset = this.width == overWidth ? 0 : this.width / 2 - overWidth / 2;
                center.setHorizontalOffset(centerOffset);
                over.setHorizontalOffset(hOffset);
                this.height = overHeight + center.getHeight();
                this.baseline = center.getVerticalOffset() + center.getBaseline();
            } else {
                int superHOffset = WmiSuperscriptView.getSuperscriptHOffset(center, over);
                over.setHorizontalOffset(superHOffset);
                int baseVOffset = WmiSuperscriptView.getBaseVOffset(this, center, over, metrics);
                center.setVerticalOffset(baseVOffset);
                this.height = baseVOffset + center.getHeight() - over.getVerticalOffset();
                this.width = superHOffset + over.getWidth();
                this.baseline = center.getBaseline() + baseVOffset;
            }
            if (over.getWidth() > center.getWidth()) {
                if (WmiHorizontalStretchyRenderer.isStretchyOperator(centerModel)) {
                    center.setWidth(over.getWidth());
                }
                int offset = (over.getWidth() - center.getWidth()) / 2;
                center.setHorizontalOffset(offset);
            }
            this.addNavigationLinks();
        }
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView over = (WmiPositionedView)this.getChild(1);
        if (base != null) {
            base.setNextView(over, 0);
            over.setNextView(base, 1);
            this.setNextView(over, -2);
            this.setNextView(base, -1);
            this.setNextView(base, -4);
            this.setNextView(base, -3);
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public int getNearestSearchRule() {
        return 1;
    }
}

