/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiSquareRootRenderer;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class WmiRootView
extends WmiTraversableCompositeMathView {
    protected static final boolean SQUARE_ROOT_UNDERLINE_ENABLED = true;
    public static final int RADICAND_INDEX = 0;
    public static final int NTH_INDEX = 1;
    public static final int SURD_MODEL_SIZE = 2;
    private static final WmiSquareRootRenderer renderer = new WmiSquareRootRenderer();
    private WmiSquareRootSignView rootSignView = null;

    public WmiRootView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            boolean isSurd = this.getChildCount() > 1;
            WmiModel model = this.getModel();
            WmiPositionedView base = (WmiPositionedView)this.getChild(0);
            base.layoutView();
            this.rootSignView = new WmiSquareRootSignView(this.getModel(), this.getDocumentView());
            this.rootSignView.layoutView();
            WmiFontAttributeSet attributes = (WmiFontAttributeSet)model.getAttributesForRead();
            boolean forPrint = this.getDocumentView().isPrintView();
            int zoom = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(attributes, zoom, forPrint);
            int baseWidth = base.getWidth();
            int baseHeight = base.getHeight();
            this.rootSignView.createGlyph(font, baseHeight, baseWidth);
            int signLeaderWidth = this.rootSignView.getLeadWidth();
            int signHeight = this.rootSignView.getHeight();
            int signWidth = this.rootSignView.getWidth();
            int xShift = 0;
            int yShift = 0;
            if (isSurd) {
                WmiPositionedView power = (WmiPositionedView)this.getChild(1);
                power.layoutView();
                int powWidth = power.getWidth();
                int powHeight = power.getHeight();
                xShift = Math.round((float)powWidth - 0.4f * (float)signLeaderWidth);
                if (xShift < 0) {
                    power.setHorizontalOffset(-xShift);
                    xShift = 0;
                } else {
                    power.setHorizontalOffset(0);
                }
                yShift = Math.round((float)powHeight - 0.5f * (float)signHeight);
                if (yShift < 0) {
                    power.setVerticalOffset(-yShift);
                    yShift = 0;
                } else {
                    power.setVerticalOffset(0);
                }
            }
            this.rootSignView.setHorizontalOffset(xShift);
            this.rootSignView.setVerticalOffset(yShift);
            base.setHorizontalOffset(xShift + signLeaderWidth + (signWidth - signLeaderWidth - baseWidth) / 2);
            base.setVerticalOffset(yShift + signHeight - baseHeight);
            this.height = yShift + signHeight;
            this.width = xShift + signWidth;
            this.baseline = base.getBaseline() + base.getVerticalOffset();
            this.addNavigationLinks();
            super.layoutView();
        }
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int zoom = this.getZoomFactor();
        boolean scriptSize = false;
        WmiModel model = this.getModel();
        WmiCompositeModel parent = model.getParent();
        while (parent instanceof WmiMathModel) {
            scriptSize = ((WmiMathModel)((Object)parent)).useScriptSize(model);
            if (scriptSize) {
                zoom = Math.round((float)zoom * 0.8f);
                break;
            }
            model = parent;
            parent = model.getParent();
        }
        return zoom;
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView nth;
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView = nth = this.getChildCount() > 1 ? (WmiPositionedView)this.getChild(1) : null;
        if (nth != null) {
            nth.setNextView(base, 3);
            base.setNextView(nth, 2);
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(nth, -4);
            this.setNextView(base, -3);
        } else {
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(base, -4);
            this.setNextView(base, -3);
        }
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return super.getNearestChildView(pt);
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        if (this.rootSignView != null) {
            path.push(this.getHorizontalOffset(), this.getVerticalOffset());
            this.rootSignView.draw(g, path, bounds);
            path.pop();
        }
        super.draw(g, path, bounds);
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        if (thresholdCost > 0) {
            if (!paragraph.isStartOfLine(this) && this.getWidth() < breakWidth) {
                WmiCompositeView parent = this.getParentView();
                int index = parent.indexOf(this);
                if (index >= 0) {
                    paragraph.split(parent, index, 0);
                    success = 2;
                }
            } else {
                WmiSuperscriptView script = this.convertToPower();
                if (script != null) {
                    success = 1;
                }
            }
        }
        return success;
    }

    private WmiSuperscriptView convertToPower() throws WmiNoReadAccessException {
        WmiSuperscriptView superView = null;
        WmiModel model = this.getModel();
        WmiMathDocumentModel docModel = model.getDocument();
        WmiMathDocumentView docView = this.getDocumentView();
        WmiCompositeModel wrapper = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
        WmiAttributeSet set = wrapper != null ? wrapper.getAttributesForRead() : null;
        String styleName = set != null ? (String)set.getAttribute("font_style_name") : null;
        WmiMathContext context = new WmiMathContext(docModel.getFontStyle(styleName));
        WmiCompositeView parent = this.getParentView();
        int index = parent.indexOf(this);
        WmiPositionedView baseView = (WmiPositionedView)this.getChild(0);
        if (WmiRootView.areBracketsRequired(baseView.getModel())) {
            baseView = WmiRootView.addBrackets(baseView);
        }
        WmiInlineView exponentView = null;
        boolean surd = this.getChildCount() == 2;
        WmiMathModel denom = surd ? (WmiMathModel)this.getChild(1).getModel() : WmiMathFactory.createMathNumericToken(docModel, "2", context);
        WmiMathTokenModel one = WmiMathFactory.createMathNumericToken(docModel, "1", context);
        WmiMathTokenModel solidus = WmiMathFactory.createMathOperatorToken(docModel, "/", context);
        WmiModel[] kids = new WmiMathModel[]{one, solidus, denom};
        WmiInlineMathModel expModel = WmiInlineMathModel.createLinebreakingMathRow(docModel, kids, context);
        try {
            one.setParent(expModel);
            if (!surd) {
                denom.setParent(expModel);
            }
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        exponentView = new WmiInlineView(expModel, docView);
        exponentView.appendView(new WmiMathTextView(one, docView));
        exponentView.appendView(new WmiMathTextView(solidus, docView));
        if (surd) {
            exponentView.appendView(this.getChild(1));
        } else {
            exponentView.appendView(new WmiMathTextView(denom, docView));
        }
        WmiSuperscriptModel superModel = new WmiSuperscriptModel(docModel);
        try {
            expModel.setParent(superModel);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        superView = new WmiSuperscriptView(superModel, docView);
        superView.appendView(baseView);
        superView.appendView(exponentView);
        superView.layoutView();
        parent.replaceChild(superView, index);
        superView.setParentView(parent);
        return superView;
    }

    public static boolean areBracketsRequired(WmiModel model) throws WmiNoReadAccessException {
        boolean required = false;
        if (model instanceof WmiCompositeModel) {
            if (model.getTag() == WmiModelTag.MATH_ROW) {
                int count = ((WmiCompositeModel)model).getChildCount();
                if (count == 1) {
                    required = WmiRootView.areBracketsRequired(((WmiCompositeModel)model).getChild(0));
                } else if (count > 1) {
                    required = true;
                }
            } else {
                required = true;
            }
        }
        return required;
    }

    public static class WmiSquareRootSignView
    extends WmiGenericView
    implements WmiPositionedView {
        private static final float HEIGHT_SCALE_FACTOR = 4.0f;
        private static final float WIDTH_SCALE_FACTOR = 0.5f;
        private static final float ROOT_TOP_WIDTH_SCALE = 0.055f;
        private WmiFontAttributeSet attributes = null;
        private Color drawColor = null;
        private WmiGlyphRenderer.RenderedGlyph glyph;
        private Rectangle2D.Float topLine;
        private int vPadding;

        public WmiSquareRootSignView(WmiModel model, WmiMathDocumentView docView) {
            super(model, docView);
        }

        protected int getLeadWidth() {
            int leadWidth = 0;
            if (this.glyph != null) {
                Rectangle2D.Float bounds = this.glyph.getBounds();
                leadWidth = Math.round(bounds.width);
            }
            return leadWidth;
        }

        protected void createGlyph(Font f, int height, int width) {
            float topLineThickness = 0.055f * f.getSize2D();
            if (topLineThickness < 1.0f) {
                topLineThickness = 1.0f;
            }
            this.vPadding = (int)Math.ceil(4.0f * topLineThickness);
            this.glyph = renderer.createGlyph(f, height);
            Rectangle2D.Float bounds = this.glyph.getBounds();
            this.topLine = new Rectangle2D.Float(bounds.width, this.vPadding, width += Math.round(0.5f * f.getSize2D()), topLineThickness);
            this.setWidth(Math.round((float)width + bounds.width));
            this.setHeight(height + this.vPadding);
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        public void addTraversableLinks() {
        }

        @Override
        public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
            if (g != null) {
                boolean drawUnderline;
                Graphics2D g2 = (Graphics2D)g;
                Stroke saveStroke = g2.getStroke();
                int frontLineX = path.getHorizontalOffset() + this.getHorizontalOffset();
                int yOffset = path.getVerticalOffset() + this.getVerticalOffset();
                Color tempColor = this.drawColor;
                WmiSelection selection = path.getSelection();
                WmiHighlightPainter highlighter = selection != null ? selection.getSelectionHighlighter() : null;
                Rectangle[] selectionBounds = highlighter != null ? highlighter.intersect(this.x + frontLineX + path.getHorizontalShift(), this.y + yOffset + path.getVerticalShift(), this.width, this.height) : null;
                Color saveColor = g.getColor();
                boolean opaque = false;
                boolean underlined = false;
                boolean composed = false;
                boolean converted = false;
                Color background = Color.WHITE;
                if (this.attributes != null) {
                    opaque = this.attributes.hasStyle(32);
                    underlined = this.attributes.hasStyle(4);
                    composed = this.attributes.hasStyle(256);
                    converted = this.attributes.hasStyle(512);
                    if (opaque) {
                        background = new Color(this.attributes.getBackground());
                    }
                }
                if (opaque) {
                    g2.setColor(background);
                    g2.fillRect(frontLineX, yOffset, this.width, this.height);
                    if (selectionBounds != null) {
                        g.setColor(this.getDocumentView().getColor(4));
                        int i = 0;
                        while (i < selectionBounds.length) {
                            g.fillRect(selectionBounds[i].x - path.getHorizontalShift(), selectionBounds[i].y - path.getVerticalShift(), selectionBounds[i].width, selectionBounds[i].height);
                            ++i;
                        }
                    }
                }
                g.setColor(tempColor);
                this.glyph.draw((Graphics2D)g, frontLineX, yOffset + this.vPadding);
                g.translate(frontLineX, yOffset);
                ((Graphics2D)g).fill(this.topLine);
                g.translate(-frontLineX, -yOffset);
                WmiMathDocumentView docView = this.getDocumentView();
                boolean bl = drawUnderline = underlined || composed;
                if (RuntimePlatform.isMac()) {
                    drawUnderline |= converted;
                }
                if (drawUnderline) {
                    if (composed) {
                        g2.setStroke(WmiTextView.COMPOSED_STROKE);
                        g.setColor(Color.GRAY);
                    } else if (converted) {
                        g2.setStroke(WmiTextView.CONVERTED_STROKE);
                        g.setColor(Color.BLUE.brighter());
                    }
                    g.drawLine(frontLineX, yOffset + this.height + 1, frontLineX + this.width, yOffset + this.height + 1);
                }
                if (selectionBounds != null && docView != null) {
                    g.setColor(docView.getColor(3));
                    int i = 0;
                    while (i < selectionBounds.length) {
                        Rectangle saveClip = g.getClipBounds();
                        g.clipRect(selectionBounds[i].x - path.getHorizontalShift(), selectionBounds[i].y - path.getVerticalShift(), selectionBounds[i].width, selectionBounds[i].height);
                        this.glyph.draw((Graphics2D)g, frontLineX, yOffset + this.vPadding);
                        g.translate(frontLineX, yOffset);
                        ((Graphics2D)g).fill(this.topLine);
                        g.translate(-frontLineX, -yOffset);
                        g.setClip(saveClip);
                        ++i;
                    }
                }
                g2.setColor(saveColor);
                g2.setStroke(saveStroke);
            }
        }

        @Override
        public void layoutView() throws WmiNoReadAccessException {
            super.layoutView();
            try {
                WmiModel model = this.getModel();
                if (model != null) {
                    WmiAttributeSet set = model.getAttributesForRead();
                    if (set instanceof WmiFontAttributeSet) {
                        this.attributes = (WmiFontAttributeSet)set;
                        this.drawColor = new Color(this.attributes.getForeground());
                    } else {
                        this.drawColor = Color.BLACK;
                    }
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }
}

