/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;

public class WmiSubSupView
extends WmiTraversableCompositeMathView {
    private static final int CENTER_INDEX = 0;
    private static final int BOTTOM_INDEX = 1;
    private static final int TOP_INDEX = 2;
    public static final float SUBSCRIPT_INTEGRAL_ADJUST = 0.3f;
    public static final float SUPERSCRIPT_INTEGRAL_ADJUST = 0.2f;

    public WmiSubSupView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            super.layoutView();
            WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
            WmiPositionedView superscript = (WmiPositionedView)this.getChild(2);
            WmiPositionedView center = (WmiPositionedView)this.getChild(0);
            WmiPositionedView subscript = (WmiPositionedView)this.getChild(1);
            if (superscript != null && center != null && subscript != null) {
                WmiMathOperatorView centerOp;
                WmiCompositeView comp;
                WmiModelTag centerTag;
                if (!superscript.isLayoutValid()) {
                    superscript.layoutView();
                }
                if (!subscript.isLayoutValid()) {
                    subscript.layoutView();
                }
                if (!center.isLayoutValid()) {
                    center.layoutView();
                }
                WmiPositionedView adjustedCenter = center;
                if (center instanceof WmiMultiscriptView) {
                    adjustedCenter = (WmiPositionedView)((WmiCompositeView)((Object)adjustedCenter)).getChild(0);
                }
                int superHOffset = WmiSuperscriptView.getSuperscriptHOffset(center, superscript);
                int baseVOffset = WmiSuperscriptView.getBaseVOffset(this, adjustedCenter, superscript, metrics);
                int centerWidth = center.getWidth();
                int subVOffset = WmiSubscriptView.getSubscriptVOffset(this, adjustedCenter, subscript, metrics) + baseVOffset;
                int subHOffset = 0;
                WmiModel centerModel = center.getModel();
                WmiModelTag wmiModelTag = centerTag = centerModel != null ? centerModel.getTag() : null;
                if (centerTag == WmiModelTag.MATH_STYLE && (comp = (WmiCompositeView)((Object)center)).getChildCount() == 1) {
                    center = (WmiPositionedView)comp.getChild(0);
                }
                if (center != adjustedCenter) {
                    superscript.setVerticalOffset(center.getBaseline() - adjustedCenter.getBaseline());
                    subVOffset += adjustedCenter.getVerticalOffset();
                }
                if (center instanceof WmiMathOperatorView && (centerOp = (WmiMathOperatorView)center).getText().equals("\u222b")) {
                    subHOffset = -Math.round((float)centerOp.getWidth() * 0.3f);
                    baseVOffset = superscript.getHeight() - metrics.getFontProperty(4) - centerOp.computeSpaceAbove();
                    subVOffset = Math.round((float)(baseVOffset + center.getHeight()) - 0.3f * (float)metrics.getFontProperty(5));
                    superHOffset += Math.round((float)centerOp.getWidth() * 0.2f);
                }
                superscript.setHorizontalOffset(superHOffset);
                center.setVerticalOffset(baseVOffset);
                subscript.setHorizontalOffset(centerWidth + subHOffset);
                subscript.setVerticalOffset(subVOffset);
                this.height = subVOffset + subscript.getHeight();
                int width1 = superHOffset + superscript.getWidth();
                int width2 = centerWidth + subscript.getWidth();
                this.width = Math.max(width1, width2);
                this.baseline = center.getBaseline() + center.getVerticalOffset();
                this.addNavigationLinks();
            }
        }
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView root = (WmiPositionedView)this.getChild(0);
        WmiPositionedView sup = (WmiPositionedView)this.getChild(2);
        WmiPositionedView sub = (WmiPositionedView)this.getChild(1);
        if (root != null && sup != null && sub != null) {
            root.setNextView(sup, 0);
            root.setNextView(sub, 1);
            sup.setNextView(sub, 1);
            sup.setNextView(root, 2);
            sub.setNextView(sup, 0);
            sub.setNextView(root, 2);
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(root, -4);
            this.setNextView(root, -3);
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }
}

