/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;

public class WmiSubscriptView
extends WmiTraversableCompositeMathView
implements WmiAdjustableTextBounds {
    public static final int BASE_INDEX = 0;
    public static final int SUBSCRIPT_INDEX = 1;

    public WmiSubscriptView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            super.layoutView();
            try {
                WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
                WmiPositionedView base = (WmiPositionedView)this.getChild(0);
                WmiPositionedView subscript = (WmiPositionedView)this.getChild(1);
                if (base != null && subscript != null) {
                    int subscriptWidth = subscript.getWidth();
                    int hoffs = base.getWidth();
                    subscript.setHorizontalOffset(hoffs);
                    WmiPositionedView adjustedBase = base;
                    if (base instanceof WmiMultiscriptView) {
                        adjustedBase = (WmiPositionedView)((WmiCompositeView)((Object)adjustedBase)).getChild(0);
                    }
                    int subsVoffs = WmiSubscriptView.getSubscriptVOffset(this, adjustedBase, subscript, metrics);
                    if (base != adjustedBase) {
                        subsVoffs += adjustedBase.getVerticalOffset();
                    }
                    base.setVerticalOffset(0);
                    subscript.setVerticalOffset(subsVoffs);
                    this.height = subsVoffs + subscript.getHeight();
                    this.width = hoffs + subscriptWidth;
                    this.baseline = base.getBaseline() + base.getVerticalOffset();
                    this.addNavigationLinks();
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    public static int getSubscriptVOffset(WmiView parent, WmiPositionedView base, WmiPositionedView subscript, WmiFontMetrics metrics) throws WmiNoReadAccessException {
        int baseHeight;
        int fontHeight = metrics.getFontProperty(5, parent.getDocumentView().isPrintView());
        int minLowerBound = fontHeight / 2;
        int additionalOffset = 0;
        try {
            WmiMathDocumentView doc;
            WmiAttributeSet parentAtts = parent.getModel().getAttributes();
            if (parentAtts instanceof WmiSubscriptModel.WmiSubscriptAttributeSet) {
                additionalOffset = ((WmiSubscriptModel.WmiSubscriptAttributeSet)parentAtts).getSubscriptShift();
            }
            if ((doc = base.getDocumentView()) != null) {
                int zoom = doc.getZoomFactor();
                additionalOffset = Math.round(zoom * additionalOffset / 100);
            }
        }
        catch (WmiNoReadAccessException wnra) {
            WmiErrorLog.log(wnra);
        }
        if ((baseHeight = base.getHeight()) < fontHeight) {
            baseHeight = fontHeight;
        }
        return baseHeight - minLowerBound + additionalOffset;
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView subscript = (WmiPositionedView)this.getChild(1);
        if (base != null && subscript != null) {
            base.setNextView(subscript, 3);
            subscript.setNextView(base, 2);
            this.setNextView(base, -2);
            this.setNextView(null, -1);
            this.setNextView(base, -4);
            this.setNextView(subscript, -3);
        }
    }

    @Override
    public WmiPositionedView getNextView(int direction) {
        WmiPositionMarker marker;
        WmiMathDocumentView docView = this.getDocumentView();
        boolean inSubscript = false;
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            inSubscript = marker.getView() == this.getChild(1);
        }
        int getDirection = inSubscript && direction == 0 ? 3 : direction;
        return super.getNextView(getDirection);
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public int computePreKernAdjustment() {
        return WmiTextAdjustmentUtils.computePreKernAdjustment(this, 0);
    }

    @Override
    public int computePostKernAdjustment() {
        return WmiTextAdjustmentUtils.computePostKernAdjustment(this, 1);
    }

    @Override
    public int computeSpaceAbove() {
        return WmiTextAdjustmentUtils.computeSpaceAbove(this, 0);
    }

    @Override
    public int computeSpaceBelow() {
        return WmiTextAdjustmentUtils.computeSpaceBelow(this, 1);
    }

    @Override
    public int getNearestSearchRule() {
        return 2;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return WmiSuperscriptView.doImplicitScriptBreak(this, paragraph, horizontalOffset, breakWidth, thresholdCost);
    }
}

