/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyRenderer;
import java.awt.Point;

public class WmiUnderOverView
extends WmiTraversableCompositeMathView {
    public static final int CENTER_INDEX = 0;
    public static final int UNDER_INDEX = 1;
    public static final int OVER_INDEX = 2;
    public static final int[] LINEBREAK_ORDERING;
    public static final float LARGE_OPERATOR_BASELINE_ADJUSTMENT = 0.25f;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 1;
        LINEBREAK_ORDERING = nArray;
    }

    public WmiUnderOverView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiPositionedView over = (WmiPositionedView)this.getChild(2);
            WmiPositionedView center = (WmiPositionedView)this.getChild(0);
            WmiPositionedView under = (WmiPositionedView)this.getChild(1);
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(over)) {
                ((WmiGenericView)over).markInvalid(1);
            } else {
                over.layoutView();
            }
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(center)) {
                ((WmiGenericView)center).markInvalid(1);
            } else {
                center.layoutView();
            }
            if (WmiHorizontalStretchyRenderer.resetStretchyOperator(under)) {
                ((WmiGenericView)under).markInvalid(1);
            } else {
                under.layoutView();
            }
            super.layoutView();
            boolean layoutAsSubAndSuperscript = false;
            WmiUnderOverModel model = (WmiUnderOverModel)this.getModel();
            WmiModel centerModel = model.getChild(0);
            WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
            WmiMathOperatorModel operator = WmiMathModelUtil.getEmbellishedOperator(centerModel);
            if (operator != null) {
                WmiMathOperatorModel.WmiMathOperatorAttributeSet opAttrs = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)operator.getAttributesForRead();
                if (opAttrs.hasMovableLimits()) {
                    layoutAsSubAndSuperscript = true;
                }
                boolean displayStyle = false;
                if (layoutAsSubAndSuperscript && !displayStyle) {
                    layoutAsSubAndSuperscript = false;
                }
            }
            over.setVerticalOffset(0);
            int overHeight = over.getHeight();
            this.width = over.getWidth();
            int centerHeight = center.getHeight();
            int underPos = overHeight + centerHeight;
            if (!layoutAsSubAndSuperscript) {
                int adjust;
                if (over instanceof WmiAdjustableTextBounds && over.getWidth() > 0 && (adjust = ((WmiAdjustableTextBounds)((Object)over)).computeSpaceBelow()) > 1) {
                    over.setVerticalOffset(adjust - 1);
                }
                if (center instanceof WmiAdjustableTextBounds && center.getWidth() > 0) {
                    adjust = ((WmiAdjustableTextBounds)((Object)center)).computeSpaceAbove();
                    if (adjust > 1) {
                        overHeight -= adjust - 1;
                        underPos -= adjust - 1;
                    }
                    if ((adjust = ((WmiAdjustableTextBounds)((Object)center)).computeSpaceBelow()) > 1) {
                        underPos -= adjust - 1;
                    }
                }
                center.setVerticalOffset(overHeight);
                if (under instanceof WmiAdjustableTextBounds && under.getWidth() > 0 && (adjust = ((WmiAdjustableTextBounds)((Object)under)).computeSpaceAbove()) > 1) {
                    underPos -= adjust - 1;
                }
                under.setVerticalOffset(underPos);
                this.height = underPos + under.getHeight();
                this.baseline = overHeight + center.getBaseline();
                this.width = center.getWidth() > this.width ? center.getWidth() : this.width;
                this.width = under.getWidth() > this.width ? under.getWidth() : this.width;
                over.setHorizontalOffset(this.width / 2 - over.getWidth() / 2);
                center.setHorizontalOffset(this.width / 2 - center.getWidth() / 2);
                under.setHorizontalOffset(this.width / 2 - under.getWidth() / 2);
            } else {
                WmiMathOperatorView centerOp;
                int superHOffset = WmiSuperscriptView.getSuperscriptHOffset(center, over);
                int baseVOffset = WmiSuperscriptView.getBaseVOffset(this, center, over, metrics);
                center.setVerticalOffset(baseVOffset);
                int centerWidth = center.getWidth();
                int subVOffset = WmiSubscriptView.getSubscriptVOffset(this, center, under, metrics);
                int subHOffset = 0;
                if (center instanceof WmiMathOperatorView && (centerOp = (WmiMathOperatorView)center).getText().equals("\u222b")) {
                    subHOffset = -Math.round((float)centerOp.getWidth() * 0.3f);
                }
                over.setHorizontalOffset(superHOffset);
                under.setHorizontalOffset(centerWidth + subHOffset);
                under.setVerticalOffset(subVOffset);
                this.height = subVOffset + under.getHeight();
                int width1 = superHOffset + over.getWidth();
                int width2 = centerWidth + under.getWidth();
                this.width = Math.max(width1, width2);
                this.baseline = center.getBaseline() + center.getVerticalOffset();
            }
            int maxWidth = Math.max(over.getWidth(), under.getWidth());
            if (maxWidth > center.getWidth()) {
                if (WmiHorizontalStretchyRenderer.isStretchyOperator(centerModel)) {
                    center.setWidth(maxWidth);
                }
                int offset = (maxWidth - center.getWidth()) / 2;
                center.setHorizontalOffset(offset);
            }
            this.addNavigationLinks();
        }
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView over = (WmiPositionedView)this.getChild(2);
        WmiPositionedView under = (WmiPositionedView)this.getChild(1);
        if (base != null) {
            base.setNextView(over, 0);
            base.setNextView(under, 1);
            over.setNextView(base, 1);
            under.setNextView(base, 0);
            this.setNextView(over, -2);
            this.setNextView(under, -1);
            this.setNextView(base, -4);
            this.setNextView(base, -3);
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public int getNearestSearchRule() {
        return 1;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return WmiUnderOverView.doStackingLinebreak(paragraph, this, LINEBREAK_ORDERING, horizontalOffset, breakWidth, thresholdCost) ? 2 : 0;
    }

    public static boolean doStackingLinebreak(WmiParagraphView paragraph, WmiCompositeView target, int[] ordering, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        boolean success = false;
        if (thresholdCost > 0) {
            WmiCompositeView parent = target.getParentView();
            int index = parent.indexOf(target);
            if (!paragraph.isStartOfLine(target) && ((WmiPositionedView)((Object)target)).getWidth() < breakWidth) {
                if (index >= 0) {
                    paragraph.split(parent, index, 0);
                    success = true;
                }
            } else if (index >= 0) {
                int size = ordering.length;
                WmiMathDocumentView docView = target.getDocumentView();
                WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
                WmiInlineMathModel inlineModel = new WmiInlineMathModel(docModel);
                WmiInlineView inline = new WmiInlineView(inlineModel, docView);
                int i = 0;
                while (i < size) {
                    WmiView child = target.getChild(ordering[i]);
                    child.markInvalid(1);
                    inline.appendView(child);
                    child.setParentView(inline);
                    ++i;
                }
                parent.replaceChild(inline, index);
                ((WmiArrayCompositeView)target).release(false);
                inline.setParentView(parent);
                inline.layoutView();
                inline.releaseObserver();
                paragraph.split(parent, index, 0);
                paragraph.split(parent, 1, 0);
                WmiView fragment = null;
                int i2 = 0;
                while (i2 < size - 1) {
                    WmiView child;
                    fragment = paragraph.split(inline, 1, 0);
                    parent = fragment.getParentView();
                    index = parent.indexOf(fragment);
                    if (index > 0 && (child = parent.getChild(index - 1)) instanceof WmiInlineView) {
                        WmiInlineView childInline = (WmiInlineView)child;
                        childInline.layoutView();
                        childInline.centerInline(breakWidth);
                    }
                    ++i2;
                }
                if (fragment instanceof WmiInlineView) {
                    WmiInlineView childInline = (WmiInlineView)fragment;
                    childInline.layoutView();
                    childInline.centerInline(breakWidth);
                }
                success = true;
            }
        }
        return success;
    }
}

